/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures.customblockzones;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.events.OnBlockBreakSoundEffect;
import io.github.moulberry.notenoughupdates.miscfeatures.customblockzones.CrimsonIsleTextures;
import io.github.moulberry.notenoughupdates.miscfeatures.customblockzones.CrystalHollowsTextures;
import io.github.moulberry.notenoughupdates.miscfeatures.customblockzones.CustomBlockSounds;
import io.github.moulberry.notenoughupdates.miscfeatures.customblockzones.DwarvenMinesTextures;
import io.github.moulberry.notenoughupdates.miscfeatures.customblockzones.IslandZoneSubdivider;
import io.github.moulberry.notenoughupdates.miscfeatures.customblockzones.LocationChangeEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.customblockzones.MineshaftTextures;
import io.github.moulberry.notenoughupdates.miscfeatures.customblockzones.SpecialBlockZone;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockStone;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.BlockPos;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CustomBiomes {
    public static final CustomBiomes INSTANCE = new CustomBiomes();
    private final Map<String, IslandZoneSubdivider> subdividers = new HashMap<String, IslandZoneSubdivider>();

    private CustomBiomes() {
        this.subdividers.put("crystal_hollows", new CrystalHollowsTextures());
        this.subdividers.put("mining_3", new DwarvenMinesTextures());
        this.subdividers.put("crimson_isle", new CrimsonIsleTextures());
        this.subdividers.put("mineshaft", new MineshaftTextures());
    }

    public BiomeGenBase getCustomBiome(BlockPos pos) {
        SpecialBlockZone specialZone = this.getSpecialZone(pos);
        if (specialZone != null && (specialZone.isDwarvenMines() && NotEnoughUpdates.INSTANCE.config.mining.dwarvenTextures || specialZone.isCrystalHollows() && NotEnoughUpdates.INSTANCE.config.mining.crystalHollowTextures)) {
            return specialZone.getCustomBiome();
        }
        return null;
    }

    public SpecialBlockZone getSpecialZone(BlockPos pos) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return null;
        }
        String location = SBInfo.getInstance().getLocation();
        IslandZoneSubdivider subdivider = this.subdividers.get(location);
        if (subdivider == null) {
            return SpecialBlockZone.NON_SPECIAL_ZONE;
        }
        return subdivider.getSpecialZoneForBlock(location, pos);
    }

    @SubscribeEvent
    public void onBreakSound(OnBlockBreakSoundEffect event) {
        SpecialBlockZone specialZone = this.getSpecialZone(event.getPosition());
        boolean hasMithrilSounds = NotEnoughUpdates.INSTANCE.config.mining.mithrilSounds;
        boolean hasCrystalSounds = NotEnoughUpdates.INSTANCE.config.mining.gemstoneSounds;
        if (specialZone != null) {
            CustomBlockSounds.CustomSoundEvent customSound = null;
            if (specialZone.hasMithril() && CustomBiomes.isBreakableMithril(event.getBlock()) && hasMithrilSounds && SBInfo.getInstance().getLocation().equals("mining_3")) {
                customSound = CustomBlockSounds.mithrilBreak;
            }
            if (specialZone.hasMithril() && CustomBiomes.isMithrilHollows(event.getBlock()) && hasMithrilSounds && SBInfo.getInstance().getLocation().equals("crystal_hollows")) {
                customSound = CustomBlockSounds.mithrilBreak;
            }
            if (specialZone.hasTitanium() && CustomBiomes.isTitanium(event.getBlock()) && hasMithrilSounds) {
                customSound = CustomBlockSounds.titaniumBreak;
            }
            if (specialZone.hasGemstones() && CustomBiomes.isGemstone(event.getBlock(), EnumDyeColor.RED) && hasCrystalSounds) {
                customSound = CustomBlockSounds.gemstoneBreakRuby;
            }
            if (specialZone.hasGemstones() && CustomBiomes.isGemstone(event.getBlock(), EnumDyeColor.YELLOW) && hasCrystalSounds) {
                customSound = CustomBlockSounds.gemstoneBreakTopaz;
            }
            if (specialZone.hasGemstones() && CustomBiomes.isGemstone(event.getBlock(), EnumDyeColor.PINK) && hasCrystalSounds) {
                customSound = CustomBlockSounds.gemstoneBreakJasper;
            }
            if (specialZone.hasGemstones() && CustomBiomes.isGemstone(event.getBlock(), EnumDyeColor.LIGHT_BLUE) && hasCrystalSounds) {
                customSound = CustomBlockSounds.gemstoneBreakSapphire;
            }
            if (specialZone.hasGemstones() && CustomBiomes.isGemstone(event.getBlock(), EnumDyeColor.ORANGE) && hasCrystalSounds) {
                customSound = CustomBlockSounds.gemstoneBreakAmber;
            }
            if (specialZone.hasGemstones() && CustomBiomes.isGemstone(event.getBlock(), EnumDyeColor.PURPLE) && hasCrystalSounds) {
                customSound = CustomBlockSounds.gemstoneBreakAmethyst;
            }
            if (specialZone.hasGemstones() && CustomBiomes.isGemstone(event.getBlock(), EnumDyeColor.LIME) && hasCrystalSounds) {
                customSound = CustomBlockSounds.gemstoneBreakJade;
            }
            if (customSound != null) {
                if (customSound.shouldReplace()) {
                    event.setSound(customSound.replaceSoundEvent(event.getSound()));
                } else {
                    event.setCanceled(true);
                }
            }
        }
    }

    public static boolean isTitanium(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150348_b && state.func_177229_b((IProperty)BlockStone.field_176247_a) == BlockStone.EnumType.DIORITE_SMOOTH;
    }

    public static boolean isMithril(IBlockState state) {
        return CustomBiomes.isBreakableMithril(state) || state.func_177230_c() == Blocks.field_150357_h;
    }

    public static boolean isBreakableMithril(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150406_ce && state.func_177229_b((IProperty)BlockColored.field_176581_a) == EnumDyeColor.CYAN || state.func_177230_c() == Blocks.field_150325_L && state.func_177229_b((IProperty)BlockColored.field_176581_a) == EnumDyeColor.GRAY || state.func_177230_c() == Blocks.field_150325_L && state.func_177229_b((IProperty)BlockColored.field_176581_a) == EnumDyeColor.LIGHT_BLUE || state.func_177230_c() == Blocks.field_180397_cI;
    }

    public static boolean isMithrilHollows(IBlockState state) {
        return state.func_177230_c() == Blocks.field_180397_cI || state.func_177230_c() == Blocks.field_150325_L && state.func_177229_b((IProperty)BlockColored.field_176581_a) == EnumDyeColor.LIGHT_BLUE;
    }

    public static boolean isGemstone(IBlockState state, EnumDyeColor color) {
        return (state.func_177230_c() == Blocks.field_150399_cn || state.func_177230_c() == Blocks.field_150397_co) && state.func_177229_b((IProperty)BlockColored.field_176581_a) == color;
    }

    @SubscribeEvent
    public void onLocationChange(LocationChangeEvent event) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        String location = event.newLocation;
        if (world == null) {
            return;
        }
        if (location == null) {
            return;
        }
        switch (location.intern()) {
            case "crystal_hollows": 
            case "mining_3": {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                if (player == null) {
                    return;
                }
                world.func_72975_g((int)player.field_70165_t, (int)player.field_70165_t, (int)player.field_70161_v, (int)player.field_70161_v);
            }
        }
    }
}

