/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.config.ConfigUtil;
import io.github.moulberry.notenoughupdates.core.config.Position;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.core.util.lerp.LerpUtils;
import io.github.moulberry.notenoughupdates.events.SlotClickEvent;
import io.github.moulberry.notenoughupdates.listener.RenderListener;
import io.github.moulberry.notenoughupdates.miscfeatures.tablisttutorial.TablistAPI;
import io.github.moulberry.notenoughupdates.miscgui.itemcustomization.ItemCustomizeManager;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.overlays.TextOverlay;
import io.github.moulberry.notenoughupdates.overlays.TextOverlayStyle;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.ItemResolutionQuery;
import io.github.moulberry.notenoughupdates.util.PetLeveling;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.SkyBlockTime;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.Items;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.util.vector.Vector2f;

public class PetInfoOverlay
extends TextOverlay {
    private static final Pattern XP_BOOST_PATTERN = Pattern.compile("PET_ITEM_(COMBAT|FISHING|MINING|FORAGING|ALL|FARMING)_(SKILL|SKILLS)_BOOST_(COMMON|UNCOMMON|RARE|EPIC)");
    private static final Pattern PET_CONTAINER = Pattern.compile("^Pets(?::)?(?: \"\\w+\")?(?: \\((\\d)\\/(\\d)\\))?");
    private static final Pattern TAB_LIST_XP = Pattern.compile("([0-9,]+\\.?[0-9]*)/([0-9,]+\\.?[0-9]*)[kM]? XP \\(\\d+\\.?\\d*%\\)");
    private static final Pattern TAB_LIST_XP_OVERFLOW = Pattern.compile("\\+([0-9,]+\\.?[0-9]*) XP");
    private static final Pattern TAB_LIST_PET_NAME = Pattern.compile("\u00a7.\\[Lvl (\\d+)\\](?: \u00a78\\[\u00a76\\d+\u00a78\u00a7.\u2726\u00a78])? \u00a7(.)(.+)");
    private static final Pattern TAB_LIST_PET_ITEM = Pattern.compile("\u00a7[fa956d4][a-zA-Z- ]+");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final HashMap<Integer, Integer> removeMap = new HashMap();
    private static long lastPetSelect = -1L;
    private static PetConfig config = new PetConfig();
    private static long lastUpdate = 0L;
    private static float levelXpLast = 0.0f;
    private static float xpGainHourLast = -1.0f;
    private static float xpGainHour = -1.0f;
    private static int pauseCountdown = 0;
    private static float xpGainHourSecondPet = -1.0f;
    private int firstPetLines = 0;
    private int secondPetLines = 0;
    private static HashMap<Long, Float> xpHourMap = new HashMap();
    private long lastXpUpdate = -1L;
    private long lastXpUpdateNonZero = -1L;
    private long lastPaused = -1L;
    private static long lastPetCorrect = -1L;
    private int lastLevelHovered = 0;
    private static final Pattern AUTOPET_EQUIP = Pattern.compile("\u00a7cAutopet \u00a7eequipped your \u00a77\\[Lvl (?<level>\\d+)](?: \u00a78\\[\u00a76\\d+\u00a78\u00a7.\u2726\u00a78])? \u00a7(?<rarityColor>.)(?<name>.*)\u00a7e! \u00a7a\u00a7lVIEW RULE\u00a7r");
    static boolean shownMissingRepo = false;
    private static boolean hasRepoPopupped = false;

    public PetInfoOverlay(Position position, Supplier<List<String>> dummyStrings, Supplier<TextOverlayStyle> styleSupplier) {
        super(position, dummyStrings, styleSupplier);
    }

    public static PetConfig getConfig() {
        return config;
    }

    public static void loadConfig(File file) {
        config = ConfigUtil.loadConfig(PetConfig.class, file, GSON);
        if (config == null) {
            config = new PetConfig();
        }
    }

    public static void saveConfig(File file) {
        ConfigUtil.saveConfig(config, file, GSON);
    }

    public static void clearPet() {
        config.selectedPet = -1;
        config.selectedPet2 = -1;
    }

    public static void setCurrentPet(int index) {
        config.selectedPet2 = config.selectedPet;
        xpGainHourSecondPet = xpGainHour;
        xpGainHourLast = xpGainHour;
        xpHourMap.clear();
        xpGainHourLast = -1.0f;
        xpGainHour = -1.0f;
        config.selectedPet = index;
        lastPetCorrect = System.currentTimeMillis();
    }

    public static Pet getCurrentPet() {
        return PetInfoOverlay.config.petMap.get(config.selectedPet);
    }

    public static Pet getCurrentPet2() {
        if (!NotEnoughUpdates.INSTANCE.config.petOverlay.dualPets) {
            return null;
        }
        if (config.selectedPet == config.selectedPet2) {
            return null;
        }
        return PetInfoOverlay.config.petMap.get(config.selectedPet2);
    }

    private static Pet getClosestPet(String petType, int petId, String petItem, float petLevel) {
        Set pets = PetInfoOverlay.config.petMap.values().stream().filter(pet -> pet.petType.equals(petType) && pet.rarity.petId == petId).collect(Collectors.toSet());
        if (pets.isEmpty()) {
            return null;
        }
        if (pets.size() == 1) {
            return (Pet)pets.iterator().next();
        }
        Set itemMatches = pets.stream().filter(pet -> Objects.equals(petItem, pet.petItem)).collect(Collectors.toSet());
        if (itemMatches.size() == 1) {
            return (Pet)itemMatches.iterator().next();
        }
        if (itemMatches.size() > 1) {
            pets = itemMatches;
        }
        float closestXp = -1.0f;
        Pet closestPet = null;
        for (Pet pet2 : pets) {
            float distXp = Math.abs((float)pet2.petLevel.getCurrentLevel() - petLevel);
            if (closestPet != null && !(distXp < closestXp)) continue;
            closestXp = distXp;
            closestPet = pet2;
        }
        return closestPet;
    }

    private static int getIdForPet(Pet pet) {
        for (Map.Entry<Integer, Pet> entry : PetInfoOverlay.config.petMap.entrySet()) {
            if (entry.getValue() != pet) continue;
            return entry.getKey();
        }
        return -1;
    }

    private static int getClosestPetIndex(String petType, int petId, String petItem, float petLevel) {
        Pet pet = PetInfoOverlay.getClosestPet(petType, petId, petItem, petLevel);
        if (pet == null) {
            return -1;
        }
        return PetInfoOverlay.getIdForPet(pet);
    }

    private float interp(float now, float last) {
        float interp = now;
        if (last >= 0.0f && last != now) {
            float factor = (float)(System.currentTimeMillis() - lastUpdate) / 1000.0f;
            factor = LerpUtils.clampZeroOne(factor);
            interp = last + (now - last) * factor;
        }
        return interp;
    }

    public static Pet getPetFromStack(NBTTagCompound tag) {
        NBTTagCompound ea;
        if (Constants.PETS == null || Constants.PETS.get("pet_levels") == null || Constants.PETS.get("pet_levels") instanceof JsonNull) {
            Utils.showOutdatedRepoNotification("pets.json");
            return null;
        }
        String petType = null;
        Rarity rarity = null;
        String heldItem = null;
        PetLeveling.PetLevel level = null;
        String skin = null;
        int skinVariantSelected = -1;
        if (tag != null && tag.func_74764_b("ExtraAttributes") && (ea = tag.func_74775_l("ExtraAttributes")).func_74764_b("petInfo")) {
            JsonObject animatedSkulls;
            JsonObject petInfo = new JsonParser().parse(ea.func_74779_i("petInfo")).getAsJsonObject();
            petType = petInfo.get("type").getAsString();
            rarity = Rarity.valueOf(petInfo.get("tier").getAsString());
            if (petInfo.has("heldItem")) {
                heldItem = petInfo.get("heldItem").getAsString();
            }
            if ("PET_ITEM_TIER_BOOST".equals(heldItem) && rarity != Rarity.MYTHIC) {
                rarity = rarity.nextRarity();
            }
            level = PetLeveling.getPetLevelingForPet(petType, rarity).getPetLevel(Utils.getElementAsFloat(petInfo.get("exp"), 0.0f));
            if (petInfo.has("skin")) {
                skin = "PET_SKIN_" + petInfo.get("skin").getAsString();
            }
            if (petInfo.has("extraData") && (animatedSkulls = Constants.ANIMATEDSKULLS) != null && animatedSkulls.has("pet_skin_nbt_name")) {
                JsonObject extraData = petInfo.get("extraData").getAsJsonObject();
                JsonArray nbtNames = animatedSkulls.get("pet_skin_nbt_name").getAsJsonArray();
                for (JsonElement nbtName : nbtNames) {
                    String nbt = nbtName.getAsString();
                    if (!petInfo.has(nbt)) continue;
                    skinVariantSelected = extraData.get(nbt).getAsInt();
                }
            }
        }
        if (petType == null) {
            return null;
        }
        Pet pet = new Pet();
        pet.petItem = heldItem;
        pet.petLevel = level;
        pet.rarity = rarity;
        pet.petType = petType;
        JsonObject petTypes = Constants.PETS.get("pet_types").getAsJsonObject();
        pet.petXpType = petTypes.has(pet.petType) ? petTypes.get(pet.petType.toUpperCase(Locale.ROOT)).getAsString().toLowerCase(Locale.ROOT) : "unknown";
        pet.skin = skin;
        pet.skinVariantSelected = skinVariantSelected;
        return pet;
    }

    @Override
    public void updateFrequent() {
        Pet currentPet = PetInfoOverlay.getCurrentPet();
        if (!NotEnoughUpdates.INSTANCE.config.petOverlay.enablePetInfo || currentPet == null || Objects.equals(SBInfo.getInstance().getLocation(), "rift")) {
            this.overlayStrings = null;
        } else {
            this.firstPetLines = 0;
            this.secondPetLines = 0;
            this.overlayStrings = new ArrayList();
            this.overlayStrings.addAll(this.createStringsForPet(currentPet, false));
            this.firstPetLines = this.overlayStrings.size();
            Pet currentPet2 = PetInfoOverlay.getCurrentPet2();
            if (currentPet2 != null) {
                this.overlayStrings.add("");
                if (this.firstPetLines == 1) {
                    this.overlayStrings.add("");
                }
                this.overlayStrings.addAll(this.createStringsForPet(currentPet2, true));
                this.secondPetLines = this.overlayStrings.size() - this.firstPetLines - 1;
                if (this.firstPetLines == 1) {
                    --this.secondPetLines;
                }
            }
        }
    }

    public float getLevelPercent(Pet pet) {
        if (pet == null) {
            return 0.0f;
        }
        try {
            if (pet.petLevel.getMaxLevel() == pet.petLevel.getCurrentLevel()) {
                return 100.0f;
            }
            return Float.parseFloat(StringUtils.formatToTenths(Float.valueOf(Math.min(pet.petLevel.getPercentageToNextLevel() * 100.0f, 100.0f))));
        }
        catch (Exception ignored) {
            return 0.0f;
        }
    }

    private List<String> createStringsForPet(Pet currentPet, boolean secondPet) {
        JsonObject json;
        float xpGain;
        JsonObject skinJson;
        float levelXp = currentPet.petLevel.getExpInCurrentLevel();
        if (!secondPet) {
            levelXp = this.interp(currentPet.petLevel.getExpInCurrentLevel(), levelXpLast);
        }
        if (levelXp < 0.0f) {
            levelXp = 0.0f;
        }
        String petName = EnumChatFormatting.GREEN + "[Lvl " + currentPet.petLevel.getCurrentLevel() + "] " + currentPet.rarity.chatFormatting + PetInfoOverlay.getPetNameFromId(currentPet.petType, currentPet.petLevel.getCurrentLevel());
        if (currentPet.skin != null && (skinJson = NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(currentPet.skin)) != null) {
            String displayName = NotEnoughUpdates.INSTANCE.manager.jsonToStack(skinJson).func_82833_r();
            String colourSt = Character.toString(Utils.getPrimaryColourCode(displayName));
            petName = petName + "\u00a7" + colourSt + " \u2726";
        }
        float levelPercent = this.getLevelPercent(currentPet);
        String lvlStringShort = null;
        String lvlString = null;
        if (levelPercent != 100.0f || !NotEnoughUpdates.INSTANCE.config.petOverlay.hidePetLevelProgress) {
            long xpForNextLevel = currentPet.petLevel.getExpRequiredForNextLevel();
            float visualXp = levelXp;
            if (levelPercent == 100.0f && (float)xpForNextLevel > levelXp) {
                visualXp = xpForNextLevel;
            }
            lvlStringShort = EnumChatFormatting.AQUA + "" + this.roundFloat(visualXp) + "/" + this.roundFloat(xpForNextLevel) + EnumChatFormatting.YELLOW + " (" + levelPercent + "%)";
            lvlString = EnumChatFormatting.AQUA + "" + Utils.shortNumberFormat(Math.min(visualXp, (float)xpForNextLevel), 0) + "/" + Utils.shortNumberFormat(xpForNextLevel, 0) + EnumChatFormatting.YELLOW + " (" + levelPercent + "%)";
        }
        if ((xpGain = !secondPet ? this.interp(xpGainHour, xpGainHourLast) : xpGainHourSecondPet) < 0.0f) {
            xpGain = 0.0f;
        }
        String xpGainString = EnumChatFormatting.AQUA + "XP/h: " + EnumChatFormatting.YELLOW + this.roundFloat(xpGain);
        if (!secondPet && xpGain > 0.0f && (levelXp != levelXpLast || System.currentTimeMillis() - this.lastXpUpdateNonZero > 4500L)) {
            if (pauseCountdown <= 0) {
                xpGainString = xpGainString + EnumChatFormatting.RED + " (PAUSED)";
            } else {
                --pauseCountdown;
            }
        } else {
            pauseCountdown = 60;
        }
        final String totalXpString = EnumChatFormatting.AQUA + "Total XP: " + EnumChatFormatting.YELLOW + this.roundFloat(currentPet.petLevel.getExpTotal());
        String petItemStr = EnumChatFormatting.AQUA + "Held Item: " + EnumChatFormatting.RED + "None";
        if (currentPet.petItem != null && (json = NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(currentPet.petItem)) != null) {
            String name = !NotEnoughUpdates.INSTANCE.config.petOverlay.petItemIcon ? NotEnoughUpdates.INSTANCE.manager.jsonToStack(json).func_82833_r() : "";
            petItemStr = EnumChatFormatting.AQUA + "Held Item: " + name;
        }
        String etaStr = null;
        String etaMaxStr = null;
        if (currentPet.petLevel.getCurrentLevel() < currentPet.petLevel.getMaxLevel()) {
            float remaining = (float)currentPet.petLevel.getExpRequiredForNextLevel() - currentPet.petLevel.getExpInCurrentLevel();
            if (remaining > 0.0f) {
                etaStr = xpGain < 1000.0f ? EnumChatFormatting.AQUA + "Until L" + (currentPet.petLevel.getCurrentLevel() + 1) + ": " + EnumChatFormatting.YELLOW + "N/A" : EnumChatFormatting.AQUA + "Until L" + (currentPet.petLevel.getCurrentLevel() + 1) + ": " + EnumChatFormatting.YELLOW + Utils.prettyTime((long)remaining * 1000L * 60L * 60L / (long)xpGain);
            }
            if (currentPet.petLevel.getCurrentLevel() < currentPet.petLevel.getMaxLevel() - 1 || !NotEnoughUpdates.INSTANCE.config.petOverlay.petOverlayText.contains(6)) {
                float remainingMax = (float)currentPet.petLevel.getExpRequiredForMaxLevel() - currentPet.petLevel.getExpTotal();
                if (remaining > 0.0f) {
                    etaMaxStr = xpGain < 1000.0f ? EnumChatFormatting.AQUA + "Until L" + currentPet.petLevel.getMaxLevel() + ": " + EnumChatFormatting.YELLOW + "N/A" : EnumChatFormatting.AQUA + "Until L" + currentPet.petLevel.getMaxLevel() + ": " + EnumChatFormatting.YELLOW + Utils.prettyTime((long)remainingMax * 1000L * 60L * 60L / (long)xpGain);
                }
            }
        }
        final String finalEtaStr = etaStr;
        final String finalEtaMaxStr = etaMaxStr;
        final String finalXpGainString = xpGainString;
        final String finalPetItemStr = petItemStr;
        final String finalLvlString = lvlString;
        final String finalLvlStringShort = lvlStringShort;
        final String finalPetName = petName;
        return new ArrayList<String>(){
            {
                for (int index : NotEnoughUpdates.INSTANCE.config.petOverlay.petOverlayText) {
                    switch (index) {
                        case 0: {
                            this.add(finalPetName);
                            break;
                        }
                        case 1: {
                            if (finalLvlStringShort == null) break;
                            this.add(finalLvlStringShort);
                            break;
                        }
                        case 2: {
                            if (finalLvlString == null) break;
                            this.add(finalLvlString);
                            break;
                        }
                        case 3: {
                            this.add(finalXpGainString);
                            break;
                        }
                        case 4: {
                            this.add(totalXpString);
                            break;
                        }
                        case 5: {
                            this.add(finalPetItemStr);
                            break;
                        }
                        case 6: {
                            if (finalEtaStr == null) break;
                            this.add(finalEtaStr);
                            break;
                        }
                        case 7: {
                            if (finalEtaMaxStr == null) break;
                            this.add(finalEtaMaxStr);
                        }
                    }
                }
            }
        };
    }

    @Override
    public boolean isEnabled() {
        return NotEnoughUpdates.INSTANCE.config.petOverlay.enablePetInfo;
    }

    @Override
    public void update() {
        if (!NotEnoughUpdates.INSTANCE.config.petOverlay.enablePetInfo) {
            this.overlayStrings = null;
            return;
        }
        Pet currentPet = PetInfoOverlay.getCurrentPet();
        if (currentPet == null) {
            this.overlayStrings = null;
        } else {
            lastUpdate = System.currentTimeMillis();
            levelXpLast = currentPet.petLevel.getExpInCurrentLevel();
            this.updatePetLevels();
        }
    }

    @Override
    protected Vector2f getSize(List<String> strings) {
        if (!NotEnoughUpdates.INSTANCE.config.petOverlay.petOverlayIcon) {
            return super.getSize(strings);
        }
        return super.getSize(strings).translate(25.0f, 0.0f);
    }

    @Override
    protected Vector2f getTextOffset() {
        if (!NotEnoughUpdates.INSTANCE.config.petOverlay.petOverlayIcon) {
            return super.getTextOffset();
        }
        if (this.styleSupplier.get() != TextOverlayStyle.BACKGROUND) {
            return super.getTextOffset().translate(30.0f, 0.0f);
        }
        return super.getTextOffset().translate(25.0f, 0.0f);
    }

    @Override
    public void renderDummy() {
        super.renderDummy();
        if (!NotEnoughUpdates.INSTANCE.config.petOverlay.petOverlayIcon) {
            return;
        }
        JsonObject petItem = NotEnoughUpdates.INSTANCE.manager.getItemInformation().get("ROCK;0");
        if (petItem != null) {
            Vector2f position = this.getPosition(this.overlayWidth, this.overlayHeight, false);
            int x = (int)position.x;
            int y = (int)position.y;
            ItemStack stack = NotEnoughUpdates.INSTANCE.manager.jsonToStack(petItem);
            GlStateManager.func_179126_j();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(x - 2), (float)(y - 2), (float)0.0f);
            GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
            Utils.drawItemStack(stack, 0, 0);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void render() {
        Vector2f position;
        super.render();
        Pet currentPet = PetInfoOverlay.getCurrentPet();
        if (currentPet == null) {
            this.overlayStrings = null;
            return;
        }
        if (this.overlayStrings == null) {
            return;
        }
        if (NotEnoughUpdates.INSTANCE.config.petOverlay.petOverlayIcon) {
            JsonObject petItem2;
            Pet currentPet2;
            int mythicRarity = currentPet.rarity.petId;
            JsonObject petItem = NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(currentPet.skin != null ? currentPet.skin : currentPet.petType + ";" + mythicRarity);
            if (petItem == null && currentPet.rarity.petId == 5) {
                petItem = NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(currentPet.skin != null ? currentPet.skin : currentPet.petType + ";" + 4);
            }
            if (petItem != null) {
                position = this.getPosition(this.overlayWidth, this.overlayHeight, true);
                int x = (int)position.x;
                int y = (int)position.y;
                ItemStack stack = NotEnoughUpdates.INSTANCE.manager.jsonToStack(petItem);
                this.getAnimatedSkin(stack, currentPet);
                GlStateManager.func_179126_j();
                GlStateManager.func_179094_E();
                Utils.pushGuiScale(NotEnoughUpdates.INSTANCE.config.locationedit.guiScale);
                if (this.firstPetLines == 1) {
                    y -= 9;
                }
                if (this.firstPetLines == 2) {
                    y -= 3;
                }
                GlStateManager.func_179109_b((float)(x - 2), (float)(y - 2), (float)0.0f);
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
                Utils.drawItemStack(stack, 0, 0);
                Utils.pushGuiScale(0);
                GlStateManager.func_179121_F();
            }
            if ((currentPet2 = PetInfoOverlay.getCurrentPet2()) != null && (petItem2 = NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(currentPet2.skin != null ? currentPet2.skin : currentPet2.petType + ";" + currentPet2.rarity.petId)) != null) {
                Vector2f position2 = this.getPosition(this.overlayWidth, this.overlayHeight, true);
                int x = (int)position2.x;
                int y = (int)position2.y + (this.overlayStrings.size() - this.secondPetLines) * 10;
                ItemStack stack = NotEnoughUpdates.INSTANCE.manager.jsonToStack(petItem2);
                this.getAnimatedSkin(stack, currentPet2);
                GlStateManager.func_179126_j();
                GlStateManager.func_179094_E();
                Utils.pushGuiScale(NotEnoughUpdates.INSTANCE.config.locationedit.guiScale);
                if (this.secondPetLines == 1) {
                    y -= 9;
                }
                if (this.secondPetLines == 2) {
                    y -= 3;
                }
                GlStateManager.func_179109_b((float)(x - 2), (float)(y - 2), (float)0.0f);
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)1.0f);
                Utils.drawItemStack(stack, 0, 0);
                Utils.pushGuiScale(0);
                GlStateManager.func_179121_F();
            }
        }
        if (NotEnoughUpdates.INSTANCE.config.petOverlay.petItemIcon) {
            JsonObject petHeldItem;
            Pet currentPet2;
            String line;
            Iterator iterator;
            JsonObject petHeldItem2;
            int backgroundOffset;
            int n = backgroundOffset = NotEnoughUpdates.INSTANCE.config.petOverlay.petInfoOverlayStyle == 0 ? 0 : 5;
            if (currentPet.petItem != null && (petHeldItem2 = NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(currentPet.petItem)) != null) {
                position = this.getPosition(this.overlayWidth, this.overlayHeight, true);
                int xOffset = NotEnoughUpdates.INSTANCE.config.petOverlay.petOverlayIcon ? 0 : 25;
                int x = (int)position.x - xOffset;
                int y = (int)position.y;
                ItemStack stack = NotEnoughUpdates.INSTANCE.manager.jsonToStack(petHeldItem2);
                int counter = 0;
                iterator = this.overlayStrings.iterator();
                while (iterator.hasNext() && !(line = (String)iterator.next()).contains("Held Item:")) {
                    ++counter;
                }
                if (counter >= this.overlayStrings.size()) {
                    return;
                }
                GlStateManager.func_179126_j();
                GlStateManager.func_179094_E();
                Utils.pushGuiScale(NotEnoughUpdates.INSTANCE.config.locationedit.guiScale);
                GlStateManager.func_179109_b((float)(x + 77), (float)(y + 10 * counter + 2 - backgroundOffset), (float)0.0f);
                Utils.drawItemStack(stack, 0, 0);
                Utils.pushGuiScale(0);
                GlStateManager.func_179121_F();
            }
            if ((currentPet2 = PetInfoOverlay.getCurrentPet2()) != null && currentPet2.petItem != null && (petHeldItem = NotEnoughUpdates.INSTANCE.manager.getItemInformation().get(currentPet2.petItem)) != null) {
                Vector2f position3 = this.getPosition(this.overlayWidth, this.overlayHeight, true);
                int x = (int)position3.x;
                int y = (int)position3.y + (this.overlayStrings.size() - this.secondPetLines) * 10;
                ItemStack stack = NotEnoughUpdates.INSTANCE.manager.jsonToStack(petHeldItem);
                int counter = 0;
                iterator = this.overlayStrings.iterator();
                while (iterator.hasNext() && !(line = (String)iterator.next()).contains("Held Item:")) {
                    ++counter;
                }
                if (counter >= this.overlayStrings.size()) {
                    return;
                }
                GlStateManager.func_179126_j();
                GlStateManager.func_179094_E();
                Utils.pushGuiScale(NotEnoughUpdates.INSTANCE.config.locationedit.guiScale);
                GlStateManager.func_179109_b((float)(x + 77), (float)(y + 10 * counter + 2 - backgroundOffset), (float)0.0f);
                Utils.drawItemStack(stack, 0, 0);
                Utils.pushGuiScale(0);
                GlStateManager.func_179121_F();
            }
        }
    }

    private void getAnimatedSkin(ItemStack stack, Pet currentPet) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null) {
            NBTTagCompound customSkull;
            String skin = currentPet.skin;
            if (currentPet.skinVariantSelected >= 0) {
                JsonObject animatedSkulls = Constants.ANIMATEDSKULLS;
                if (animatedSkulls == null) {
                    return;
                }
                if (!animatedSkulls.has("pet_skin_variant")) {
                    return;
                }
                JsonElement pet_skin_variant = animatedSkulls.get("pet_skin_variant");
                if (!pet_skin_variant.getAsJsonObject().has(skin)) {
                    return;
                }
                JsonArray skinsArray = pet_skin_variant.getAsJsonObject().get(skin).getAsJsonArray();
                if (skinsArray.size() <= currentPet.skinVariantSelected) {
                    return;
                }
                skin = skinsArray.get(currentPet.skinVariantSelected).getAsString();
            }
            if ("PET_SKIN_FOUR_SEASONS_GRIFFIN".equals(skin)) {
                String monthName = SkyBlockTime.now().getMonthName();
                if (monthName.contains("Spring")) {
                    skin = "PET_SKIN_FOUR_SEASONS_GRIFFIN_SPRING";
                } else if (monthName.contains("Summer")) {
                    skin = "PET_SKIN_FOUR_SEASONS_GRIFFIN_SUMMER";
                } else if (monthName.contains("Autumn")) {
                    skin = "PET_SKIN_FOUR_SEASONS_GRIFFIN_AUTUMN";
                } else if (monthName.contains("Winter")) {
                    skin = "PET_SKIN_FOUR_SEASONS_GRIFFIN_WINTER";
                }
            }
            if ((customSkull = ItemCustomizeManager.getAnimatedCustomSkull(skin, "")) != null) {
                tagCompound.func_82580_o("SkullOwner");
                tagCompound.func_74782_a("SkullOwner", (NBTBase)customSkull);
            }
        }
    }

    @SubscribeEvent
    public void onStackClick(SlotClickEvent event) {
        if (event.clickedButton < 0 || event.clickedButton > 8) {
            return;
        }
        if (event.clickedButton == 1 && event.clickType == 0) {
            return;
        }
        if (event.clickType == 1) {
            return;
        }
        int slotIdMod = (event.slotId - 10) % 9;
        if (event.slotId >= 10 && event.slotId <= 43 && slotIdMod >= 0 && slotIdMod <= 6 && Minecraft.func_71410_x().field_71462_r instanceof GuiChest) {
            GuiChest chest = (GuiChest)Minecraft.func_71410_x().field_71462_r;
            ContainerChest container = (ContainerChest)chest.field_147002_h;
            IInventory lower2 = container.func_85151_d();
            String containerName = lower2.func_145748_c_().func_150260_c();
            if (lower2.func_70302_i_() >= 54 && event.guiContainer.field_147002_h.field_75152_c == container.field_75152_c) {
                int page = 0;
                boolean isPets = this.isPetMenu(containerName, container);
                if (isPets) {
                    try {
                        Matcher matcher = PET_CONTAINER.matcher(containerName);
                        if (matcher.find()) {
                            page = Integer.parseInt(matcher.group(1)) - 1;
                        }
                    }
                    catch (NumberFormatException matcher) {
                        // empty catch block
                    }
                    boolean isRemoving = event.clickedButton == 1;
                    int newSelected = event.slotId - 10 - (event.slotId - 10) / 9 * 2 + page * 28;
                    lastPetSelect = System.currentTimeMillis();
                    if (isRemoving) {
                        if (newSelected == config.selectedPet) {
                            PetInfoOverlay.clearPet();
                        } else if (config.selectedPet > newSelected) {
                            config.selectedPet--;
                        }
                    } else {
                        Pet pet;
                        PetInfoOverlay.setCurrentPet(newSelected);
                        if (event.slot.func_75211_c() != null && event.slot.func_75211_c().func_77978_p() != null && (pet = PetInfoOverlay.getPetFromStack(event.slot.func_75211_c().func_77978_p())) != null) {
                            PetInfoOverlay.config.petMap.put(config.selectedPet, pet);
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71462_r instanceof GuiChest && RenderListener.inventoryLoaded) {
            GuiChest chest = (GuiChest)Minecraft.func_71410_x().field_71462_r;
            ContainerChest container = (ContainerChest)chest.field_147002_h;
            IInventory lower2 = container.func_85151_d();
            String containerName = lower2.func_145748_c_().func_150260_c();
            if (lower2.func_70302_i_() >= 54) {
                NBTTagCompound ea;
                NBTTagCompound tag;
                ItemStack petStack;
                int page = 0;
                int maxPage = 1;
                boolean isPets = this.isPetMenu(containerName, container);
                if (isPets) {
                    try {
                        Matcher matcher = PET_CONTAINER.matcher(containerName);
                        if (matcher.find()) {
                            page = Integer.parseInt(matcher.group(1)) - 1;
                            maxPage = Integer.parseInt(matcher.group(2));
                        }
                    }
                    catch (NumberFormatException matcher) {
                        // empty catch block
                    }
                    boolean hasItem = false;
                    for (int i = 0; i < lower2.func_70302_i_(); ++i) {
                        if (lower2.func_70301_a(i) == null) continue;
                        hasItem = true;
                        break;
                    }
                    if (!hasItem) {
                        return;
                    }
                    HashSet<Integer> clear2 = new HashSet<Integer>();
                    for (int i : PetInfoOverlay.config.petMap.keySet()) {
                        if (i < maxPage * 28) continue;
                        clear2.add(i);
                    }
                    PetInfoOverlay.config.petMap.keySet().removeAll(clear2);
                    HashSet<Integer> removeSet = new HashSet<Integer>();
                    long currentTime = System.currentTimeMillis();
                    for (int index = 0; index < 28; ++index) {
                        int petIndex = page * 28 + index;
                        int itemIndex = 10 + index + index / 7 * 2;
                        ItemStack stack = lower2.func_70301_a(itemIndex);
                        if (stack == null || !stack.func_77942_o()) {
                            int itemIndexNext;
                            ItemStack stackNext;
                            if (index >= 27 || (stackNext = lower2.func_70301_a(itemIndexNext = 10 + (index + 1) + (index + 1) / 7 * 2)) != null && stackNext.func_77942_o()) continue;
                            int old = removeMap.getOrDefault(petIndex, 0);
                            if (old >= 20) {
                                PetInfoOverlay.config.petMap.remove(petIndex);
                                continue;
                            }
                            removeSet.add(petIndex);
                            removeMap.put(petIndex, old + 1);
                            continue;
                        }
                        String[] lore = NotEnoughUpdates.INSTANCE.manager.getLoreFromNBT(stack.func_77978_p());
                        Pet pet = PetInfoOverlay.getPetFromStack(stack.func_77978_p());
                        if (pet == null) continue;
                        PetInfoOverlay.config.petMap.put(petIndex, pet);
                        if (currentTime - lastPetSelect <= 500L) continue;
                        boolean foundDespawn = false;
                        for (String line : lore) {
                            if (line.startsWith("\u00a77\u00a7cClick to despawn")) {
                                config.selectedPet = petIndex;
                                foundDespawn = true;
                                break;
                            }
                            if (!line.equals("\u00a77\u00a77Selected pet: \u00a7cNone")) continue;
                            PetInfoOverlay.clearPet();
                        }
                        if (foundDespawn || config.selectedPet != petIndex || currentTime - lastPetSelect <= 500L) continue;
                        PetInfoOverlay.clearPet();
                    }
                    removeMap.keySet().retainAll(removeSet);
                } else if (containerName.startsWith("Your Equipment") && (petStack = lower2.func_70301_a(47)) != null && petStack.func_77973_b() == Items.field_151144_bL && (tag = petStack.func_77978_p()).func_150297_b("ExtraAttributes", 10) && (ea = tag.func_74775_l("ExtraAttributes")).func_74764_b("petInfo")) {
                    int index;
                    JsonParser jsonParser = new JsonParser();
                    JsonObject petInfoObject = jsonParser.parse(ea.func_74779_i("petInfo")).getAsJsonObject();
                    JsonObject jsonStack = NotEnoughUpdates.INSTANCE.manager.getJsonForItem(petStack);
                    if (jsonStack == null || !jsonStack.has("lore") || !petInfoObject.has("exp")) {
                        return;
                    }
                    int rarity = Utils.getRarityFromLore(jsonStack.get("lore").getAsJsonArray());
                    String rarityString = Utils.getRarityFromInt(rarity);
                    String name = petInfoObject.get("type").getAsString();
                    float petXp = petInfoObject.get("exp").getAsFloat();
                    double petLevel = PetLeveling.getPetLevelingForPet(name, Rarity.valueOf(rarityString)).getPetLevel(petXp).getCurrentLevel();
                    String petItem = "";
                    if (petInfoObject.has("heldItem")) {
                        petItem = petInfoObject.get("heldItem").getAsString();
                    }
                    if ((index = PetInfoOverlay.getClosestPetIndex(name, rarity, petItem, (float)petLevel)) != config.selectedPet) {
                        PetInfoOverlay.clearPet();
                        PetInfoOverlay.setCurrentPet(index);
                    }
                }
            }
        }
    }

    private boolean isPetMenu(String containerName, ContainerChest container) {
        List backLore;
        Matcher matcher = PET_CONTAINER.matcher(containerName);
        if (!matcher.find()) {
            return false;
        }
        try {
            backLore = container.func_75139_a(48).func_75211_c().func_82840_a(null, false);
        }
        catch (Exception _) {
            return false;
        }
        for (String line : backLore) {
            if (!line.contains("To Select Process (Slot #")) continue;
            return false;
        }
        return true;
    }

    public void updatePetLevels() {
        float totalGain = 0.0f;
        Pet currentPet = PetInfoOverlay.getCurrentPet();
        JsonObject petsJson = Constants.PETS;
        if (petsJson == null) {
            Utils.showOutdatedRepoNotification("pets.json");
            return;
        }
        if ("rift".equals(SBInfo.getInstance().getLocation())) {
            return;
        }
        List<String> widgetLines = TablistAPI.getWidgetLines(TablistAPI.WidgetNames.PET);
        for (int i = 0; i < widgetLines.size(); ++i) {
            String petItem;
            String line = widgetLines.get(i);
            String lineWithColours = line.replace("\u00a7r", "").trim();
            line = Utils.cleanColour(line).replace(",", "").replace("\u2726", "").trim();
            Matcher normalXPMatcher = TAB_LIST_XP.matcher(line);
            Matcher overflowXPMatcher = TAB_LIST_XP_OVERFLOW.matcher(line);
            Matcher petNameMatcher = TAB_LIST_PET_NAME.matcher(lineWithColours);
            Matcher petItemMatcher = TAB_LIST_PET_ITEM.matcher(lineWithColours);
            if (petNameMatcher.matches()) {
                String petName = petNameMatcher.group(3);
                int petLevel = 1;
                try {
                    petLevel = Integer.parseInt(petNameMatcher.group(1));
                }
                catch (NumberFormatException ignored) {
                    Utils.addChatMessage(EnumChatFormatting.RED + "[NEU] Invalid number in tab list: " + petNameMatcher.group(1));
                }
                if (!PetInfoOverlay.getPetNameFromId(currentPet.petType, currentPet.petLevel.getCurrentLevel()).equalsIgnoreCase(petName)) {
                    int closestPetIndex;
                    String internalName;
                    String nextLine;
                    Matcher nextLinePetItemMatcher;
                    if (lastPetCorrect != -1L && (lastPetCorrect <= 0L || System.currentTimeMillis() - lastPetCorrect <= 6000L)) break;
                    int rarity = PetInfoOverlay.getRarityByColor((String)petNameMatcher.group((int)2)).petId;
                    String petItem2 = "";
                    if (widgetLines.size() > i + 1 && (nextLinePetItemMatcher = TAB_LIST_PET_ITEM.matcher(nextLine = widgetLines.get(i + 1).replace("\u00a7r", "").trim())).matches()) {
                        petItem2 = PetInfoOverlay.getInternalIdForPetItemDisplayName(nextLinePetItemMatcher.group(0));
                    }
                    if ((internalName = ItemResolutionQuery.findInternalNameByDisplayName(lineWithColours, true)) == null) continue;
                    String[] split = internalName.split(";");
                    if (split.length > 0) {
                        internalName = split[0];
                    }
                    if ((currentPet.petItem != null && !petItem2.isEmpty() && !currentPet.petItem.equals(petItem2) || currentPet.rarity.petId != rarity || currentPet.petLevel.getCurrentLevel() != petLevel) && (closestPetIndex = PetInfoOverlay.getClosestPetIndex(internalName, rarity, petItem2, petLevel)) != -1 && closestPetIndex != config.selectedPet) {
                        PetInfoOverlay.setCurrentPet(closestPetIndex);
                    }
                    lastPetCorrect = System.currentTimeMillis();
                    break;
                }
                lastPetCorrect = System.currentTimeMillis();
                PetLeveling.ExpLadder petLadder = PetLeveling.getPetLevelingForPet(currentPet.petType, currentPet.rarity);
                if (currentPet.petLevel.getCurrentLevel() != petLevel) {
                    long baseLevelXp = petLadder.getPetExpForLevel(petLevel);
                    currentPet.petLevel.setExpTotal(baseLevelXp);
                    currentPet.petLevel = petLadder.getPetLevel(currentPet.petLevel.getExpTotal());
                }
            }
            if (petItemMatcher.matches() && !Objects.equals(currentPet.petItem, petItem = PetInfoOverlay.getInternalIdForPetItemDisplayName(petItemMatcher.group(0))) && currentPet.petItem != null && !currentPet.petItem.isEmpty()) {
                int closestPetIndex = PetInfoOverlay.getClosestPetIndex(currentPet.petType, currentPet.rarity.petId, petItem, currentPet.petLevel.getCurrentLevel());
                if (config.selectedPet != closestPetIndex && closestPetIndex != -1) {
                    PetInfoOverlay.setCurrentPet(closestPetIndex);
                }
            }
            if (!normalXPMatcher.matches() && !overflowXPMatcher.matches()) continue;
            String xpString = normalXPMatcher.matches() ? normalXPMatcher.group(1) : overflowXPMatcher.group(1);
            xpString = xpString.replace(",", "");
            float xpNumber = 0.0f;
            try {
                xpNumber = Float.parseFloat(xpString);
            }
            catch (NumberFormatException e2) {
                Utils.addChatMessage(EnumChatFormatting.RED + "[NEU] Invalid number in tab list: " + xpString);
            }
            PetLeveling.ExpLadder petLadder = PetLeveling.getPetLevelingForPet(currentPet.petType, currentPet.rarity);
            long petExpForLevel = petLadder.getPetExpForLevel(currentPet.petLevel.getCurrentLevel());
            float expTotalBefore = currentPet.petLevel.getExpTotal();
            currentPet.petLevel.setExpTotal(xpNumber + (float)petExpForLevel);
            float expTotalAfter = currentPet.petLevel.getExpTotal();
            totalGain = expTotalAfter - expTotalBefore;
            xpGainHourLast = xpGainHour;
            int seconds = 15;
            if (pauseCountdown > 0 || totalGain > 0.0f) {
                long updateTime = 0L;
                if (System.currentTimeMillis() - this.lastPaused < (long)(1000 * (seconds + 1))) {
                    updateTime = this.lastPaused;
                }
                Iterator<Map.Entry<Long, Float>> iterator = xpHourMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<Long, Float> entry = iterator.next();
                    long keyTime = entry.getKey();
                    if (updateTime > 0L) {
                        keyTime = updateTime;
                    }
                    if (System.currentTimeMillis() - keyTime <= (long)(seconds * 1000)) continue;
                    iterator.remove();
                }
                if (totalGain != 0.0f || System.currentTimeMillis() - this.lastXpUpdate > 4500L) {
                    xpHourMap.put(System.currentTimeMillis(), Float.valueOf(totalGain));
                    this.lastXpUpdate = System.currentTimeMillis();
                }
                if (totalGain > 0.0f) {
                    pauseCountdown = 60;
                    this.lastXpUpdateNonZero = System.currentTimeMillis();
                }
                float averageXp = 0.0f;
                for (float value : xpHourMap.values()) {
                    averageXp += value;
                }
                xpGainHour = !xpHourMap.isEmpty() ? averageXp * (3600.0f / (float)seconds) : 0.0f;
            } else {
                this.lastPaused = System.currentTimeMillis();
            }
            currentPet.petLevel = petLadder.getPetLevel(currentPet.petLevel.getExpTotal());
        }
    }

    public String roundFloat(float f) {
        if (f % 1.0f < 0.05f) {
            return StringUtils.formatNumber((int)f);
        }
        String s = Utils.floatToString(f, 1);
        if (s.contains(".")) {
            return StringUtils.formatNumber((int)f) + '.' + s.split("\\.")[1];
        }
        if (s.contains(",")) {
            return StringUtils.formatNumber((int)f) + ',' + s.split(",")[1];
        }
        return s;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onChatReceived(ClientChatReceivedEvent event) {
        NEUConfig config = NotEnoughUpdates.INSTANCE.config;
        if ((config.petOverlay.enablePetInfo || config.itemOverlays.enableMonkeyCheck || config.petOverlay.petInvDisplay) && event.type == 0) {
            String chatMessage = Utils.cleanColour(event.message.func_150260_c());
            Matcher autopetMatcher = AUTOPET_EQUIP.matcher(event.message.func_150254_d());
            if (autopetMatcher.matches()) {
                try {
                    this.lastLevelHovered = Integer.parseInt(autopetMatcher.group("level"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                String petName = autopetMatcher.group("name");
                Rarity rarity = PetInfoOverlay.getRarityByColor(autopetMatcher.group("rarityColor"));
                String pet = Utils.cleanColour(petName).replaceAll("[^\\w ]", "").trim().replace(" ", "_").toUpperCase(Locale.ROOT);
                List siblings = event.message.func_150256_b().func_150210_i().func_150702_b().func_150253_a();
                String petItem = "";
                if (siblings.size() > 6) {
                    int i = -1;
                    for (IChatComponent sibling : siblings) {
                        ++i;
                        if (!sibling.func_150260_c().startsWith("Held Item:")) continue;
                        IChatComponent iChatComponent = (IChatComponent)siblings.get(i + 1);
                        String formattedText = iChatComponent.func_150256_b().func_150215_a() + iChatComponent.func_150260_c();
                        petItem = PetInfoOverlay.getInternalIdForPetItemDisplayName(formattedText);
                    }
                } else {
                    petItem = null;
                }
                PetInfoOverlay.setCurrentPet(PetInfoOverlay.getClosestPetIndex(pet, rarity.petId, petItem, this.lastLevelHovered));
                if (PetInfoOverlay.config.selectedPet == -1) {
                    PetInfoOverlay.setCurrentPet(PetInfoOverlay.getClosestPetIndex(pet, rarity.petId - 1, petItem, this.lastLevelHovered));
                    if (PetInfoOverlay.getCurrentPet() != null && !"PET_ITEM_TIER_BOOST".equals(PetInfoOverlay.getCurrentPet().petItem)) {
                        PetInfoOverlay.config.selectedPet = -1;
                        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "[NEU] Can't find pet \u00a7" + petName + EnumChatFormatting.RED + " try revisiting all pages of /pets."));
                    }
                }
            } else if (chatMessage.toLowerCase(Locale.ROOT).startsWith("you despawned your") || chatMessage.toLowerCase(Locale.ROOT).contains("switching to profile") || chatMessage.toLowerCase(Locale.ROOT).contains("transferring you to a new island...")) {
                PetInfoOverlay.clearPet();
            }
        }
    }

    private static Rarity getRarityByColor(String colChar) {
        EnumChatFormatting col = EnumChatFormatting.RESET;
        for (EnumChatFormatting formatting : EnumChatFormatting.values()) {
            if (!formatting.toString().equals("\u00a7" + colChar)) continue;
            col = formatting;
            break;
        }
        Rarity rarity = Rarity.COMMON;
        if (col != EnumChatFormatting.RESET) {
            rarity = Rarity.getRarityFromColor(col);
        }
        return rarity;
    }

    private static String getPetNameFromId(String petId, int petLevel) {
        JsonObject pets = Constants.PETS;
        String defaultName = WordUtils.capitalizeFully((String)petId.replace("_", " "));
        if (pets == null) {
            return defaultName;
        }
        if (!pets.has("id_to_display_name")) {
            if (!shownMissingRepo) {
                Utils.showOutdatedRepoNotification("pets.json id_to_display_name");
                shownMissingRepo = true;
            }
            return defaultName;
        }
        if ("GOLDEN_DRAGON".equals(petId)) {
            if (petLevel < 100) {
                return "Golden Dragon Egg";
            }
            return defaultName;
        }
        JsonObject idToDisplayName = pets.get("id_to_display_name").getAsJsonObject();
        if (idToDisplayName.has(petId)) {
            return idToDisplayName.get(petId).getAsString();
        }
        return defaultName;
    }

    private static String getInternalIdForPetItemDisplayName(String displayName) {
        JsonObject pets = Constants.PETS;
        String defaultName = displayName.replace(" ", "_").replace("-", "_").toUpperCase(Locale.ROOT);
        defaultName = Utils.cleanColour(defaultName).trim();
        if (pets == null) {
            return defaultName;
        }
        if (!pets.has("pet_item_display_name_to_id")) {
            if (!hasRepoPopupped) {
                Utils.showOutdatedRepoNotification("pets.json pet_item_display_name_to_id");
            }
            hasRepoPopupped = true;
            return defaultName;
        }
        JsonObject petItemDisplayNameToId = pets.get("pet_item_display_name_to_id").getAsJsonObject();
        if (petItemDisplayNameToId.has(displayName)) {
            return petItemDisplayNameToId.get(displayName).getAsString();
        }
        return defaultName;
    }

    public static class Pet {
        public String petType;
        public Rarity rarity;
        public PetLeveling.PetLevel petLevel;
        public String petXpType;
        public String petItem;
        public String skin;
        public int skinVariantSelected;
        public int candyUsed;

        public String getPetId(boolean withoutBoost) {
            boolean shouldDecreaseRarity = withoutBoost && "PET_ITEM_TIER_BOOST".equals(this.petItem);
            return this.petType + ";" + (shouldDecreaseRarity ? this.rarity.petId - 1 : this.rarity.petId);
        }
    }

    public static class PetConfig {
        public HashMap<Integer, Pet> petMap = new HashMap();
        private int selectedPet = -1;
        private int selectedPet2 = -1;
        public int tamingLevel = 1;
        public float beastMultiplier = 0.0f;
    }

    public static enum Rarity {
        COMMON(0, 0, 1, EnumChatFormatting.WHITE),
        UNCOMMON(6, 1, 2, EnumChatFormatting.GREEN),
        RARE(11, 2, 3, EnumChatFormatting.BLUE),
        EPIC(16, 3, 4, EnumChatFormatting.DARK_PURPLE),
        LEGENDARY(20, 4, 5, EnumChatFormatting.GOLD),
        MYTHIC(20, 5, 5, EnumChatFormatting.LIGHT_PURPLE);

        public final int petOffset;
        public final EnumChatFormatting chatFormatting;
        public final int petId;
        public final int beastcreatMultiplyer;

        private Rarity(int petOffset, int petId, int beastcreatMultiplyer, EnumChatFormatting chatFormatting) {
            this.chatFormatting = chatFormatting;
            this.petOffset = petOffset;
            this.petId = petId;
            this.beastcreatMultiplyer = beastcreatMultiplyer;
        }

        public static Rarity getRarityFromColor(EnumChatFormatting chatFormatting) {
            for (Rarity rarity : Rarity.values()) {
                if (!rarity.chatFormatting.equals((Object)chatFormatting)) continue;
                return rarity;
            }
            return COMMON;
        }

        public Rarity nextRarity() {
            switch (this) {
                case COMMON: {
                    return UNCOMMON;
                }
                case UNCOMMON: {
                    return RARE;
                }
                case RARE: {
                    return EPIC;
                }
                case EPIC: {
                    return LEGENDARY;
                }
                case LEGENDARY: {
                    return MYTHIC;
                }
            }
            return null;
        }
    }
}

