/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.events.SlotClickEvent;
import io.github.moulberry.notenoughupdates.events.TabListChangeEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.tablisttutorial.TablistAPI;
import io.github.moulberry.notenoughupdates.options.NEUConfig;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.SBInfo;
import io.github.moulberry.notenoughupdates.util.Utils;
import io.github.moulberry.notenoughupdates.util.kotlin.KSerializable;
import io.github.moulberry.notenoughupdates.util.kotlin.RegexUtilKt;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0007J\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001fH\u0007J\b\u0010 \u001a\u00020\u0017H\u0007R\u001f\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006\""}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/HotmDesires;", "", "()V", "desires", "", "", "Lio/github/moulberry/notenoughupdates/miscfeatures/HotmDesires$Desire;", "getDesires", "()Ljava/util/Map;", "lastPowder", "", "getLastPowder", "powderRequirementText", "Ljava/util/regex/Pattern;", "getPowderRequirementText", "()Ljava/util/regex/Pattern;", "tablistPowderLine", "getTablistPowderLine", "youArePoorText", "getYouArePoorText", "appendDesireForType", "powderType", "isEnabled", "", "onAfterGuiDraw", "", "event", "Lnet/minecraftforge/event/entity/player/ItemTooltipEvent;", "onClickHotmItemThatYouCannotUpgrade", "Lio/github/moulberry/notenoughupdates/events/SlotClickEvent;", "onTabListChange", "Lio/github/moulberry/notenoughupdates/events/TabListChangeEvent;", "wantsPowderInfo", "Desire", "NotEnoughUpdates"})
@SourceDebugExtension(value={"SMAP\nHotmDesires.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HotmDesires.kt\nio/github/moulberry/notenoughupdates/miscfeatures/HotmDesires\n+ 2 RegexUtil.kt\nio/github/moulberry/notenoughupdates/util/kotlin/RegexUtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n26#2:131\n26#2:132\n26#2:134\n1#3:133\n1747#4,3:135\n*S KotlinDebug\n*F\n+ 1 HotmDesires.kt\nio/github/moulberry/notenoughupdates/miscfeatures/HotmDesires\n*L\n72#1:131\n99#1:132\n103#1:134\n119#1:135,3\n*E\n"})
public final class HotmDesires {
    @NotNull
    public static final HotmDesires INSTANCE = new HotmDesires();
    @NotNull
    private static final Pattern powderRequirementText;
    @NotNull
    private static final Pattern youArePoorText;
    @NotNull
    private static final Map<String, Integer> lastPowder;
    @NotNull
    private static final Pattern tablistPowderLine;

    private HotmDesires() {
    }

    @NotNull
    public final Pattern getPowderRequirementText() {
        return powderRequirementText;
    }

    @NotNull
    public final Pattern getYouArePoorText() {
        return youArePoorText;
    }

    @NotNull
    public final Map<String, Integer> getLastPowder() {
        return lastPowder;
    }

    @Nullable
    public final Map<String, Desire> getDesires() {
        NEUConfig.HiddenProfileSpecific hiddenProfileSpecific = NotEnoughUpdates.INSTANCE.config.getProfileSpecific();
        return hiddenProfileSpecific != null ? hiddenProfileSpecific.hotmDesires : null;
    }

    @JvmStatic
    @NotNull
    public static final String appendDesireForType(@NotNull String powderType) {
        Intrinsics.checkNotNullParameter((Object)powderType, (String)"powderType");
        Map<String, Desire> map2 = INSTANCE.getDesires();
        if (map2 == null || (map2 = map2.get(powderType)) == null) {
            return "";
        }
        Map<String, Desire> desire = map2;
        return "\u00a77/\u00a7c" + StringUtils.formatNumber(((Desire)((Object)desire)).getPowderRequirement());
    }

    @NotNull
    public final Pattern getTablistPowderLine() {
        return tablistPowderLine;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onTabListChange(@NotNull TabListChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        Map<String, Desire> map2 = this.getDesires();
        if (map2 == null) {
            return;
        }
        Map<String, Desire> desireMap = map2;
        if (!this.isEnabled()) {
            desireMap.clear();
            return;
        }
        String[] stringArray = new String[]{"mining_3", "crystal_hollows", "mineshaft"};
        if (!CollectionsKt.contains((Iterable)SetsKt.setOf((Object[])stringArray), (Object)SBInfo.getInstance().getLocation())) {
            return;
        }
        for (String line : TablistAPI.getWidgetLines(TablistAPI.WidgetNames.POWDER)) {
            Desire goal;
            Pair pair;
            String text$iv22;
            void $this$useMatcher$iv;
            Pattern pattern = tablistPowderLine;
            Intrinsics.checkNotNullExpressionValue((Object)StringUtils.cleanColour(line), (String)"cleanColour(line)");
            boolean $i$f$useMatcher = false;
            if (RegexUtilKt.useMatcher((Pattern)$this$useMatcher$iv, text$iv22) != null) {
                Matcher $this$onTabListChange_u24lambda_u240;
                boolean bl = false;
                String powderKind = $this$onTabListChange_u24lambda_u240.group(1);
                String string = $this$onTabListChange_u24lambda_u240.group(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(2)");
                int powderCount = Integer.parseInt(StringsKt.replace$default((String)string, (String)",", (String)"", (boolean)false, (int)4, null));
                pair = TuplesKt.to((Object)powderKind, (Object)powderCount);
            } else {
                pair = null;
            }
            if (pair == null) continue;
            Pair pair2 = pair;
            String powderKind = (String)pair2.component1();
            int powderCount = ((Number)pair2.component2()).intValue();
            Integer n = lastPowder.get(powderKind);
            int text$iv22 = powderCount;
            if (n != null && n == text$iv22) continue;
            Integer n2 = powderCount;
            Intrinsics.checkNotNullExpressionValue((Object)powderKind, (String)"powderKind");
            lastPowder.put(powderKind, n2);
            if (desireMap.get(powderKind) == null || goal.getPowderRequirement() > powderCount) continue;
            desireMap.remove(powderKind);
            Utils.addClickableChatMessage("\u00a7e[NEU] You have enough " + powderKind + " powder to upgrade " + goal.getName() + "\u00a7e!", "/hotm", "\u00a7eClick to open your Heart of the Mountain to select the next upgrade.");
        }
    }

    public final boolean isEnabled() {
        return NotEnoughUpdates.INSTANCE.config.mining.powderTodo;
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent
    public final void onClickHotmItemThatYouCannotUpgrade(@NotNull SlotClickEvent event) {
        Integer n;
        String powderKind;
        String name;
        block13: {
            String string;
            Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
            if (!Intrinsics.areEqual((Object)Utils.getOpenChestName(), (Object)"Heart of the Mountain") || !this.isEnabled()) {
                return;
            }
            String string2 = ItemUtils.getDisplayName(event.slot.func_75211_c());
            if (string2 == null) {
                return;
            }
            name = string2;
            List<String> list = ItemUtils.getLore(event.slot.func_75211_c());
            Intrinsics.checkNotNullExpressionValue(list, (String)"getLore(event.slot.stack)");
            List<String> lore = list;
            String string3 = (String)CollectionsKt.lastOrNull(lore);
            if (string3 == null) {
                return;
            }
            String missingPowderText = string3;
            Pattern $this$useMatcher$iv = youArePoorText;
            boolean $i$f$useMatcher = false;
            Matcher matcher = RegexUtilKt.useMatcher($this$useMatcher$iv, missingPowderText);
            if (matcher != null) {
                Matcher $this$onClickHotmItemThatYouCannotUpgrade_u24lambda_u241 = matcher;
                boolean bl = false;
                string = $this$onClickHotmItemThatYouCannotUpgrade_u24lambda_u241.group(1);
            } else {
                string = null;
            }
            if (string == null) {
                return;
            }
            powderKind = string;
            for (String it : (Iterable)lore) {
                Integer n2;
                Integer n3;
                void $this$useMatcher$iv2;
                boolean bl = false;
                Pattern pattern = powderRequirementText;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                String text$iv = it;
                boolean $i$f$useMatcher2 = false;
                if (RegexUtilKt.useMatcher((Pattern)$this$useMatcher$iv2, text$iv) != null) {
                    Matcher $this$onClickHotmItemThatYouCannotUpgrade_u24lambda_u243_u24lambda_u242;
                    boolean bl2 = false;
                    String string4 = $this$onClickHotmItemThatYouCannotUpgrade_u24lambda_u243_u24lambda_u242.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"group(1)");
                    n3 = Integer.parseInt(StringsKt.replace$default((String)string4, (String)",", (String)"", (boolean)false, (int)4, null));
                } else {
                    n3 = null;
                }
                if ((n2 = n3) == null) continue;
                n = n2;
                break block13;
            }
            n = null;
        }
        if (n == null) {
            return;
        }
        int powderCount = n;
        Map<String, Desire> map2 = this.getDesires();
        if (map2 == null) {
            return;
        }
        Map<String, Desire> desireMap = map2;
        Desire desire = desireMap.get(powderKind);
        if (!Intrinsics.areEqual((Object)(desire != null ? desire.getName() : null), (Object)name)) {
            desireMap.put(powderKind, new Desire(name, powderCount));
        } else {
            desireMap.remove(powderKind);
        }
    }

    @SubscribeEvent
    public final void onAfterGuiDraw(@NotNull ItemTooltipEvent event) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)Utils.getOpenChestName(), (Object)"Heart of the Mountain") || !this.isEnabled()) {
            return;
        }
        String string = ItemUtils.getDisplayName(event.itemStack);
        if (string == null) {
            return;
        }
        String name = string;
        Map<String, Desire> map2 = this.getDesires();
        if (map2 != null && (map2 = map2.values()) != null) {
            boolean bl2;
            block8: {
                Iterable $this$any$iv = (Iterable)((Object)map2);
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Desire it = (Desire)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                        bl2 = true;
                        break block8;
                    }
                    bl2 = false;
                }
            }
            bl = bl2;
        } else {
            bl = false;
        }
        if (!bl) {
            return;
        }
        event.toolTip.add("\u00a7e[NEU] Selected this perk as your next goal.");
        event.toolTip.add("\u00a7e[NEU] Click again to deselect.");
    }

    @JvmStatic
    public static final boolean wantsPowderInfo() {
        Map<String, Desire> map2 = INSTANCE.getDesires();
        return (map2 != null ? !map2.isEmpty() : false) && INSTANCE.isEnabled();
    }

    static {
        String string = "\u00a7.([0-9,]+) .* Powder";
        int n = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(this, flags)");
        powderRequirementText = pattern;
        string = "\u00a7cYou don't have enough (.*) Powder!";
        n = 0;
        Pattern pattern2 = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(this, flags)");
        youArePoorText = pattern2;
        lastPowder = new LinkedHashMap();
        string = " (.*): ([0-9,]+)";
        n = 0;
        Pattern pattern3 = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(this, flags)");
        tablistPowderLine = pattern3;
    }

    @KSerializable
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/HotmDesires$Desire;", "", "name", "", "powderRequirement", "", "(Ljava/lang/String;I)V", "getName", "()Ljava/lang/String;", "getPowderRequirement", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "NotEnoughUpdates"})
    public static final class Desire {
        @NotNull
        private final String name;
        private final int powderRequirement;

        public Desire(@NotNull String name, int powderRequirement) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.name = name;
            this.powderRequirement = powderRequirement;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final int getPowderRequirement() {
            return this.powderRequirement;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        public final int component2() {
            return this.powderRequirement;
        }

        @NotNull
        public final Desire copy(@NotNull String name, int powderRequirement) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Desire(name, powderRequirement);
        }

        public static /* synthetic */ Desire copy$default(Desire desire, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = desire.name;
            }
            if ((n2 & 2) != 0) {
                n = desire.powderRequirement;
            }
            return desire.copy(string, n);
        }

        @NotNull
        public String toString() {
            return "Desire(name=" + this.name + ", powderRequirement=" + this.powderRequirement + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.powderRequirement);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Desire)) {
                return false;
            }
            Desire desire = (Desire)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)desire.name)) {
                return false;
            }
            return this.powderRequirement == desire.powderRequirement;
        }
    }
}

