/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.util.ReverseWorldRenderer;
import io.github.moulberry.notenoughupdates.util.SpecialColour;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public class CrystalOverlay {
    private static double posLastUpdateX;
    private static double posLastUpdateY;
    private static double posLastUpdateZ;
    private static final HashMap<String, CrystalType> skullId;
    public static long displayMillis;
    public static long lastMiningUpdate;
    public static HashMap<CrystalType, BlockPos> crystals;

    public static void tick() {
        if (!NotEnoughUpdates.INSTANCE.config.itemOverlays.enableCrystalOverlay) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return;
        }
        EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
        if (p == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (NotEnoughUpdates.INSTANCE.config.itemOverlays.alwaysShowCrystal) {
            displayMillis = currentTime;
        } else {
            ItemStack held;
            String internal;
            if (currentTime - displayMillis > 10000L) {
                crystals.clear();
                displayMillis = -1L;
            }
            if ((internal = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(held = p.func_70694_bm())) != null && internal.endsWith("_CRYSTAL") && !internal.equals("POWER_CRYSTAL")) {
                displayMillis = currentTime;
            }
            if (displayMillis < 0L) {
                return;
            }
        }
        HashSet<CrystalType> foundTypes = new HashSet<CrystalType>();
        for (Entity entity : Minecraft.func_71410_x().field_71441_e.field_72996_f) {
            String id;
            NBTTagCompound skullOwner;
            NBTTagCompound tag;
            ItemStack helmet;
            EntityArmorStand armorStand;
            if (!(entity instanceof EntityArmorStand) || !(armorStand = (EntityArmorStand)entity).func_70631_g_() || armorStand.func_71124_b(4) == null || (helmet = armorStand.func_71124_b(4)).func_77973_b() != Items.field_151144_bL || !helmet.func_77942_o() || !(tag = helmet.func_77978_p()).func_150297_b("SkullOwner", 10) || !(skullOwner = tag.func_74775_l("SkullOwner")).func_150297_b("Id", 8) || !skullId.containsKey(id = skullOwner.func_74779_i("Id"))) continue;
            CrystalType type2 = skullId.get(id);
            foundTypes.add(type2);
            BlockPos pos = new BlockPos(armorStand.field_70165_t, armorStand.field_70163_u + 0.5, armorStand.field_70161_v);
            if (crystals.containsKey((Object)type2)) {
                BlockPos old = crystals.get((Object)type2);
                if (old.equals((Object)pos)) {
                    type2.updates = 0;
                    continue;
                }
                if (++type2.updates < 3) continue;
                type2.updates = 0;
                crystals.put(type2, pos);
                continue;
            }
            crystals.put(type2, pos);
        }
        crystals.keySet().retainAll(foundTypes);
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (!NotEnoughUpdates.INSTANCE.config.itemOverlays.enableCrystalOverlay) {
            return;
        }
        if (displayMillis < 0L) {
            return;
        }
        EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
        if (p == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            double dX = p.field_70165_t - posLastUpdateX;
            double dY = p.field_70163_u - posLastUpdateY;
            double dZ = p.field_70161_v - posLastUpdateZ;
            if (dX * dX + dY * dY + dZ * dZ < 1.0) {
                return;
            }
            posLastUpdateX = p.field_70165_t;
            posLastUpdateY = p.field_70163_u;
            posLastUpdateZ = p.field_70161_v;
            for (CrystalType type2 : crystals.keySet()) {
                ReverseWorldRenderer worldRenderer;
                if (type2 == CrystalType.MINING_MINION) {
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - lastMiningUpdate < 1000L) continue;
                    lastMiningUpdate = currentTime;
                }
                if ((worldRenderer = type2.getOverlayVBO()) == null) continue;
                BlockPos crystal = crystals.get((Object)type2);
                worldRenderer.setTranslation(0.0, 0.0, 0.0);
                worldRenderer.sortVertexData((float)p.field_70165_t - (float)crystal.func_177958_n(), (float)p.field_70163_u - (float)crystal.func_177956_o(), (float)p.field_70161_v - (float)crystal.func_177952_p());
            }
        }
    }

    @SubscribeEvent
    public void onRenderLast(RenderWorldLastEvent event) {
        if (!NotEnoughUpdates.INSTANCE.config.itemOverlays.enableCrystalOverlay) {
            return;
        }
        if (displayMillis < 0L) {
            return;
        }
        Entity viewer = Minecraft.func_71410_x().func_175606_aa();
        double viewerX = viewer.field_70142_S + (viewer.field_70165_t - viewer.field_70142_S) * (double)event.partialTicks;
        double viewerY = viewer.field_70137_T + (viewer.field_70163_u - viewer.field_70137_T) * (double)event.partialTicks;
        double viewerZ = viewer.field_70136_U + (viewer.field_70161_v - viewer.field_70136_U) * (double)event.partialTicks;
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179090_x();
        GlStateManager.func_179137_b((double)(-viewerX), (double)(-viewerY), (double)(-viewerZ));
        GL11.glPolygonOffset((float)5.0f, (float)5.0f);
        for (CrystalType type2 : crystals.keySet()) {
            VertexFormatElement vertexformatelement;
            int index;
            ReverseWorldRenderer worldRenderer = type2.getOverlayVBO();
            if (worldRenderer == null || worldRenderer.getVertexCount() <= 0) continue;
            BlockPos crystal = crystals.get((Object)type2);
            GlStateManager.func_179109_b((float)crystal.func_177958_n(), (float)crystal.func_177956_o(), (float)crystal.func_177952_p());
            VertexFormat vertexformat = worldRenderer.getVertexFormat();
            int stride = vertexformat.func_177338_f();
            ByteBuffer bytebuffer = worldRenderer.getByteBuffer();
            List list = vertexformat.func_177343_g();
            for (index = 0; index < list.size(); ++index) {
                vertexformatelement = (VertexFormatElement)list.get(index);
                vertexformatelement.func_177375_c().preDraw(vertexformat, index, stride, bytebuffer);
            }
            GL11.glDrawArrays((int)worldRenderer.getDrawMode(), (int)0, (int)worldRenderer.getVertexCount());
            for (index = 0; index < list.size(); ++index) {
                vertexformatelement = (VertexFormatElement)list.get(index);
                vertexformatelement.func_177375_c().postDraw(vertexformat, index, stride, bytebuffer);
            }
            GlStateManager.func_179109_b((float)(-crystal.func_177958_n()), (float)(-crystal.func_177956_o()), (float)(-crystal.func_177952_p()));
        }
        GL11.glPolygonOffset((float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)viewerX, (double)viewerY, (double)viewerZ);
        GlStateManager.func_179098_w();
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        crystals.clear();
    }

    public static void uploadFilledBoundingBox(AxisAlignedBB p_181561_0_, float alpha, String special, ReverseWorldRenderer worldrenderer) {
        Color c = new Color(SpecialColour.specialToChromaRGB(special), true);
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f, (float)c.getGreen() / 255.0f, (float)c.getBlue() / 255.0f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f * 0.8f, (float)c.getGreen() / 255.0f * 0.8f, (float)c.getBlue() / 255.0f * 0.8f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f * 0.8f, (float)c.getGreen() / 255.0f * 0.8f, (float)c.getBlue() / 255.0f * 0.8f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f * 0.8f, (float)c.getGreen() / 255.0f * 0.8f, (float)c.getBlue() / 255.0f * 0.8f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f * 0.8f, (float)c.getGreen() / 255.0f * 0.8f, (float)c.getBlue() / 255.0f * 0.8f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f * 0.8f, (float)c.getGreen() / 255.0f * 0.8f, (float)c.getBlue() / 255.0f * 0.8f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f * 0.8f, (float)c.getGreen() / 255.0f * 0.8f, (float)c.getBlue() / 255.0f * 0.8f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f * 0.8f, (float)c.getGreen() / 255.0f * 0.8f, (float)c.getBlue() / 255.0f * 0.8f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f * 0.8f, (float)c.getGreen() / 255.0f * 0.8f, (float)c.getBlue() / 255.0f * 0.8f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f * 0.9f, (float)c.getGreen() / 255.0f * 0.9f, (float)c.getBlue() / 255.0f * 0.9f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f * 0.9f, (float)c.getGreen() / 255.0f * 0.9f, (float)c.getBlue() / 255.0f * 0.9f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f * 0.9f, (float)c.getGreen() / 255.0f * 0.9f, (float)c.getBlue() / 255.0f * 0.9f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72339_c).color((float)c.getRed() / 255.0f * 0.9f, (float)c.getGreen() / 255.0f * 0.9f, (float)c.getBlue() / 255.0f * 0.9f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f * 0.9f, (float)c.getGreen() / 255.0f * 0.9f, (float)c.getBlue() / 255.0f * 0.9f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72338_b, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f * 0.9f, (float)c.getGreen() / 255.0f * 0.9f, (float)c.getBlue() / 255.0f * 0.9f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72336_d, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f * 0.9f, (float)c.getGreen() / 255.0f * 0.9f, (float)c.getBlue() / 255.0f * 0.9f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
        worldrenderer.pos(p_181561_0_.field_72340_a, p_181561_0_.field_72337_e, p_181561_0_.field_72334_f).color((float)c.getRed() / 255.0f * 0.9f, (float)c.getGreen() / 255.0f * 0.9f, (float)c.getBlue() / 255.0f * 0.9f, (float)c.getAlpha() / 255.0f * alpha).endVertex();
    }

    static {
        skullId = new HashMap<String, CrystalType>(){
            {
                this.put("d9c3168a-8654-3dd8-b297-4d3b7e55b95a", CrystalType.FARMING_MINION);
                this.put("949d100c-aa74-3b09-a642-af5529f808aa", CrystalType.MINING_MINION);
                this.put("bd79a474-cf07-3f8c-b5a4-98657c33520a", CrystalType.FORAGING_MINION);
                this.put("2e474ee3-5361-3218-84db-880eb1cface1", CrystalType.FISHING);
                this.put("7a237e5c-ca9a-3dc1-b1d9-b385fc200aa7", CrystalType.WINTER);
            }
        };
        displayMillis = 0L;
        lastMiningUpdate = 0L;
        crystals = new HashMap();
    }

    private static enum CrystalType {
        FARMING_MINION(8, 14329120),
        MINING_MINION(40, 7232073),
        FORAGING_MINION(12, 107858),
        DESERT(16, 16773496),
        FISHING(15, 1667750),
        WART(5, 8525104),
        WHEAT(6, 16751872),
        WINTER(16, 0x3FFCFF);

        ReverseWorldRenderer overlayVBO = null;
        Set<BlockPos> circleOffsets = null;
        int updates = 0;
        int rgb;
        int radius;

        private CrystalType(int radius, int rgb) {
            this.radius = radius;
            this.rgb = rgb;
        }

        public Set<BlockPos> getCircleOffsets() {
            if (this.circleOffsets != null) {
                return this.circleOffsets;
            }
            this.circleOffsets = new HashSet<BlockPos>();
            for (int x = -this.radius; x <= this.radius; ++x) {
                for (int y = -this.radius; y <= this.radius; ++y) {
                    for (int z = -this.radius; z <= this.radius; ++z) {
                        float distSq = ((float)x - 0.5f) * ((float)x - 0.5f) + (float)(y * y) + ((float)z - 0.5f) * ((float)z - 0.5f);
                        if (!(distSq > (float)((this.radius - 1) * (this.radius - 1))) || !(distSq < (float)(this.radius * this.radius))) continue;
                        this.circleOffsets.add(new BlockPos(x, y, z));
                    }
                }
            }
            return this.circleOffsets;
        }

        public ReverseWorldRenderer getOverlayVBO() {
            if (this.overlayVBO != null) {
                return this.overlayVBO;
            }
            EntityPlayerSP p = Minecraft.func_71410_x().field_71439_g;
            if (p == null) {
                return null;
            }
            if (!crystals.containsKey((Object)this)) {
                return null;
            }
            ReverseWorldRenderer worldRenderer = new ReverseWorldRenderer(196 * this.getCircleOffsets().size());
            worldRenderer.begin(7, DefaultVertexFormats.field_181706_f);
            String col = SpecialColour.special(0, 180, this.rgb);
            for (BlockPos offset : this.getCircleOffsets()) {
                BlockPos overlayPos = new BlockPos(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p());
                AxisAlignedBB bb = new AxisAlignedBB((double)overlayPos.func_177958_n(), (double)overlayPos.func_177956_o(), (double)overlayPos.func_177952_p(), (double)(overlayPos.func_177958_n() + 1), (double)(overlayPos.func_177956_o() + 1), (double)(overlayPos.func_177952_p() + 1)).func_72314_b((double)(0.001f * (float)(this.ordinal() + 1)), (double)(0.001f * (float)(this.ordinal() + 1)), (double)(0.001f * (float)(this.ordinal() + 1)));
                CrystalOverlay.uploadFilledBoundingBox(bb, 1.0f, col, worldRenderer);
            }
            this.overlayVBO = worldRenderer;
            return this.overlayVBO;
        }
    }
}

