/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.miscfeatures;

import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.events.SlotClickEvent;
import io.github.moulberry.notenoughupdates.miscfeatures.WarningPopUp;
import io.github.moulberry.notenoughupdates.util.ItemUtils;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aJ\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aH\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00180\u001aH\u0016J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\b\u0010 \u001a\u00020!H\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\f\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lio/github/moulberry/notenoughupdates/miscfeatures/BazaarPriceWarning;", "Lio/github/moulberry/notenoughupdates/miscfeatures/WarningPopUp;", "()V", "clickedSlot", "Lnet/minecraft/inventory/Slot;", "getClickedSlot", "()Lnet/minecraft/inventory/Slot;", "setClickedSlot", "(Lnet/minecraft/inventory/Slot;)V", "limit", "", "getLimit", "()D", "price", "getPrice", "setPrice", "(D)V", "priceRegx", "Ljava/util/regex/Pattern;", "getPriceRegx", "()Ljava/util/regex/Pattern;", "confirmClick", "", "getItemName", "", "getLore", "", "getWarningLines", "getWarningPopup", "onClick", "event", "Lio/github/moulberry/notenoughupdates/events/SlotClickEvent;", "shouldShow", "", "NotEnoughUpdates"})
@SourceDebugExtension(value={"SMAP\nBazaarPriceWarning.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazaarPriceWarning.kt\nio/github/moulberry/notenoughupdates/miscfeatures/BazaarPriceWarning\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,107:1\n1#2:108\n*E\n"})
public final class BazaarPriceWarning
extends WarningPopUp {
    @Nullable
    private Slot clickedSlot;
    @NotNull
    private final Pattern priceRegx;
    private double price;

    public BazaarPriceWarning() {
        String string = "\u00a77Price: \u00a76([0-9.,]+) coins";
        int n = 0;
        Pattern pattern = Pattern.compile(string, n);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(this, flags)");
        this.priceRegx = pattern;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldShow() {
        EntityPlayerSP entityPlayerSP = Minecraft.func_71410_x().field_71439_g;
        EntityPlayerSP entityPlayerSP2 = entityPlayerSP;
        if (entityPlayerSP == null) return false;
        Container container = entityPlayerSP2.field_71070_bA;
        entityPlayerSP2 = container;
        if (container == null) return false;
        List list = entityPlayerSP2.field_75151_b;
        if (list == null) {
            return false;
        }
        List openSlots = list;
        if (!super.shouldShow()) return false;
        Slot slot = this.clickedSlot;
        if (slot == null) {
            return false;
        }
        if (!openSlots.contains(slot)) return false;
        return true;
    }

    @Nullable
    public final Slot getClickedSlot() {
        return this.clickedSlot;
    }

    public final void setClickedSlot(@Nullable Slot slot) {
        this.clickedSlot = slot;
    }

    @NotNull
    public final Pattern getPriceRegx() {
        return this.priceRegx;
    }

    public final double getPrice() {
        return this.price;
    }

    public final void setPrice(double d) {
        this.price = d;
    }

    public final double getLimit() {
        return NotEnoughUpdates.INSTANCE.config.bazaarTweaks.bazaarOverpayWarning;
    }

    @SubscribeEvent
    public final void onClick(@NotNull SlotClickEvent event) {
        Matcher matcher;
        block10: {
            Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
            EntityPlayerSP entityPlayerSP = Minecraft.func_71410_x().field_71439_g;
            List list = entityPlayerSP != null && (entityPlayerSP = entityPlayerSP.field_71070_bA) != null ? entityPlayerSP.field_75151_b : null;
            if (list == null) {
                return;
            }
            List openSlots = list;
            if (openSlots.size() < 17) {
                return;
            }
            Slot slot = (Slot)openSlots.get(16);
            Object object = slot != null ? slot.func_75211_c() : null;
            if (object == null) {
                return;
            }
            ItemStack signStack = object;
            boolean hasCustomAmount = (Intrinsics.areEqual((Object)signStack.func_77973_b(), (Object)Items.field_151155_ap) || Intrinsics.areEqual((Object)signStack.func_77973_b(), (Object)Item.func_150898_a((Block)Blocks.field_150451_bX))) && !Intrinsics.areEqual((Object)ItemUtils.getDisplayName(signStack), (Object)"\u00a7aCustom Amount");
            String string = Utils.getOpenChestName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOpenChestName()");
            boolean isBuyOrder = StringsKt.contains$default((CharSequence)string, (CharSequence)"How many do you want?", (boolean)false, (int)2, null);
            String string2 = Utils.getOpenChestName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getOpenChestName()");
            boolean isConfirmInstantBuy = StringsKt.contains$default((CharSequence)string2, (CharSequence)"Confirm Instant Buy", (boolean)false, (int)2, null);
            if (hasCustomAmount && !isBuyOrder && !isConfirmInstantBuy) {
                return;
            }
            if (this.shouldShow()) {
                return;
            }
            ItemStack itemStack = event.slot.func_75211_c();
            if (itemStack == null) {
                return;
            }
            ItemStack stack = itemStack;
            List<String> list2 = ItemUtils.getLore(stack);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getLore(stack)");
            List<String> lore = list2;
            if (!Intrinsics.areEqual((Object)CollectionsKt.lastOrNull(lore), (Object)"\u00a77\u00a7eClick to buy now!")) {
                return;
            }
            for (String it : (Iterable)lore) {
                Matcher matcher2;
                boolean bl = false;
                Matcher it2 = matcher2 = this.priceRegx.matcher(it);
                boolean bl2 = false;
                Matcher matcher3 = it2.matches() ? matcher2 : null;
                if (matcher3 == null) continue;
                matcher = matcher3;
                break block10;
            }
            matcher = null;
        }
        if (matcher == null) {
            return;
        }
        Matcher priceMatch = matcher;
        String string = priceMatch.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"priceMatch.group(1)");
        double price = Double.parseDouble(StringsKt.replace$default((String)string, (String)",", (String)"", (boolean)false, (int)4, null));
        if (price <= this.getLimit() || this.getLimit() < 1.0) {
            return;
        }
        this.price = price;
        this.clickedSlot = event.slot;
        this.show();
        event.cancel();
    }

    @NotNull
    public final List<String> getLore() {
        List<String> list;
        Slot slot = this.clickedSlot;
        if (slot != null && (slot = slot.func_75211_c()) != null) {
            Slot p0 = slot;
            boolean bl = false;
            list = ItemUtils.getLore((ItemStack)p0);
        } else {
            list = null;
        }
        List<String> list2 = list;
        return list2 == null ? CollectionsKt.emptyList() : list2;
    }

    @Override
    @NotNull
    public String getItemName() {
        String string = (String)CollectionsKt.firstOrNull(this.getLore());
        if (string == null) {
            string = "<unknown>";
        }
        return string;
    }

    @Override
    @NotNull
    public List<String> getWarningLines() {
        return CollectionsKt.listOf((Object)("will cost you \u00a76" + StringUtils.formatNumber(this.price) + "\u00a7r coins"));
    }

    @Override
    @NotNull
    public List<String> getWarningPopup() {
        String string;
        Slot slot = this.clickedSlot;
        if (slot != null && (slot = slot.func_75211_c()) != null) {
            Slot p0 = slot;
            boolean bl = false;
            string = ItemUtils.getDisplayName((ItemStack)p0);
        } else {
            string = null;
        }
        String displayName = string;
        List tooltip = CollectionsKt.toMutableList((Collection)this.getLore());
        if (displayName != null) {
            tooltip.add(0, displayName);
        }
        return tooltip;
    }

    @Override
    public void confirmClick() {
        GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
        Intrinsics.checkNotNull((Object)guiScreen, (String)"null cannot be cast to non-null type net.minecraft.client.gui.inventory.GuiChest");
        GuiChest chest = (GuiChest)guiScreen;
        Slot slot = this.clickedSlot;
        if (slot == null) {
            return;
        }
        Minecraft.func_71410_x().field_71442_b.func_78753_a(chest.field_147002_h.field_75152_c, slot.field_75222_d, 0, 0, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
    }
}

