/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.loader;

import io.github.moulberry.notenoughupdates.loader.JARLoadingTweaker;
import java.nio.file.Path;
import java.util.Arrays;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class KotlinLoadingTweaker
extends JARLoadingTweaker {
    public static final int[] BUNDLED_KOTLIN_VERSION = new int[]{1, 8, 21};

    @Override
    protected Path getFilesToLoad() {
        int[] requiredVersion;
        if ("1".equals(System.getProperty("neu.relinquishkotlin"))) {
            System.out.println("NEU is forced to relinquish Kotlin by user configuration.");
            return null;
        }
        if (Launch.blackboard.get("fml.deobfuscatedEnvironment") == Boolean.TRUE) {
            System.out.println("Skipping NEU Kotlin loading in development environment.");
            return null;
        }
        Object relinquishAlways = Launch.blackboard.get("neu.relinquishkotlin.always");
        if (relinquishAlways == Boolean.TRUE) {
            System.err.println("NEU is forced to blanket relinquish loading Kotlin. This is probably a bad judgement call by another developer.");
            return null;
        }
        Object relinquishIfBelow = Launch.blackboard.get("neu.relinquishkotlin.ifbelow");
        if (relinquishIfBelow instanceof int[] && !this.areWeBundlingAKotlinVersionHigherThan(requiredVersion = (int[])relinquishIfBelow)) {
            System.err.println("NEU is relinquishing loading Kotlin because a higher version is requested. This may lead to errors if the advertised Kotlin version is not found. (" + Arrays.toString(requiredVersion) + " required, " + Arrays.toString(BUNDLED_KOTLIN_VERSION) + " available)");
            return null;
        }
        System.out.println("Attempting to load Kotlin from NEU wrapped libraries.");
        return this.getShadowedElement("/neu-kotlin-libraries-wrapped");
    }

    @Override
    protected String getTestClass() {
        return "kotlin.KotlinVersion";
    }

    public boolean areWeBundlingAKotlinVersionHigherThan(int[] x) {
        int i = 0;
        while (true) {
            boolean doTheyHaveMoreVersionIdsLeft;
            boolean doWeHaveMoreVersionIdsLeft = i < BUNDLED_KOTLIN_VERSION.length;
            boolean bl = doTheyHaveMoreVersionIdsLeft = i < x.length;
            if (doWeHaveMoreVersionIdsLeft && !doTheyHaveMoreVersionIdsLeft) {
                return false;
            }
            if (doTheyHaveMoreVersionIdsLeft && !doWeHaveMoreVersionIdsLeft) {
                return true;
            }
            if (!doTheyHaveMoreVersionIdsLeft) {
                return true;
            }
            if (x[i] > BUNDLED_KOTLIN_VERSION[i]) {
                return false;
            }
            ++i;
        }
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
        this.performLoading(classLoader);
    }
}

