/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.listener;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import io.github.moulberry.notenoughupdates.ItemPriceInformation;
import io.github.moulberry.notenoughupdates.NotEnoughUpdates;
import io.github.moulberry.notenoughupdates.core.util.StringUtils;
import io.github.moulberry.notenoughupdates.miscfeatures.PetInfoOverlay;
import io.github.moulberry.notenoughupdates.util.Constants;
import io.github.moulberry.notenoughupdates.util.PetLeveling;
import io.github.moulberry.notenoughupdates.util.Utils;
import java.awt.datatransfer.StringSelection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiChest;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.input.Keyboard;

public class ItemTooltipListener {
    public static final Pattern petToolTipRegex = Pattern.compile("((Farming)|(Combat)|(Fishing)|(Mining)|(Foraging)|(Enchanting)|(Alchemy)) ((Mount)|(Pet)|(Morph)).*");
    public final Pattern gemstoneRegex = Pattern.compile("(ROUGH|FLAWED|FINE|FLAWLESS|PERFECT)_(RUBY|AMBER|SAPPHIRE|JADE|AMETHYST|TOPAZ|JASPER|OPAL|AQUAMARINE|CITRINE|ONYX|PERIDOT)_GEM");
    private final NotEnoughUpdates neu;
    private final Pattern xpLevelPattern = Pattern.compile("(.*) (\\xA7e(.*)\\xA76/\\xA7e(.*))");
    private final HashSet<String> percentStats = new HashSet();
    DecimalFormat myFormatter = new DecimalFormat("#,###,###.###");
    private String currentRarity = "COMMON";
    private String currentGemstoneRarity = "COMMON";
    private boolean copied = false;
    private boolean showReforgeStoneStats = true;
    private boolean showGemstoneStats = true;
    private boolean pressedArrowLast = false;
    private boolean pressedShiftLast = false;
    JsonArray skullTextures = new JsonArray();

    public ItemTooltipListener(NotEnoughUpdates neu) {
        this.neu = neu;
        this.percentStats.add("bonus_attack_speed");
        this.percentStats.add("crit_damage");
        this.percentStats.add("crit_chance");
        this.percentStats.add("sea_creature_chance");
        this.percentStats.add("ability_damage");
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemTooltipLow(ItemTooltipEvent event) {
        HashSet ignoreFromPool;
        JsonArray allItemEnchs;
        JsonObject enchantsConst;
        Set enchantIds;
        boolean hasEnchantments;
        String internalName;
        block96: {
            if (!NotEnoughUpdates.INSTANCE.isOnSkyblock()) {
                return;
            }
            internalName = NotEnoughUpdates.INSTANCE.manager.createItemResolutionQuery().withCurrentGuiContext().withItemStack(event.itemStack).resolveInternalName();
            if (internalName == null) {
                return;
            }
            this.petToolTipXPExtendPetMenu(event);
            hasEnchantments = event.itemStack.func_77978_p().func_74775_l("ExtraAttributes").func_150297_b("enchantments", 10);
            enchantIds = new HashSet();
            if (hasEnchantments) {
                enchantIds = event.itemStack.func_77978_p().func_74775_l("ExtraAttributes").func_74775_l("enchantments").func_150296_c();
            }
            enchantsConst = Constants.ENCHANTS;
            allItemEnchs = null;
            ignoreFromPool = new HashSet();
            if (enchantsConst != null && hasEnchantments && NotEnoughUpdates.INSTANCE.config.tooltipTweaks.missingEnchantList) {
                try {
                    NBTTagCompound display;
                    JsonArray enchantPools = enchantsConst.get("enchant_pools").getAsJsonArray();
                    block8: for (JsonElement element : enchantPools) {
                        String poolS;
                        HashSet<String> currentPool = new HashSet<String>();
                        for (JsonElement poolElement : element.getAsJsonArray()) {
                            poolS = poolElement.getAsString();
                            currentPool.add(poolS);
                        }
                        for (JsonElement poolElement : element.getAsJsonArray()) {
                            poolS = poolElement.getAsString();
                            if (!enchantIds.contains(poolS)) continue;
                            ignoreFromPool.addAll(currentPool);
                            continue block8;
                        }
                    }
                    JsonObject enchantsObj = enchantsConst.get("enchants").getAsJsonObject();
                    NBTTagCompound tag = event.itemStack.func_77978_p();
                    if (tag == null || !(display = tag.func_74775_l("display")).func_150297_b("Lore", 9)) break block96;
                    NBTTagList list = display.func_150295_c("Lore", 8);
                    for (int i = list.func_74745_c(); i >= 0; --i) {
                        String line = list.func_150307_f(i);
                        for (int j = 0; j < Utils.rarityArrC.length; ++j) {
                            for (Map.Entry<String, JsonElement> entry : enchantsObj.entrySet()) {
                                if (!line.contains(Utils.rarityArrC[j] + " " + entry.getKey()) && !line.contains(Utils.rarityArrC[j] + " DUNGEON " + entry.getKey()) && !line.contains("SHINY " + Utils.rarityArrC[j].replaceAll("\u00a7.\u00a7.", "") + " DUNGEON " + entry.getKey())) continue;
                                allItemEnchs = entry.getValue().getAsJsonArray();
                                break block96;
                            }
                        }
                    }
                }
                catch (Exception enchantPools) {
                    // empty catch block
                }
            }
        }
        boolean gotToEnchants = false;
        boolean passedEnchants = false;
        boolean dungeonProfit = false;
        ArrayList<String> newTooltip = new ArrayList<String>();
        for (int k = 0; k < event.toolTip.size(); ++k) {
            String valueStringBIN2;
            String valueStringBIN1;
            String line = (String)event.toolTip.get(k);
            if (line.endsWith(EnumChatFormatting.DARK_GRAY + "Reforge Stone") && NotEnoughUpdates.INSTANCE.config.tooltipTweaks.showReforgeStats) {
                JsonObject reforgeStones = Constants.REFORGESTONES;
                if (reforgeStones != null && reforgeStones.has(internalName)) {
                    JsonObject stats;
                    JsonElement statsRarE;
                    boolean shift;
                    boolean bl = shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
                    if (!this.pressedShiftLast && shift) {
                        this.showReforgeStoneStats = !this.showReforgeStoneStats;
                    }
                    this.pressedShiftLast = shift;
                    newTooltip.add(line);
                    newTooltip.add("");
                    if (!this.showReforgeStoneStats) {
                        newTooltip.add(EnumChatFormatting.DARK_GRAY + "[Press SHIFT to show extra info]");
                    } else {
                        newTooltip.add(EnumChatFormatting.DARK_GRAY + "[Press SHIFT to hide extra info]");
                    }
                    JsonObject reforgeInfo = reforgeStones.get(internalName).getAsJsonObject();
                    JsonArray requiredRaritiesArray = reforgeInfo.get("requiredRarities").getAsJsonArray();
                    if (!this.showReforgeStoneStats || requiredRaritiesArray.size() <= 0) continue;
                    String reforgeName = Utils.getElementAsString(reforgeInfo.get("reforgeName"), "");
                    String[] requiredRarities = new String[requiredRaritiesArray.size()];
                    for (int i = 0; i < requiredRaritiesArray.size(); ++i) {
                        requiredRarities[i] = requiredRaritiesArray.get(i).getAsString();
                    }
                    int rarityIndex = requiredRarities.length - 1;
                    String rarity = requiredRarities[rarityIndex];
                    for (int i = 0; i < requiredRarities.length; ++i) {
                        String rar = requiredRarities[i];
                        if (!rar.equalsIgnoreCase(this.currentRarity)) continue;
                        rarity = rar;
                        rarityIndex = i;
                        break;
                    }
                    boolean left = Keyboard.isKeyDown((int)203);
                    boolean right = Keyboard.isKeyDown((int)205);
                    if (!this.pressedArrowLast && (left || right)) {
                        rarityIndex = left ? --rarityIndex : ++rarityIndex;
                        if (rarityIndex < 0) {
                            rarityIndex = 0;
                        }
                        if (rarityIndex >= requiredRarities.length) {
                            rarityIndex = requiredRarities.length - 1;
                        }
                        rarity = this.currentRarity = requiredRarities[rarityIndex];
                    }
                    this.pressedArrowLast = left || right;
                    JsonElement statsE = reforgeInfo.get("reforgeStats");
                    String rarityFormatted = Utils.rarityArrMap.getOrDefault(rarity, rarity);
                    JsonElement reforgeAbilityE = reforgeInfo.get("reforgeAbility");
                    String reforgeAbility = null;
                    if (reforgeAbilityE != null) {
                        if (reforgeAbilityE.isJsonPrimitive() && reforgeAbilityE.getAsJsonPrimitive().isString()) {
                            reforgeAbility = Utils.getElementAsString(reforgeInfo.get("reforgeAbility"), "");
                        } else if (reforgeAbilityE.isJsonObject() && reforgeAbilityE.getAsJsonObject().has(rarity)) {
                            reforgeAbility = reforgeAbilityE.getAsJsonObject().get(rarity).getAsString();
                        }
                    }
                    if (reforgeAbility != null && !reforgeAbility.isEmpty()) {
                        String text = EnumChatFormatting.BLUE + (reforgeName.isEmpty() ? "Bonus: " : reforgeName + " Bonus: ") + EnumChatFormatting.GRAY + reforgeAbility;
                        boolean first = true;
                        for (String s : Minecraft.func_71410_x().field_71466_p.func_78271_c(text, 150)) {
                            newTooltip.add((first ? "" : "  ") + s);
                            first = false;
                        }
                        newTooltip.add("");
                    }
                    newTooltip.add(EnumChatFormatting.BLUE + "Stats for " + rarityFormatted + "\u00a79: [\u00a7l\u00a7m< \u00a79Switch\u00a7l\u00a7m >\u00a79]");
                    if (statsE != null && statsE.isJsonObject() && (statsRarE = (stats = statsE.getAsJsonObject()).get(rarity)) != null && statsRarE.isJsonObject()) {
                        JsonObject statsRar = statsRarE.getAsJsonObject();
                        TreeSet sorted = new TreeSet(Map.Entry.comparingByKey());
                        sorted.addAll(statsRar.entrySet());
                        for (Map.Entry entry : sorted) {
                            if (!((JsonElement)entry.getValue()).isJsonPrimitive() || !((JsonPrimitive)entry.getValue()).isNumber()) continue;
                            float statNumF = ((JsonElement)entry.getValue()).getAsFloat();
                            String statNumS = statNumF % 1.0f == 0.0f ? String.valueOf(Math.round(statNumF)) : Utils.floatToString(statNumF, 1);
                            String reforgeNamePretty = WordUtils.capitalizeFully((String)((String)entry.getKey()).replace("_", " "));
                            String text = EnumChatFormatting.GRAY + reforgeNamePretty + ": " + EnumChatFormatting.GREEN + "+" + statNumS;
                            if (this.percentStats.contains(entry.getKey())) {
                                text = text + "%";
                            }
                            newTooltip.add("  " + text);
                        }
                    }
                    JsonElement reforgeCostsE = reforgeInfo.get("reforgeCosts");
                    int reforgeCost = -1;
                    if (reforgeCostsE != null) {
                        if (reforgeCostsE.isJsonPrimitive() && reforgeCostsE.getAsJsonPrimitive().isNumber()) {
                            reforgeCost = (int)Utils.getElementAsFloat(reforgeInfo.get("reforgeAbility"), -1.0f);
                        } else if (reforgeCostsE.isJsonObject() && reforgeCostsE.getAsJsonObject().has(rarity)) {
                            reforgeCost = (int)Utils.getElementAsFloat(reforgeCostsE.getAsJsonObject().get(rarity), -1.0f);
                        }
                    }
                    if (reforgeCost < 0) continue;
                    String text = EnumChatFormatting.BLUE + "Apply Cost: " + EnumChatFormatting.GOLD + StringUtils.formatNumber(reforgeCost) + " coins";
                    newTooltip.add("");
                    newTooltip.add(text);
                    continue;
                }
            } else if (this.gemstoneRegex.matcher(internalName).matches() && NotEnoughUpdates.INSTANCE.config.tooltipTweaks.showGemstoneStats) {
                String[] splitInternal = internalName.split("_");
                String gemstoneTier = splitInternal[0];
                String gemstoneType = splitInternal[1];
                JsonObject gemstones = Constants.GEMSTONES;
                if (gemstones != null && gemstones.getAsJsonObject("gemstoneTypes").has(gemstoneType) && gemstones.getAsJsonObject("gemstoneTypes").getAsJsonObject(gemstoneType).getAsJsonObject("stats").has(gemstoneTier)) {
                    int lineToInject;
                    int n = lineToInject = ((String)event.toolTip.get(1)).contains("Collection Item") ? 3 : 1;
                    if (k == lineToInject) {
                        boolean shift;
                        boolean bl = shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
                        if (!this.pressedShiftLast && shift) {
                            this.showGemstoneStats = !this.showGemstoneStats;
                        }
                        this.pressedShiftLast = shift;
                        if (!this.showGemstoneStats) {
                            newTooltip.add(EnumChatFormatting.DARK_GRAY + "[Press SHIFT to show extra info]");
                        } else {
                            newTooltip.add(EnumChatFormatting.DARK_GRAY + "[Press SHIFT to hide extra info]");
                        }
                        JsonObject gemstoneInfo = gemstones.getAsJsonObject("gemstoneTypes").getAsJsonObject(gemstoneType);
                        JsonObject statNums = gemstoneInfo.getAsJsonObject("stats").getAsJsonObject(gemstoneTier);
                        ArrayList<Map.Entry<String, JsonElement>> validRarities = new ArrayList<Map.Entry<String, JsonElement>>(statNums.entrySet());
                        int rarityIndex = validRarities.size() - 1;
                        String rarity = (String)((Map.Entry)validRarities.get(rarityIndex)).getKey();
                        for (int i = 0; i < validRarities.size(); ++i) {
                            String rar = (String)((Map.Entry)validRarities.get(i)).getKey();
                            if (!rar.equalsIgnoreCase(this.currentGemstoneRarity)) continue;
                            rarity = rar;
                            rarityIndex = i;
                            break;
                        }
                        if (this.showGemstoneStats) {
                            boolean left = Keyboard.isKeyDown((int)203);
                            boolean right = Keyboard.isKeyDown((int)205);
                            if (!this.pressedArrowLast && (left || right)) {
                                rarityIndex = left ? --rarityIndex : ++rarityIndex;
                                if (rarityIndex < 0) {
                                    rarityIndex = 0;
                                }
                                if (rarityIndex >= validRarities.size()) {
                                    rarityIndex = validRarities.size() - 1;
                                }
                                rarity = this.currentGemstoneRarity = (String)((Map.Entry)validRarities.get(rarityIndex)).getKey();
                            }
                            this.pressedArrowLast = left || right;
                            String rarityFormatted = Utils.rarityArrMap.getOrDefault(rarity, rarity);
                            String statName = gemstoneInfo.get("statName").getAsString();
                            double statNum = ((JsonElement)((Map.Entry)validRarities.get(rarityIndex)).getValue()).getAsDouble();
                            int removalCost = gemstones.getAsJsonObject("removalCosts").get(gemstoneTier).getAsInt();
                            String formattedStatNum = "";
                            formattedStatNum = statNum == 0.0 ? "???" : (statNum % 1.0 == 0.0 ? formattedStatNum + Math.round(statNum) : formattedStatNum + statNum);
                            if (gemstoneInfo.has("chiselBonus")) {
                                String chiselBonus = gemstoneInfo.get("chiselBonus").getAsString();
                                String formattedChiselBonus = chiselBonus.replace("{}", gemstones.getAsJsonObject("chiselPercentages").get(gemstoneTier).getAsString());
                                newTooltip.add("");
                                String text = EnumChatFormatting.BLUE + "Chisel bonus: " + formattedChiselBonus;
                                boolean first = true;
                                for (String s : Minecraft.func_71410_x().field_71466_p.func_78271_c(text, 150)) {
                                    newTooltip.add((first ? "" : "  ") + s);
                                    first = false;
                                }
                                newTooltip.add("");
                            }
                            newTooltip.add("\u00a79Stats for " + rarityFormatted + "\u00a79: [\u00a7l\u00a7m< \u00a79Switch\u00a7l\u00a7m >\u00a79]");
                            newTooltip.add("  \u00a77" + statName + ": \u00a7a+" + formattedStatNum);
                            newTooltip.add("");
                            newTooltip.add("\u00a79Removal Cost: \u00a76" + StringUtils.formatNumber(removalCost) + (removalCost == 1 ? " coin" : " coins"));
                            newTooltip.add("\u00a78Combinable in Gemstone Grinder or The Hex");
                            newTooltip.add("");
                        }
                    }
                }
            } else if (line.contains("\u00a7cR\u00a76a\u00a7ei\u00a7an\u00a7bb\u00a79o\u00a7dw\u00a79 Rune")) {
                line = line.replace("\u00a7cR\u00a76a\u00a7ei\u00a7an\u00a7bb\u00a79o\u00a7dw\u00a79 Rune", Utils.chromaString("Rainbow Rune", (float)k, false) + EnumChatFormatting.BLUE);
            } else if (hasEnchantments && Keyboard.isKeyDown((int)42) && NotEnoughUpdates.INSTANCE.config.tooltipTweaks.missingEnchantList) {
                boolean lineHasEnch = false;
                for (Object s : enchantIds) {
                    String enchantName = WordUtils.capitalizeFully((String)((String)s).replace("_", " "));
                    if (!line.contains(enchantName)) continue;
                    lineHasEnch = true;
                    break;
                }
                if (lineHasEnch) {
                    gotToEnchants = true;
                } else if (gotToEnchants && !passedEnchants && Utils.cleanColour(line).trim().length() == 0) {
                    if (enchantsConst != null && allItemEnchs != null) {
                        Object s;
                        ArrayList<String> missing = new ArrayList<String>();
                        s = allItemEnchs.iterator();
                        while (s.hasNext()) {
                            JsonElement enchIdElement = (JsonElement)s.next();
                            String enchId = enchIdElement.getAsString();
                            if (enchId.startsWith("ultimate_") || ignoreFromPool.contains(enchId) || enchantIds.contains(enchId)) continue;
                            missing.add(enchId);
                        }
                        if (!missing.isEmpty()) {
                            newTooltip.add("");
                            StringBuilder currentLine = new StringBuilder(EnumChatFormatting.RED + "Missing: " + EnumChatFormatting.GRAY);
                            for (int i = 0; i < missing.size(); ++i) {
                                String enchName = WordUtils.capitalizeFully((String)((String)missing.get(i)).replace("_", " "));
                                if (currentLine.length() != 0 && Utils.cleanColour(currentLine.toString()).length() + enchName.length() > 40) {
                                    newTooltip.add(currentLine.toString());
                                    currentLine = new StringBuilder();
                                }
                                if (currentLine.length() != 0 && i != 0) {
                                    currentLine.append(", ").append(enchName);
                                    continue;
                                }
                                currentLine.append(EnumChatFormatting.GRAY).append(enchName);
                            }
                            if (currentLine.length() != 0) {
                                newTooltip.add(currentLine.toString());
                            }
                        }
                    }
                    passedEnchants = true;
                }
            }
            newTooltip.add(line);
            if (NotEnoughUpdates.INSTANCE.config.tooltipTweaks.showPriceInfoAucItem && (line.contains(EnumChatFormatting.GRAY + "Buy it now: ") || line.contains(EnumChatFormatting.GRAY + "Bidder: ") || line.contains(EnumChatFormatting.GRAY + "Starting bid: "))) {
                if (!Keyboard.isKeyDown((int)42) && !Keyboard.isKeyDown((int)54)) {
                    newTooltip.add("");
                    newTooltip.add(EnumChatFormatting.GRAY + "[SHIFT for Price Info]");
                } else {
                    ItemPriceInformation.addToTooltip(newTooltip, internalName, event.itemStack);
                }
            }
            if (NotEnoughUpdates.INSTANCE.config.dungeons.profitDisplayLoc != 2 || !(Minecraft.func_71410_x().field_71462_r instanceof GuiChest)) continue;
            if (line.contains(EnumChatFormatting.GREEN + "Open Reward Chest")) {
                dungeonProfit = true;
                continue;
            }
            if (k != 7 || !dungeonProfit) continue;
            GuiChest eventGui = (GuiChest)Minecraft.func_71410_x().field_71462_r;
            ContainerChest cc = (ContainerChest)eventGui.field_147002_h;
            IInventory lower2 = cc.func_85151_d();
            int chestCost = 0;
            try {
                JsonObject dungeonChestKey;
                String line6 = Utils.cleanColour(line);
                String line7 = "";
                if (event.toolTip.size() > 7) {
                    line7 = Utils.cleanColour((String)event.toolTip.get(k + 1));
                }
                StringBuilder cost = new StringBuilder();
                for (int i = 0; i < line6.length(); ++i) {
                    char c = line6.charAt(i);
                    if ("0123456789".indexOf(c) < 0) continue;
                    cost.append(c);
                }
                if (cost.length() > 0) {
                    chestCost = Integer.parseInt(cost.toString());
                }
                if (this.neu.config.dungeons.useChestKeyCost && (line6.contains("Dungeon Chest Key") || line7.contains("Dungeon Chest Key")) && (dungeonChestKey = this.neu.manager.auctionManager.getBazaarInfo("DUNGEON_CHEST_KEY")) != null && dungeonChestKey.has("curr_buy")) {
                    float bazaarPrice = dungeonChestKey.get("curr_buy").getAsFloat();
                    chestCost = (int)((float)chestCost + bazaarPrice);
                }
            }
            catch (Exception line6) {
                // empty catch block
            }
            String missingItem = null;
            int totalValue = 0;
            HashMap<String, Double> itemValues = new HashMap<String, Double>();
            for (int i = 0; i < 7; ++i) {
                ItemStack item = lower2.func_70301_a(10 + i);
                String internal = this.neu.manager.getInternalNameForItem(item);
                if (internal == null) continue;
                internal = internal.replace("\u00cd", "I").replace("\u0130", "I");
                float bazaarPrice = -1.0f;
                JsonObject bazaarInfo = this.neu.manager.auctionManager.getBazaarInfo(internal);
                if (bazaarInfo != null && bazaarInfo.has("curr_sell")) {
                    bazaarPrice = bazaarInfo.get("curr_sell").getAsFloat();
                }
                if (bazaarPrice < 5000000.0f && internal.equals("RECOMBOBULATOR_3000")) {
                    bazaarPrice = 5000000.0f;
                }
                double worth = -1.0;
                if (bazaarPrice > 0.0f) {
                    worth = bazaarPrice;
                } else {
                    JsonObject auctionInfo;
                    switch (NotEnoughUpdates.INSTANCE.config.dungeons.profitType) {
                        case 1: {
                            worth = this.neu.manager.auctionManager.getItemAvgBin(internal);
                            break;
                        }
                        case 2: {
                            auctionInfo = this.neu.manager.auctionManager.getItemAuctionInfo(internal);
                            if (auctionInfo == null) break;
                            if (auctionInfo.has("clean_price")) {
                                worth = (long)auctionInfo.get("clean_price").getAsDouble();
                                break;
                            }
                            worth = (long)(auctionInfo.get("price").getAsDouble() / auctionInfo.get("count").getAsDouble());
                            break;
                        }
                        default: {
                            worth = this.neu.manager.auctionManager.getLowestBin(internal);
                        }
                    }
                    if (worth <= 0.0 && (worth = (double)this.neu.manager.auctionManager.getLowestBin(internal)) <= 0.0 && (worth = this.neu.manager.auctionManager.getItemAvgBin(internal)) <= 0.0 && (auctionInfo = this.neu.manager.auctionManager.getItemAuctionInfo(internal)) != null) {
                        worth = auctionInfo.has("clean_price") ? (double)((int)auctionInfo.get("clean_price").getAsFloat()) : (double)((int)(auctionInfo.get("price").getAsFloat() / auctionInfo.get("count").getAsFloat()));
                    }
                }
                if (worth > 0.0 && totalValue >= 0) {
                    NBTTagCompound tag;
                    totalValue = (int)((double)totalValue + worth);
                    String display = item.func_82833_r();
                    if (display.contains("Enchanted Book") && (tag = item.func_77978_p()) != null && tag.func_150297_b("ExtraAttributes", 10)) {
                        NBTTagCompound ea = tag.func_74775_l("ExtraAttributes");
                        NBTTagCompound enchants = ea.func_74775_l("enchantments");
                        int highestLevel = -1;
                        for (String enchname : enchants.func_150296_c()) {
                            int level = enchants.func_74762_e(enchname);
                            if (level <= highestLevel) continue;
                            display = EnumChatFormatting.BLUE + WordUtils.capitalizeFully((String)enchname.replace("_", " ").replace("Ultimate", "").trim()) + " " + level;
                        }
                    }
                    itemValues.put(display, worth);
                    continue;
                }
                if (totalValue != -1) {
                    missingItem = internal;
                }
                totalValue = -1;
            }
            if (totalValue >= 0) {
                valueStringBIN1 = EnumChatFormatting.YELLOW + "Value (BIN): ";
                valueStringBIN2 = EnumChatFormatting.GOLD + StringUtils.formatNumber(totalValue) + " coins";
            } else {
                valueStringBIN1 = EnumChatFormatting.YELLOW + "Can't find BIN: ";
                valueStringBIN2 = missingItem;
            }
            int profitLossBIN = totalValue - chestCost;
            String profitPrefix = EnumChatFormatting.DARK_GREEN.toString();
            String lossPrefix = EnumChatFormatting.RED.toString();
            String prefix = profitLossBIN >= 0 ? profitPrefix : lossPrefix;
            String plStringBIN = profitLossBIN >= 0 ? prefix + "+" + StringUtils.formatNumber(profitLossBIN) + " coins" : prefix + "-" + StringUtils.formatNumber(-profitLossBIN) + " coins";
            String neu = EnumChatFormatting.YELLOW + "[NEU] ";
            newTooltip.add(neu + valueStringBIN1 + " " + valueStringBIN2);
            if (totalValue >= 0) {
                newTooltip.add(neu + EnumChatFormatting.YELLOW + "Profit/Loss: " + plStringBIN);
            }
            for (Map.Entry entry : itemValues.entrySet()) {
                newTooltip.add(neu + (String)entry.getKey() + prefix + "+" + StringUtils.formatNumber(((Double)entry.getValue()).intValue()));
            }
        }
        this.pressedShiftLast = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
        this.pressedArrowLast = Keyboard.isKeyDown((int)203) || Keyboard.isKeyDown((int)205);
        event.toolTip.clear();
        event.toolTip.addAll(newTooltip);
        if (NotEnoughUpdates.INSTANCE.config.tooltipTweaks.showPriceInfoInvItem) {
            ItemPriceInformation.addToTooltip(event.toolTip, internalName, event.itemStack);
        }
        if (event.itemStack.func_77978_p() != null && event.itemStack.func_77978_p().func_74767_n("NEUHIDEPETTOOLTIP") && NotEnoughUpdates.INSTANCE.config.petOverlay.hidePetTooltip) {
            event.toolTip.clear();
        }
    }

    private void petToolTipXPExtendPetMenu(ItemTooltipEvent event) {
        if (!NotEnoughUpdates.INSTANCE.config.tooltipTweaks.petExtendExp) {
            return;
        }
        if (event.toolTip.size() < 7) {
            return;
        }
        if (event.itemStack.func_77978_p().func_74764_b("NEUHIDEPETTOOLTIP")) {
            return;
        }
        if (petToolTipRegex.matcher(Utils.cleanColour((String)event.toolTip.get(1))).matches()) {
            PetInfoOverlay.Pet pet;
            int xpLine = -1;
            for (int i = event.toolTip.size() - 1; i >= 0; --i) {
                Matcher matcher = this.xpLevelPattern.matcher((CharSequence)event.toolTip.get(i));
                if (matcher.matches()) {
                    xpLine = i;
                    event.toolTip.set(xpLine, matcher.group(1));
                    break;
                }
                if (!((String)event.toolTip.get(i)).matches("MAX LEVEL")) continue;
                return;
            }
            if ((pet = PetInfoOverlay.getPetFromStack(event.itemStack.func_77978_p())) == null) {
                return;
            }
            PetLeveling.PetLevel petLevel = pet.petLevel;
            if (petLevel == null || xpLine == -1) {
                return;
            }
            event.toolTip.add(xpLine + 1, EnumChatFormatting.GRAY + "EXP: " + EnumChatFormatting.YELLOW + this.myFormatter.format(petLevel.getExpInCurrentLevel()) + EnumChatFormatting.GOLD + "/" + EnumChatFormatting.YELLOW + this.myFormatter.format(petLevel.getExpRequiredForNextLevel()));
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        String secondLine;
        if (!this.neu.isOnSkyblock()) {
            return;
        }
        if (event.toolTip == null) {
            return;
        }
        if (event.toolTip.size() > 2 && NotEnoughUpdates.INSTANCE.config.tooltipTweaks.hideDefaultReforgeStats && (secondLine = StringUtils.cleanColour((String)event.toolTip.get(1))).equals("Reforge Stone")) {
            Integer startIndex = null;
            Integer cutoffIndex = null;
            for (int i = event.toolTip.size() - 1; i >= 0; --i) {
                String line = StringUtils.cleanColour((String)event.toolTip.get(i));
                if (line.contains("REFORGE STONE") || line.contains("Requires Mining Skill Level")) {
                    cutoffIndex = i;
                }
                if (!line.contains("(Legendary):")) continue;
                startIndex = i;
                break;
            }
            if (startIndex != null && cutoffIndex != null && startIndex < cutoffIndex) {
                event.toolTip.subList(startIndex, cutoffIndex).clear();
            }
        }
        if (Keyboard.isKeyDown((int)29) && NotEnoughUpdates.INSTANCE.config.hidden.dev && event.toolTip.size() > 0 && ((String)event.toolTip.get(event.toolTip.size() - 1)).startsWith(EnumChatFormatting.DARK_GRAY + "NBT: ")) {
            event.toolTip.remove(event.toolTip.size() - 1);
            StringBuilder sb = new StringBuilder();
            String nbt = event.itemStack.func_77978_p().toString();
            int indent = 0;
            for (char c : nbt.toCharArray()) {
                int i;
                boolean newline = false;
                if (c == '{' || c == '[') {
                    ++indent;
                    newline = true;
                } else if (c == '}' || c == ']') {
                    --indent;
                    sb.append("\n");
                    for (i = 0; i < indent; ++i) {
                        sb.append("  ");
                    }
                } else if (c == ',') {
                    newline = true;
                } else if (c == '\"') {
                    sb.append(EnumChatFormatting.RESET).append(EnumChatFormatting.GRAY);
                }
                sb.append(c);
                if (!newline) continue;
                sb.append("\n");
                for (i = 0; i < indent; ++i) {
                    sb.append("  ");
                }
            }
            event.toolTip.add(sb.toString());
            if (Keyboard.isKeyDown((int)35)) {
                if (!this.copied) {
                    this.copied = true;
                    StringSelection selection = new StringSelection(sb.toString().replace("\u00a7r\u00a77", ""));
                    Utils.copyToClipboard(selection, selection);
                }
            } else {
                this.copied = false;
            }
        } else if (NotEnoughUpdates.INSTANCE.packDevEnabled) {
            event.toolTip.add("");
            event.toolTip.add(EnumChatFormatting.AQUA + "NEU Pack Dev Info:");
            event.toolTip.add(EnumChatFormatting.GRAY + "Press " + EnumChatFormatting.GOLD + "[KEY]" + EnumChatFormatting.GRAY + " to copy line");
            String internal = NotEnoughUpdates.INSTANCE.manager.getInternalNameForItem(event.itemStack);
            boolean k = Keyboard.isKeyDown((int)37);
            boolean m = Keyboard.isKeyDown((int)50);
            boolean n = Keyboard.isKeyDown((int)49);
            boolean f = Keyboard.isKeyDown((int)33);
            boolean b = Keyboard.isKeyDown((int)48);
            boolean y = Keyboard.isKeyDown((int)21);
            boolean j = Keyboard.isKeyDown((int)36);
            boolean isDev = NotEnoughUpdates.INSTANCE.config.hidden.dev;
            if (!this.copied && f && isDev) {
                Utils.copyToClipboard(NotEnoughUpdates.INSTANCE.manager.getSkullValueForItem(event.itemStack));
            }
            if (!this.copied && j && isDev) {
                this.skullTextures = new JsonArray();
                Utils.addChatMessage("Reset skull texture list");
            }
            event.toolTip.add(EnumChatFormatting.AQUA + "Internal Name: " + EnumChatFormatting.GRAY + internal + EnumChatFormatting.GOLD + " [K]");
            if (!this.copied && k) {
                Utils.copyToClipboard(internal);
            }
            if (event.itemStack.func_77978_p() != null) {
                NBTTagCompound tag = event.itemStack.func_77978_p();
                event.toolTip.add(EnumChatFormatting.AQUA + "NBT: " + EnumChatFormatting.GRAY + "[...]" + EnumChatFormatting.GOLD + " [B]");
                if (!this.copied && b) {
                    Utils.copyToClipboard(tag.toString());
                }
                if (tag.func_150297_b("SkullOwner", 10)) {
                    GameProfile gameprofile;
                    if (!this.copied && y && isDev) {
                        NBTTagCompound skullOwner = event.itemStack.func_77978_p().func_74775_l("SkullOwner");
                        String id = skullOwner.func_74779_i("Id");
                        String value = skullOwner.func_74775_l("Properties").func_150295_c("textures", 10).func_150305_b(0).func_74779_i("Value");
                        this.skullTextures.add(new JsonPrimitive(id + ":" + value));
                        Utils.addChatMessage("Added " + event.itemStack.func_82833_r() + " to the texture list. Size: " + this.skullTextures.size());
                        Utils.copyToClipboard(this.skullTextures.toString());
                    }
                    if ((gameprofile = NBTUtil.func_152459_a((NBTTagCompound)tag.func_74775_l("SkullOwner"))) != null) {
                        Map map2;
                        event.toolTip.add(EnumChatFormatting.AQUA + "Skull UUID: " + EnumChatFormatting.GRAY + gameprofile.getId() + EnumChatFormatting.GOLD + " [M]");
                        if (!this.copied && m) {
                            Utils.copyToClipboard(gameprofile.getId().toString());
                        }
                        if ((map2 = Minecraft.func_71410_x().func_152342_ad().func_152788_a(gameprofile)).containsKey(MinecraftProfileTexture.Type.SKIN)) {
                            MinecraftProfileTexture profTex = (MinecraftProfileTexture)map2.get(MinecraftProfileTexture.Type.SKIN);
                            event.toolTip.add(EnumChatFormatting.AQUA + "Skull Texture Link: " + EnumChatFormatting.GRAY + profTex.getUrl() + EnumChatFormatting.GOLD + " [N]");
                            if (!this.copied && n) {
                                Utils.copyToClipboard(profTex.getUrl());
                            }
                        }
                    }
                }
            }
            this.copied = k || m || n || f || b || y || j;
        }
    }
}

