/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.moe.nea.lisp;

import io.github.moulberry.notenoughupdates.deps.moe.nea.lisp.Builtins;
import io.github.moulberry.notenoughupdates.deps.moe.nea.lisp.CoreBindings;
import io.github.moulberry.notenoughupdates.deps.moe.nea.lisp.HasLispPosition;
import io.github.moulberry.notenoughupdates.deps.moe.nea.lisp.LispAst;
import io.github.moulberry.notenoughupdates.deps.moe.nea.lisp.LispData;
import io.github.moulberry.notenoughupdates.deps.moe.nea.lisp.LispPosition;
import io.github.moulberry.notenoughupdates.deps.moe.nea.lisp.OutputCapture;
import io.github.moulberry.notenoughupdates.deps.moe.nea.lisp.StackFrame;
import io.github.moulberry.notenoughupdates.deps.moe.nea.lisp.TestFramework;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000fJ\u0006\u0010\u0017\u001a\u00020\u000bJ\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u001a\u001a\u00020\u0005H\u0002J\u0016\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u000fJ\u0016\u0010 \u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014J:\u0010!\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u00052\b\b\u0002\u0010\u0012\u001a\u00020\u000b2\u000e\b\u0002\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050%2\b\b\u0002\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020\u0019R)\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006)"}, d2={"Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/LispExecutionContext;", "", "()V", "modules", "", "", "", "Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/LispData;", "getModules", "()Ljava/util/Map;", "rootStackFrame", "Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/StackFrame;", "getRootStackFrame", "()Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/StackFrame;", "unloadedModules", "Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/LispAst$Program;", "getUnloadedModules", "executeLisp", "stackFrame", "node", "Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/LispAst$LispNode;", "executeProgram", "program", "genBindings", "importModule", "", "moduleName", "into", "position", "Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/HasLispPosition;", "realizeModule", "registerModule", "resolveValue", "runTests", "Lio/github/moulberry/notenoughupdates/deps/moe/nea/lisp/TestFramework$TestSuite;", "name", "testList", "", "isWhitelist", "", "setupStandardBindings", "nealisp"})
public final class LispExecutionContext {
    @NotNull
    private final StackFrame rootStackFrame = new StackFrame(null);
    @NotNull
    private final Map<String, LispAst.Program> unloadedModules = new LinkedHashMap();
    @NotNull
    private final Map<String, Map<String, LispData>> modules = new LinkedHashMap();

    @NotNull
    public final StackFrame getRootStackFrame() {
        return this.rootStackFrame;
    }

    @NotNull
    public final Map<String, LispAst.Program> getUnloadedModules() {
        return this.unloadedModules;
    }

    @NotNull
    public final Map<String, Map<String, LispData>> getModules() {
        return this.modules;
    }

    @NotNull
    public final StackFrame genBindings() {
        return new StackFrame(this.rootStackFrame);
    }

    public final void setupStandardBindings() {
        CoreBindings.INSTANCE.offerAllTo(this.rootStackFrame);
        this.registerModule("builtins", Builtins.INSTANCE.getBuiltinProgram());
        this.registerModule("test", Builtins.INSTANCE.getTestProgram());
        this.modules.put("ntest", TestFramework.INSTANCE.getRealizedTestModule());
        this.importModule("builtins", this.rootStackFrame, new HasLispPosition(){

            @NotNull
            public LispPosition getPosition() {
                throw new IllegalStateException("Builtin import failed".toString());
            }
        });
    }

    @NotNull
    public final TestFramework.TestSuite runTests(@NotNull LispAst.Program program, @NotNull String name, @NotNull StackFrame stackFrame, @NotNull List<String> testList, boolean isWhitelist) {
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
        Intrinsics.checkNotNullParameter(testList, (String)"testList");
        TestFramework.TestSuite testSuite = TestFramework.INSTANCE.setup(stackFrame, name, testList, isWhitelist);
        OutputCapture.CapturedOutput output = OutputCapture.INSTANCE.captureOutput(stackFrame);
        this.executeProgram(stackFrame, program);
        testSuite.setTesting(false);
        testSuite.setOtherOutput(output.getAsString());
        return testSuite;
    }

    public static /* synthetic */ TestFramework.TestSuite runTests$default(LispExecutionContext lispExecutionContext, LispAst.Program program, String string, StackFrame stackFrame, List list, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            stackFrame = lispExecutionContext.genBindings();
        }
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return lispExecutionContext.runTests(program, string, stackFrame, list, bl);
    }

    public final void registerModule(@NotNull String moduleName, @NotNull LispAst.Program program) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        if (this.unloadedModules.containsKey(moduleName) || this.modules.containsKey(moduleName)) {
            throw new IllegalStateException(("Cannot register already registered module " + moduleName).toString());
        }
        this.unloadedModules.put(moduleName, program);
    }

    public final void importModule(@NotNull String moduleName, @NotNull StackFrame into, @NotNull HasLispPosition position) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)into, (String)"into");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Map<String, LispData> exports = this.modules.get(moduleName);
        if (exports == null) {
            LispAst.Program module = this.unloadedModules.get(moduleName);
            if (module == null) {
                into.reportError("Could not find module " + moduleName, position);
                return;
            }
            exports = this.realizeModule(moduleName);
        }
        into.getVariables().putAll(exports);
    }

    private final Map<String, LispData> realizeModule(String moduleName) {
        Map map2 = new LinkedHashMap();
        this.modules.put(moduleName, map2);
        LispAst.Program program = this.unloadedModules.remove(moduleName);
        if (program == null) {
            throw new IllegalStateException(("Could not find module " + moduleName).toString());
        }
        LispAst.Program module = program;
        StackFrame stackFrame = this.genBindings();
        stackFrame.setValueLocal("export", LispData.Companion.externalRawCall("export", (Function4<? super LispExecutionContext, ? super LispAst.LispNode, ? super StackFrame, ? super List<? extends LispAst.LispNode>, ? extends LispData>)((Function4)new Function4<LispExecutionContext, LispAst.LispNode, StackFrame, List<? extends LispAst.LispNode>, LispData>((Map<String, LispData>)map2){
            final /* synthetic */ Map<String, LispData> $map;
            {
                this.$map = $map;
                super(4);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final LispData invoke(@NotNull LispExecutionContext context, @NotNull LispAst.LispNode callsite, @NotNull StackFrame stackFrame, @NotNull List<? extends LispAst.LispNode> args) {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)callsite, (String)"callsite");
                Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
                Intrinsics.checkNotNullParameter(args, (String)"args");
                Iterable iterable = args;
                Map<String, LispData> map2 = this.$map;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    LispAst.LispNode name = (LispAst.LispNode)element$iv;
                    boolean bl = false;
                    if (!(name instanceof LispAst.Reference)) {
                        stackFrame.reportError("Invalid export", name);
                        continue;
                    }
                    map2.put(((LispAst.Reference)name).getLabel(), context.resolveValue(stackFrame, name));
                }
                return LispData.LispNil.INSTANCE;
            }
        })));
        this.executeProgram(stackFrame, module);
        return map2;
    }

    @Nullable
    public final LispData executeProgram(@NotNull StackFrame stackFrame, @NotNull LispAst.Program program) {
        Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
        Intrinsics.checkNotNullParameter((Object)program, (String)"program");
        LispData lastValue = null;
        for (LispAst.LispNode node : program.getNodes()) {
            lastValue = this.resolveValue(stackFrame, node);
        }
        return lastValue;
    }

    @NotNull
    public final LispData executeLisp(@NotNull StackFrame stackFrame, @NotNull LispAst.LispNode node) {
        Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof LispAst.Parenthesis) {
            LispAst.LispNode lispNode = (LispAst.LispNode)CollectionsKt.firstOrNull(((LispAst.Parenthesis)node).getItems());
            if (lispNode == null) {
                return stackFrame.reportError("Cannot execute empty parenthesis ()", node);
            }
            LispAst.LispNode first = lispNode;
            List rest = CollectionsKt.drop((Iterable)((LispAst.Parenthesis)node).getItems(), (int)1);
            LispData resolvedValue = this.resolveValue(stackFrame, first);
            return resolvedValue instanceof LispData.LispExecutable ? ((LispData.LispExecutable)resolvedValue).execute(this, node, stackFrame, rest) : (LispData)stackFrame.reportError("Cannot evaluate expression of type " + resolvedValue, node);
        }
        return stackFrame.reportError("Expected invocation", node);
    }

    @NotNull
    public final LispData resolveValue(@NotNull StackFrame stackFrame, @NotNull LispAst.LispNode node) {
        LispData lispData;
        Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        LispAst.LispNode lispNode = node;
        if (lispNode instanceof LispAst.Atom) {
            lispData = new LispData.Atom(((LispAst.Atom)node).getLabel());
        } else if (lispNode instanceof LispAst.Parenthesis) {
            lispData = this.executeLisp(stackFrame, node);
        } else if (lispNode instanceof LispAst.Reference) {
            lispData = stackFrame.resolveReference(((LispAst.Reference)node).getLabel());
            if (lispData == null) {
                lispData = stackFrame.reportError("Could not resolve variable " + ((LispAst.Reference)node).getLabel(), node);
            }
        } else if (lispNode instanceof LispAst.NumberLiteral) {
            lispData = new LispData.LispNumber(((LispAst.NumberLiteral)node).getNumberValue());
        } else if (lispNode instanceof LispAst.StringLiteral) {
            lispData = new LispData.LispString(((LispAst.StringLiteral)node).getParsedString());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return lispData;
    }
}

