/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.editors;

import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.GuiTextures;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.common.IMinecraft;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.GuiOptionEditor;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.LerpUtils;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.RenderUtils;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.TextRenderUtils;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.internal.Warnings;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.processor.ProcessedOption;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Mouse;

public class GuiOptionEditorDraggableList
extends GuiOptionEditor {
    private Map<Object, String> exampleText = new HashMap<Object, String>();
    private boolean enableDeleting;
    private List<Object> activeText;
    private final boolean requireNonEmpty;
    private Object currentDragging = null;
    private int dragStartIndex = -1;
    private long trashHoverTime = -1L;
    private int dragOffsetX = -1;
    private int dragOffsetY = -1;
    private boolean dropdownOpen = false;
    private Enum<?>[] enumConstants;
    private String exampleTextConcat;

    public GuiOptionEditorDraggableList(ProcessedOption option, String[] exampleText, boolean enableDeleting) {
        this(option, exampleText, enableDeleting, false);
    }

    public GuiOptionEditorDraggableList(ProcessedOption option, String[] exampleText, boolean enableDeleting, boolean requireNonEmpty) {
        super(option);
        this.enableDeleting = enableDeleting;
        this.activeText = (List)option.get();
        this.requireNonEmpty = requireNonEmpty;
        Type elementType = ((ParameterizedType)option.getType()).getActualTypeArguments()[0];
        if (Enum.class.isAssignableFrom((Class)elementType)) {
            Class enumType = (Class)((ParameterizedType)option.getType()).getActualTypeArguments()[0];
            this.enumConstants = (Enum[])enumType.getEnumConstants();
            for (int i = 0; i < this.enumConstants.length; ++i) {
                this.exampleText.put(this.enumConstants[i], this.enumConstants[i].toString());
            }
        } else {
            for (int i = 0; i < exampleText.length; ++i) {
                this.exampleText.put(i, exampleText[i]);
            }
        }
    }

    private void saveChanges() {
        this.option.explicitNotifyChange();
    }

    private String getExampleText(Object forObject) {
        String str = this.exampleText.get(forObject);
        if (str == null) {
            str = "<unknown " + forObject + ">";
            Warnings.warnOnce("Could not find draggable list object for " + forObject + " on option " + this.option.field, forObject, this.option);
        }
        return str;
    }

    @Override
    public int getHeight() {
        int height = super.getHeight() + 13;
        for (Object object : this.activeText) {
            String str = this.getExampleText(object);
            height += 10 * str.split("\n").length;
        }
        return height;
    }

    public boolean canDeleteRightNow() {
        return this.enableDeleting && (this.activeText.size() > 1 || !this.requireNonEmpty);
    }

    @Override
    public void render(int x, int y, int width) {
        float greenBlue;
        super.render(x, y, width);
        int height = this.getHeight();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        IMinecraft.instance.bindTexture(GuiTextures.BUTTON);
        RenderUtils.drawTexturedRect(x + width / 6 - 24, y + 45 - 7 - 14, 48.0f, 16.0f);
        TextRenderUtils.drawStringCenteredScaledMaxWidth("Add", Minecraft.func_71410_x().field_71466_p, x + width / 6, y + 45 - 7 - 6, false, 44, -13619152);
        long currentTime = System.currentTimeMillis();
        if (this.trashHoverTime < 0L) {
            greenBlue = LerpUtils.clampZeroOne((float)(currentTime + this.trashHoverTime) / 250.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)greenBlue, (float)greenBlue, (float)1.0f);
        } else {
            greenBlue = LerpUtils.clampZeroOne((float)(250L + this.trashHoverTime - currentTime) / 250.0f);
            GlStateManager.func_179131_c((float)1.0f, (float)greenBlue, (float)greenBlue, (float)1.0f);
        }
        if (this.canDeleteRightNow()) {
            IMinecraft.instance.bindTexture(GuiTextures.DELETE);
            RenderUtils.drawTexturedRect(x + width / 6 + 27, y + 45 - 7 - 13, 11.0f, 14.0f, 9728);
        }
        Gui.func_73734_a((int)(x + 5), (int)(y + 45), (int)(x + width - 5), (int)(y + height - 5), (int)-2236963);
        Gui.func_73734_a((int)(x + 6), (int)(y + 46), (int)(x + width - 6), (int)(y + height - 6), (int)-16777216);
        int i = 0;
        int yOff = 0;
        for (Object indexObject : this.activeText) {
            String str = this.getExampleText(indexObject);
            String[] multilines = str.split("\n");
            int ySize = multilines.length * 10;
            if (i++ != this.dragStartIndex) {
                for (int multilineIndex = 0; multilineIndex < multilines.length; ++multilineIndex) {
                    String line = multilines[multilineIndex];
                    TextRenderUtils.drawStringScaledMaxWidth(line + EnumChatFormatting.RESET, Minecraft.func_71410_x().field_71466_p, x + 20, y + 50 + yOff + multilineIndex * 10, true, width - 20, -1);
                }
                Minecraft.func_71410_x().field_71466_p.func_175065_a("\u2261", (float)(x + 10), (float)(y + 50 + yOff + ySize / 2 - 4), 0xFFFFFF, true);
            }
            yOff += ySize;
        }
    }

    @Override
    public void renderOverlay(int x, int y, int width) {
        super.renderOverlay(x, y, width);
        if (this.dropdownOpen) {
            ArrayList<Object> remaining = new ArrayList<Object>(this.exampleText.keySet());
            remaining.removeAll(this.activeText);
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            int dropdownWidth = Math.min(width / 2 - 10, 150);
            int left = this.dragOffsetX;
            int top = this.dragOffsetY;
            int dropdownHeight = -1 + 12 * remaining.size();
            int main = -14671834;
            int outline = -12566458;
            Gui.func_73734_a((int)left, (int)top, (int)(left + 1), (int)(top + dropdownHeight), (int)outline);
            Gui.func_73734_a((int)(left + 1), (int)top, (int)(left + dropdownWidth), (int)(top + 1), (int)outline);
            Gui.func_73734_a((int)(left + dropdownWidth - 1), (int)(top + 1), (int)(left + dropdownWidth), (int)(top + dropdownHeight), (int)outline);
            Gui.func_73734_a((int)(left + 1), (int)(top + dropdownHeight - 1), (int)(left + dropdownWidth - 1), (int)(top + dropdownHeight), (int)outline);
            Gui.func_73734_a((int)(left + 1), (int)(top + 1), (int)(left + dropdownWidth - 1), (int)(top + dropdownHeight - 1), (int)main);
            int dropdownY = -1;
            for (Object e2 : remaining) {
                String str = this.getExampleText(e2);
                if (str.isEmpty()) {
                    str = "<NONE>";
                }
                TextRenderUtils.drawStringScaledMaxWidth(str.replaceAll("(\n.*)+", " ..."), fr, left + 3, top + 3 + dropdownY, false, dropdownWidth - 6, -6250336);
                dropdownY += 12;
            }
        } else if (this.currentDragging != null) {
            float greenBlue;
            int opacity = 128;
            long currentTime = System.currentTimeMillis();
            if (this.trashHoverTime < 0L) {
                greenBlue = LerpUtils.clampZeroOne((float)(currentTime + this.trashHoverTime) / 250.0f);
                opacity = (int)((float)opacity * greenBlue);
            } else {
                greenBlue = LerpUtils.clampZeroOne((float)(250L + this.trashHoverTime - currentTime) / 250.0f);
                opacity = (int)((float)opacity * greenBlue);
            }
            if (opacity < 20) {
                return;
            }
            ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
            int mouseX = Mouse.getX() * scaledResolution.func_78326_a() / Minecraft.func_71410_x().field_71443_c;
            int mouseY = scaledResolution.func_78328_b() - Mouse.getY() * scaledResolution.func_78328_b() / Minecraft.func_71410_x().field_71440_d - 1;
            String str = this.getExampleText(this.currentDragging);
            String[] multilines = str.split("\n");
            GlStateManager.func_179147_l();
            for (int multilineIndex = 0; multilineIndex < multilines.length; ++multilineIndex) {
                String line = multilines[multilineIndex];
                TextRenderUtils.drawStringScaledMaxWidth(line + EnumChatFormatting.RESET, Minecraft.func_71410_x().field_71466_p, this.dragOffsetX + mouseX + 10, this.dragOffsetY + mouseY + multilineIndex * 10, true, width - 20, 0xFFFFFF | opacity << 24);
            }
            int ySize = multilines.length * 10;
            Minecraft.func_71410_x().field_71466_p.func_175065_a("\u2261", (float)(this.dragOffsetX + mouseX), (float)(this.dragOffsetY + mouseY + ySize / 2 - 4), 0xFFFFFF, true);
        }
    }

    @Override
    public boolean mouseInput(int x, int y, int width, int mouseX, int mouseY) {
        block20: {
            block21: {
                if (!Mouse.getEventButtonState() && !this.dropdownOpen && this.dragStartIndex >= 0 && Mouse.getEventButton() == 0 && mouseX >= x + width / 6 + 27 - 3 && mouseX <= x + width / 6 + 27 + 11 + 3 && mouseY >= y + 45 - 7 - 13 - 3 && mouseY <= y + 45 - 7 - 13 + 14 + 3) {
                    if (this.canDeleteRightNow()) {
                        this.activeText.remove(this.dragStartIndex);
                        this.saveChanges();
                    }
                    this.currentDragging = null;
                    this.dragStartIndex = -1;
                    return false;
                }
                if (!Mouse.isButtonDown((int)0) || this.dropdownOpen) {
                    this.currentDragging = null;
                    this.dragStartIndex = -1;
                    if (this.trashHoverTime > 0L && this.canDeleteRightNow()) {
                        this.trashHoverTime = -System.currentTimeMillis();
                    }
                } else if (this.currentDragging != null && mouseX >= x + width / 6 + 27 - 3 && mouseX <= x + width / 6 + 27 + 11 + 3 && mouseY >= y + 45 - 7 - 13 - 3 && mouseY <= y + 45 - 7 - 13 + 14 + 3) {
                    if (this.trashHoverTime < 0L && this.canDeleteRightNow()) {
                        this.trashHoverTime = System.currentTimeMillis();
                    }
                } else if (this.trashHoverTime > 0L && this.canDeleteRightNow()) {
                    this.trashHoverTime = -System.currentTimeMillis();
                }
                if (!Mouse.getEventButtonState()) break block21;
                int height = this.getHeight();
                if (this.dropdownOpen) {
                    ArrayList<Object> remaining = new ArrayList<Object>(this.exampleText.keySet());
                    remaining.removeAll(this.activeText);
                    int dropdownWidth = Math.min(width / 2 - 10, 150);
                    int left = this.dragOffsetX;
                    int top = this.dragOffsetY;
                    int dropdownHeight = -1 + 12 * remaining.size();
                    if (mouseX > left && mouseX < left + dropdownWidth && mouseY > top && mouseY < top + dropdownHeight) {
                        int dropdownY = -1;
                        for (Object e2 : remaining) {
                            if (mouseY < top + dropdownY + 12) {
                                this.activeText.add(0, e2);
                                this.saveChanges();
                                if (remaining.size() == 1) {
                                    this.dropdownOpen = false;
                                }
                                return true;
                            }
                            dropdownY += 12;
                        }
                    }
                    this.dropdownOpen = false;
                    return true;
                }
                if (this.activeText.size() < this.exampleText.size() && mouseX > x + width / 6 - 24 && mouseX < x + width / 6 + 24 && mouseY > y + 45 - 7 - 14 && mouseY < y + 45 - 7 + 2) {
                    this.dropdownOpen = !this.dropdownOpen;
                    this.dragOffsetX = mouseX;
                    this.dragOffsetY = mouseY;
                    return true;
                }
                if (Mouse.getEventButton() != 0 || mouseX <= x + 5 || mouseX >= x + width - 5 || mouseY <= y + 45 || mouseY >= y + height - 6) break block20;
                int yOff = 0;
                int i = 0;
                for (Object objectIndex : this.activeText) {
                    String str = this.getExampleText(objectIndex);
                    int ySize = 10 * str.split("\n").length;
                    if (mouseY < y + 50 + yOff + ySize) {
                        this.dragOffsetX = x + 10 - mouseX;
                        this.dragOffsetY = y + 50 + yOff - mouseY;
                        this.currentDragging = objectIndex;
                        this.dragStartIndex = i;
                        break block20;
                    }
                    yOff += ySize;
                    ++i;
                }
                break block20;
            }
            if (Mouse.getEventButton() == -1 && this.currentDragging != null) {
                int yOff = 0;
                int i = 0;
                for (Object objectIndex : this.activeText) {
                    if (this.dragOffsetY + mouseY + 4 < y + 50 + yOff + 10) {
                        this.activeText.remove(this.dragStartIndex);
                        this.activeText.add(i, this.currentDragging);
                        this.saveChanges();
                        this.dragStartIndex = i;
                        break;
                    }
                    String str = this.getExampleText(objectIndex);
                    yOff += 10 * str.split("\n").length;
                    ++i;
                }
            }
        }
        return false;
    }

    @Override
    public boolean fulfillsSearch(String word) {
        if (this.exampleTextConcat == null) {
            this.exampleTextConcat = String.join((CharSequence)"", this.exampleText.values()).toLowerCase(Locale.ROOT);
        }
        return super.fulfillsSearch(word) || this.exampleTextConcat.contains(word);
    }

    @Override
    public boolean keyboardInput() {
        return false;
    }
}

