/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.component;

import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.GuiComponent;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.GuiImmediateContext;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.KeyboardEvent;
import io.github.moulberry.notenoughupdates.deps.io.github.moulberry.moulconfig.gui.MouseEvent;
import java.util.function.BiFunction;

public class PanelComponent
extends GuiComponent {
    private final GuiComponent element;
    private final int insets;

    public PanelComponent(GuiComponent element, int insets) {
        this.element = element;
        this.insets = insets;
    }

    public PanelComponent(GuiComponent element) {
        this(element, 2);
    }

    @Override
    public <T> T foldChildren(T initial, BiFunction<GuiComponent, T, T> visitor) {
        return visitor.apply(this.element, (GuiComponent)initial);
    }

    @Override
    public int getWidth() {
        return this.element.getWidth() + this.insets * 2;
    }

    public int getInsets() {
        return this.insets;
    }

    @Override
    public int getHeight() {
        return this.element.getHeight() + this.insets * 2 + 2;
    }

    GuiImmediateContext getChildContext(GuiImmediateContext context) {
        return context.translated(this.insets, this.insets, this.element.getWidth(), this.element.getHeight());
    }

    @Override
    public void render(GuiImmediateContext context) {
        context.getRenderContext().pushMatrix();
        context.getRenderContext().renderDarkRect(0, 0, this.getWidth(), this.getHeight() - 2);
        context.getRenderContext().translate(this.insets, this.insets, 0.0f);
        this.element.render(this.getChildContext(context));
        context.getRenderContext().popMatrix();
    }

    @Override
    public void keyboardEvent(KeyboardEvent event, GuiImmediateContext context) {
        this.element.keyboardEvent(event, this.getChildContext(context));
    }

    @Override
    public void mouseEvent(MouseEvent mouseEvent, GuiImmediateContext context) {
        this.element.mouseEvent(mouseEvent, this.getChildContext(context));
    }
}

