/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.core.util.lerp;

public class LerpingInteger {
    private int timeSpent;
    private long lastMillis;
    private int timeToReachTarget;
    private int targetValue;
    private int lerpValue;

    public LerpingInteger(int initialValue, int timeToReachTarget) {
        this.targetValue = this.lerpValue = initialValue;
        this.timeToReachTarget = timeToReachTarget;
    }

    public LerpingInteger(int initialValue) {
        this(initialValue, 200);
    }

    public void tick() {
        int lastTimeSpent = this.timeSpent;
        this.timeSpent = (int)((long)this.timeSpent + (System.currentTimeMillis() - this.lastMillis));
        float lastDistPercentToTarget = (float)lastTimeSpent / (float)this.timeToReachTarget;
        float distPercentToTarget = (float)this.timeSpent / (float)this.timeToReachTarget;
        float fac = (1.0f - lastDistPercentToTarget) / lastDistPercentToTarget;
        int startValue = this.lerpValue - (int)((float)(this.targetValue - this.lerpValue) / fac);
        int dist = this.targetValue - startValue;
        if (dist == 0) {
            return;
        }
        int oldLerpValue = this.lerpValue;
        this.lerpValue = distPercentToTarget >= 1.0f ? this.targetValue : startValue + (int)((float)dist * distPercentToTarget);
        if (this.lerpValue == oldLerpValue) {
            this.timeSpent = lastTimeSpent;
        } else {
            this.lastMillis = System.currentTimeMillis();
        }
    }

    public int getTimeSpent() {
        return this.timeSpent;
    }

    public void resetTimer() {
        this.timeSpent = 0;
        this.lastMillis = System.currentTimeMillis();
    }

    public void setTimeToReachTarget(int timeToReachTarget) {
        this.timeToReachTarget = timeToReachTarget;
    }

    public void setTarget(int targetValue) {
        this.targetValue = targetValue;
    }

    public void setValue(int value) {
        this.targetValue = this.lerpValue = value;
    }

    public int getValue() {
        return this.lerpValue;
    }

    public int getTarget() {
        return this.targetValue;
    }
}

