/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.core.util;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class StringUtils {
    private static final DecimalFormat TENTHS_DECIMAL_FORMAT = new DecimalFormat("#.#");
    public static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Locale.US);
    private static final char[] sizeSuffix = new char[]{'k', 'm', 'b', 't'};

    public static String cleanColour(String in) {
        return in.replaceAll("(?i)\\u00A7.", "");
    }

    public static String cleanColourNotModifiers(String in) {
        return in.replaceAll("(?i)\\u00A7[0-9a-f]", "\u00a7r");
    }

    public static String substringBetween(String str, String open, String close) {
        return org.apache.commons.lang3.StringUtils.substringBetween((String)str, (String)open, (String)close);
    }

    public static int cleanAndParseInt(String str) {
        str = StringUtils.cleanColour(str);
        str = str.replace(",", "");
        return Integer.parseInt(str);
    }

    public static String shortNumberFormat(int n) {
        return StringUtils.shortNumberFormat(n, 0);
    }

    public static String shortNumberFormat(double n) {
        return StringUtils.shortNumberFormat(n, 0);
    }

    public static String shortNumberFormat(BigInteger bigInteger) {
        int i;
        BigInteger THOUSAND = BigInteger.valueOf(1000L);
        for (i = -1; bigInteger.compareTo(THOUSAND) > 0 && i < sizeSuffix.length; ++i) {
            bigInteger = bigInteger.divide(THOUSAND);
        }
        return bigInteger.toString() + (i == -1 ? "" : Character.valueOf(sizeSuffix[i]));
    }

    public static String shortNumberFormat(double n, int iteration) {
        boolean isRound;
        if (n < 0.0) {
            return "-" + StringUtils.shortNumberFormat(-n, iteration);
        }
        if (n < 1000.0) {
            if (n % 1.0 == 0.0) {
                return Integer.toString((int)n);
            }
            return String.format("%.2f", n);
        }
        double d = (double)((long)n / 100L) / 10.0;
        boolean bl = isRound = d * 10.0 % 10.0 == 0.0;
        return d < 1000.0 ? (isRound || d > 9.99 ? Integer.valueOf((int)d * 10 / 10) : d + "") + "" + sizeSuffix[iteration] : StringUtils.shortNumberFormat(d, iteration + 1);
    }

    public static String removeLastWord(String string, String splitString) {
        try {
            String[] split = string.split(splitString);
            String rawTier = split[split.length - 1];
            return string.substring(0, string.length() - rawTier.length() - 1);
        }
        catch (StringIndexOutOfBoundsException e2) {
            throw new RuntimeException("removeLastWord: '" + string + "'", e2);
        }
    }

    public static String firstUpperLetter(String text) {
        if (text.isEmpty()) {
            return text;
        }
        String firstLetter = ("" + text.charAt(0)).toUpperCase(Locale.ROOT);
        return firstLetter + text.substring(1);
    }

    public static boolean isNumeric(String string) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        for (char c : string.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static String formatToTenths(Number num) {
        return TENTHS_DECIMAL_FORMAT.format(num);
    }

    public static String formatNumber(Number num) {
        return NUMBER_FORMAT.format(num);
    }
}

