/*
 * Decompiled with CFR 0.152.
 */
package io.github.moulberry.notenoughupdates.core.config;

import com.google.gson.annotations.Expose;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.gui.ScaledResolution;

public class PositionNew {
    @Expose
    private int x = 0;
    @Expose
    private int y = 0;
    @Expose
    private float scaleX = 1.0f;
    @Expose
    private float scaleY = 1.0f;
    @Expose
    private Anchor anchorX = Anchor.MIN;
    @Expose
    private Anchor anchorY = Anchor.MIN;
    @Expose
    private boolean pinned = false;
    @Expose
    private boolean allowPinToggle = true;
    @Expose
    private boolean allowResize = true;

    public PositionNew(int x, int y, int scaleX, int scaleY, Anchor anchorX, Anchor anchorY, boolean pinned, boolean allowPinToggle, boolean allowResize) {
        this.x = x;
        this.y = y;
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.anchorX = anchorX;
        this.anchorY = anchorY;
        this.pinned = pinned;
        this.allowPinToggle = allowPinToggle;
        this.allowResize = allowResize;
    }

    protected PositionNew() {
    }

    public int moveX(ScaledResolution scaledResolution, int deltaX, int sizeX) {
        int originalX = this.resolveX(scaledResolution, sizeX);
        AtomicInteger atomicInteger = new AtomicInteger(this.x + deltaX);
        AtomicReference<Anchor> atomicReference = new AtomicReference<Anchor>(this.anchorX);
        this.move(atomicInteger, atomicReference, this.anchorY, (int)Math.ceil((float)sizeX * this.scaleX), scaledResolution.func_78326_a(), 176);
        this.x = atomicInteger.get();
        this.anchorX = atomicReference.get();
        return this.resolveX(scaledResolution, sizeX) - originalX;
    }

    public int moveY(ScaledResolution scaledResolution, int deltaY, int sizeY) {
        int originalY = this.resolveY(scaledResolution, sizeY);
        AtomicInteger atomicInteger = new AtomicInteger(this.y + deltaY);
        AtomicReference<Anchor> atomicReference = new AtomicReference<Anchor>(this.anchorY);
        this.move(atomicInteger, atomicReference, this.anchorY, (int)Math.ceil((float)sizeY * this.scaleY), scaledResolution.func_78328_b(), 166);
        this.y = atomicInteger.get();
        this.anchorY = atomicReference.get();
        return this.resolveY(scaledResolution, sizeY) - originalY;
    }

    private void move(AtomicInteger coord, AtomicReference<Anchor> anchor, Anchor oppositeAnchor, int elementSize, int screenSize, int guiSize) {
        int centerCoord = this.resolve(coord.get(), anchor.get(), elementSize, screenSize, guiSize) + elementSize / 2;
        if (centerCoord < screenSize / 2 - guiSize / 2) {
            if (this.pinned && centerCoord > screenSize / 4 - guiSize / 4 && oppositeAnchor == Anchor.MID) {
                anchor.set(Anchor.GUI_MIN);
            } else {
                anchor.set(Anchor.MIN);
            }
        } else if (centerCoord > screenSize / 2 + guiSize / 2) {
            if (this.pinned && centerCoord < screenSize - (screenSize / 4 - guiSize / 4) && oppositeAnchor == Anchor.MID) {
                anchor.set(Anchor.GUI_MAX);
            } else {
                anchor.set(Anchor.MAX);
            }
        } else {
            anchor.set(Anchor.MID);
        }
        if (centerCoord - elementSize / 2 < 0) {
            centerCoord = elementSize / 2;
        }
        if (centerCoord + elementSize / 2 > screenSize) {
            centerCoord = screenSize - elementSize / 2;
        }
        Anchor newAnchor = anchor.get();
        coord.set(Math.round((float)centerCoord - (float)elementSize * (newAnchor.elementMult + 0.5f) - (float)screenSize * newAnchor.screenMult - (float)guiSize * newAnchor.guiMult));
    }

    public int resolveX(ScaledResolution scaledResolution, int sizeX) {
        return this.resolve(this.x, this.anchorX, (int)Math.ceil((float)sizeX * this.scaleX), scaledResolution.func_78326_a(), 176);
    }

    public int resolveY(ScaledResolution scaledResolution, int sizeY) {
        return this.resolve(this.y, this.anchorY, (int)Math.ceil((float)sizeY * this.scaleY), scaledResolution.func_78328_b(), 166);
    }

    private int resolve(int coord, Anchor anchor, int elementSize, int screenSize, int guiSize) {
        return Math.round((float)screenSize * anchor.screenMult + (float)elementSize * anchor.elementMult + (float)guiSize * anchor.guiMult + (float)coord);
    }

    public void setScaleX(float scaleX) {
        if (this.allowResize) {
            this.scaleX = scaleX;
        }
    }

    public void setScaleY(float scaleY) {
        if (this.allowResize) {
            this.scaleY = scaleY;
        }
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setPinned(boolean pinned) {
        if (this.allowPinToggle) {
            this.pinned = pinned;
        }
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public Anchor getAnchorX() {
        return this.anchorX;
    }

    public Anchor getAnchorY() {
        return this.anchorY;
    }

    public static enum Anchor {
        MIN(0.0f, 0.0f, 0.0f),
        MID(0.5f, -0.5f, 0.0f),
        MAX(1.0f, -1.0f, 0.0f),
        GUI_MIN(0.5f, -1.0f, -0.5f),
        GUI_MAX(0.5f, 0.0f, 0.5f);

        float screenMult;
        float elementMult;
        float guiMult;

        private Anchor(float screenMult, float elementMult, float guiMult) {
            this.screenMult = screenMult;
            this.elementMult = elementMult;
            this.guiMult = guiMult;
        }
    }
}

