/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.htmlcleaner;

import info.bliki.htmlcleaner.BaseToken;
import info.bliki.htmlcleaner.XmlSerializer;
import java.io.IOException;

public class DoctypeToken
implements BaseToken {
    private String part1;
    private String part2;
    private String part3;
    private String part4;

    public DoctypeToken(String p1, String p2, String p3, String p4) {
        this.part1 = p1 != null ? p1.toUpperCase() : p1;
        this.part2 = p2 != null ? p2.toUpperCase() : p2;
        this.part3 = this.clean(p3);
        this.part4 = this.clean(p4);
    }

    private String clean(String s) {
        if (s != null) {
            s = s.replace('>', ' ');
            s = s.replace('<', ' ');
            s = s.replace('&', ' ');
            s = s.replace('\'', ' ');
            s = s.replace('\"', ' ');
        }
        return s;
    }

    public boolean isValid() {
        if (this.part1 == null || "".equals(this.part1)) {
            return false;
        }
        if (!"public".equalsIgnoreCase(this.part2) && !"system".equalsIgnoreCase(this.part2)) {
            return false;
        }
        if ("system".equalsIgnoreCase(this.part2) && this.part4 != null && !"".equals(this.part4)) {
            return false;
        }
        return !"public".equalsIgnoreCase(this.part2) || this.part4 != null && !"".equals(this.part4);
    }

    public String getContent() {
        String result2 = "<!DOCTYPE " + this.part1 + " ";
        result2 = result2 + this.part2 + " \"" + this.part3 + "\"";
        if (this.part4 != null && !"".equals(this.part4)) {
            result2 = result2 + " \"" + this.part4 + "\"";
        }
        result2 = result2 + ">";
        return result2;
    }

    public String toString() {
        return this.getContent();
    }

    public String getName() {
        return "";
    }

    @Override
    public void serialize(XmlSerializer xmlSerializer) throws IOException {
        xmlSerializer.getWriter().write(this.getContent() + "\n");
    }
}

