/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import net.optifine.model.BlockModelUtils;
import net.optifine.util.PropertiesOrdered;

public class BetterGrass {
    private static boolean betterGrass = true;
    private static boolean betterMycelium = true;
    private static boolean betterPodzol = true;
    private static boolean betterGrassSnow = true;
    private static boolean betterMyceliumSnow = true;
    private static boolean betterPodzolSnow = true;
    private static boolean grassMultilayer = false;
    private static bmi spriteGrass = null;
    private static bmi spriteGrassSide = null;
    private static bmi spriteMycelium = null;
    private static bmi spritePodzol = null;
    private static bmi spriteSnow = null;
    private static boolean spritesLoaded = false;
    private static boq modelCubeGrass = null;
    private static boq modelCubeMycelium = null;
    private static boq modelCubePodzol = null;
    private static boq modelCubeSnow = null;
    private static boolean modelsLoaded = false;
    private static final String TEXTURE_GRASS_DEFAULT = "blocks/grass_top";
    private static final String TEXTURE_GRASS_SIDE_DEFAULT = "blocks/grass_side";
    private static final String TEXTURE_MYCELIUM_DEFAULT = "blocks/mycelium_top";
    private static final String TEXTURE_PODZOL_DEFAULT = "blocks/dirt_podzol_top";
    private static final String TEXTURE_SNOW_DEFAULT = "blocks/snow";

    public static void updateIcons(bmh textureMap) {
        spritesLoaded = false;
        modelsLoaded = false;
        BetterGrass.loadProperties(textureMap);
    }

    public static void update() {
        if (!spritesLoaded) {
            return;
        }
        modelCubeGrass = BlockModelUtils.makeModelCube(spriteGrass, 0);
        if (grassMultilayer) {
            boq modelCubeGrassSide = BlockModelUtils.makeModelCube(spriteGrassSide, -1);
            modelCubeGrass = BlockModelUtils.joinModelsCube(modelCubeGrassSide, modelCubeGrass);
        }
        modelCubeMycelium = BlockModelUtils.makeModelCube(spriteMycelium, -1);
        modelCubePodzol = BlockModelUtils.makeModelCube(spritePodzol, 0);
        modelCubeSnow = BlockModelUtils.makeModelCube(spriteSnow, -1);
        modelsLoaded = true;
    }

    private static void loadProperties(bmh textureMap) {
        betterGrass = true;
        betterMycelium = true;
        betterPodzol = true;
        betterGrassSnow = true;
        betterMyceliumSnow = true;
        betterPodzolSnow = true;
        spriteGrass = textureMap.a(new jy(TEXTURE_GRASS_DEFAULT));
        spriteGrassSide = textureMap.a(new jy(TEXTURE_GRASS_SIDE_DEFAULT));
        spriteMycelium = textureMap.a(new jy(TEXTURE_MYCELIUM_DEFAULT));
        spritePodzol = textureMap.a(new jy(TEXTURE_PODZOL_DEFAULT));
        spriteSnow = textureMap.a(new jy(TEXTURE_SNOW_DEFAULT));
        spritesLoaded = true;
        String name = "optifine/bettergrass.properties";
        try {
            jy locFile = new jy(name);
            if (!Config.hasResource(locFile)) {
                return;
            }
            InputStream in = Config.getResourceStream(locFile);
            if (in == null) {
                return;
            }
            boolean defaultConfig = Config.isFromDefaultResourcePack(locFile);
            if (defaultConfig) {
                Config.dbg("BetterGrass: Parsing default configuration " + name);
            } else {
                Config.dbg("BetterGrass: Parsing configuration " + name);
            }
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            betterGrass = BetterGrass.getBoolean(props, "grass", true);
            betterMycelium = BetterGrass.getBoolean(props, "mycelium", true);
            betterPodzol = BetterGrass.getBoolean(props, "podzol", true);
            betterGrassSnow = BetterGrass.getBoolean(props, "grass.snow", true);
            betterMyceliumSnow = BetterGrass.getBoolean(props, "mycelium.snow", true);
            betterPodzolSnow = BetterGrass.getBoolean(props, "podzol.snow", true);
            grassMultilayer = BetterGrass.getBoolean(props, "grass.multilayer", false);
            spriteGrass = BetterGrass.registerSprite(props, "texture.grass", TEXTURE_GRASS_DEFAULT, textureMap);
            spriteGrassSide = BetterGrass.registerSprite(props, "texture.grass_side", TEXTURE_GRASS_SIDE_DEFAULT, textureMap);
            spriteMycelium = BetterGrass.registerSprite(props, "texture.mycelium", TEXTURE_MYCELIUM_DEFAULT, textureMap);
            spritePodzol = BetterGrass.registerSprite(props, "texture.podzol", TEXTURE_PODZOL_DEFAULT, textureMap);
            spriteSnow = BetterGrass.registerSprite(props, "texture.snow", TEXTURE_SNOW_DEFAULT, textureMap);
        }
        catch (IOException e) {
            Config.warn("Error reading: " + name + ", " + e.getClass().getName() + ": " + e.getMessage());
        }
    }

    private static bmi registerSprite(Properties props, String key, String textureDefault, bmh textureMap) {
        jy locPng;
        String texture = props.getProperty(key);
        if (texture == null) {
            texture = textureDefault;
        }
        if (!Config.hasResource(locPng = new jy("textures/" + texture + ".png"))) {
            Config.warn("BetterGrass texture not found: " + locPng);
            texture = textureDefault;
        }
        jy locSprite = new jy(texture);
        bmi sprite = textureMap.a(locSprite);
        return sprite;
    }

    public static List getFaceQuads(adq blockAccess, alz blockState, cj blockPos, cq facing, List quads) {
        if (facing == cq.b || facing == cq.a) {
            return quads;
        }
        if (!modelsLoaded) {
            return quads;
        }
        afh block = blockState.c();
        if (block instanceof aib) {
            return BetterGrass.getFaceQuadsMycelium(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof agf) {
            return BetterGrass.getFaceQuadsDirt(blockAccess, blockState, blockPos, facing, quads);
        }
        if (block instanceof ahe) {
            return BetterGrass.getFaceQuadsGrass(blockAccess, blockState, blockPos, facing, quads);
        }
        return quads;
    }

    private static List getFaceQuadsMycelium(adq blockAccess, alz blockState, cj blockPos, cq facing, List quads) {
        boolean snowy;
        afh blockUp = blockAccess.p(blockPos.a()).c();
        boolean bl = snowy = blockUp == afi.aJ || blockUp == afi.aH;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterMyceliumSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == afi.aH) {
                    return modelCubeSnow.a(facing);
                }
            } else if (betterMycelium && BetterGrass.getBlockAt(blockPos.b(), facing, blockAccess) == afi.bw) {
                return modelCubeMycelium.a(facing);
            }
        } else if (snowy) {
            if (betterMyceliumSnow) {
                return modelCubeSnow.a(facing);
            }
        } else if (betterMycelium) {
            return modelCubeMycelium.a(facing);
        }
        return quads;
    }

    private static List getFaceQuadsDirt(adq blockAccess, alz blockState, cj blockPos, cq facing, List quads) {
        afh blockTop = BetterGrass.getBlockAt(blockPos, cq.b, blockAccess);
        if (blockState.b((amo)agf.a) == agf.a.c) {
            boolean snowy;
            boolean bl = snowy = blockTop == afi.aJ || blockTop == afi.aH;
            if (Config.isBetterGrassFancy()) {
                cj posSide;
                alz stateSide;
                if (snowy) {
                    if (betterPodzolSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == afi.aH) {
                        return modelCubeSnow.a(facing);
                    }
                } else if (betterPodzol && (stateSide = blockAccess.p(posSide = blockPos.b().a(facing))).c() == afi.d && stateSide.b((amo)agf.a) == agf.a.c) {
                    return modelCubePodzol.a(facing);
                }
            } else if (snowy) {
                if (betterPodzolSnow) {
                    return modelCubeSnow.a(facing);
                }
            } else if (betterPodzol) {
                return modelCubePodzol.a(facing);
            }
            return quads;
        }
        return quads;
    }

    private static List getFaceQuadsGrass(adq blockAccess, alz blockState, cj blockPos, cq facing, List quads) {
        boolean snowy;
        afh blockUp = blockAccess.p(blockPos.a()).c();
        boolean bl = snowy = blockUp == afi.aJ || blockUp == afi.aH;
        if (Config.isBetterGrassFancy()) {
            if (snowy) {
                if (betterGrassSnow && BetterGrass.getBlockAt(blockPos, facing, blockAccess) == afi.aH) {
                    return modelCubeSnow.a(facing);
                }
            } else if (betterGrass && BetterGrass.getBlockAt(blockPos.b(), facing, blockAccess) == afi.c) {
                return modelCubeGrass.a(facing);
            }
        } else if (snowy) {
            if (betterGrassSnow) {
                return modelCubeSnow.a(facing);
            }
        } else if (betterGrass) {
            return modelCubeGrass.a(facing);
        }
        return quads;
    }

    private static afh getBlockAt(cj blockPos, cq facing, adq blockAccess) {
        cj pos = blockPos.a(facing);
        afh block = blockAccess.p(pos).c();
        return block;
    }

    private static boolean getBoolean(Properties props, String key, boolean def) {
        String str = props.getProperty(key);
        if (str == null) {
            return def;
        }
        return Boolean.parseBoolean(str);
    }
}

