/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.lib.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.spongepowered.asm.lib.AnnotationVisitor;
import org.spongepowered.asm.lib.Attribute;
import org.spongepowered.asm.lib.Handle;
import org.spongepowered.asm.lib.Label;
import org.spongepowered.asm.lib.MethodVisitor;
import org.spongepowered.asm.lib.Opcodes;
import org.spongepowered.asm.lib.Type;
import org.spongepowered.asm.lib.TypePath;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.analysis.Analyzer;
import org.spongepowered.asm.lib.tree.analysis.BasicValue;
import org.spongepowered.asm.lib.tree.analysis.BasicVerifier;
import org.spongepowered.asm.lib.util.CheckAnnotationAdapter;
import org.spongepowered.asm.lib.util.CheckClassAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckMethodAdapter
extends MethodVisitor {
    public int version;
    private int access;
    private boolean startCode;
    private boolean endCode;
    private boolean endMethod;
    private int insnCount;
    private final Map<Label, Integer> labels;
    private Set<Label> usedLabels;
    private int expandedFrames;
    private int compressedFrames;
    private int lastFrame = -1;
    private List<Label> handlers;
    private static final int[] TYPE;
    private static Field labelStatusField;

    public CheckMethodAdapter(MethodVisitor mv) {
        this(mv, new HashMap<Label, Integer>());
    }

    public CheckMethodAdapter(MethodVisitor mv, Map<Label, Integer> labels) {
        this(327680, mv, labels);
        if (this.getClass() != CheckMethodAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckMethodAdapter(int api, MethodVisitor mv, Map<Label, Integer> labels) {
        super(api, mv);
        this.labels = labels;
        this.usedLabels = new HashSet<Label>();
        this.handlers = new ArrayList<Label>();
    }

    public CheckMethodAdapter(int access, String name2, String desc, final MethodVisitor cmv, Map<Label, Integer> labels) {
        this(new MethodNode(327680, access, name2, desc, null, null){

            public void visitEnd() {
                Analyzer<BasicValue> a = new Analyzer<BasicValue>(new BasicVerifier());
                try {
                    a.analyze("dummy", this);
                }
                catch (Exception e) {
                    if (e instanceof IndexOutOfBoundsException && this.maxLocals == 0 && this.maxStack == 0) {
                        throw new RuntimeException("Data flow checking option requires valid, non zero maxLocals and maxStack values.");
                    }
                    e.printStackTrace();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter((Writer)sw, true);
                    CheckClassAdapter.printAnalyzerResult(this, a, pw);
                    pw.close();
                    throw new RuntimeException(e.getMessage() + ' ' + sw.toString());
                }
                this.accept(cmv);
            }
        }, labels);
        this.access = access;
    }

    @Override
    public void visitParameter(String name2, int access) {
        if (name2 != null) {
            CheckMethodAdapter.checkUnqualifiedName(this.version, name2, "name");
        }
        CheckClassAdapter.checkAccess(access, 36880);
        super.visitParameter(name2, access);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.checkEndMethod();
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(desc, visible));
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.checkEndMethod();
        int sort = typeRef >>> 24;
        if (sort != 1 && sort != 18 && sort != 20 && sort != 21 && sort != 22 && sort != 23) {
            throw new IllegalArgumentException("Invalid type reference sort 0x" + Integer.toHexString(sort));
        }
        CheckClassAdapter.checkTypeRefAndPath(typeRef, typePath);
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(super.visitTypeAnnotation(typeRef, typePath, desc, visible));
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        this.checkEndMethod();
        return new CheckAnnotationAdapter(super.visitAnnotationDefault(), false);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        this.checkEndMethod();
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(super.visitParameterAnnotation(parameter, desc, visible));
    }

    @Override
    public void visitAttribute(Attribute attr) {
        this.checkEndMethod();
        if (attr == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        super.visitAttribute(attr);
    }

    @Override
    public void visitCode() {
        if ((this.access & 0x400) != 0) {
            throw new RuntimeException("Abstract methods cannot have code");
        }
        this.startCode = true;
        super.visitCode();
    }

    @Override
    public void visitFrame(int type2, int nLocal, Object[] local, int nStack, Object[] stack) {
        int i2;
        int mStack;
        int mLocal;
        if (this.insnCount == this.lastFrame) {
            throw new IllegalStateException("At most one frame can be visited at a given code location.");
        }
        this.lastFrame = this.insnCount;
        switch (type2) {
            case -1: 
            case 0: {
                mLocal = Integer.MAX_VALUE;
                mStack = Integer.MAX_VALUE;
                break;
            }
            case 3: {
                mLocal = 0;
                mStack = 0;
                break;
            }
            case 4: {
                mLocal = 0;
                mStack = 1;
                break;
            }
            case 1: 
            case 2: {
                mLocal = 3;
                mStack = 0;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid frame type " + type2);
            }
        }
        if (nLocal > mLocal) {
            throw new IllegalArgumentException("Invalid nLocal=" + nLocal + " for frame type " + type2);
        }
        if (nStack > mStack) {
            throw new IllegalArgumentException("Invalid nStack=" + nStack + " for frame type " + type2);
        }
        if (type2 != 2) {
            if (nLocal > 0 && (local == null || local.length < nLocal)) {
                throw new IllegalArgumentException("Array local[] is shorter than nLocal");
            }
            for (i2 = 0; i2 < nLocal; ++i2) {
                this.checkFrameValue(local[i2]);
            }
        }
        if (nStack > 0 && (stack == null || stack.length < nStack)) {
            throw new IllegalArgumentException("Array stack[] is shorter than nStack");
        }
        for (i2 = 0; i2 < nStack; ++i2) {
            this.checkFrameValue(stack[i2]);
        }
        if (type2 == -1) {
            ++this.expandedFrames;
        } else {
            ++this.compressedFrames;
        }
        if (this.expandedFrames > 0 && this.compressedFrames > 0) {
            throw new RuntimeException("Expanded and compressed frames must not be mixed.");
        }
        super.visitFrame(type2, nLocal, local, nStack, stack);
    }

    @Override
    public void visitInsn(int opcode) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(opcode, 0);
        super.visitInsn(opcode);
        ++this.insnCount;
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(opcode, 1);
        switch (opcode) {
            case 16: {
                CheckMethodAdapter.checkSignedByte(operand, "Invalid operand");
                break;
            }
            case 17: {
                CheckMethodAdapter.checkSignedShort(operand, "Invalid operand");
                break;
            }
            default: {
                if (operand >= 4 && operand <= 11) break;
                throw new IllegalArgumentException("Invalid operand (must be an array type code T_...): " + operand);
            }
        }
        super.visitIntInsn(opcode, operand);
        ++this.insnCount;
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(opcode, 2);
        CheckMethodAdapter.checkUnsignedShort(var, "Invalid variable index");
        super.visitVarInsn(opcode, var);
        ++this.insnCount;
    }

    @Override
    public void visitTypeInsn(int opcode, String type2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(opcode, 3);
        CheckMethodAdapter.checkInternalName(type2, "type");
        if (opcode == 187 && type2.charAt(0) == '[') {
            throw new IllegalArgumentException("NEW cannot be used to create arrays: " + type2);
        }
        super.visitTypeInsn(opcode, type2);
        ++this.insnCount;
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name2, String desc) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(opcode, 4);
        CheckMethodAdapter.checkInternalName(owner, "owner");
        CheckMethodAdapter.checkUnqualifiedName(this.version, name2, "name");
        CheckMethodAdapter.checkDesc(desc, false);
        super.visitFieldInsn(opcode, owner, name2, desc);
        ++this.insnCount;
    }

    @Override
    @Deprecated
    public void visitMethodInsn(int opcode, String owner, String name2, String desc) {
        if (this.api >= 327680) {
            super.visitMethodInsn(opcode, owner, name2, desc);
            return;
        }
        this.doVisitMethodInsn(opcode, owner, name2, desc, opcode == 185);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name2, String desc, boolean itf) {
        if (this.api < 327680) {
            super.visitMethodInsn(opcode, owner, name2, desc, itf);
            return;
        }
        this.doVisitMethodInsn(opcode, owner, name2, desc, itf);
    }

    private void doVisitMethodInsn(int opcode, String owner, String name2, String desc, boolean itf) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(opcode, 5);
        if (opcode != 183 || !"<init>".equals(name2)) {
            CheckMethodAdapter.checkMethodIdentifier(this.version, name2, "name");
        }
        CheckMethodAdapter.checkInternalName(owner, "owner");
        CheckMethodAdapter.checkMethodDesc(desc);
        if (opcode == 182 && itf) {
            throw new IllegalArgumentException("INVOKEVIRTUAL can't be used with interfaces");
        }
        if (opcode == 185 && !itf) {
            throw new IllegalArgumentException("INVOKEINTERFACE can't be used with classes");
        }
        if (opcode == 183 && itf && (this.version & 0xFFFF) < 52) {
            throw new IllegalArgumentException("INVOKESPECIAL can't be used with interfaces prior to Java 8");
        }
        if (this.mv != null) {
            this.mv.visitMethodInsn(opcode, owner, name2, desc, itf);
        }
        ++this.insnCount;
    }

    @Override
    public void visitInvokeDynamicInsn(String name2, String desc, Handle bsm, Object ... bsmArgs) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkMethodIdentifier(this.version, name2, "name");
        CheckMethodAdapter.checkMethodDesc(desc);
        if (bsm.getTag() != 6 && bsm.getTag() != 8) {
            throw new IllegalArgumentException("invalid handle tag " + bsm.getTag());
        }
        for (int i2 = 0; i2 < bsmArgs.length; ++i2) {
            this.checkLDCConstant(bsmArgs[i2]);
        }
        super.visitInvokeDynamicInsn(name2, desc, bsm, bsmArgs);
        ++this.insnCount;
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkOpcode(opcode, 6);
        this.checkLabel(label, false, "label");
        CheckMethodAdapter.checkNonDebugLabel(label);
        super.visitJumpInsn(opcode, label);
        this.usedLabels.add(label);
        ++this.insnCount;
    }

    @Override
    public void visitLabel(Label label) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLabel(label, false, "label");
        if (this.labels.get(label) != null) {
            throw new IllegalArgumentException("Already visited label");
        }
        this.labels.put(label, this.insnCount);
        super.visitLabel(label);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLDCConstant(cst);
        super.visitLdcInsn(cst);
        ++this.insnCount;
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnsignedShort(var, "Invalid variable index");
        CheckMethodAdapter.checkSignedShort(increment, "Invalid increment");
        super.visitIincInsn(var, increment);
        ++this.insnCount;
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        int i2;
        this.checkStartCode();
        this.checkEndCode();
        if (max < min) {
            throw new IllegalArgumentException("Max = " + max + " must be greater than or equal to min = " + min);
        }
        this.checkLabel(dflt, false, "default label");
        CheckMethodAdapter.checkNonDebugLabel(dflt);
        if (labels == null || labels.length != max - min + 1) {
            throw new IllegalArgumentException("There must be max - min + 1 labels");
        }
        for (i2 = 0; i2 < labels.length; ++i2) {
            this.checkLabel(labels[i2], false, "label at index " + i2);
            CheckMethodAdapter.checkNonDebugLabel(labels[i2]);
        }
        super.visitTableSwitchInsn(min, max, dflt, labels);
        for (i2 = 0; i2 < labels.length; ++i2) {
            this.usedLabels.add(labels[i2]);
        }
        ++this.insnCount;
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys2, Label[] labels) {
        int i2;
        this.checkEndCode();
        this.checkStartCode();
        this.checkLabel(dflt, false, "default label");
        CheckMethodAdapter.checkNonDebugLabel(dflt);
        if (keys2 == null || labels == null || keys2.length != labels.length) {
            throw new IllegalArgumentException("There must be the same number of keys and labels");
        }
        for (i2 = 0; i2 < labels.length; ++i2) {
            this.checkLabel(labels[i2], false, "label at index " + i2);
            CheckMethodAdapter.checkNonDebugLabel(labels[i2]);
        }
        super.visitLookupSwitchInsn(dflt, keys2, labels);
        this.usedLabels.add(dflt);
        for (i2 = 0; i2 < labels.length; ++i2) {
            this.usedLabels.add(labels[i2]);
        }
        ++this.insnCount;
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkDesc(desc, false);
        if (desc.charAt(0) != '[') {
            throw new IllegalArgumentException("Invalid descriptor (must be an array type descriptor): " + desc);
        }
        if (dims < 1) {
            throw new IllegalArgumentException("Invalid dimensions (must be greater than 0): " + dims);
        }
        if (dims > desc.lastIndexOf(91) + 1) {
            throw new IllegalArgumentException("Invalid dimensions (must not be greater than dims(desc)): " + dims);
        }
        super.visitMultiANewArrayInsn(desc, dims);
        ++this.insnCount;
    }

    @Override
    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.checkStartCode();
        this.checkEndCode();
        int sort = typeRef >>> 24;
        if (sort != 67 && sort != 68 && sort != 69 && sort != 70 && sort != 71 && sort != 72 && sort != 73 && sort != 74 && sort != 75) {
            throw new IllegalArgumentException("Invalid type reference sort 0x" + Integer.toHexString(sort));
        }
        CheckClassAdapter.checkTypeRefAndPath(typeRef, typePath);
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(super.visitInsnAnnotation(typeRef, typePath, desc, visible));
    }

    @Override
    public void visitTryCatchBlock(Label start2, Label end, Label handler, String type2) {
        this.checkStartCode();
        this.checkEndCode();
        this.checkLabel(start2, false, "start label");
        this.checkLabel(end, false, "end label");
        this.checkLabel(handler, false, "handler label");
        CheckMethodAdapter.checkNonDebugLabel(start2);
        CheckMethodAdapter.checkNonDebugLabel(end);
        CheckMethodAdapter.checkNonDebugLabel(handler);
        if (this.labels.get(start2) != null || this.labels.get(end) != null || this.labels.get(handler) != null) {
            throw new IllegalStateException("Try catch blocks must be visited before their labels");
        }
        if (type2 != null) {
            CheckMethodAdapter.checkInternalName(type2, "type");
        }
        super.visitTryCatchBlock(start2, end, handler, type2);
        this.handlers.add(start2);
        this.handlers.add(end);
    }

    @Override
    public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.checkStartCode();
        this.checkEndCode();
        int sort = typeRef >>> 24;
        if (sort != 66) {
            throw new IllegalArgumentException("Invalid type reference sort 0x" + Integer.toHexString(sort));
        }
        CheckClassAdapter.checkTypeRefAndPath(typeRef, typePath);
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(super.visitTryCatchAnnotation(typeRef, typePath, desc, visible));
    }

    @Override
    public void visitLocalVariable(String name2, String desc, String signature2, Label start2, Label end, int index) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnqualifiedName(this.version, name2, "name");
        CheckMethodAdapter.checkDesc(desc, false);
        this.checkLabel(start2, true, "start label");
        this.checkLabel(end, true, "end label");
        CheckMethodAdapter.checkUnsignedShort(index, "Invalid variable index");
        int s = this.labels.get(start2);
        int e = this.labels.get(end);
        if (e < s) {
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        super.visitLocalVariable(name2, desc, signature2, start2, end, index);
    }

    @Override
    public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start2, Label[] end, int[] index, String desc, boolean visible) {
        this.checkStartCode();
        this.checkEndCode();
        int sort = typeRef >>> 24;
        if (sort != 64 && sort != 65) {
            throw new IllegalArgumentException("Invalid type reference sort 0x" + Integer.toHexString(sort));
        }
        CheckClassAdapter.checkTypeRefAndPath(typeRef, typePath);
        CheckMethodAdapter.checkDesc(desc, false);
        if (start2 == null || end == null || index == null || end.length != start2.length || index.length != start2.length) {
            throw new IllegalArgumentException("Invalid start, end and index arrays (must be non null and of identical length");
        }
        for (int i2 = 0; i2 < start2.length; ++i2) {
            this.checkLabel(start2[i2], true, "start label");
            this.checkLabel(end[i2], true, "end label");
            CheckMethodAdapter.checkUnsignedShort(index[i2], "Invalid variable index");
            int s = this.labels.get(start2[i2]);
            int e = this.labels.get(end[i2]);
            if (e >= s) continue;
            throw new IllegalArgumentException("Invalid start and end labels (end must be greater than start)");
        }
        return super.visitLocalVariableAnnotation(typeRef, typePath, start2, end, index, desc, visible);
    }

    @Override
    public void visitLineNumber(int line, Label start2) {
        this.checkStartCode();
        this.checkEndCode();
        CheckMethodAdapter.checkUnsignedShort(line, "Invalid line number");
        this.checkLabel(start2, true, "start label");
        super.visitLineNumber(line, start2);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.checkStartCode();
        this.checkEndCode();
        this.endCode = true;
        for (Label l : this.usedLabels) {
            if (this.labels.get(l) != null) continue;
            throw new IllegalStateException("Undefined label used");
        }
        int i2 = 0;
        while (i2 < this.handlers.size()) {
            Integer start2 = this.labels.get(this.handlers.get(i2++));
            Integer end = this.labels.get(this.handlers.get(i2++));
            if (start2 == null || end == null) {
                throw new IllegalStateException("Undefined try catch block labels");
            }
            if (end > start2) continue;
            throw new IllegalStateException("Emty try catch block handler range");
        }
        CheckMethodAdapter.checkUnsignedShort(maxStack, "Invalid max stack");
        CheckMethodAdapter.checkUnsignedShort(maxLocals, "Invalid max locals");
        super.visitMaxs(maxStack, maxLocals);
    }

    @Override
    public void visitEnd() {
        this.checkEndMethod();
        this.endMethod = true;
        super.visitEnd();
    }

    void checkStartCode() {
        if (!this.startCode) {
            throw new IllegalStateException("Cannot visit instructions before visitCode has been called.");
        }
    }

    void checkEndCode() {
        if (this.endCode) {
            throw new IllegalStateException("Cannot visit instructions after visitMaxs has been called.");
        }
    }

    void checkEndMethod() {
        if (this.endMethod) {
            throw new IllegalStateException("Cannot visit elements after visitEnd has been called.");
        }
    }

    void checkFrameValue(Object value) {
        if (value == Opcodes.TOP || value == Opcodes.INTEGER || value == Opcodes.FLOAT || value == Opcodes.LONG || value == Opcodes.DOUBLE || value == Opcodes.NULL || value == Opcodes.UNINITIALIZED_THIS) {
            return;
        }
        if (value instanceof String) {
            CheckMethodAdapter.checkInternalName((String)value, "Invalid stack frame value");
            return;
        }
        if (!(value instanceof Label)) {
            throw new IllegalArgumentException("Invalid stack frame value: " + value);
        }
        this.usedLabels.add((Label)value);
    }

    static void checkOpcode(int opcode, int type2) {
        if (opcode < 0 || opcode > 199 || TYPE[opcode] != type2) {
            throw new IllegalArgumentException("Invalid opcode: " + opcode);
        }
    }

    static void checkSignedByte(int value, String msg) {
        if (value < -128 || value > 127) {
            throw new IllegalArgumentException(msg + " (must be a signed byte): " + value);
        }
    }

    static void checkSignedShort(int value, String msg) {
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new IllegalArgumentException(msg + " (must be a signed short): " + value);
        }
    }

    static void checkUnsignedShort(int value, String msg) {
        if (value < 0 || value > 65535) {
            throw new IllegalArgumentException(msg + " (must be an unsigned short): " + value);
        }
    }

    static void checkConstant(Object cst) {
        if (!(cst instanceof Integer || cst instanceof Float || cst instanceof Long || cst instanceof Double || cst instanceof String)) {
            throw new IllegalArgumentException("Invalid constant: " + cst);
        }
    }

    void checkLDCConstant(Object cst) {
        if (cst instanceof Type) {
            int s = ((Type)cst).getSort();
            if (s != 10 && s != 9 && s != 11) {
                throw new IllegalArgumentException("Illegal LDC constant value");
            }
            if (s != 11 && (this.version & 0xFFFF) < 49) {
                throw new IllegalArgumentException("ldc of a constant class requires at least version 1.5");
            }
            if (s == 11 && (this.version & 0xFFFF) < 51) {
                throw new IllegalArgumentException("ldc of a method type requires at least version 1.7");
            }
        } else if (cst instanceof Handle) {
            if ((this.version & 0xFFFF) < 51) {
                throw new IllegalArgumentException("ldc of a handle requires at least version 1.7");
            }
            int tag = ((Handle)cst).getTag();
            if (tag < 1 || tag > 9) {
                throw new IllegalArgumentException("invalid handle tag " + tag);
            }
        } else {
            CheckMethodAdapter.checkConstant(cst);
        }
    }

    static void checkUnqualifiedName(int version, String name2, String msg) {
        if ((version & 0xFFFF) < 49) {
            CheckMethodAdapter.checkIdentifier(name2, msg);
        } else {
            for (int i2 = 0; i2 < name2.length(); ++i2) {
                if (".;[/".indexOf(name2.charAt(i2)) == -1) continue;
                throw new IllegalArgumentException("Invalid " + msg + " (must be a valid unqualified name): " + name2);
            }
        }
    }

    static void checkIdentifier(String name2, String msg) {
        CheckMethodAdapter.checkIdentifier(name2, 0, -1, msg);
    }

    static void checkIdentifier(String name2, int start2, int end, String msg) {
        if (name2 == null || (end == -1 ? name2.length() <= start2 : end <= start2)) {
            throw new IllegalArgumentException("Invalid " + msg + " (must not be null or empty)");
        }
        if (!Character.isJavaIdentifierStart(name2.charAt(start2))) {
            throw new IllegalArgumentException("Invalid " + msg + " (must be a valid Java identifier): " + name2);
        }
        int max = end == -1 ? name2.length() : end;
        for (int i2 = start2 + 1; i2 < max; ++i2) {
            if (Character.isJavaIdentifierPart(name2.charAt(i2))) continue;
            throw new IllegalArgumentException("Invalid " + msg + " (must be a valid Java identifier): " + name2);
        }
    }

    static void checkMethodIdentifier(int version, String name2, String msg) {
        if (name2 == null || name2.length() == 0) {
            throw new IllegalArgumentException("Invalid " + msg + " (must not be null or empty)");
        }
        if ((version & 0xFFFF) >= 49) {
            for (int i2 = 0; i2 < name2.length(); ++i2) {
                if (".;[/<>".indexOf(name2.charAt(i2)) == -1) continue;
                throw new IllegalArgumentException("Invalid " + msg + " (must be a valid unqualified name): " + name2);
            }
            return;
        }
        if (!Character.isJavaIdentifierStart(name2.charAt(0))) {
            throw new IllegalArgumentException("Invalid " + msg + " (must be a '<init>', '<clinit>' or a valid Java identifier): " + name2);
        }
        for (int i3 = 1; i3 < name2.length(); ++i3) {
            if (Character.isJavaIdentifierPart(name2.charAt(i3))) continue;
            throw new IllegalArgumentException("Invalid " + msg + " (must be '<init>' or '<clinit>' or a valid Java identifier): " + name2);
        }
    }

    static void checkInternalName(String name2, String msg) {
        if (name2 == null || name2.length() == 0) {
            throw new IllegalArgumentException("Invalid " + msg + " (must not be null or empty)");
        }
        if (name2.charAt(0) == '[') {
            CheckMethodAdapter.checkDesc(name2, false);
        } else {
            CheckMethodAdapter.checkInternalName(name2, 0, -1, msg);
        }
    }

    static void checkInternalName(String name2, int start2, int end, String msg) {
        int max = end == -1 ? name2.length() : end;
        try {
            int slash;
            int begin = start2;
            do {
                if ((slash = name2.indexOf(47, begin + 1)) == -1 || slash > max) {
                    slash = max;
                }
                CheckMethodAdapter.checkIdentifier(name2, begin, slash, null);
                begin = slash + 1;
            } while (slash != max);
        }
        catch (IllegalArgumentException unused) {
            throw new IllegalArgumentException("Invalid " + msg + " (must be a fully qualified class name in internal form): " + name2);
        }
    }

    static void checkDesc(String desc, boolean canBeVoid) {
        int end = CheckMethodAdapter.checkDesc(desc, 0, canBeVoid);
        if (end != desc.length()) {
            throw new IllegalArgumentException("Invalid descriptor: " + desc);
        }
    }

    static int checkDesc(String desc, int start2, boolean canBeVoid) {
        if (desc == null || start2 >= desc.length()) {
            throw new IllegalArgumentException("Invalid type descriptor (must not be null or empty)");
        }
        switch (desc.charAt(start2)) {
            case 'V': {
                if (canBeVoid) {
                    return start2 + 1;
                }
                throw new IllegalArgumentException("Invalid descriptor: " + desc);
            }
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return start2 + 1;
            }
            case '[': {
                int index;
                for (index = start2 + 1; index < desc.length() && desc.charAt(index) == '['; ++index) {
                }
                if (index < desc.length()) {
                    return CheckMethodAdapter.checkDesc(desc, index, false);
                }
                throw new IllegalArgumentException("Invalid descriptor: " + desc);
            }
            case 'L': {
                int index = desc.indexOf(59, start2);
                if (index == -1 || index - start2 < 2) {
                    throw new IllegalArgumentException("Invalid descriptor: " + desc);
                }
                try {
                    CheckMethodAdapter.checkInternalName(desc, start2 + 1, index, null);
                }
                catch (IllegalArgumentException unused) {
                    throw new IllegalArgumentException("Invalid descriptor: " + desc);
                }
                return index + 1;
            }
        }
        throw new IllegalArgumentException("Invalid descriptor: " + desc);
    }

    static void checkMethodDesc(String desc) {
        if (desc == null || desc.length() == 0) {
            throw new IllegalArgumentException("Invalid method descriptor (must not be null or empty)");
        }
        if (desc.charAt(0) != '(' || desc.length() < 3) {
            throw new IllegalArgumentException("Invalid descriptor: " + desc);
        }
        int start2 = 1;
        if (desc.charAt(start2) != ')') {
            do {
                if (desc.charAt(start2) != 'V') continue;
                throw new IllegalArgumentException("Invalid descriptor: " + desc);
            } while ((start2 = CheckMethodAdapter.checkDesc(desc, start2, false)) < desc.length() && desc.charAt(start2) != ')');
        }
        if ((start2 = CheckMethodAdapter.checkDesc(desc, start2 + 1, true)) != desc.length()) {
            throw new IllegalArgumentException("Invalid descriptor: " + desc);
        }
    }

    void checkLabel(Label label, boolean checkVisited, String msg) {
        if (label == null) {
            throw new IllegalArgumentException("Invalid " + msg + " (must not be null)");
        }
        if (checkVisited && this.labels.get(label) == null) {
            throw new IllegalArgumentException("Invalid " + msg + " (must be visited first)");
        }
    }

    private static void checkNonDebugLabel(Label label) {
        Field f = CheckMethodAdapter.getLabelStatusField();
        int status = 0;
        try {
            status = f == null ? 0 : (Integer)f.get(label);
        }
        catch (IllegalAccessException e) {
            throw new Error("Internal error");
        }
        if ((status & 1) != 0) {
            throw new IllegalArgumentException("Labels used for debug info cannot be reused for control flow");
        }
    }

    private static Field getLabelStatusField() {
        if (labelStatusField == null && (labelStatusField = CheckMethodAdapter.getLabelField("a")) == null) {
            labelStatusField = CheckMethodAdapter.getLabelField("status");
        }
        return labelStatusField;
    }

    private static Field getLabelField(String name2) {
        try {
            Field f = Label.class.getDeclaredField(name2);
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    static {
        String s = "BBBBBBBBBBBBBBBBCCIAADDDDDAAAAAAAAAAAAAAAAAAAABBBBBBBBDDDDDAAAAAAAAAAAAAAAAAAAABBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBBJBBBBBBBBBBBBBBBBBBBBHHHHHHHHHHHHHHHHDKLBBBBBBFFFFGGGGAECEBBEEBBAMHHAA";
        TYPE = new int[s.length()];
        for (int i2 = 0; i2 < TYPE.length; ++i2) {
            CheckMethodAdapter.TYPE[i2] = s.charAt(i2) - 65 - 1;
        }
    }
}

