/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.utils.system;

import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.ArgContext;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.data.NotificationManager;
import at.hannibal2.skyhanni.data.SkyHanniNotification;
import at.hannibal2.skyhanni.events.DebugDataCollectEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.MarkdownBuilder;
import at.hannibal2.skyhanni.utils.OSUtils;
import at.hannibal2.skyhanni.utils.VersionConstants;
import at.hannibal2.skyhanni.utils.system.ModInstance;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0012\u001a\u00020\u00062\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0015\u001a\u0004\u0018\u00010\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0010H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u0004\u0018\u00010\r*\u0006\u0012\u0002\b\u00030\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\r\u0010\u001e\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b \u0010\u0003R\u0017\u0010!\u001a\u00020\u00108\u0006\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u0017\u0010%\u001a\u00020\u001b8\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010\u001fR\u001b\u0010*\u001a\u00020\u001b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010\u001fR\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00100+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R'\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020/0.8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b0\u0010)\u001a\u0004\b1\u00102R\u0016\u00104\u001a\u00020\u001b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u0010&\u00a8\u00065"}, d2={"Lat/hannibal2/skyhanni/utils/system/PlatformUtils;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "event", "", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;", "onDebug", "(Lat/hannibal2/skyhanni/events/DebugDataCollectEvent;)V", "", "Lat/hannibal2/skyhanni/utils/system/ModInstance;", "getLoadedMods", "()Ljava/util/List;", "", "reason", "shutdownMinecraft", "(Ljava/lang/String;)V", "packageName", "getModFromPackage", "(Ljava/lang/String;)Lat/hannibal2/skyhanni/utils/system/ModInstance;", "Ljava/lang/Class;", "getModInstance", "(Ljava/lang/Class;)Lat/hannibal2/skyhanni/utils/system/ModInstance;", "modId", "", "isModInstalled", "(Ljava/lang/String;)Z", "isNeuLoaded", "()Z", "checkIfNeuIsLoaded", "MC_VERSION", "Ljava/lang/String;", "getMC_VERSION", "()Ljava/lang/String;", "IS_LEGACY", "Z", "getIS_LEGACY", "isDevEnvironment$delegate", "Lkotlin/Lazy;", "isDevEnvironment", "", "allowedFabricReports", "Ljava/util/Set;", "", "Lnet/minecraftforge/fml/common/ModContainer;", "modPackages$delegate", "getModPackages", "()Ljava/util/Map;", "modPackages", "validNeuInstalled", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nPlatformUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlatformUtils.kt\nat/hannibal2/skyhanni/utils/system/PlatformUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,177:1\n1863#2,2:178\n774#2:181\n865#2,2:182\n1863#2,2:184\n1863#2,2:186\n1368#2:188\n1454#2,2:189\n1557#2:191\n1628#2,3:192\n1456#2,3:195\n1#3:180\n*S KotlinDebug\n*F\n+ 1 PlatformUtils.kt\nat/hannibal2/skyhanni/utils/system/PlatformUtils\n*L\n89#1:178,2\n64#1:181\n64#1:182,2\n68#1:184,2\n81#1:186,2\n114#1:188\n114#1:189,2\n114#1:191\n114#1:192,3\n114#1:195,3\n*E\n"})
public final class PlatformUtils {
    @NotNull
    public static final PlatformUtils INSTANCE = new PlatformUtils();
    @NotNull
    private static final String MC_VERSION = VersionConstants.INSTANCE.getMC_VERSION();
    private static final boolean IS_LEGACY = Intrinsics.areEqual(VersionConstants.INSTANCE.getMC_VERSION(), "1.8.9");
    @NotNull
    private static final Lazy isDevEnvironment$delegate = LazyKt.lazy(PlatformUtils::isDevEnvironment_delegate$lambda$0);
    @NotNull
    private static final Set<String> allowedFabricReports;
    @NotNull
    private static final Lazy modPackages$delegate;
    private static boolean validNeuInstalled;

    private PlatformUtils() {
    }

    @NotNull
    public final String getMC_VERSION() {
        return MC_VERSION;
    }

    public final boolean getIS_LEGACY() {
        return IS_LEGACY;
    }

    public final boolean isDevEnvironment() {
        Lazy lazy = isDevEnvironment$delegate;
        return (Boolean)lazy.getValue();
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (validNeuInstalled) {
            return;
        }
        event.registerBrigadier("shmodlist", PlatformUtils::onCommandRegistration$lambda$4);
    }

    @HandleEvent
    public final void onDebug(@NotNull DebugDataCollectEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        event.title("Loaded Mods");
        event.addIrrelevant(PlatformUtils::onDebug$lambda$6);
    }

    private final List<ModInstance> getLoadedMods() {
        List<ModInstance> list;
        List<ModInstance> $this$getLoadedMods_u24lambda_u248 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        List list2 = Loader.instance().getModList();
        Intrinsics.checkNotNullExpressionValue(list2, "getModList(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModContainer it = (ModContainer)element$iv;
            boolean bl2 = false;
            String string = it.getModId();
            Intrinsics.checkNotNullExpressionValue(string, "getModId(...)");
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            String string3 = it.getVersion();
            Intrinsics.checkNotNullExpressionValue(string3, "getVersion(...)");
            String string4 = it.getSource().getName();
            Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
            $this$getLoadedMods_u24lambda_u248.add(new ModInstance(string, string2, string3, string4));
        }
        return CollectionsKt.build(list);
    }

    public final void shutdownMinecraft(@Nullable String reason) {
        String string;
        String string2;
        String string3 = reason;
        if (string3 != null) {
            String it = string3;
            boolean bl = false;
            string2 = " Reason: " + it;
        } else {
            string2 = string = null;
        }
        if (string2 == null) {
            string = "";
        }
        String reasonLine = string;
        System.err.println("SkyHanni-4.26.0 forced the game to shutdown." + reasonLine);
        FMLCommonHandler.instance().handleExit(-1);
    }

    public static /* synthetic */ void shutdownMinecraft$default(PlatformUtils platformUtils, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        platformUtils.shutdownMinecraft(string);
    }

    private final Map<String, ModContainer> getModPackages() {
        Lazy lazy = modPackages$delegate;
        return (Map)lazy.getValue();
    }

    private final ModInstance getModFromPackage(String packageName) {
        ModInstance modInstance;
        ModContainer modContainer = this.getModPackages().get(packageName);
        if (modContainer != null) {
            ModContainer it = modContainer;
            boolean bl = false;
            String string = it.getModId();
            Intrinsics.checkNotNullExpressionValue(string, "getModId(...)");
            String string2 = it.getName();
            Intrinsics.checkNotNullExpressionValue(string2, "getName(...)");
            String string3 = it.getVersion();
            Intrinsics.checkNotNullExpressionValue(string3, "getVersion(...)");
            String string4 = it.getSource().getName();
            Intrinsics.checkNotNullExpressionValue(string4, "getName(...)");
            modInstance = new ModInstance(string, string2, string3, string4);
        } else {
            modInstance = null;
        }
        return modInstance;
    }

    @Nullable
    public final ModInstance getModInstance(@NotNull Class<?> $this$getModInstance) {
        Intrinsics.checkNotNullParameter($this$getModInstance, "<this>");
        String string = $this$getModInstance.getCanonicalName();
        return this.getModFromPackage(string != null ? StringsKt.substringBeforeLast$default(string, '.', null, 2, null) : null);
    }

    public final boolean isModInstalled(@NotNull String modId) {
        Intrinsics.checkNotNullParameter(modId, "modId");
        return Loader.isModLoaded((String)modId);
    }

    public final boolean isNeuLoaded() {
        return validNeuInstalled;
    }

    @JvmStatic
    public static final void checkIfNeuIsLoaded() {
        Object object;
        try {
            Class.forName("io.github.moulberry.notenoughupdates.NotEnoughUpdates");
        }
        catch (Throwable e) {
            return;
        }
        try {
            Class<?> clazz = Class.forName("io.github.moulberry.notenoughupdates.util.ItemResolutionQuery");
            object = ArrayIteratorKt.iterator(clazz.getMethods());
            while (object.hasNext()) {
                Method field = (Method)object.next();
                if (!Intrinsics.areEqual(field.getName(), "findInternalNameByDisplayName")) continue;
                validNeuInstalled = true;
                return;
            }
        }
        catch (Throwable clazz) {
            // empty catch block
        }
        object = new String[]{"\u00a7c\u00a7lOutdated NotEnoughUpdates version detected!", "\u00a7cWhile Skyhanni doesn't require NotEnoughUpdates to function anymore,", "\u00a7cif you choose to still use NotEnoughUpdates, which is recommended,", "\u00a7cwe require you to use a newer version of NotEnoughUpdates to ensure", "\u00a7ccompatibility with some of our features.", "\u00a7cPlease update NotEnoughUpdates"};
        List text = CollectionsKt.listOf(object);
        DelayedRun.INSTANCE.runNextTick(() -> PlatformUtils.checkIfNeuIsLoaded$lambda$14(text));
    }

    private static final boolean isDevEnvironment_delegate$lambda$0() {
        Map map2 = Launch.blackboard;
        Object v = map2 != null ? map2.get("fml.deobfuscatedEnvironment") : null;
        Boolean bl = v instanceof Boolean ? (Boolean)v : null;
        return bl != null ? bl : true;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit onCommandRegistration$lambda$4$lambda$3(ArgContext $this$callback) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$callback, "$this$callback");
        Iterable $this$filter$iv = INSTANCE.getLoadedMods();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ModInstance it = (ModInstance)element$iv$iv;
            boolean bl = false;
            if (!(allowedFabricReports.contains(it.getId()) || !StringsKt.startsWith$default(it.getId(), "fabric-", false, 2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List loadedMods = (List)destination$iv$iv;
        MarkdownBuilder loadedModsMd = new MarkdownBuilder().category("Mods Loaded");
        Iterable $this$forEach$iv = loadedMods;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModInstance modInstance = (ModInstance)element$iv;
            boolean bl = false;
            String name2 = modInstance.component2();
            String version = modInstance.component3();
            String origin = modInstance.component4();
            loadedModsMd.append(name2, origin + " (" + version + ')');
        }
        OSUtils.INSTANCE.copyToClipboard(loadedModsMd.toString());
        ChatUtils.chat$default(ChatUtils.INSTANCE, "Copied " + loadedMods.size() + " mods to clipboard!", false, null, false, false, null, 62, null);
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$4(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter($this$registerBrigadier, "$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Get a Discord-formatted list of all loaded mods");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_ACTIVE);
        $this$registerBrigadier.callback(PlatformUtils::onCommandRegistration$lambda$4$lambda$3);
        return Unit.INSTANCE;
    }

    private static final Unit onDebug$lambda$6(List $this$addIrrelevant) {
        Intrinsics.checkNotNullParameter($this$addIrrelevant, "$this$addIrrelevant");
        Iterable $this$forEach$iv = INSTANCE.getLoadedMods();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ModInstance modInstance = (ModInstance)element$iv;
            boolean bl = false;
            String name2 = modInstance.component2();
            String version = modInstance.component3();
            String origin = modInstance.component4();
            $this$addIrrelevant.add(name2 + ": \t" + origin + " (" + version + ')');
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map modPackages_delegate$lambda$12() {
        void var3_3;
        void $this$flatMapTo$iv$iv;
        List list = Loader.instance().getModList();
        Intrinsics.checkNotNullExpressionValue(list, "getModList(...)");
        Iterable $this$flatMap$iv = list;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            ModContainer mod = (ModContainer)element$iv$iv;
            boolean bl = false;
            List list2 = mod.getOwnedPackages();
            Intrinsics.checkNotNullExpressionValue(list2, "getOwnedPackages(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(TuplesKt.to(it, mod));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return MapsKt.toMap((List)var3_3);
    }

    private static final Unit checkIfNeuIsLoaded$lambda$14(List $text) {
        Intrinsics.checkNotNullParameter($text, "$text");
        NotificationManager.INSTANCE.queueNotification(new SkyHanniNotification($text, Duration.Companion.getINFINITE-UwyO8pc(), true, null));
        return Unit.INSTANCE;
    }

    static {
        String[] stringArray = new String[]{"fabricloader", "fabric-api"};
        allowedFabricReports = SetsKt.setOf(stringArray);
        modPackages$delegate = LazyKt.lazy(PlatformUtils::modPackages_delegate$lambda$12);
    }
}

