/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.misc;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.commands.CommandCategory;
import at.hannibal2.skyhanni.config.commands.CommandRegistrationEvent;
import at.hannibal2.skyhanni.config.commands.brigadier.BaseBrigadierBuilder;
import at.hannibal2.skyhanni.config.enums.OutsideSBFeature;
import at.hannibal2.skyhanni.config.features.gui.GuiConfig;
import at.hannibal2.skyhanni.events.GuiRenderEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.events.minecraft.packet.PacketReceivedEvent;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.DelayedRun;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.TimeUtils;
import at.hannibal2.skyhanni.utils.renderables.Renderable;
import at.hannibal2.skyhanni.utils.renderables.primitives.TextRenderableKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\u0003J\u0017\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u000f\u0010\u000f\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0003J\u000f\u0010\u0010\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0003J\u0017\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0014H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0017H\u0007\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u0017\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001eH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010$\u001a\u00020!2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b$\u0010#J\u0017\u0010%\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b%\u0010&R\u0014\u0010*\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010,\u001a\u00020+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020+8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010-R\u0016\u00100\u001a\u00020/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u001a\u00103\u001a\b\u0012\u0004\u0012\u00020/028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0016\u00105\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0016\u00107\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00106R(\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u00108\u001a\u0004\u0018\u00010\n8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u000b\u00109\u001a\u0004\b:\u0010;R\u0018\u0010=\u001a\u0004\u0018\u00010<8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u0014\u0010A\u001a\u00020+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0016\u0010B\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u00106\u00a8\u0006C"}, d2={"Lat/hannibal2/skyhanni/features/misc/TpsCounter;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "event", "", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "updateDisplay", "", "tps", "fixTps", "(D)D", "tpsCommand", "onTick", "onWorldChange", "Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;", "onPacketReceive", "(Lat/hannibal2/skyhanni/events/minecraft/packet/PacketReceivedEvent;)V", "Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;", "onRenderOverlay", "(Lat/hannibal2/skyhanni/events/GuiRenderEvent$GuiOverlayRenderEvent;)V", "Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;", "onCommandRegistration", "(Lat/hannibal2/skyhanni/config/commands/CommandRegistrationEvent;)V", "", "shouldIgnore", "()Z", "isEnabled", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "", "format", "(D)Ljava/lang/String;", "getColor", "printError", "(D)V", "Lat/hannibal2/skyhanni/config/features/gui/GuiConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/gui/GuiConfig;", "config", "Lkotlin/time/Duration;", "ignorePacketDelay", "J", "minimumSecondsDisplayDelay", "", "packetsFromLastSecond", "I", "", "tpsList", "Ljava/util/List;", "hasRemovedFirstSecond", "Z", "hasReceivedPacket", "value", "Ljava/lang/Double;", "getTps", "()Ljava/lang/Double;", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "display", "Lat/hannibal2/skyhanni/utils/renderables/Renderable;", "getTimeSinceWorldSwitch-UwyO8pc", "()J", "timeSinceWorldSwitch", "pendingTpsCommand", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nTpsCounter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TpsCounter.kt\nat/hannibal2/skyhanni/features/misc/TpsCounter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n1#2:181\n*E\n"})
public final class TpsCounter {
    @NotNull
    public static final TpsCounter INSTANCE = new TpsCounter();
    private static final long ignorePacketDelay = DurationKt.toDuration(5, DurationUnit.SECONDS);
    private static final long minimumSecondsDisplayDelay = DurationKt.toDuration(10, DurationUnit.SECONDS);
    private static int packetsFromLastSecond;
    @NotNull
    private static final List<Integer> tpsList;
    private static boolean hasRemovedFirstSecond;
    private static boolean hasReceivedPacket;
    @Nullable
    private static Double tps;
    @Nullable
    private static Renderable display;
    private static boolean pendingTpsCommand;

    private TpsCounter() {
    }

    private final GuiConfig getConfig() {
        return SkyHanniMod.feature.gui;
    }

    @Nullable
    public final Double getTps() {
        return tps;
    }

    private final long getTimeSinceWorldSwitch-UwyO8pc() {
        return SimpleTimeMark.passedSince-UwyO8pc(SkyBlockUtils.INSTANCE.getLastWorldSwitch-uFjCsEo());
    }

    @HandleEvent
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (this.shouldIgnore()) {
            this.updateDisplay();
            return;
        }
        if (packetsFromLastSecond != 0) {
            if (hasRemovedFirstSecond) {
                tpsList.add(packetsFromLastSecond);
            }
            hasRemovedFirstSecond = true;
        }
        packetsFromLastSecond = 0;
        if (tpsList.size() > 10) {
            tpsList.remove(0);
        }
        this.updateDisplay();
        if (pendingTpsCommand) {
            pendingTpsCommand = false;
            this.tpsCommand();
        }
    }

    private final void updateDisplay() {
        String string;
        long timeUntil = Duration.minus-LRDsOJo(minimumSecondsDisplayDelay, this.getTimeSinceWorldSwitch-UwyO8pc());
        if (Duration.isPositive-impl(timeUntil)) {
            string = "\u00a7f(" + Duration.getInWholeSeconds-impl(timeUntil) + "s)";
        } else if (tpsList.isEmpty()) {
            string = "\u00a770 (Limbo?)";
        } else {
            double newTps = ((Number)RangesKt.coerceIn((Comparable)Double.valueOf(NumberUtil.INSTANCE.roundTo(CollectionsKt.averageOfInt((Iterable<Integer>)tpsList), 1)), RangesKt.rangeTo(0.0, 20.0))).doubleValue();
            tps = newTps;
            String legacyColor = this.format(newTps);
            string = legacyColor + this.fixTps(newTps);
        }
        String text = string;
        display = TextRenderableKt.text$default(Renderable.Companion, "\u00a7eTPS: " + text, 0.0, null, null, null, 30, null);
    }

    private final double fixTps(double tps) {
        return TimeUtils.INSTANCE.isAprilFoolsDay() ? tps / (double)2 : tps;
    }

    private final void tpsCommand() {
        block3: {
            Object object;
            block5: {
                block4: {
                    block2: {
                        long timeUntil = Duration.minus-LRDsOJo(minimumSecondsDisplayDelay, this.getTimeSinceWorldSwitch-UwyO8pc());
                        if (!Duration.isPositive-impl(timeUntil)) break block2;
                        ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7eTPS: \u00a7fCalculating... \u00a77(" + Duration.getInWholeSeconds-impl(timeUntil) + "s)", false, null, false, false, null, 62, null);
                        SimpleTimeMark.box-impl(DelayedRun.INSTANCE.runDelayed-bouF650(timeUntil, TpsCounter::tpsCommand$lambda$0));
                        break block3;
                    }
                    object = tps;
                    if (object == null) break block4;
                    double it = ((Number)object).doubleValue();
                    boolean bl = false;
                    String string = INSTANCE.format(INSTANCE.fixTps(it)) + it;
                    object = string;
                    if (string != null) break block5;
                }
                object = "\u00a770 (Limbo?)";
            }
            Object tpsMessage = object;
            ChatUtils.chat$default(ChatUtils.INSTANCE, "\u00a7eTPS: " + (String)tpsMessage, false, null, false, false, null, 62, null);
        }
    }

    @HandleEvent
    public final void onTick() {
        if (hasReceivedPacket) {
            int n = packetsFromLastSecond;
            packetsFromLastSecond = n + 1;
            hasReceivedPacket = false;
        }
    }

    @HandleEvent
    public final void onWorldChange() {
        tpsList.clear();
        tps = null;
        packetsFromLastSecond = 0;
        display = null;
        hasRemovedFirstSecond = false;
    }

    @HandleEvent(priority=-2, receiveCancelled=true)
    public final void onPacketReceive(@NotNull PacketReceivedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        hasReceivedPacket = true;
    }

    @HandleEvent
    public final void onRenderOverlay(@NotNull GuiRenderEvent.GuiOverlayRenderEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        RenderUtils.renderRenderable$default(RenderUtils.INSTANCE, this.getConfig().getTpsDisplayPosition(), display, "Tps Display", false, 4, null);
    }

    @HandleEvent
    public final void onCommandRegistration(@NotNull CommandRegistrationEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        event.registerBrigadier("shtps", TpsCounter::onCommandRegistration$lambda$3);
    }

    private final boolean shouldIgnore() {
        return Duration.compareTo-LRDsOJo(this.getTimeSinceWorldSwitch-UwyO8pc(), ignorePacketDelay) < 0;
    }

    private final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getOnHypixel() && this.getConfig().getTpsDisplay() && (SkyBlockUtils.INSTANCE.getInSkyBlock() || OutsideSBFeature.TPS_DISPLAY.isSelected());
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.tpsDisplayEnabled", "gui.tpsDisplay", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.tpsDisplayPosition", "gui.tpsDisplayPosition", null, 8, null);
    }

    private final String format(double tps) {
        double d = tps;
        if (!(!Double.isInfinite(d) && !Double.isNaN(d))) {
            this.printError(tps);
        }
        return this.getColor(tps);
    }

    private final String getColor(double tps) {
        return tps > 19.8 ? "\u00a72" : (tps > 19.0 ? "\u00a7a" : (tps > 17.5 ? "\u00a76" : (tps > 12.0 ? "\u00a7c" : "\u00a74")));
    }

    private final void printError(double tps) {
        Pair[] pairArray = new Pair[]{TuplesKt.to("tps", tps), TuplesKt.to("packetsFromLastSecond", packetsFromLastSecond), TuplesKt.to("hasRemovedFirstSecond", hasRemovedFirstSecond), TuplesKt.to("hasReceivedPacket", hasReceivedPacket), TuplesKt.to("tpsList", tpsList), TuplesKt.to("timeSinceWorldSwitch", Duration.box-impl(this.getTimeSinceWorldSwitch-UwyO8pc()))};
        ErrorManager.logErrorStateWithData$default(ErrorManager.INSTANCE, "TPS calculation got an error", "tps is " + tps, pairArray, false, false, false, null, 120, null);
    }

    private static final Unit tpsCommand$lambda$0() {
        pendingTpsCommand = true;
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$3$lambda$2() {
        INSTANCE.tpsCommand();
        return Unit.INSTANCE;
    }

    private static final Unit onCommandRegistration$lambda$3(BaseBrigadierBuilder $this$registerBrigadier) {
        Intrinsics.checkNotNullParameter($this$registerBrigadier, "$this$registerBrigadier");
        $this$registerBrigadier.setDescription("Informs in chat about the server ticks per second (TPS).");
        $this$registerBrigadier.setCategory(CommandCategory.USERS_ACTIVE);
        $this$registerBrigadier.simpleCallback(TpsCounter::onCommandRegistration$lambda$3$lambda$2);
        return Unit.INSTANCE;
    }

    static {
        tpsList = new ArrayList();
    }
}

