/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.inventory.tiarelay;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.ConfigUpdaterMigrator;
import at.hannibal2.skyhanni.config.features.inventory.helper.TiaRelayConfig;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.PlaySoundEvent;
import at.hannibal2.skyhanni.events.RenderInventoryItemTipEvent;
import at.hannibal2.skyhanni.events.SecondPassedEvent;
import at.hannibal2.skyhanni.utils.ChatUtils;
import at.hannibal2.skyhanni.utils.HypixelCommands;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.ItemUtils;
import at.hannibal2.skyhanni.utils.SimpleTimeMark;
import at.hannibal2.skyhanni.utils.collection.CollectionUtils;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001(B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\f\u0010\u0003J\u0017\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0010H\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0013H\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0019\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u001b\u001a\u00020\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001e\u001a\u00020\u001d8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010!\u001a\u00020 8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R \u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020$0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&R \u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010&\u00a8\u0006)"}, d2={"Lat/hannibal2/skyhanni/features/inventory/tiarelay/TiaRelayHelper;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/PlaySoundEvent;", "event", "", "onPlaySound", "(Lat/hannibal2/skyhanni/events/PlaySoundEvent;)V", "Lat/hannibal2/skyhanni/events/SecondPassedEvent;", "onSecondPassed", "(Lat/hannibal2/skyhanni/events/SecondPassedEvent;)V", "tryResult", "Lat/hannibal2/skyhanni/events/RenderInventoryItemTipEvent;", "onRenderItemTip", "(Lat/hannibal2/skyhanni/events/RenderInventoryItemTipEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;", "onSlotClick", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$SlotClickEvent;)V", "Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;", "onConfigFix", "(Lat/hannibal2/skyhanni/config/ConfigUpdaterMigrator$ConfigFixEvent;)V", "Lat/hannibal2/skyhanni/config/features/inventory/helper/TiaRelayConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/inventory/helper/TiaRelayConfig;", "config", "", "inInventory", "Z", "", "lastClickSlot", "I", "Lat/hannibal2/skyhanni/utils/SimpleTimeMark;", "lastClickTime", "J", "", "Lat/hannibal2/skyhanni/features/inventory/tiarelay/TiaRelayHelper$Sound;", "sounds", "Ljava/util/Map;", "resultDisplay", "Sound", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nTiaRelayHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TiaRelayHelper.kt\nat/hannibal2/skyhanni/features/inventory/tiarelay/TiaRelayHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,153:1\n1755#2,3:154\n1755#2,3:157\n*S KotlinDebug\n*F\n+ 1 TiaRelayHelper.kt\nat/hannibal2/skyhanni/features/inventory/tiarelay/TiaRelayHelper\n*L\n114#1:154,3\n122#1:157,3\n*E\n"})
public final class TiaRelayHelper {
    @NotNull
    public static final TiaRelayHelper INSTANCE = new TiaRelayHelper();
    private static boolean inInventory;
    private static int lastClickSlot;
    private static long lastClickTime;
    @NotNull
    private static final Map<Integer, Sound> sounds;
    @NotNull
    private static final Map<Integer, Integer> resultDisplay;

    private TiaRelayHelper() {
    }

    private final TiaRelayConfig getConfig() {
        return SkyHanniMod.feature.getInventory().getHelper().getTiaRelay();
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onPlaySound(@NotNull PlaySoundEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        String soundName = event.getSoundName();
        if (this.getConfig().getTiaRelayMute() && Intrinsics.areEqual(soundName, "mob.wolf.whine")) {
            event.cancel();
        }
        if (!this.getConfig().getSoundHelper()) {
            return;
        }
        if (!inInventory) {
            return;
        }
        double distance = event.getDistanceToPlayer();
        if (distance >= 2.0) {
            return;
        }
        if (lastClickSlot == 0) {
            return;
        }
        if (Duration.compareTo-LRDsOJo(SimpleTimeMark.passedSince-UwyO8pc(lastClickTime), DurationKt.toDuration(1, DurationUnit.MINUTES)) > 0) {
            return;
        }
        if (sounds.containsKey(lastClickSlot)) {
            return;
        }
        sounds.put(lastClickSlot, new Sound(soundName, event.getPitch()));
        lastClickSlot = 0;
        this.tryResult();
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onSecondPassed(@NotNull SecondPassedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.getConfig().getSoundHelper()) {
            return;
        }
        if (StringsKt.contains$default((CharSequence)InventoryUtils.INSTANCE.openInventoryName(), "Network Relay", false, 2, null)) {
            inInventory = true;
        } else {
            inInventory = false;
            sounds.clear();
            resultDisplay.clear();
        }
    }

    private final void tryResult() {
        if (sounds.size() < 4) {
            return;
        }
        String name2 = ((Sound)CollectionsKt.first((Iterable)sounds.values())).getName();
        for (Map.Entry<Integer, Sound> sound2 : MapsKt.toMutableMap(sounds).entrySet()) {
            if (Intrinsics.areEqual(sound2.getValue().getName(), name2)) continue;
            ChatUtils.userError$default(ChatUtils.INSTANCE, "Tia Relay Helper error: Too much background noise! Try turning off the music and then try again.", false, 2, null);
            ChatUtils.clickableChat-ylHfTWE$default(ChatUtils.INSTANCE, "Click here to run /togglemusic", TiaRelayHelper::tryResult$lambda$0, "\u00a7eClick to run /togglemusic!", 0L, false, null, false, false, 248, null);
            sounds.clear();
            return;
        }
        Map pitchMap = new LinkedHashMap();
        for (Map.Entry entry : sounds.entrySet()) {
            pitchMap.put(entry.getKey(), Float.valueOf(((Sound)entry.getValue()).getPitch()));
        }
        sounds.clear();
        resultDisplay.clear();
        int i2 = 1;
        for (Map.Entry entry : CollectionUtils.INSTANCE.sorted(pitchMap).entrySet()) {
            Integer n = i2;
            resultDisplay.put((Integer)entry.getKey(), n);
            ++i2;
        }
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onRenderItemTip(@NotNull RenderInventoryItemTipEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.getConfig().getSoundHelper()) {
            return;
        }
        if (!inInventory) {
            return;
        }
        Slot slot = event.getSlot();
        ItemStack stack = slot.func_75211_c();
        int slotNumber = slot.field_75222_d;
        Integer n = slotNumber;
        Integer position = resultDisplay.getOrDefault(n, null);
        if (position != null) {
            boolean bl;
            block12: {
                Intrinsics.checkNotNull(stack);
                Iterable $this$any$iv = ItemUtils.INSTANCE.getLore(stack);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!StringsKt.contains$default((CharSequence)it, "Done!", false, 2, null)) continue;
                        bl = true;
                        break block12;
                    }
                    bl = false;
                }
            }
            if (bl) {
                resultDisplay.clear();
                return;
            }
            event.setStackTip("" + '#' + position);
            return;
        }
        if (!sounds.containsKey(slotNumber)) {
            boolean bl;
            block13: {
                Intrinsics.checkNotNull(stack);
                Iterable $this$any$iv = ItemUtils.INSTANCE.getLore(stack);
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.contains$default((CharSequence)it, "Hear!", false, 2, null)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl) {
                event.setStackTip("Hear!");
                event.setOffsetX(5);
                event.setOffsetY(-5);
                return;
            }
        }
    }

    @HandleEvent(onlyOnSkyblock=true)
    public final void onSlotClick(@NotNull GuiContainerEvent.SlotClickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.getConfig().getSoundHelper()) {
            return;
        }
        if (!inInventory) {
            return;
        }
        if (event.getClickedButton() != 1) {
            return;
        }
        lastClickSlot = event.getSlotId();
        lastClickTime = SimpleTimeMark.Companion.now-uFjCsEo();
    }

    @HandleEvent
    public final void onConfigFix(@NotNull ConfigUpdaterMigrator.ConfigFixEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.tiaRelayMute", "inventory.helper.tiaRelay.tiaRelayMute", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.tiaRelayHelper", "inventory.helper.tiaRelay.soundHelper", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.tiaRelayNextWaypoint", "inventory.helper.tiaRelay.nextWaypoint", null, 8, null);
        ConfigUpdaterMigrator.ConfigFixEvent.move$default(event, 2, "misc.tiaRelayAllWaypoints", "inventory.helper.tiaRelay.allWaypoints", null, 8, null);
    }

    private static final Unit tryResult$lambda$0() {
        HypixelCommands.INSTANCE.toggleMusic();
        return Unit.INSTANCE;
    }

    static {
        lastClickTime = SimpleTimeMark.Companion.farPast();
        sounds = new LinkedHashMap();
        resultDisplay = new LinkedHashMap();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\b\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000b\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lat/hannibal2/skyhanni/features/inventory/tiarelay/TiaRelayHelper$Sound;", "", "", "name", "", "pitch", "<init>", "(Ljava/lang/String;F)V", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "F", "getPitch", "()F", "1.8.9"})
    public static final class Sound {
        @NotNull
        private final String name;
        private final float pitch;

        public Sound(@NotNull String name2, float pitch) {
            Intrinsics.checkNotNullParameter(name2, "name");
            this.name = name2;
            this.pitch = pitch;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final float getPitch() {
            return this.pitch;
        }
    }
}

