/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.fishing.trophy;

import at.hannibal2.skyhanni.data.jsonobjects.repo.TrophyFishInfo;
import at.hannibal2.skyhanni.features.fishing.trophy.TrophyFishManager;
import at.hannibal2.skyhanni.features.fishing.trophy.TrophyRarity;
import at.hannibal2.skyhanni.utils.NumberUtil;
import at.hannibal2.skyhanni.utils.StringUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\u0007J+\u0010\u000f\u001a\u00020\u00042\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lat/hannibal2/skyhanni/features/fishing/trophy/TrophyFishApi;", "", "<init>", "()V", "", "internalName", "hoverInfo", "(Ljava/lang/String;)Ljava/lang/String;", "displayName", "getInternalName", "", "Lat/hannibal2/skyhanni/features/fishing/trophy/TrophyRarity;", "", "counts", "rarity", "formatCount", "(Ljava/util/Map;Lat/hannibal2/skyhanni/features/fishing/trophy/TrophyRarity;)Ljava/lang/String;", "Lkotlin/text/Regex;", "regex", "Lkotlin/text/Regex;", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nTrophyFishApi.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrophyFishApi.kt\nat/hannibal2/skyhanni/features/fishing/trophy/TrophyFishApi\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,41:1\n535#2:42\n520#2,6:43\n*S KotlinDebug\n*F\n+ 1 TrophyFishApi.kt\nat/hannibal2/skyhanni/features/fishing/trophy/TrophyFishApi\n*L\n13#1:42\n13#1:43,6\n*E\n"})
public final class TrophyFishApi {
    @NotNull
    public static final TrophyFishApi INSTANCE = new TrophyFishApi();
    @NotNull
    private static final Regex regex = new Regex("[- ]");

    private TrophyFishApi() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String hoverInfo(@NotNull String internalName2) {
        void $this$filterTo$iv$iv;
        Map<TrophyRarity, Integer> counts;
        Intrinsics.checkNotNullParameter(internalName2, "internalName");
        Map<String, Map<TrophyRarity, Integer>> map2 = TrophyFishManager.INSTANCE.getFish();
        if (map2 == null) {
            return null;
        }
        Map<String, Map<TrophyRarity, Integer>> trophyFishes = map2;
        TrophyFishInfo trophyFishInfo = TrophyFishManager.INSTANCE.getInfo(internalName2);
        if (trophyFishInfo == null) {
            return null;
        }
        TrophyFishInfo info = trophyFishInfo;
        Map<TrophyRarity, Integer> map3 = trophyFishes.get(internalName2);
        if (map3 == null) {
            map3 = MapsKt.emptyMap();
        }
        Map<TrophyRarity, Integer> $this$filter$iv = counts = map3;
        boolean $i$f$filter = false;
        Map<TrophyRarity, Integer> map4 = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!(((Number)it.getValue()).intValue() > 0)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        TrophyRarity trophyRarity = (TrophyRarity)((Object)CollectionsKt.maxOrNull(destination$iv$iv.keySet()));
        if (trophyRarity == null) {
            trophyRarity = TrophyRarity.BRONZE;
        }
        TrophyRarity bestFishObtained = trophyRarity;
        String rateString = info.getRate() != null ? "\u00a78[\u00a77" + info.getRate() + "%\u00a78]" : "";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n                |").append(info.getDisplayName()).append(' ').append(rateString).append("\n                |").append(StringUtils.INSTANCE.splitLines(info.getDescription(), 150)).append("\n                |\n                |").append(TrophyRarity.DIAMOND.getFormattedString()).append(": ").append(this.formatCount(counts, TrophyRarity.DIAMOND)).append("\n                |").append(TrophyRarity.GOLD.getFormattedString()).append(": ").append(this.formatCount(counts, TrophyRarity.GOLD)).append("\n                |").append(TrophyRarity.SILVER.getFormattedString()).append(": ").append(this.formatCount(counts, TrophyRarity.SILVER)).append("\n                |").append(TrophyRarity.BRONZE.getFormattedString()).append(": ").append(this.formatCount(counts, TrophyRarity.BRONZE)).append("\n                |\n                |\u00a77Total: ");
        stringBuilder.append(bestFishObtained.getFormatCode()).append(NumberUtil.INSTANCE.addSeparators(CollectionsKt.sumOfInt((Iterable<Integer>)counts.values()))).append("\n        ");
        return StringsKt.trimMargin$default(stringBuilder.toString(), null, 1, null);
    }

    @NotNull
    public final String getInternalName(@NotNull String displayName) {
        Intrinsics.checkNotNullParameter(displayName, "displayName");
        CharSequence charSequence = StringsKt.replace$default(displayName, "Obfuscated", "Obfuscated Fish", false, 4, null);
        Regex regex = TrophyFishApi.regex;
        String string = "";
        String string2 = regex.replace(charSequence, string).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
        return StringUtils.removeColor$default(StringUtils.INSTANCE, string2, false, 1, null);
    }

    private final String formatCount(Map<TrophyRarity, Integer> counts, TrophyRarity rarity) {
        int count2 = ((Number)counts.getOrDefault((Object)rarity, 0)).intValue();
        return count2 > 0 ? "\u00a76" + NumberUtil.INSTANCE.addSeparators(count2) : "\u00a7c\u2716";
    }
}

