/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.features.bingo.card;

import at.hannibal2.skyhanni.SkyHanniMod;
import at.hannibal2.skyhanni.api.event.HandleEvent;
import at.hannibal2.skyhanni.config.features.event.bingo.BingoCardConfig;
import at.hannibal2.skyhanni.data.jsonobjects.repo.BingoData;
import at.hannibal2.skyhanni.events.GuiContainerEvent;
import at.hannibal2.skyhanni.events.minecraft.ToolTipEvent;
import at.hannibal2.skyhanni.features.bingo.BingoApi;
import at.hannibal2.skyhanni.features.bingo.card.goals.BingoGoal;
import at.hannibal2.skyhanni.features.bingo.card.goals.GoalType;
import at.hannibal2.skyhanni.test.command.ErrorManager;
import at.hannibal2.skyhanni.utils.InventoryUtils;
import at.hannibal2.skyhanni.utils.LorenzColor;
import at.hannibal2.skyhanni.utils.RegexUtils;
import at.hannibal2.skyhanni.utils.RenderUtils;
import at.hannibal2.skyhanni.utils.SkyBlockUtils;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPattern;
import at.hannibal2.skyhanni.utils.repopatterns.RepoPatternGroup;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerChest;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001%B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015R\u001b\u0010\u001b\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001e\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0018\u001a\u0004\b\u001d\u0010\u001aR\u001b\u0010!\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u0018\u001a\u0004\b \u0010\u001aR\u001b\u0010$\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0018\u001a\u0004\b#\u0010\u001a\u00a8\u0006&"}, d2={"Lat/hannibal2/skyhanni/features/bingo/card/BingoCardTips;", "", "<init>", "()V", "Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;", "event", "", "onToolTip", "(Lat/hannibal2/skyhanni/events/minecraft/ToolTipEvent;)V", "Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;", "onBackgroundDrawn", "(Lat/hannibal2/skyhanni/events/GuiContainerEvent$BackgroundDrawnEvent;)V", "", "isEnabled", "()Z", "Lat/hannibal2/skyhanni/config/features/event/bingo/BingoCardConfig;", "getConfig", "()Lat/hannibal2/skyhanni/config/features/event/bingo/BingoCardConfig;", "config", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "patternGroup", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPatternGroup;", "Ljava/util/regex/Pattern;", "inventoryPattern$delegate", "Lat/hannibal2/skyhanni/utils/repopatterns/RepoPattern;", "getInventoryPattern", "()Ljava/util/regex/Pattern;", "inventoryPattern", "rewardPattern$delegate", "getRewardPattern", "rewardPattern", "contributionRewardsPattern$delegate", "getContributionRewardsPattern", "contributionRewardsPattern", "rowNamePattern$delegate", "getRowNamePattern", "rowNamePattern", "Difficulty", "1.8.9"})
@SourceDebugExtension(value={"SMAP\nBingoCardTips.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BingoCardTips.kt\nat/hannibal2/skyhanni/features/bingo/card/BingoCardTips\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n360#2,7:127\n360#2,7:134\n*S KotlinDebug\n*F\n+ 1 BingoCardTips.kt\nat/hannibal2/skyhanni/features/bingo/card/BingoCardTips\n*L\n71#1:127,7\n73#1:134,7\n*E\n"})
public final class BingoCardTips {
    @NotNull
    public static final BingoCardTips INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final RepoPatternGroup patternGroup;
    @NotNull
    private static final RepoPattern inventoryPattern$delegate;
    @NotNull
    private static final RepoPattern rewardPattern$delegate;
    @NotNull
    private static final RepoPattern contributionRewardsPattern$delegate;
    @NotNull
    private static final RepoPattern rowNamePattern$delegate;

    private BingoCardTips() {
    }

    private final BingoCardConfig getConfig() {
        return SkyHanniMod.feature.getEvent().getBingo().getBingoCard();
    }

    private final Pattern getInventoryPattern() {
        return (Pattern)inventoryPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[0]);
    }

    private final Pattern getRewardPattern() {
        return (Pattern)rewardPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[1]);
    }

    private final Pattern getContributionRewardsPattern() {
        return (Pattern)contributionRewardsPattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[2]);
    }

    private final Pattern getRowNamePattern() {
        return (Pattern)rowNamePattern$delegate.getValue(this, (KProperty<?>)$$delegatedProperties[3]);
    }

    @HandleEvent
    public final void onToolTip(@NotNull ToolTipEvent event) {
        block14: {
            int n;
            int index$iv;
            int index;
            BingoData bingoTip;
            List<String> toolTip;
            BingoGoal goal;
            Slot slot;
            block13: {
                String it;
                String item$iv;
                Iterator<String> iterator2;
                boolean $i$f$indexOfFirst;
                List<String> $this$indexOfFirst$iv;
                Intrinsics.checkNotNullParameter(event, "event");
                if (!this.isEnabled()) {
                    return;
                }
                if (!RegexUtils.INSTANCE.matches(this.getInventoryPattern(), InventoryUtils.INSTANCE.openInventoryName())) {
                    return;
                }
                slot = event.getSlot();
                BingoGoal bingoGoal = BingoApi.INSTANCE.getBingoGoals().get(slot.field_75222_d);
                if (bingoGoal == null) {
                    return;
                }
                goal = bingoGoal;
                toolTip = event.getToolTip();
                if (RegexUtils.INSTANCE.matches(this.getRowNamePattern(), CollectionsKt.firstOrNull(toolTip))) {
                    return;
                }
                BingoData bingoData = BingoApi.INSTANCE.getData(goal);
                if (bingoData == null) {
                    return;
                }
                bingoTip = bingoData;
                boolean communityGoal = goal.getType() == GoalType.COMMUNITY;
                String string = bingoTip.getDifficulty().toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                Difficulty difficulty = Difficulty.valueOf(string);
                toolTip.set(0, toolTip.get(0) + " \u00a77(" + difficulty.getDisplayName() + "\u00a77)");
                index = 0;
                if (!communityGoal) {
                    $this$indexOfFirst$iv = toolTip;
                    $i$f$indexOfFirst = false;
                    index$iv = 0;
                    iterator2 = $this$indexOfFirst$iv.iterator();
                    while (iterator2.hasNext()) {
                        it = item$iv = iterator2.next();
                        boolean bl = false;
                        if (RegexUtils.INSTANCE.matches(INSTANCE.getRewardPattern(), it)) {
                            n = index$iv;
                            break block13;
                        }
                        ++index$iv;
                    }
                    n = -1;
                } else {
                    $this$indexOfFirst$iv = toolTip;
                    $i$f$indexOfFirst = false;
                    index$iv = 0;
                    iterator2 = $this$indexOfFirst$iv.iterator();
                    while (iterator2.hasNext()) {
                        it = item$iv = iterator2.next();
                        boolean bl = false;
                        if (RegexUtils.INSTANCE.matches(INSTANCE.getContributionRewardsPattern(), it)) {
                            n = index$iv;
                            break block13;
                        }
                        ++index$iv;
                    }
                    n = -1;
                }
            }
            index = n - 1;
            if (index == -2) {
                Pair[] pairArray = new Pair[]{TuplesKt.to("goal displayName", goal.getDisplayName()), TuplesKt.to("slot slotNumber", slot.field_75222_d), TuplesKt.to("toolTip", toolTip)};
                ErrorManager.logErrorWithData$default(ErrorManager.INSTANCE, new IndexOutOfBoundsException(), "BingoCardTips reward line not found", pairArray, false, false, false, 56, null);
                return;
            }
            int n2 = index;
            index = n2 + 1;
            toolTip.add(n2, "");
            n2 = index;
            index = n2 + 1;
            toolTip.add(n2, "\u00a7eGuide:");
            for (String line : bingoTip.getGuide()) {
                index$iv = index;
                index = index$iv + 1;
                toolTip.add(index$iv, ' ' + line);
            }
            String string = bingoTip.getFound();
            if (string == null) break block14;
            String it = string;
            boolean bl = false;
            int n3 = index;
            index = n3 + 1;
            toolTip.add(n3, "\u00a77Found by: \u00a7e" + it);
        }
    }

    @HandleEvent
    public final void onBackgroundDrawn(@NotNull GuiContainerEvent.BackgroundDrawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.isEnabled()) {
            return;
        }
        if (!RegexUtils.INSTANCE.matches(this.getInventoryPattern(), InventoryUtils.INSTANCE.openInventoryName())) {
            return;
        }
        Container container = event.getContainer();
        Intrinsics.checkNotNull(container, "null cannot be cast to non-null type net.minecraft.inventory.ContainerChest");
        ContainerChest chest = (ContainerChest)container;
        Iterator<Map.Entry<Slot, ItemStack>> iterator2 = InventoryUtils.INSTANCE.getAllItems(chest).entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object;
            Slot slot;
            block7: {
                block6: {
                    BingoGoal goal;
                    slot = iterator2.next().getKey();
                    if (BingoApi.INSTANCE.getBingoGoals().get(slot.field_75222_d) == null || this.getConfig().getHideDoneDifficulty() && goal.getDone()) continue;
                    object = BingoApi.INSTANCE.getData(goal);
                    if (object == null) break block6;
                    BingoData it = object;
                    boolean bl = false;
                    String string = it.getDifficulty().toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue(string, "toUpperCase(...)");
                    Difficulty difficulty = Difficulty.valueOf(string);
                    LorenzColor lorenzColor = difficulty.getColor();
                    object = lorenzColor;
                    if (lorenzColor != null) break block7;
                }
                object = LorenzColor.GRAY;
            }
            BingoData color = object;
            RenderUtils.INSTANCE.highlight(slot, ((LorenzColor)((Object)color)).addOpacity(120));
        }
    }

    public final boolean isEnabled() {
        return SkyBlockUtils.INSTANCE.getInSkyBlock() && this.getConfig().getBingoSplashGuide();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(BingoCardTips.class, "inventoryPattern", "getInventoryPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(BingoCardTips.class, "rewardPattern", "getRewardPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(BingoCardTips.class, "contributionRewardsPattern", "getContributionRewardsPattern()Ljava/util/regex/Pattern;", 0)), Reflection.property1(new PropertyReference1Impl(BingoCardTips.class, "rowNamePattern", "getRowNamePattern()Ljava/util/regex/Pattern;", 0))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new BingoCardTips();
        patternGroup = RepoPattern.Companion.group("bingo.card.tips");
        inventoryPattern$delegate = patternGroup.pattern("card", "Bingo Card");
        rewardPattern$delegate = patternGroup.pattern("reward", "(?:\u00a7.)+Reward");
        contributionRewardsPattern$delegate = patternGroup.pattern("reward.contribution", "(?:\u00a7.)+Contribution Rewards.*");
        rowNamePattern$delegate = patternGroup.pattern("row.name", "(?:\u00a7.)+Row #.*");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\b\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011\u00a8\u0006\u0012"}, d2={"Lat/hannibal2/skyhanni/features/bingo/card/BingoCardTips$Difficulty;", "", "", "rawName", "Lat/hannibal2/skyhanni/utils/LorenzColor;", "color", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lat/hannibal2/skyhanni/utils/LorenzColor;)V", "Lat/hannibal2/skyhanni/utils/LorenzColor;", "getColor", "()Lat/hannibal2/skyhanni/utils/LorenzColor;", "displayName", "Ljava/lang/String;", "getDisplayName", "()Ljava/lang/String;", "EASY", "MEDIUM", "HARD", "1.8.9"})
    public static final class Difficulty
    extends Enum<Difficulty> {
        @NotNull
        private final LorenzColor color;
        @NotNull
        private final String displayName;
        public static final /* enum */ Difficulty EASY = new Difficulty("Easy", LorenzColor.GREEN);
        public static final /* enum */ Difficulty MEDIUM = new Difficulty("Medium", LorenzColor.YELLOW);
        public static final /* enum */ Difficulty HARD = new Difficulty("Hard", LorenzColor.RED);
        private static final /* synthetic */ Difficulty[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Difficulty(String rawName, LorenzColor color) {
            this.color = color;
            this.displayName = this.color.getChatColor() + rawName;
        }

        @NotNull
        public final LorenzColor getColor() {
            return this.color;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public static Difficulty[] values() {
            return (Difficulty[])$VALUES.clone();
        }

        public static Difficulty valueOf(String value) {
            return Enum.valueOf(Difficulty.class, value);
        }

        @NotNull
        public static EnumEntries<Difficulty> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = difficultyArray = new Difficulty[]{Difficulty.EASY, Difficulty.MEDIUM, Difficulty.HARD};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

