/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.moulconfig;

import at.hannibal2.skyhanni.deps.moulconfig.common.ClickType;
import at.hannibal2.skyhanni.deps.moulconfig.common.IMinecraft;
import at.hannibal2.skyhanni.deps.moulconfig.common.MyResourceLocation;
import at.hannibal2.skyhanni.deps.moulconfig.common.text.StructuredText;
import java.awt.Desktop;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;

public abstract class Social {
    public static Social forLink(StructuredText name2, MyResourceLocation icon, String link) {
        try {
            return new URLSocial(name2, new URI(link), icon);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract void onClick();

    public abstract List<StructuredText> getTooltip();

    public abstract MyResourceLocation getIcon();

    private static class URLSocial
    extends Social {
        private final StructuredText name;
        private final URI url;
        private final MyResourceLocation icon;

        private URLSocial(StructuredText name2, URI url, MyResourceLocation icon) {
            this.name = name2;
            this.url = url;
            this.icon = icon;
        }

        @Override
        public void onClick() {
            try {
                Desktop.getDesktop().browse(this.url);
            }
            catch (Exception e) {
                IMinecraft.INSTANCE.sendClickableChatMessage(StructuredText.of("Click here to open ").append(this.name), this.url.toString(), ClickType.OPEN_LINK);
            }
        }

        @Override
        public List<StructuredText> getTooltip() {
            return Collections.singletonList(this.name);
        }

        @Override
        public MyResourceLocation getIcon() {
            return this.icon;
        }
    }
}

