/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.libautoupdate;

import at.hannibal2.skyhanni.deps.libautoupdate.UpdateData;
import at.hannibal2.skyhanni.deps.libautoupdate.UpdateSource;
import at.hannibal2.skyhanni.deps.libautoupdate.UpdateUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import lombok.NonNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

@NonNull
public final class MavenSource
implements UpdateSource {
    private final String repoUrl;
    private final String module;
    private final String artifact;
    private final String classifier;
    private final String extension;

    protected String getMavenBaseUrl() {
        return String.format("%s/%s/%s", this.repoUrl, this.module.replace('.', '/'), this.artifact);
    }

    protected String getMavenMetadataUrl() {
        return this.getMavenBaseUrl() + "/maven-metadata.xml";
    }

    protected String getMavenArtifactUrl(String version) {
        return String.format("%s/%s/%s-%s%s%s.%s", this.getMavenBaseUrl(), version, this.artifact, version, this.classifier.isEmpty() ? "" : "-", this.classifier, this.extension);
    }

    @Override
    public CompletableFuture<UpdateData> checkUpdate(String updateStream) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return CompletableFuture.supplyAsync(() -> {
            UpdateData updateData2;
            block8: {
                InputStream is = UpdateUtils.openUrlConnection(new URL(this.getMavenMetadataUrl()));
                try {
                    Document document = db.parse(new InputSource(is));
                    Element metadata2 = document.getDocumentElement();
                    Element versioning = (Element)metadata2.getElementsByTagName("versioning").item(0);
                    Element latest = (Element)versioning.getElementsByTagName("latest").item(0);
                    String latestVersion = latest.getTextContent();
                    updateData2 = new UpdateData(latestVersion, (JsonElement)new JsonPrimitive(latestVersion), null, this.getMavenArtifactUrl(latestVersion));
                    if (is == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw new CompletionException(e);
                    }
                }
                is.close();
            }
            return updateData2;
        });
    }

    public MavenSource(String repoUrl, String module, String artifact, String classifier2, String extension) {
        this.repoUrl = repoUrl;
        this.module = module;
        this.artifact = artifact;
        this.classifier = classifier2;
        this.extension = extension;
    }

    public String getRepoUrl() {
        return this.repoUrl;
    }

    public String getModule() {
        return this.module;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }

    public String toString() {
        return "MavenSource(repoUrl=" + this.getRepoUrl() + ", module=" + this.getModule() + ", artifact=" + this.getArtifact() + ", classifier=" + this.getClassifier() + ", extension=" + this.getExtension() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MavenSource)) {
            return false;
        }
        MavenSource other = (MavenSource)o;
        String this$repoUrl = this.getRepoUrl();
        String other$repoUrl = other.getRepoUrl();
        if (this$repoUrl == null ? other$repoUrl != null : !this$repoUrl.equals(other$repoUrl)) {
            return false;
        }
        String this$module = this.getModule();
        String other$module = other.getModule();
        if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
            return false;
        }
        String this$artifact = this.getArtifact();
        String other$artifact = other.getArtifact();
        if (this$artifact == null ? other$artifact != null : !this$artifact.equals(other$artifact)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        String this$extension = this.getExtension();
        String other$extension = other.getExtension();
        return !(this$extension == null ? other$extension != null : !this$extension.equals(other$extension));
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        String $repoUrl = this.getRepoUrl();
        result2 = result2 * 59 + ($repoUrl == null ? 43 : $repoUrl.hashCode());
        String $module = this.getModule();
        result2 = result2 * 59 + ($module == null ? 43 : $module.hashCode());
        String $artifact = this.getArtifact();
        result2 = result2 * 59 + ($artifact == null ? 43 : $artifact.hashCode());
        String $classifier = this.getClassifier();
        result2 = result2 * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        String $extension = this.getExtension();
        result2 = result2 * 59 + ($extension == null ? 43 : $extension.hashCode());
        return result2;
    }
}

