/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.hypixel.modapi.tweaker;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.relauncher.CoreModManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HypixelModAPITweaker
implements ITweaker {
    private static Logger LOGGER = LogManager.getLogger();
    public static final String VERSION_NAME;
    public static final long VERSION;
    public static final String BUNDLED_JAR_NAME;
    public static final String VERSION_KEY = "net.hypixel.mod-api.version:1";
    private boolean hasOfferedVersion = false;

    public static long getBlackboardVersion() {
        Object blackboardVersion = Launch.blackboard.get(VERSION_KEY);
        if (blackboardVersion == null) {
            return Long.MIN_VALUE;
        }
        if (!(blackboardVersion instanceof Long)) {
            return Long.MAX_VALUE;
        }
        return (Long)blackboardVersion;
    }

    private void tryInjectAPI() {
        if (HypixelModAPITweaker.getBlackboardVersion() != VERSION) {
            LOGGER.info("Blackboard version newer than our version {}. Skipping injecting API.", new Object[]{VERSION});
            return;
        }
        if (!this.hasOfferedVersion) {
            LOGGER.info("Someone else with the same version number {} offered to inject themselves first. Skipping injecting API.", new Object[]{VERSION});
            return;
        }
        this.injectAPI();
    }

    /*
     * Exception decompiling
     */
    private File unpackAPI() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private File getThisJar() {
        URL thisJarURL = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        if (thisJarURL == null) {
            return null;
        }
        if (!"file".equals(thisJarURL.getProtocol())) {
            return null;
        }
        try {
            return new File(thisJarURL.toURI()).getAbsoluteFile();
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    private void injectAPI() {
        LOGGER.info("Injecting mod API of version {}", new Object[]{VERSION_NAME});
        try {
            Launch.classLoader.addURL(this.unpackAPI().toURI().toURL());
            LOGGER.info("Added mod API to classpath");
        }
        catch (MalformedURLException e) {
            LOGGER.error("Could not add mod API to classpath", (Throwable)e);
        }
    }

    private void allowModLoading() {
        File file = this.getThisJar();
        if (file != null) {
            CoreModManager.getReparseableCoremods().add(file.getPath());
            CoreModManager.getIgnoredMods().remove(file.getPath());
            LOGGER.info("Re-added mod {} to the mod candidate list.", new Object[]{file});
        } else {
            LOGGER.warn("Did not find JAR including this tweaker, cannot re-add mod.");
        }
    }

    private void offerVersionToBlackboard() {
        if (HypixelModAPITweaker.getBlackboardVersion() < VERSION) {
            LOGGER.info("Offering newer version {} > {}", new Object[]{VERSION, HypixelModAPITweaker.getBlackboardVersion()});
            this.hasOfferedVersion = true;
            Launch.blackboard.put(VERSION_KEY, VERSION);
        }
    }

    public void acceptOptions(List<String> args2, File gameDir, File assetsDir, String profile) {
        this.offerVersionToBlackboard();
        this.allowModLoading();
    }

    public void injectIntoClassLoader(LaunchClassLoader classLoader) {
    }

    public String getLaunchTarget() {
        return null;
    }

    public String[] getLaunchArguments() {
        this.tryInjectAPI();
        return new String[0];
    }

    static {
        Properties properties2 = new Properties();
        try {
            properties2.load(HypixelModAPITweaker.class.getResourceAsStream("/hypixel-mod-api-bundled.properties"));
        }
        catch (IOException e) {
            LOGGER.error("Could not load version information for bundled hypixel mod API", (Throwable)e);
        }
        VERSION_NAME = properties2.getProperty("version", "0.0.0.0");
        LOGGER.info("Loaded bundled hypixel mod API version as {}", new Object[]{VERSION_NAME});
        String[] versionComponents = VERSION_NAME.split("\\.");
        assert (versionComponents.length == 4);
        assert (Math.pow(10000.0, 4.0) < 9.223372036854776E18);
        long version = 0L;
        for (int i2 = 0; i2 < 4; ++i2) {
            version *= 10000L;
            version += Long.parseLong(versionComponents[i2]);
        }
        VERSION = version;
        LOGGER.info("Loaded bundled hypixel mod API numeric version as {}", new Object[]{VERSION});
        BUNDLED_JAR_NAME = "HypixelModAPI-" + VERSION_NAME + ".jar";
    }
}

