/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.commons.net.nntp;

import at.hannibal2.skyhanni.deps.commons.net.nntp.NntpThreadContainer;
import at.hannibal2.skyhanni.deps.commons.net.nntp.Threadable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Threader {
    private void buildContainer(Threadable threadable, HashMap<String, NntpThreadContainer> idTable) {
        String[] references;
        String id = threadable.messageThreadId();
        NntpThreadContainer container = idTable.get(id);
        int bogusIdCount = 0;
        if (container != null) {
            if (container.threadable != null) {
                id = "<Bogus-id:" + ++bogusIdCount + ">";
                container = null;
            } else {
                container.threadable = threadable;
            }
        }
        if (container == null) {
            container = new NntpThreadContainer();
            container.threadable = threadable;
            idTable.put(id, container);
        }
        NntpThreadContainer parentRef = null;
        for (String refString : references = threadable.messageThreadReferences()) {
            NntpThreadContainer ref = idTable.get(refString);
            if (ref == null) {
                ref = new NntpThreadContainer();
                idTable.put(refString, ref);
            }
            if (parentRef != null && ref.parent == null && parentRef != ref && !ref.findChild(parentRef)) {
                ref.parent = parentRef;
                ref.next = parentRef.child;
                parentRef.child = ref;
            }
            parentRef = ref;
        }
        if (parentRef != null && (parentRef == container || container.findChild(parentRef))) {
            parentRef = null;
        }
        if (container.parent != null) {
            NntpThreadContainer prev = null;
            NntpThreadContainer rest = container.parent.child;
            while (rest != null && rest != container) {
                prev = rest;
                rest = rest.next;
            }
            if (rest == null) {
                throw new IllegalStateException("Didnt find " + container + " in parent " + container.parent);
            }
            if (prev == null) {
                container.parent.child = container.next;
            } else {
                prev.next = container.next;
            }
            container.next = null;
            container.parent = null;
        }
        if (parentRef != null) {
            container.parent = parentRef;
            container.next = parentRef.child;
            parentRef.child = container;
        }
    }

    private NntpThreadContainer findRootSet(HashMap<String, NntpThreadContainer> idTable) {
        NntpThreadContainer root = new NntpThreadContainer();
        for (Map.Entry<String, NntpThreadContainer> entry : idTable.entrySet()) {
            NntpThreadContainer c = entry.getValue();
            if (c.parent != null) continue;
            if (c.next != null) {
                throw new IllegalStateException("c.next is " + c.next.toString());
            }
            c.next = root.child;
            root.child = c;
        }
        return root;
    }

    private void gatherSubjects(NntpThreadContainer root) {
        int count2 = 0;
        NntpThreadContainer c = root.child;
        while (c != null) {
            ++count2;
            c = c.next;
        }
        HashMap<String, NntpThreadContainer> subjectTable = new HashMap<String, NntpThreadContainer>((int)((double)count2 * 1.2), 0.9f);
        count2 = 0;
        NntpThreadContainer c2 = root.child;
        while (c2 != null) {
            NntpThreadContainer old;
            String subj;
            Threadable threadable = c2.threadable;
            if (threadable == null) {
                threadable = c2.child.threadable;
            }
            if ((subj = threadable.simplifiedSubject()) != null && !subj.isEmpty() && ((old = (NntpThreadContainer)subjectTable.get(subj)) == null || c2.threadable == null && old.threadable != null || old.threadable != null && old.threadable.subjectIsReply() && c2.threadable != null && !c2.threadable.subjectIsReply())) {
                subjectTable.put(subj, c2);
                ++count2;
            }
            c2 = c2.next;
        }
        if (count2 == 0) {
            return;
        }
        NntpThreadContainer prev = null;
        NntpThreadContainer c3 = root.child;
        NntpThreadContainer rest = c3.next;
        while (c3 != null) {
            NntpThreadContainer old;
            String subj;
            Threadable threadable = c3.threadable;
            if (threadable == null) {
                threadable = c3.child.threadable;
            }
            if ((subj = threadable.simplifiedSubject()) != null && !subj.isEmpty() && (old = (NntpThreadContainer)subjectTable.get(subj)) != c3) {
                if (prev == null) {
                    root.child = c3.next;
                } else {
                    prev.next = c3.next;
                }
                c3.next = null;
                if (old.threadable == null && c3.threadable == null) {
                    NntpThreadContainer tail = old.child;
                    while (tail != null && tail.next != null) {
                        tail = tail.next;
                    }
                    if (tail != null) {
                        tail.next = c3.child;
                    }
                    tail = c3.child;
                    while (tail != null) {
                        tail.parent = old;
                        tail = tail.next;
                    }
                    c3.child = null;
                } else if (old.threadable == null || c3.threadable != null && c3.threadable.subjectIsReply() && !old.threadable.subjectIsReply()) {
                    c3.parent = old;
                    c3.next = old.child;
                    old.child = c3;
                } else {
                    NntpThreadContainer newc = new NntpThreadContainer();
                    newc.threadable = old.threadable;
                    NntpThreadContainer tail = newc.child = old.child;
                    while (tail != null) {
                        tail.parent = newc;
                        tail = tail.next;
                    }
                    old.threadable = null;
                    old.child = null;
                    c3.parent = old;
                    newc.parent = old;
                    old.child = c3;
                    c3.next = newc;
                }
                c3 = prev;
            }
            prev = c3;
            c3 = rest;
            rest = rest == null ? null : rest.next;
        }
        subjectTable.clear();
        subjectTable = null;
    }

    private void pruneEmptyContainers(NntpThreadContainer parent) {
        NntpThreadContainer prev = null;
        NntpThreadContainer container = parent.child;
        NntpThreadContainer next = container.next;
        while (container != null) {
            if (container.threadable == null && container.child == null) {
                if (prev == null) {
                    parent.child = container.next;
                } else {
                    prev.next = container.next;
                }
                container = prev;
            } else if (container.threadable == null && (container.parent != null || container.child.next == null)) {
                NntpThreadContainer kids = container.child;
                if (prev == null) {
                    parent.child = kids;
                } else {
                    prev.next = kids;
                }
                NntpThreadContainer tail = kids;
                while (tail.next != null) {
                    tail.parent = container.parent;
                    tail = tail.next;
                }
                tail.parent = container.parent;
                tail.next = container.next;
                next = kids;
                container = prev;
            } else if (container.child != null) {
                this.pruneEmptyContainers(container);
            }
            prev = container;
            container = next;
            next = container == null ? null : container.next;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Threadable thread(Iterable<? extends Threadable> messages) {
        void var4_6;
        if (messages == null) {
            return null;
        }
        HashMap<String, NntpThreadContainer> idTable = new HashMap<String, NntpThreadContainer>();
        for (Threadable threadable : messages) {
            if (threadable.isDummy()) continue;
            this.buildContainer(threadable, idTable);
        }
        if (idTable.isEmpty()) {
            return null;
        }
        NntpThreadContainer root = this.findRootSet(idTable);
        idTable.clear();
        idTable = null;
        this.pruneEmptyContainers(root);
        root.reverseChildren();
        this.gatherSubjects(root);
        if (root.next != null) {
            throw new IllegalStateException("root node has a next:" + root);
        }
        NntpThreadContainer nntpThreadContainer = root.child;
        while (var4_6 != null) {
            if (var4_6.threadable == null) {
                var4_6.threadable = var4_6.child.threadable.makeDummy();
            }
            NntpThreadContainer nntpThreadContainer2 = var4_6.next;
        }
        Threadable threadable = root.child == null ? null : root.child.threadable;
        root.flush();
        return threadable;
    }

    public Threadable thread(List<? extends Threadable> messages) {
        return this.thread((Iterable<? extends Threadable>)messages);
    }

    @Deprecated
    public Threadable thread(Threadable[] messages) {
        if (messages == null) {
            return null;
        }
        return this.thread(Arrays.asList(messages));
    }
}

