/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.commons.net.nntp;

import at.hannibal2.skyhanni.deps.commons.net.nntp.Threadable;
import at.hannibal2.skyhanni.deps.commons.net.util.NetConstants;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;

public class Article
implements Threadable {
    private long articleNumber = -1L;
    private String subject;
    private String date;
    private String articleId;
    private String simplifiedSubject;
    private String from;
    private ArrayList<String> references;
    private boolean isReply;
    public Article kid;
    public Article next;

    public static void printThread(Article article) {
        Article.printThread(article, 0, System.out);
    }

    public static void printThread(Article article, int depth) {
        Article.printThread(article, depth, System.out);
    }

    public static void printThread(Article article, int depth, PrintStream ps) {
        for (int i2 = 0; i2 < depth; ++i2) {
            ps.print("==>");
        }
        ps.println(article.getSubject() + "\t" + article.getFrom() + "\t" + article.getArticleId());
        if (article.kid != null) {
            Article.printThread(article.kid, depth + 1);
        }
        if (article.next != null) {
            Article.printThread(article.next, depth);
        }
    }

    public static void printThread(Article article, PrintStream ps) {
        Article.printThread(article, 0, ps);
    }

    @Deprecated
    public void addHeaderField(String name2, String val) {
    }

    public void addReference(String msgId) {
        if (msgId == null || msgId.isEmpty()) {
            return;
        }
        if (this.references == null) {
            this.references = new ArrayList();
        }
        this.isReply = true;
        Collections.addAll(this.references, msgId.split(" "));
    }

    private void flushSubjectCache() {
        this.simplifiedSubject = null;
    }

    public String getArticleId() {
        return this.articleId;
    }

    @Deprecated
    public int getArticleNumber() {
        return (int)this.articleNumber;
    }

    public long getArticleNumberLong() {
        return this.articleNumber;
    }

    public String getDate() {
        return this.date;
    }

    public String getFrom() {
        return this.from;
    }

    public String[] getReferences() {
        if (this.references == null) {
            return NetConstants.EMPTY_STRING_ARRAY;
        }
        return this.references.toArray(NetConstants.EMPTY_STRING_ARRAY);
    }

    public String getSubject() {
        return this.subject;
    }

    @Override
    public boolean isDummy() {
        return this.articleNumber == -1L;
    }

    @Override
    public Threadable makeDummy() {
        return new Article();
    }

    @Override
    public String messageThreadId() {
        return this.articleId;
    }

    @Override
    public String[] messageThreadReferences() {
        return this.getReferences();
    }

    public void setArticleId(String string) {
        this.articleId = string;
    }

    @Deprecated
    public void setArticleNumber(int a) {
        this.articleNumber = a;
    }

    public void setArticleNumber(long l) {
        this.articleNumber = l;
    }

    @Override
    public void setChild(Threadable child) {
        this.kid = (Article)child;
        this.flushSubjectCache();
    }

    public void setDate(String string) {
        this.date = string;
    }

    public void setFrom(String string) {
        this.from = string;
    }

    @Override
    public void setNext(Threadable next) {
        this.next = (Article)next;
        this.flushSubjectCache();
    }

    public void setSubject(String string) {
        this.subject = string;
    }

    @Override
    public String simplifiedSubject() {
        if (this.simplifiedSubject == null) {
            this.simplifySubject();
        }
        return this.simplifiedSubject;
    }

    private void simplifySubject() {
        int start2 = 0;
        String subject = this.getSubject();
        int len = subject.length();
        boolean done = false;
        while (!done) {
            int end;
            done = true;
            while (start2 < len && subject.charAt(start2) == ' ') {
                ++start2;
            }
            if (!(start2 >= len - 2 || subject.charAt(start2) != 'r' && subject.charAt(start2) != 'R' || subject.charAt(start2 + 1) != 'e' && subject.charAt(start2 + 1) != 'E')) {
                if (subject.charAt(start2 + 2) == ':') {
                    start2 += 3;
                    done = false;
                } else if (start2 < len - 2 && (subject.charAt(start2 + 2) == '[' || subject.charAt(start2 + 2) == '(')) {
                    int i2;
                    for (i2 = start2 + 3; i2 < len && subject.charAt(i2) >= '0' && subject.charAt(i2) <= '9'; ++i2) {
                    }
                    if (i2 < len - 1 && (subject.charAt(i2) == ']' || subject.charAt(i2) == ')') && subject.charAt(i2 + 1) == ':') {
                        start2 = i2 + 2;
                        done = false;
                    }
                }
            }
            if ("(no subject)".equals(this.simplifiedSubject)) {
                this.simplifiedSubject = "";
            }
            for (end = len; end > start2 && subject.charAt(end - 1) < ' '; --end) {
            }
            if (start2 == 0 && end == len) {
                this.simplifiedSubject = subject;
                continue;
            }
            this.simplifiedSubject = subject.substring(start2, end);
        }
    }

    @Override
    public boolean subjectIsReply() {
        return this.isReply;
    }

    public String toString() {
        return this.articleNumber + " " + this.articleId + " " + this.subject;
    }
}

