/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.commons.net.ftp.parser;

import at.hannibal2.skyhanni.deps.commons.net.ftp.FTPClientConfig;
import at.hannibal2.skyhanni.deps.commons.net.ftp.FTPFile;
import at.hannibal2.skyhanni.deps.commons.net.ftp.parser.ConfigurableFTPFileEntryParserImpl;
import java.io.File;
import java.text.ParseException;
import java.util.Locale;

public class OS400FTPEntryParser
extends ConfigurableFTPFileEntryParserImpl {
    private static final String DEFAULT_DATE_FORMAT = "yy/MM/dd HH:mm:ss";
    private static final String REGEX = "(\\S+)\\s+(?:(\\d+)\\s+)?(?:(\\S+)\\s+(\\S+)\\s+)?(\\*STMF|\\*DIR|\\*FILE|\\*MEM)\\s+((\\S+\\s*)+)?";

    public OS400FTPEntryParser() {
        this((FTPClientConfig)null);
    }

    public OS400FTPEntryParser(FTPClientConfig config) {
        super(REGEX);
        this.configure(config);
    }

    @Override
    protected FTPClientConfig getDefaultConfiguration() {
        return new FTPClientConfig("OS/400", DEFAULT_DATE_FORMAT, null);
    }

    private boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    @Override
    public FTPFile parseFTPEntry(String entry) {
        FTPFile file = new FTPFile();
        file.setRawListing(entry);
        if (this.matches(entry)) {
            int pos;
            int type2;
            String usr = this.group(1);
            String filesize = this.group(2);
            String datestr = "";
            if (!this.isNullOrEmpty(this.group(3)) || !this.isNullOrEmpty(this.group(4))) {
                datestr = this.group(3) + " " + this.group(4);
            }
            String typeStr = this.group(5);
            String name2 = this.group(6);
            boolean mustScanForPathSeparator = true;
            try {
                file.setTimestamp(super.parseTimestamp(datestr));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (typeStr.equalsIgnoreCase("*STMF")) {
                type2 = 0;
                if (this.isNullOrEmpty(filesize) || this.isNullOrEmpty(name2)) {
                    return null;
                }
            } else if (typeStr.equalsIgnoreCase("*DIR")) {
                type2 = 1;
                if (this.isNullOrEmpty(filesize) || this.isNullOrEmpty(name2)) {
                    return null;
                }
            } else if (typeStr.equalsIgnoreCase("*FILE")) {
                if (name2 == null || !name2.toUpperCase(Locale.ROOT).endsWith(".SAVF")) {
                    return null;
                }
                mustScanForPathSeparator = false;
                type2 = 0;
            } else if (typeStr.equalsIgnoreCase("*MEM")) {
                mustScanForPathSeparator = false;
                type2 = 0;
                if (this.isNullOrEmpty(name2)) {
                    return null;
                }
                if (!this.isNullOrEmpty(filesize) || !this.isNullOrEmpty(datestr)) {
                    return null;
                }
                name2 = name2.replace('/', File.separatorChar);
            } else {
                type2 = 3;
            }
            file.setType(type2);
            file.setUser(usr);
            try {
                file.setSize(Long.parseLong(filesize));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (name2.endsWith("/")) {
                name2 = name2.substring(0, name2.length() - 1);
            }
            if (mustScanForPathSeparator && (pos = name2.lastIndexOf(47)) > -1) {
                name2 = name2.substring(pos + 1);
            }
            file.setName(name2);
            return file;
        }
        return null;
    }
}

