/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.deps.commons.net.ftp.parser;

import at.hannibal2.skyhanni.deps.commons.net.ftp.FTPClientConfig;
import at.hannibal2.skyhanni.deps.commons.net.ftp.FTPFile;
import at.hannibal2.skyhanni.deps.commons.net.ftp.parser.ConfigurableFTPFileEntryParserImpl;
import java.text.ParseException;

public class MacOsPeterFTPEntryParser
extends ConfigurableFTPFileEntryParserImpl {
    static final String DEFAULT_DATE_FORMAT = "MMM d yyyy";
    static final String DEFAULT_RECENT_DATE_FORMAT = "MMM d HH:mm";
    private static final String REGEX = "([bcdelfmpSs-])(((r|-)(w|-)([xsStTL-]))((r|-)(w|-)([xsStTL-]))((r|-)(w|-)([xsStTL-])))\\+?\\s+((folder\\s+)|((\\d+)\\s+(\\d+)\\s+))(\\d+)\\s+((?:\\d+[-/]\\d+[-/]\\d+)|(?:\\S{3}\\s+\\d{1,2})|(?:\\d{1,2}\\s+\\S{3}))\\s+(\\d+(?::\\d+)?)\\s+(\\S*)(\\s*.*)";

    public MacOsPeterFTPEntryParser() {
        this((FTPClientConfig)null);
    }

    public MacOsPeterFTPEntryParser(FTPClientConfig config) {
        super(REGEX);
        this.configure(config);
    }

    @Override
    protected FTPClientConfig getDefaultConfiguration() {
        return new FTPClientConfig("UNIX", DEFAULT_DATE_FORMAT, DEFAULT_RECENT_DATE_FORMAT);
    }

    @Override
    public FTPFile parseFTPEntry(String entry) {
        FTPFile file = new FTPFile();
        file.setRawListing(entry);
        boolean isDevice = false;
        if (this.matches(entry)) {
            int type2;
            String typeStr = this.group(1);
            String hardLinkCount = "0";
            String filesize = this.group(20);
            String datestr = this.group(21) + " " + this.group(22);
            String name2 = this.group(23);
            String endtoken = this.group(24);
            try {
                file.setTimestamp(super.parseTimestamp(datestr));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            switch (typeStr.charAt(0)) {
                case 'd': {
                    type2 = 1;
                    break;
                }
                case 'e': {
                    type2 = 2;
                    break;
                }
                case 'l': {
                    type2 = 2;
                    break;
                }
                case 'b': 
                case 'c': {
                    isDevice = true;
                    type2 = 0;
                    break;
                }
                case '-': 
                case 'f': {
                    type2 = 0;
                    break;
                }
                default: {
                    type2 = 3;
                }
            }
            file.setType(type2);
            int g = 4;
            int access2 = 0;
            while (access2 < 3) {
                file.setPermission(access2, 0, !this.group(g).equals("-"));
                file.setPermission(access2, 1, !this.group(g + 1).equals("-"));
                String execPerm = this.group(g + 2);
                file.setPermission(access2, 2, !execPerm.equals("-") && !Character.isUpperCase(execPerm.charAt(0)));
                ++access2;
                g += 4;
            }
            if (!isDevice) {
                try {
                    file.setHardLinkCount(Integer.parseInt("0"));
                }
                catch (NumberFormatException access2) {
                    // empty catch block
                }
            }
            file.setUser(null);
            file.setGroup(null);
            try {
                file.setSize(Long.parseLong(filesize));
            }
            catch (NumberFormatException access2) {
                // empty catch block
            }
            if (null == endtoken) {
                file.setName(name2);
            } else {
                name2 = name2 + endtoken;
                if (type2 == 2) {
                    int end = name2.indexOf(" -> ");
                    if (end == -1) {
                        file.setName(name2);
                    } else {
                        file.setName(name2.substring(0, end));
                        file.setLink(name2.substring(end + 4));
                    }
                } else {
                    file.setName(name2);
                }
            }
            return file;
        }
        return null;
    }
}

