/*
 * Decompiled with CFR 0.152.
 */
package at.hannibal2.skyhanni.api.minecraftevents;

import at.hannibal2.skyhanni.api.minecraftevents.RenderLayer;
import at.hannibal2.skyhanni.data.GlobalRender;
import at.hannibal2.skyhanni.events.GuiKeyPressEvent;
import at.hannibal2.skyhanni.events.minecraft.SkyHanniRenderWorldEvent;
import at.hannibal2.skyhanni.events.render.BlockOverlayRenderEvent;
import at.hannibal2.skyhanni.events.render.OverlayType;
import at.hannibal2.skyhanni.events.render.gui.DrawBackgroundEvent;
import at.hannibal2.skyhanni.events.render.gui.GameOverlayRenderPostEvent;
import at.hannibal2.skyhanni.events.render.gui.GameOverlayRenderPreEvent;
import at.hannibal2.skyhanni.events.render.gui.GuiActionPerformedEvent;
import at.hannibal2.skyhanni.events.render.gui.GuiMouseInputEvent;
import at.hannibal2.skyhanni.events.render.gui.GuiScreenOpenEvent;
import at.hannibal2.skyhanni.events.render.gui.InitializeGuiEvent;
import at.hannibal2.skyhanni.events.render.gui.RenderingTickEvent;
import at.hannibal2.skyhanni.events.render.gui.ScreenDrawnEvent;
import at.hannibal2.skyhanni.utils.compat.DrawContext;
import at.hannibal2.skyhanni.utils.compat.MinecraftCompat;
import at.hannibal2.skyhanni.utils.compat.WorldRenderContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0015H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001bH\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u001eH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020!H\u0007\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010%\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020$H\u0007\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010(\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020'H\u0007\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010+\u001a\u00020*H\u0002\u00a2\u0006\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Lat/hannibal2/skyhanni/api/minecraftevents/RenderEvents;", "", "<init>", "()V", "Lnet/minecraftforge/client/event/RenderWorldLastEvent;", "event", "", "onRenderWorld", "(Lnet/minecraftforge/client/event/RenderWorldLastEvent;)V", "Lnet/minecraftforge/client/event/GuiScreenEvent$DrawScreenEvent$Post;", "onGuiRender", "(Lnet/minecraftforge/client/event/GuiScreenEvent$DrawScreenEvent$Post;)V", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$RenderTickEvent;", "onPostRenderTick", "(Lnet/minecraftforge/fml/common/gameevent/TickEvent$RenderTickEvent;)V", "Lnet/minecraftforge/client/event/RenderGameOverlayEvent$Pre;", "onRenderOverlayPre", "(Lnet/minecraftforge/client/event/RenderGameOverlayEvent$Pre;)V", "Lnet/minecraftforge/client/event/RenderGameOverlayEvent$Post;", "onRenderOverlayPost", "(Lnet/minecraftforge/client/event/RenderGameOverlayEvent$Post;)V", "Lnet/minecraftforge/client/event/GuiOpenEvent;", "onGuiOpen", "(Lnet/minecraftforge/client/event/GuiOpenEvent;)V", "Lnet/minecraftforge/client/event/GuiScreenEvent$KeyboardInputEvent$Pre;", "onGuiScreenKeybind", "(Lnet/minecraftforge/client/event/GuiScreenEvent$KeyboardInputEvent$Pre;)V", "Lnet/minecraftforge/client/event/GuiScreenEvent$MouseInputEvent$Pre;", "onMouseInput", "(Lnet/minecraftforge/client/event/GuiScreenEvent$MouseInputEvent$Pre;)V", "Lnet/minecraftforge/client/event/RenderBlockOverlayEvent;", "onRenderBlockOverlay", "(Lnet/minecraftforge/client/event/RenderBlockOverlayEvent;)V", "Lnet/minecraftforge/client/event/GuiScreenEvent$BackgroundDrawnEvent;", "onBackgroundDraw", "(Lnet/minecraftforge/client/event/GuiScreenEvent$BackgroundDrawnEvent;)V", "Lnet/minecraftforge/client/event/GuiScreenEvent$ActionPerformedEvent$Post;", "onGuiAction", "(Lnet/minecraftforge/client/event/GuiScreenEvent$ActionPerformedEvent$Post;)V", "Lnet/minecraftforge/client/event/GuiScreenEvent$InitGuiEvent$Post;", "onGuiInitPost", "(Lnet/minecraftforge/client/event/GuiScreenEvent$InitGuiEvent$Post;)V", "", "canRender", "()Z", "1.8.9"})
public final class RenderEvents {
    @NotNull
    public static final RenderEvents INSTANCE = new RenderEvents();

    private RenderEvents() {
    }

    @SubscribeEvent
    public final void onRenderWorld(@NotNull RenderWorldLastEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (GlobalRender.INSTANCE.getRenderDisabled()) {
            return;
        }
        if (!this.canRender()) {
            return;
        }
        new SkyHanniRenderWorldEvent(new WorldRenderContext(), event.partialTicks).post();
    }

    @SubscribeEvent
    public final void onGuiRender(@NotNull GuiScreenEvent.DrawScreenEvent.Post event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.canRender()) {
            return;
        }
        new ScreenDrawnEvent(new DrawContext(), event.gui).post();
    }

    @SubscribeEvent
    public final void onPostRenderTick(@NotNull TickEvent.RenderTickEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.canRender()) {
            return;
        }
        new RenderingTickEvent(new DrawContext(), event.phase == TickEvent.Phase.START).post();
    }

    @SubscribeEvent
    public final void onRenderOverlayPre(@NotNull RenderGameOverlayEvent.Pre event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.canRender()) {
            return;
        }
        DrawContext drawContext = new DrawContext();
        RenderGameOverlayEvent.ElementType elementType = event.type;
        Intrinsics.checkNotNullExpressionValue(elementType, "type");
        if (new GameOverlayRenderPreEvent(drawContext, RenderLayer.Companion.fromForge(elementType)).post()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public final void onRenderOverlayPost(@NotNull RenderGameOverlayEvent.Post event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.canRender()) {
            return;
        }
        DrawContext drawContext = new DrawContext();
        RenderGameOverlayEvent.ElementType elementType = event.type;
        Intrinsics.checkNotNullExpressionValue(elementType, "type");
        new GameOverlayRenderPostEvent(drawContext, RenderLayer.Companion.fromForge(elementType)).post();
    }

    @SubscribeEvent
    public final void onGuiOpen(@NotNull GuiOpenEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        new GuiScreenOpenEvent(event.gui).post();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public final void onGuiScreenKeybind(@NotNull GuiScreenEvent.KeyboardInputEvent.Pre event) {
        Intrinsics.checkNotNullParameter(event, "event");
        GuiScreen guiScreen = event.gui;
        GuiContainer guiContainer = guiScreen instanceof GuiContainer ? (GuiContainer)guiScreen : null;
        if (guiContainer == null) {
            return;
        }
        GuiContainer guiScreen2 = guiContainer;
        if (new GuiKeyPressEvent(guiScreen2).post()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public final void onMouseInput(@NotNull GuiScreenEvent.MouseInputEvent.Pre event) {
        Intrinsics.checkNotNullParameter(event, "event");
        GuiScreen guiScreen = event.gui;
        Intrinsics.checkNotNullExpressionValue(guiScreen, "gui");
        if (new GuiMouseInputEvent(guiScreen).post()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public final void onRenderBlockOverlay(@NotNull RenderBlockOverlayEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        RenderBlockOverlayEvent.OverlayType overlayType = event.overlayType;
        Intrinsics.checkNotNullExpressionValue(overlayType, "overlayType");
        if (new BlockOverlayRenderEvent(OverlayType.Companion.fromForge(overlayType)).post()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public final void onBackgroundDraw(@NotNull GuiScreenEvent.BackgroundDrawnEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!this.canRender()) {
            return;
        }
        new DrawBackgroundEvent(new DrawContext()).post();
    }

    @SubscribeEvent
    public final void onGuiAction(@NotNull GuiScreenEvent.ActionPerformedEvent.Post event) {
        Intrinsics.checkNotNullParameter(event, "event");
        GuiScreen guiScreen = event.gui;
        GuiButton guiButton = event.button;
        Intrinsics.checkNotNullExpressionValue(guiButton, "button");
        new GuiActionPerformedEvent(guiScreen, guiButton).post();
    }

    @SubscribeEvent
    public final void onGuiInitPost(@NotNull GuiScreenEvent.InitGuiEvent.Post event) {
        Intrinsics.checkNotNullParameter(event, "event");
        GuiScreen guiScreen = event.gui;
        Intrinsics.checkNotNullExpressionValue(guiScreen, "gui");
        List list = event.buttonList;
        Intrinsics.checkNotNullExpressionValue(list, "buttonList");
        new InitializeGuiEvent(guiScreen, list).post();
    }

    private final boolean canRender() {
        return MinecraftCompat.INSTANCE.getLocalWorldExists() && MinecraftCompat.INSTANCE.getLocalPlayerExists();
    }
}

