/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.screen.render.overlay.metrics;

import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.hooks.MinecraftHook;
import club.sk1er.patcher.hooks.MinecraftServerHook;
import club.sk1er.patcher.screen.render.overlay.metrics.MetricsData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MetricsRenderer
extends Gui {
    private final Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void draw(RenderGameOverlayEvent.Post event) {
        RenderGameOverlayEvent.ElementType type = event.type;
        ScaledResolution res = event.resolution;
        if (PatcherConfig.useVanillaMetricsRenderer && type == RenderGameOverlayEvent.ElementType.DEBUG && this.mc.field_71474_y.field_181657_aC && this.mc.field_71474_y.field_74330_P) {
            int width = res.func_78326_a();
            this.drawMetricsData(res, this.mc.field_71466_p, MinecraftHook.metricsData, 0, width >> 1, true);
            if (this.mc.func_71401_C() != null) {
                this.drawMetricsData(res, this.mc.field_71466_p, MinecraftServerHook.metricsData, width - Math.min(width >> 1, 240), width >> 1, false);
            }
        }
    }

    public void drawMetricsData(ScaledResolution resolution, FontRenderer fontRenderer, MetricsData data, int x, int width, boolean showFps) {
        int startIndex = data.getStartIndex();
        int writeIndex = data.getWriteIndex();
        long[] samples = data.getSamples();
        int maxSamples = Math.max(0, samples.length - width);
        int sampleAverage = samples.length - maxSamples;
        int modifiedX = x;
        int startWrap = data.wrapIndex(startIndex + maxSamples);
        long o = 0L;
        int maxValue = Integer.MAX_VALUE;
        int minValue = Integer.MIN_VALUE;
        for (int sampleLength = 0; sampleLength < sampleAverage; ++sampleLength) {
            int wrappedIndex = (int)(samples[data.wrapIndex(startWrap + sampleLength)] / 1000000L);
            maxValue = Math.min(maxValue, wrappedIndex);
            minValue = Math.max(minValue, wrappedIndex);
            o += (long)wrappedIndex;
        }
        int scaledHeight = resolution.func_78328_b();
        MetricsRenderer.func_73734_a((int)x, (int)(scaledHeight - 60), (int)(x + sampleAverage), (int)scaledHeight, (int)-1873784752);
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer renderer = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)771, (int)0);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        while (startWrap != writeIndex) {
            int valuePosition = data.scaleSampleTo(samples[startWrap], showFps ? 30 : 60, showFps ? 60 : 20);
            int colorValue = showFps ? 100 : 60;
            int lineColor = this.getMetricsLineColor(MathHelper.func_76125_a((int)valuePosition, (int)0, (int)colorValue), colorValue / 2, colorValue);
            int alpha = lineColor >> 24 & 0xFF;
            int red = lineColor >> 16 & 0xFF;
            int green = lineColor >> 8 & 0xFF;
            int blue = lineColor & 0xFF;
            renderer.func_181662_b((double)(modifiedX + 1), (double)scaledHeight, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
            renderer.func_181662_b((double)(modifiedX + 1), (double)(scaledHeight - valuePosition + 1), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
            renderer.func_181662_b((double)modifiedX, (double)(scaledHeight - valuePosition + 1), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
            renderer.func_181662_b((double)modifiedX, (double)scaledHeight, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
            ++modifiedX;
            startWrap = data.wrapIndex(startWrap + 1);
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        if (showFps) {
            MetricsRenderer.func_73734_a((int)(x + 1), (int)(scaledHeight - 30 + 1), (int)(x + 14), (int)(scaledHeight - 30 + 10), (int)-1873784752);
            fontRenderer.func_78276_b("60 FPS", x + 2, scaledHeight - 30 + 2, 0xE0E0E0);
            this.func_73730_a(x, x + sampleAverage - 1, scaledHeight - 30, -1);
            MetricsRenderer.func_73734_a((int)(x + 1), (int)(scaledHeight - 60 + 1), (int)(x + 14), (int)(scaledHeight - 60 + 10), (int)-1873784752);
            fontRenderer.func_78276_b("30 FPS", x + 2, scaledHeight - 60 + 2, 0xE0E0E0);
        } else {
            MetricsRenderer.func_73734_a((int)(x + 1), (int)(scaledHeight - 60 + 1), (int)(x + 14), (int)(scaledHeight - 60 + 10), (int)-1873784752);
            fontRenderer.func_78276_b("20 TPS", x + 2, scaledHeight - 60 + 2, 0xE0E0E0);
        }
        this.func_73730_a(x, x + sampleAverage - 1, scaledHeight - 60, -1);
        this.func_73730_a(x, x + sampleAverage - 1, scaledHeight - 1, -1);
        this.func_73728_b(x, scaledHeight - 60, scaledHeight, -1);
        this.func_73728_b(x + sampleAverage - 1, scaledHeight - 60, scaledHeight, -1);
        if (showFps && this.mc.field_71474_y.field_74350_i > 0 && this.mc.field_71474_y.field_74350_i <= 250) {
            this.func_73730_a(x, x + sampleAverage - 1, scaledHeight - 1 - 1800 / this.mc.field_71474_y.field_74350_i, -16711681);
        }
        String minMs = maxValue + " ms min";
        String msAvg = o / (long)sampleAverage + " ms avg";
        String msMax = minValue + " ms max";
        int textHeight = scaledHeight - 60 - 9;
        fontRenderer.func_175063_a(minMs, (float)(x + 2), (float)textHeight, 0xE0E0E0);
        fontRenderer.func_175063_a(msAvg, (float)(x + (sampleAverage >> 1) - (fontRenderer.func_78256_a(msAvg) >> 1)), (float)textHeight, 0xE0E0E0);
        fontRenderer.func_175063_a(msMax, (float)(x + sampleAverage - fontRenderer.func_78256_a(msMax)), (float)textHeight, 0xE0E0E0);
        GlStateManager.func_179126_j();
    }

    private int getMetricsLineColor(int value, int yellowValue, int redValue) {
        return value < yellowValue ? this.interpolateColor(-16711936, -256, (float)value / (float)yellowValue) : this.interpolateColor(-256, -65536, (float)(value - yellowValue) / (float)(redValue - yellowValue));
    }

    private int interpolateColor(int minColor, int maxColor, float delta) {
        int minAlpha = minColor >> 24 & 0xFF;
        int minRed = minColor >> 16 & 0xFF;
        int minGreen = minColor >> 8 & 0xFF;
        int minBlue = minColor & 0xFF;
        int maxAlpha = maxColor >> 24 & 0xFF;
        int maxRed = maxColor >> 16 & 0xFF;
        int maxGreen = maxColor >> 8 & 0xFF;
        int maxBlue = maxColor & 0xFF;
        int clampAlpha = MathHelper.func_76125_a((int)((int)this.lerp(delta, minAlpha, maxAlpha)), (int)0, (int)255);
        int clampRed = MathHelper.func_76125_a((int)((int)this.lerp(delta, minRed, maxRed)), (int)0, (int)255);
        int clampGreen = MathHelper.func_76125_a((int)((int)this.lerp(delta, minGreen, maxGreen)), (int)0, (int)255);
        int clampBlue = MathHelper.func_76125_a((int)((int)this.lerp(delta, minBlue, maxBlue)), (int)0, (int)255);
        return clampAlpha << 24 | clampRed << 16 | clampGreen << 8 | clampBlue;
    }

    private float lerp(float delta, float start, float end) {
        return start + delta * (end - start);
    }
}

