/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.utils.tictactoe;

import gg.skytils.skytilsmod.utils.tictactoe.Board;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J7\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ7\u0010\r\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\r\u0010\fJ7\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000e\u0010\fJ\u001f\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0013J'\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0012\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lgg/skytils/skytilsmod/utils/tictactoe/AlphaBetaAdvanced;", "", "Lgg/skytils/skytilsmod/utils/tictactoe/Board$State;", "player", "Lgg/skytils/skytilsmod/utils/tictactoe/Board;", "board", "", "alpha", "beta", "", "currentPly", "alphaBetaPruning", "(Lgg/skytils/skytilsmod/utils/tictactoe/Board$State;Lgg/skytils/skytilsmod/utils/tictactoe/Board;DDI)I", "getMax", "getMin", "ply", "run", "(Lgg/skytils/skytilsmod/utils/tictactoe/Board;D)I", "maxPly", "(Lgg/skytils/skytilsmod/utils/tictactoe/Board$State;Lgg/skytils/skytilsmod/utils/tictactoe/Board;D)I", "score", "(Lgg/skytils/skytilsmod/utils/tictactoe/Board$State;Lgg/skytils/skytilsmod/utils/tictactoe/Board;I)I", "D", "<init>", "()V", "SkytilsMod"})
@SourceDebugExtension(value={"SMAP\nAlphaBetaAdvanced.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlphaBetaAdvanced.kt\ngg/skytils/skytilsmod/utils/tictactoe/AlphaBetaAdvanced\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1#2:163\n*E\n"})
public final class AlphaBetaAdvanced {
    @NotNull
    public static final AlphaBetaAdvanced INSTANCE = new AlphaBetaAdvanced();
    private static double maxPly;

    private AlphaBetaAdvanced() {
    }

    public final int run(@NotNull Board board, double ply) {
        Intrinsics.checkNotNullParameter(board, "board");
        return this.run(board.getTurn(), board, ply);
    }

    public static /* synthetic */ int run$default(AlphaBetaAdvanced alphaBetaAdvanced, Board board, double d, int n, Object object) {
        if ((n & 2) != 0) {
            d = Double.POSITIVE_INFINITY;
        }
        return alphaBetaAdvanced.run(board, d);
    }

    private final int run(Board.State player, Board board, double maxPly) {
        if (!(maxPly >= 1.0)) {
            boolean bl = false;
            String string = "Maximum depth must be greater than 0.";
            throw new IllegalArgumentException(string.toString());
        }
        AlphaBetaAdvanced.maxPly = maxPly;
        return this.alphaBetaPruning(player, board, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 0);
    }

    private final int alphaBetaPruning(Board.State player, Board board, double alpha, double beta, int currentPly) {
        int cp = currentPly;
        if ((double)cp++ == maxPly || board.isGameOver()) {
            return this.score(player, board, cp);
        }
        return board.getTurn() == player ? this.getMax(player, board, alpha, beta, cp) : this.getMin(player, board, alpha, beta, cp);
    }

    private final int getMax(Board.State player, Board board, double alpha, double beta, int currentPly) {
        double a = alpha;
        int indexOfBestMove = -1;
        for (Integer theMove : board.getAvailableMoves()) {
            Board modifiedBoard = board.getDeepCopy();
            Intrinsics.checkNotNull(theMove);
            modifiedBoard.move(theMove);
            int score = this.alphaBetaPruning(player, modifiedBoard, a, beta, currentPly);
            if ((double)score > a) {
                a = score;
                indexOfBestMove = theMove;
            }
            if (!(a >= beta)) continue;
        }
        if (indexOfBestMove != -1) {
            board.setAlgorithmBestMove(indexOfBestMove);
        }
        return (int)a;
    }

    private final int getMin(Board.State player, Board board, double alpha, double beta, int currentPly) {
        double b = beta;
        int indexOfBestMove = -1;
        for (Integer theMove : board.getAvailableMoves()) {
            Board modifiedBoard = board.getDeepCopy();
            Intrinsics.checkNotNull(theMove);
            modifiedBoard.move(theMove);
            int score = this.alphaBetaPruning(player, modifiedBoard, alpha, b, currentPly);
            if ((double)score < b) {
                b = score;
                indexOfBestMove = theMove;
            }
            if (!(alpha >= b)) continue;
        }
        if (indexOfBestMove != -1) {
            board.setAlgorithmBestMove(indexOfBestMove);
        }
        return (int)b;
    }

    private final int score(Board.State player, Board board, int currentPly) {
        Board.State opponent;
        if (!(player != Board.State.Blank)) {
            boolean bl = false;
            String string = "Player must be X or O.";
            throw new IllegalArgumentException(string.toString());
        }
        Board.State state = opponent = player == Board.State.X ? Board.State.O : Board.State.X;
        return board.isGameOver() && board.getWinner() == player ? 10 - currentPly : (board.isGameOver() && board.getWinner() == opponent ? -10 + currentPly : 0);
    }
}

