/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.utils.graphics.colors;

import gg.skytils.ktx-serialization.KSerializer;
import gg.skytils.ktx-serialization.descriptors.PrimitiveKind;
import gg.skytils.ktx-serialization.descriptors.SerialDescriptor;
import gg.skytils.ktx-serialization.descriptors.SerialDescriptorsKt;
import gg.skytils.ktx-serialization.encoding.Decoder;
import gg.skytils.ktx-serialization.encoding.Encoder;
import gg.skytils.skytilsmod.utils.MathUtil;
import gg.skytils.skytilsmod.utils.Utils;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.minecraft.client.renderer.GlStateManager;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0018\b\u0016\u0018\u0000 +2\u00020\u0001:\u0003+,-B+\b\u0017\u0012\u0006\u0010#\u001a\u00020\f\u0012\u0006\u0010 \u001a\u00020\f\u0012\u0006\u0010\u001d\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b&\u0010'B!\b\u0016\u0012\u0006\u0010#\u001a\u00020\t\u0012\u0006\u0010 \u001a\u00020\t\u0012\u0006\u0010\u001d\u001a\u00020\t\u00a2\u0006\u0004\b&\u0010(B\t\b\u0016\u00a2\u0006\u0004\b&\u0010\u0004B\u0011\b\u0016\u0012\u0006\u0010)\u001a\u00020\u0000\u00a2\u0006\u0004\b&\u0010*J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000e\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u000bJ\u0015\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t\u00a2\u0006\u0004\b\u0013\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\"\u0010\r\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u000e\u0010\u001cR\"\u0010\u001d\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u0019\u001a\u0004\b\u001e\u0010\u001b\"\u0004\b\u001f\u0010\u001cR\"\u0010 \u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010\u0019\u001a\u0004\b!\u0010\u001b\"\u0004\b\"\u0010\u001cR\"\u0010#\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b#\u0010\u0019\u001a\u0004\b$\u0010\u001b\"\u0004\b%\u0010\u001c\u00a8\u0006."}, d2={"Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;", "", "", "applyColor", "()V", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "a", "setA", "(F)Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;", "", "toHSV", "()[F", "toInt", "alpha", "(I)I", "", "toString", "()Ljava/lang/String;", "F", "getA", "()F", "(F)V", "b", "getB", "setB", "g", "getG", "setG", "r", "getR", "setR", "<init>", "(FFFF)V", "(III)V", "c", "(Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;)V", "Companion", "Serializer", "SetBase", "SkytilsMod"})
public class CustomColor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float r;
    private float g;
    private float b;
    private float a;

    public final float getR() {
        return this.r;
    }

    public final void setR(float f) {
        this.r = f;
    }

    public final float getG() {
        return this.g;
    }

    public final void setG(float f) {
        this.g = f;
    }

    public final float getB() {
        return this.b;
    }

    public final void setB(float f) {
        this.b = f;
    }

    public final float getA() {
        return this.a;
    }

    public final void setA(float f) {
        this.a = f;
    }

    @JvmOverloads
    public CustomColor(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public /* synthetic */ CustomColor(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        this(f, f2, f3, f4);
    }

    public CustomColor(int r, int g, int b) {
        this.r = (float)r / 255.0f;
        this.g = (float)g / 255.0f;
        this.b = (float)b / 255.0f;
        this.a = 1.0f;
    }

    public CustomColor() {
    }

    public CustomColor(@NotNull CustomColor c) {
        Intrinsics.checkNotNullParameter(c, "c");
        this(c.r, c.g, c.b, c.a);
    }

    public void applyColor() {
        GlStateManager.func_179131_c((float)this.r, (float)this.g, (float)this.b, (float)this.a);
    }

    @NotNull
    public CustomColor setA(float a) {
        this.a = a;
        return this;
    }

    @NotNull
    public float[] toHSV() {
        float hue = 0.0f;
        float saturation = 0.0f;
        float value = 0.0f;
        float cmax = RangesKt.coerceAtLeast(RangesKt.coerceAtLeast(this.r, this.g), this.b);
        float cmin = RangesKt.coerceAtMost(RangesKt.coerceAtMost(this.r, this.g), this.b);
        value = cmax;
        saturation = cmax == 0.0f ? 0.0f : (cmax - cmin) / cmax;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (cmax - this.r) / (cmax - cmin);
            float greenc = (cmax - this.g) / (cmax - cmin);
            float bluec = (cmax - this.b) / (cmax - cmin);
            hue = this.r == cmax ? bluec - greenc : (this.g == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        float[] fArray = new float[]{hue, saturation, value, this.a};
        return fArray;
    }

    public int toInt() {
        int r = (int)(RangesKt.coerceAtMost(this.r, 1.0f) * (float)255);
        int g = (int)(RangesKt.coerceAtMost(this.g, 1.0f) * (float)255);
        int b = (int)(RangesKt.coerceAtMost(this.b, 1.0f) * (float)255);
        int a = (int)(RangesKt.coerceAtMost(this.a, 1.0f) * (float)255);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public final int toInt(int alpha) {
        int r = (int)(RangesKt.coerceAtMost(this.r, 1.0f) * (float)255);
        int g = (int)(RangesKt.coerceAtMost(this.g, 1.0f) * (float)255);
        int b = (int)(RangesKt.coerceAtMost(this.b, 1.0f) * (float)255);
        int a = RangesKt.coerceAtMost(alpha, 255);
        return a << 24 | r << 16 | g << 8 | b;
    }

    @NotNull
    public String toString() {
        return "rgba(" + (int)(this.r * (float)255) + ',' + (int)(this.g * (float)255) + ',' + (int)(this.b * (float)255) + ',' + (int)(this.a * (float)255) + ')';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof CustomColor) {
            return this.r == ((CustomColor)other).r && this.g == ((CustomColor)other).g && this.b == ((CustomColor)other).b && this.a == ((CustomColor)other).a;
        }
        return false;
    }

    public int hashCode() {
        float[] fArray = new float[]{this.r, this.g, this.b, this.a};
        return Arrays.hashCode(fArray);
    }

    @JvmOverloads
    public CustomColor(float r, float g, float b) {
        this(r, g, b, 0.0f, 8, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ-\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ1\u0010\b\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\b\b\u0002\u0010\u0006\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\b\u0010\u000bJ-\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\n\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\n\u00a2\u0006\u0004\b\u0013\u0010\u0016J\u001f\u0010\u0019\u001a\u00020\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0006\u001a\u00020\n\u00a2\u0006\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor$Companion;", "", "", "r", "g", "b", "a", "Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;", "fromBytes", "(BBBB)Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;", "", "(BBBF)Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;", "h", "s", "v", "fromHSV", "(FFFF)Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;", "", "argb", "fromInt", "(I)Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;", "rgb", "(IF)Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;", "", "string", "fromString", "(Ljava/lang/String;F)Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;", "<init>", "()V", "SkytilsMod"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CustomColor fromString(@Nullable String string, float a) {
            if (string == null) {
                return new CustomColor(0.0f, 0.0f, 0.0f, a);
            }
            String withoutHash = ((Object)StringsKt.trim((CharSequence)string)).toString();
            if (StringsKt.startsWith$default(withoutHash, "#", false, 2, null)) {
                String string2 = withoutHash.substring(1);
                Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
                withoutHash = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            }
            if (Intrinsics.areEqual(withoutHash, "")) {
                return new CustomColor(0.0f, 0.0f, 0.0f, a);
            }
            switch (withoutHash.length()) {
                case 6: {
                    try {
                        return this.fromInt(Integer.parseInt(withoutHash, CharsKt.checkRadix(16)), a);
                    }
                    catch (Exception exception) {
                        break;
                    }
                }
                case 3: {
                    try {
                        int rgb = Integer.parseInt(withoutHash, CharsKt.checkRadix(16));
                        int r = (rgb >> 8 & 0xF) * 17;
                        int g = (rgb >> 4 & 0xF) * 17;
                        int b = (rgb & 0xF) * 17;
                        return this.fromBytes((byte)r, (byte)g, (byte)b, a);
                    }
                    catch (Exception rgb) {
                        break;
                    }
                }
                case 2: {
                    try {
                        byte v = (byte)Integer.parseInt(withoutHash, CharsKt.checkRadix(16));
                        return this.fromBytes(v, v, v, a);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            byte[] hash = DigestUtils.sha1((String)string);
            return this.fromBytes(hash[0], hash[1], hash[2], a);
        }

        @NotNull
        public final CustomColor fromHSV(float h, float s, float v, float a) {
            CustomColor customColor;
            float s1 = s;
            float v4 = v;
            float a1 = a;
            a1 = RangesKt.coerceIn(a1, 0.0f, 1.0f);
            if (v4 <= 0.0f) {
                return new CustomColor(0.0f, 0.0f, 0.0f, a1);
            }
            if (v4 > 1.0f) {
                v4 = 1.0f;
            }
            if (s1 <= 0.0f) {
                return new CustomColor(v4, v4, v4, a1);
            }
            if (s1 > 1.0f) {
                s1 = 1.0f;
            }
            float vh = (h % 1.0f + 1.0f) * (float)6 % (float)6;
            int vi = MathUtil.INSTANCE.fastFloor(vh);
            float v1 = v4 * (1.0f - s1);
            float v2 = v4 * (1.0f - s1 * (vh - (float)vi));
            float v3 = v4 * (1.0f - s1 * (1.0f - (vh - (float)vi)));
            switch (vi) {
                case 0: {
                    customColor = new CustomColor(v4, v3, v1, a1);
                    break;
                }
                case 1: {
                    customColor = new CustomColor(v2, v4, v1, a1);
                    break;
                }
                case 2: {
                    customColor = new CustomColor(v1, v4, v3, a1);
                    break;
                }
                case 3: {
                    customColor = new CustomColor(v1, v2, v4, a1);
                    break;
                }
                case 4: {
                    customColor = new CustomColor(v3, v1, v4, a1);
                    break;
                }
                default: {
                    customColor = new CustomColor(v4, v1, v2, a1);
                }
            }
            return customColor;
        }

        @NotNull
        public final CustomColor fromInt(int argb) {
            return this.fromInt(argb & 0xFFFFFF, (float)(argb >>> 24 & 0xFF) / 255.0f);
        }

        @NotNull
        public final CustomColor fromInt(int rgb, float a) {
            return this.fromBytes((byte)(rgb >>> 16), (byte)(rgb >>> 8), (byte)rgb, a);
        }

        @NotNull
        public final CustomColor fromBytes(byte r, byte g, byte b, byte a) {
            return this.fromBytes(r, g, b, (float)Byte.toUnsignedInt(a) / 255.0f);
        }

        @JvmOverloads
        @NotNull
        public final CustomColor fromBytes(byte r, byte g, byte b, float a) {
            return new CustomColor((float)Byte.toUnsignedInt(r) / 255.0f, (float)Byte.toUnsignedInt(g) / 255.0f, (float)Byte.toUnsignedInt(b) / 255.0f, a);
        }

        public static /* synthetic */ CustomColor fromBytes$default(Companion companion, byte by, byte by2, byte by3, float f, int n, Object object) {
            if ((n & 8) != 0) {
                f = 0.0f;
            }
            return companion.fromBytes(by, by2, by3, f);
        }

        @JvmOverloads
        @NotNull
        public final CustomColor fromBytes(byte r, byte g, byte b) {
            return gg.skytils.skytilsmod.utils.graphics.colors.CustomColor$Companion.fromBytes$default(this, r, g, b, 0.0f, 8, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u000e\u001a\u00020\r8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor$Serializer;", "Lgg/skytils/ktx-serialization/KSerializer;", "Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;", "Lgg/skytils/ktx-serialization/encoding/Decoder;", "decoder", "deserialize", "(Lgg/skytils/ktx-serialization/encoding/Decoder;)Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;", "Lgg/skytils/ktx-serialization/encoding/Encoder;", "encoder", "value", "", "serialize", "(Lgg/skytils/ktx-serialization/encoding/Encoder;Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;)V", "Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;", "descriptor", "Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "<init>", "()V", "SkytilsMod"})
    public static final class Serializer
    implements KSerializer<CustomColor> {
        @NotNull
        public static final Serializer INSTANCE = new Serializer();
        @NotNull
        private static final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor("CustomColor", PrimitiveKind.STRING.INSTANCE);

        private Serializer() {
        }

        @Override
        @NotNull
        public SerialDescriptor getDescriptor() {
            return descriptor;
        }

        @Override
        @NotNull
        public CustomColor deserialize(@NotNull Decoder decoder) {
            Intrinsics.checkNotNullParameter(decoder, "decoder");
            return Utils.INSTANCE.customColorFromString(decoder.decodeString());
        }

        @Override
        public void serialize(@NotNull Encoder encoder2, @NotNull CustomColor value) {
            Intrinsics.checkNotNullParameter(encoder2, "encoder");
            Intrinsics.checkNotNullParameter(value, "value");
            encoder2.encodeString(value.toString());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tB)\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u0002\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u0012\u0006\u0010\f\u001a\u00020\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\rJ\u0017\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000e"}, d2={"Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor$SetBase;", "Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;", "", "a", "setA", "(F)Lgg/skytils/skytilsmod/utils/graphics/colors/CustomColor;", "", "rgb", "<init>", "(I)V", "r", "g", "b", "(FFFF)V", "SkytilsMod"})
    public static class SetBase
    extends CustomColor {
        public SetBase(int rgb) {
            super((float)(rgb >> 16) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f, 1.0f);
        }

        public SetBase(float r, float g, float b, float a) {
            super(r, g, b, a);
        }

        @Override
        @NotNull
        public CustomColor setA(float a) {
            new UnsupportedOperationException("Cannot set alpha of common color").printStackTrace();
            return this;
        }
    }
}

