/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.tweaker;

import gg.skytils.skytilsmod.tweaker.SkytilsLoadingPluginKt;
import gg.skytils.skytilsmod.tweaker.TweakerUtil;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.swing.JButton;
import kotlin.KotlinVersion;
import kotlin.text.StringsKt;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;

@IFMLLoadingPlugin.Name(value="Skytils On Top")
@IFMLLoadingPlugin.SortingIndex(value=69)
public class SkytilsLoadingPlugin
implements IFMLLoadingPlugin {
    public static final String missingDependency = "<html><p>Skytils has detected a possible missing dependency<br>The most likely reason is Essential failed to load.<br>Wait a bit, then restart your game.<br>Essential might also not work in your country.<br>Check the Skytils Discord for any announcements, and<br>if there are none, ask for support.</p></html>";
    public static final String kotlinErrorMessage = "<html><p>Skytils has detected a mod with an older version of Kotlin.<br>In order to resolve this conflict you must<br>delete the outdated mods.<br>You can also try to rename Skytils to be above other mods alphabetically<br>by changing Skytils.jar to !Skytils.jar<br>If you have already done this and are still getting this error,<br>or need assistance, ask for support in the Discord.";
    public static final String badMixinVersionMessage = "<html><p>Skytils has detected an older version of Mixin.<br>Many of my features require Mixin 0.8 or later!<br>In order to resolve this conflict you must remove<br>any mods with a Mixin version below 0.8.<br>You can also try to rename Skytils to be above other mods alphabetically<br>by changing Skytils.jar to !Skytils.jar<br>If you have already done this and are still getting this error,<br>ask for support in the Discord.";
    public static final String liteloaderUserMessage = "<html><p>Skytils has detected that you are using LiteLoader.<br>LiteLoader bundles an older, incompatible version of Mixin.<br>In order to resolve this conflict you must launch<br>Minecraft without LiteLoader.<br>If you have already done this and are still getting this error,<br>ask for support in the Discord.</p></html>";
    private static final String voidChatMessage = "<html><p>Skytils has detected that you are using VoidChat.<br>VoidChat breaks many of my features!<br>In order to resolve this conflict you must remove<br>VoidChat from your Minecraft mods folder.<br>A good alternative is Patcher at https://sk1er.club/mods/Patcher.<br>If you have already done this and are still getting this error,<br>ask for support in the Discord.</p></html>";
    private static final String betterFPSMessage = "<html><p>Skytils has detected that you are using BetterFPS.<br>BetterFPS breaks my core plugins, and also breaks the game!<br>In order to resolve this conflict you must remove<br>BetterFPS from your Minecraft mods folder.<br>You probably will not notice a change in your FPS.<br>Video showcasing breaking changes: https://streamable.com/q4ip5u.<br>If you have already done this and are still getting this error,<br>ask for support in the Discord.</p></html>";
    private final SkytilsLoadingPluginKt kotlinPlugin;

    public SkytilsLoadingPlugin() throws URISyntaxException {
        if (System.getProperty("skytils.skipStartChecks") == null) {
            if (!this.checkForClass("kotlin.KotlinVersion") || !this.checkForClass("gg.essential.api.EssentialAPI")) {
                TweakerUtil.showMessage(missingDependency, new JButton[0]);
                TweakerUtil.exit();
            }
            if (!KotlinVersion.CURRENT.isAtLeast(1, 9, 0)) {
                String name;
                File file2;
                File realFile = file2 = new File(KotlinVersion.class.getProtectionDomain().getCodeSource().getLocation().toURI());
                for (int i = 0; i < 5; ++i) {
                    if (realFile == null) {
                        realFile = file2;
                        break;
                    }
                    if (realFile.getName().endsWith(".jar!") || realFile.getName().endsWith(".jar")) break;
                    realFile = realFile.getParentFile();
                }
                String string = name = realFile.getName().contains(".jar") ? realFile.getName() : StringsKt.substringAfterLast(StringsKt.substringBeforeLast(file2.getAbsolutePath(), ".jar", "unknown"), "/", "Unknown");
                if (name.endsWith("!")) {
                    name = name.substring(0, name.length() - 1);
                }
                JButton openModFolder = new JButton("Open Mod Folder");
                openModFolder.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        try {
                            Desktop.getDesktop().open(new File("./mods"));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
                if (realFile.getParentFile().getName().equals("essential") && name.contains("Essential")) {
                    JButton watchVideo = new JButton("Open Tutorial Video");
                    watchVideo.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            try {
                                Desktop.getDesktop().browse(URI.create("https://l.skytils.gg/update-essential-video"));
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                        }
                    });
                    TweakerUtil.showMessage("<html><p>Skytils has detected a mod with an older version of Kotlin.<br>In order to resolve this conflict you must<br>delete the outdated mods.<br>You can also try to rename Skytils to be above other mods alphabetically<br>by changing Skytils.jar to !Skytils.jar<br>If you have already done this and are still getting this error,<br>or need assistance, ask for support in the Discord.<br>The culprit seems to be " + name + "<br>It bundles version " + KotlinVersion.CURRENT + "</p></html>", openModFolder, watchVideo);
                } else {
                    TweakerUtil.showMessage("<html><p>Skytils has detected a mod with an older version of Kotlin.<br>In order to resolve this conflict you must<br>delete the outdated mods.<br>You can also try to rename Skytils to be above other mods alphabetically<br>by changing Skytils.jar to !Skytils.jar<br>If you have already done this and are still getting this error,<br>or need assistance, ask for support in the Discord.<br>The culprit seems to be " + name + "<br>It bundles version " + KotlinVersion.CURRENT + "</p></html>", openModFolder);
                }
                TweakerUtil.exit();
            }
            if (this.checkForClass("com.sky.voidchat.EDFMLLoadingPlugin")) {
                TweakerUtil.showMessage(voidChatMessage, new JButton[0]);
                TweakerUtil.exit();
            }
            if (this.checkForClass("me.guichaguri.betterfps.BetterFpsHelper")) {
                TweakerUtil.showMessage(betterFPSMessage, new JButton[0]);
                TweakerUtil.exit();
            }
        }
        this.kotlinPlugin = new SkytilsLoadingPluginKt();
    }

    private boolean checkForClass(String className) {
        try {
            Class.forName(className, false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    public String[] getASMTransformerClass() {
        return this.kotlinPlugin.getASMTransformerClass();
    }

    public String getModContainerClass() {
        return this.kotlinPlugin.getModContainerClass();
    }

    public String getSetupClass() {
        return this.kotlinPlugin.getSetupClass();
    }

    public void injectData(Map<String, Object> data2) {
        this.kotlinPlugin.injectData(data2);
    }

    public String getAccessTransformerClass() {
        return this.kotlinPlugin.getAccessTransformerClass();
    }
}

