/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.tweaker;

import gg.essential.universal.UDesktop;
import gg.skytils.skytilsmod.Reference;
import gg.skytils.skytilsmod.tweaker.TweakerUtil;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JButton;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;

public class EssentialPlatformSetup {
    private static final String[] dataURLCandidates = new String[]{System.getProperty("skytils.dataURL"), Reference.dataUrl, "https://skytilsmod-data.pages.dev/", "https://cdn.jsdelivr.net/gh/Skytils/SkytilsMod-Data@main/", "https://mirror.ghproxy.com/https://raw.githubusercontent.com/Skytils/SkytilsMod-Data/main/"};

    private static boolean trySetDataUrl(String url2) {
        if (url2 == null) {
            return false;
        }
        try {
            return TweakerUtil.makeRequest(url2 + "CANYOUSEEME").contains("YOUCANSEEME");
        }
        catch (Exception e) {
            LogManager.getLogger().error("Failed to contact url " + url2);
            return false;
        }
    }

    public static void setup() {
        block30: {
            try {
                String ver = System.getProperty("java.runtime.version", "unknown");
                String javaLoc = System.getProperty("java.home");
                if (!ver.contains("1.8.0_51") && !javaLoc.contains("jre-legacy")) break block30;
                System.out.println("Minecraft is running on legacy Java 8");
                Path keyStoreLoc = Paths.get("./config/skytils/updates/files/skytilscacerts.jks", new String[0]);
                File keyStoreFile = keyStoreLoc.toFile();
                if (keyStoreFile.exists()) break block30;
                System.out.println("Skytils is attempting to run keytool.");
                Files.createDirectories(keyStoreLoc.getParent(), new FileAttribute[0]);
                try (InputStream in = EssentialPlatformSetup.class.getResourceAsStream("/skytilscacerts.jks");
                     OutputStream os = Files.newOutputStream(keyStoreLoc, new OpenOption[0]);){
                    IOUtils.copy((InputStream)Objects.requireNonNull(in), (OutputStream)os);
                }
                String os = System.getProperty("os.name", "unknown");
                Path keyStorePath = Paths.get(javaLoc, "lib", "security", "cacerts").toAbsolutePath();
                Path keyToolPath = Paths.get(javaLoc, "bin", os.toLowerCase(Locale.ENGLISH).startsWith("windows") ? "keytool.exe" : "keytool").toAbsolutePath();
                File log = new File("./config/skytils/updates/files/sslfix-" + System.currentTimeMillis() + ".log");
                new ProcessBuilder(new String[0]).command(keyToolPath.toString(), "-importkeystore", "-srckeystore", keyStoreFile.getAbsolutePath(), "-destkeystore", keyStorePath.toString(), "-srcstorepass", "skytilsontop", "-deststorepass", "changeit", "-noprompt").redirectOutput(log).redirectError(log).start().waitFor();
                System.out.println("A reboot of Minecraft is required for the code to work, force closing the game");
                TweakerUtil.exit();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        TweakerUtil.registerTransformerExclusions("kotlin.", "kotlinx.", "gg.skytils.asmhelper.", "gg.skytils.skytilsmod.tweaker.", "gg.skytils.skytilsmod.asm.");
        for (String url2 : dataURLCandidates) {
            if (!EssentialPlatformSetup.trySetDataUrl(url2)) continue;
            Reference.dataUrl = url2;
            break;
        }
        LogManager.getLogger().info("Data URL: " + Reference.dataUrl);
        try {
            if (Integer.parseInt(TweakerUtil.makeRequest(Reference.dataUrl + "api/version").trim()) > 5) {
                JButton btn = new JButton("Open Website");
                btn.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        try {
                            UDesktop.browse((URI)URI.create("https://skytils.gg"));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
                JButton openModFolder = new JButton("Open Mod Folder");
                openModFolder.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        try {
                            UDesktop.open((File)new File("./mods"));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
                TweakerUtil.showMessage("<html><p>Your version of Skytils (1.8.3) requires a<br>mandatory update before you can play!<br>Please download the latest version,<br>join the Discord for support.<br></p></html>", btn, openModFolder);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

