/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.skytilsmod.features.impl.dungeons.solvers;

import gg.essential.universal.UMatrixStack;
import gg.skytils.skytilsmod.Skytils;
import gg.skytils.skytilsmod.core.TickKt;
import gg.skytils.skytilsmod.features.impl.misc.Funny;
import gg.skytils.skytilsmod.utils.RenderUtil;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b9\u0010:J\u0015\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0019\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ!\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010JG\u0010\u0016\u001a\u0004\u0018\u00010\b2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\u0014\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00020\u00022\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0017\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJE\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0$2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b%\u0010&J\u001b\u0010)\u001a\u00020\u000b*\u00020\u00062\u0006\u0010(\u001a\u00020'H\u0002\u00a2\u0006\u0004\b)\u0010*R\u001e\u0010+\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b+\u0010,R\u0018\u0010-\u001a\u0004\u0018\u00010\u00148\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010.R\u0018\u00100\u001a\u0004\u0018\u00010/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0018\u00102\u001a\u0004\u0018\u00010\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0018\u00104\u001a\u0004\u0018\u00010\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b4\u00105R\u001c\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108\u00a8\u0006;"}, d2={"Lgg/skytils/skytilsmod/features/impl/dungeons/solvers/IcePathSolver;", "", "", "", "getGridLayout", "()[[I", "Lnet/minecraft/util/BlockPos;", "pos", "Ljava/awt/Point;", "getGridPointFromPos", "(Lnet/minecraft/util/BlockPos;)Ljava/awt/Point;", "", "column", "row", "Lnet/minecraft/util/Vec3;", "getVec3RelativeToGrid", "(II)Lnet/minecraft/util/Vec3;", "iceCave", "iceCaveColors", "currPos", "Lnet/minecraft/util/EnumFacing;", "dir", "move", "([[I[[Ljava/awt/Point;Ljava/awt/Point;Lnet/minecraft/util/EnumFacing;)Ljava/awt/Point;", "Lnet/minecraftforge/event/world/WorldEvent$Load;", "event", "", "onWorldChange", "(Lnet/minecraftforge/event/world/WorldEvent$Load;)V", "Lnet/minecraftforge/client/event/RenderWorldLastEvent;", "onWorldRender", "(Lnet/minecraftforge/client/event/RenderWorldLastEvent;)V", "startX", "startY", "endX", "endY", "Ljava/util/ArrayList;", "solve", "([[IIIII)Ljava/util/ArrayList;", "Lnet/minecraft/util/EnumFacing$Axis;", "axis", "getValueOnAxis", "(Lnet/minecraft/util/BlockPos;Lnet/minecraft/util/EnumFacing$Axis;)I", "grid", "[[I", "roomFacing", "Lnet/minecraft/util/EnumFacing;", "Lnet/minecraft/entity/monster/EntitySilverfish;", "silverfish", "Lnet/minecraft/entity/monster/EntitySilverfish;", "silverfishChestPos", "Lnet/minecraft/util/BlockPos;", "silverfishPos", "Ljava/awt/Point;", "", "steps", "Ljava/util/List;", "<init>", "()V", "SkytilsMod"})
@SourceDebugExtension(value={"SMAP\nIcePathSolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IcePathSolver.kt\ngg/skytils/skytilsmod/features/impl/dungeons/solvers/IcePathSolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,262:1\n1855#2,2:263\n*S KotlinDebug\n*F\n+ 1 IcePathSolver.kt\ngg/skytils/skytilsmod/features/impl/dungeons/solvers/IcePathSolver\n*L\n118#1:263,2\n*E\n"})
public final class IcePathSolver {
    @NotNull
    public static final IcePathSolver INSTANCE = new IcePathSolver();
    @NotNull
    private static final List<Point> steps = new ArrayList();
    @Nullable
    private static BlockPos silverfishChestPos;
    @Nullable
    private static EnumFacing roomFacing;
    @Nullable
    private static int[][] grid;
    @Nullable
    private static EntitySilverfish silverfish;
    @Nullable
    private static Point silverfishPos;

    private IcePathSolver() {
    }

    @SubscribeEvent
    public final void onWorldRender(@NotNull RenderWorldLastEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (!Skytils.Companion.getConfig().getIcePathSolver()) {
            return;
        }
        if (silverfishChestPos != null && roomFacing != null && grid != null) {
            EntitySilverfish entitySilverfish = silverfish;
            Intrinsics.checkNotNull(entitySilverfish);
            if (entitySilverfish.func_70089_S()) {
                GlStateManager.func_179129_p();
                Iterable $this$forEach$iv = CollectionsKt.zipWithNext((Iterable)steps);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    Point point = (Point)pair.component1();
                    Point point2 = (Point)pair.component2();
                    Point point3 = point;
                    Intrinsics.checkNotNull(point3);
                    Vec3 pos = INSTANCE.getVec3RelativeToGrid(point3.x, point.y);
                    Point point4 = point2;
                    Intrinsics.checkNotNull(point4);
                    Vec3 pos2 = INSTANCE.getVec3RelativeToGrid(point4.x, point2.y);
                    Vec3 vec3 = pos;
                    Intrinsics.checkNotNull(vec3);
                    Vec3 vec32 = vec3.func_72441_c(0.5, 0.5, 0.5);
                    Intrinsics.checkNotNullExpressionValue(vec32, "addVector(...)");
                    Vec3 vec33 = pos2;
                    Intrinsics.checkNotNull(vec33);
                    Vec3 vec34 = vec33.func_72441_c(0.5, 0.5, 0.5);
                    Intrinsics.checkNotNullExpressionValue(vec34, "addVector(...)");
                    RenderUtil.draw3DLine$default(RenderUtil.INSTANCE, vec32, vec34, 5, new Color(1.0f, 0.0f, 0.0f, Funny.INSTANCE.getAlphaMult()), event.partialTicks, UMatrixStack.Compat.INSTANCE.get(), 0.0f, 64, null);
                }
                GlStateManager.func_179089_o();
            }
        }
    }

    @SubscribeEvent
    public final void onWorldChange(@NotNull WorldEvent.Load event) {
        Intrinsics.checkNotNullParameter(event, "event");
        silverfishChestPos = null;
        roomFacing = null;
        grid = null;
        steps.clear();
        silverfish = null;
        silverfishPos = null;
    }

    private final Vec3 getVec3RelativeToGrid(int column, int row) {
        Vec3 vec3;
        BlockPos blockPos2 = silverfishChestPos;
        if (blockPos2 != null) {
            BlockPos chestPos = blockPos2;
            boolean bl = false;
            EnumFacing enumFacing = roomFacing;
            if (enumFacing != null) {
                EnumFacing facing = enumFacing;
                boolean bl2 = false;
                vec3 = new Vec3((Vec3i)chestPos.func_177967_a(facing.func_176734_d(), 4).func_177967_a(facing.func_176735_f(), 8).func_177967_a(facing.func_176746_e(), column).func_177967_a(facing.func_176734_d(), row));
            } else {
                vec3 = null;
            }
        } else {
            vec3 = null;
        }
        return vec3;
    }

    private final Point getGridPointFromPos(BlockPos pos) {
        if (silverfishChestPos == null || roomFacing == null) {
            return null;
        }
        BlockPos blockPos2 = silverfishChestPos;
        Intrinsics.checkNotNull(blockPos2);
        EnumFacing enumFacing = roomFacing;
        Intrinsics.checkNotNull(enumFacing);
        BlockPos blockPos3 = blockPos2.func_177967_a(enumFacing.func_176734_d(), 4);
        EnumFacing enumFacing2 = roomFacing;
        Intrinsics.checkNotNull(enumFacing2);
        BlockPos topLeft = blockPos3.func_177967_a(enumFacing2.func_176735_f(), 8);
        BlockPos diff = pos.func_177973_b((Vec3i)topLeft);
        Intrinsics.checkNotNull(diff);
        EnumFacing enumFacing3 = roomFacing;
        Intrinsics.checkNotNull(enumFacing3);
        EnumFacing.Axis axis = enumFacing3.func_176746_e().func_176740_k();
        Intrinsics.checkNotNullExpressionValue(axis, "getAxis(...)");
        int n = Math.abs(this.getValueOnAxis(diff, axis));
        EnumFacing enumFacing4 = roomFacing;
        Intrinsics.checkNotNull(enumFacing4);
        EnumFacing.Axis axis2 = enumFacing4.func_176734_d().func_176740_k();
        Intrinsics.checkNotNullExpressionValue(axis2, "getAxis(...)");
        return new Point(n, Math.abs(this.getValueOnAxis(diff, axis2)));
    }

    private final int getValueOnAxis(BlockPos $this$getValueOnAxis, EnumFacing.Axis axis) {
        int n;
        switch (WhenMappings.$EnumSwitchMapping$0[axis.ordinal()]) {
            case 1: {
                n = $this$getValueOnAxis.func_177958_n();
                break;
            }
            case 2: {
                n = $this$getValueOnAxis.func_177956_o();
                break;
            }
            case 3: {
                n = $this$getValueOnAxis.func_177952_p();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @Nullable
    public final int[][] getGridLayout() {
        if (silverfishChestPos == null || roomFacing == null) {
            return null;
        }
        int n = 0;
        int[][] nArrayArray = new int[17][];
        while (n < 17) {
            int n2 = n++;
            nArrayArray[n2] = new int[17];
        }
        int[][] grid = nArrayArray;
        for (int row = 0; row < 17; ++row) {
            for (int column = 0; column < 17; ++column) {
                grid[row][column] = Skytils.Companion.getMc().field_71441_e.func_180495_p(new BlockPos(this.getVec3RelativeToGrid(column, row))).func_177230_c() != Blocks.field_150350_a ? 1 : 0;
            }
            if (row != 16) continue;
            return grid;
        }
        return null;
    }

    private final ArrayList<Point> solve(int[][] iceCave, int startX, int startY, int endX, int endY) {
        Point startPoint = new Point(startX, startY);
        ArrayDeque<Point> queue = new ArrayDeque<Point>();
        int n = 0;
        int n2 = ((Object[])iceCave).length;
        Point[][] pointArray = new Point[n2][];
        while (n < n2) {
            int n3 = n++;
            pointArray[n3] = new Point[iceCave[0].length];
        }
        Point[][] iceCaveColors = pointArray;
        queue.addLast(new Point(startX, startY));
        iceCaveColors[startY][startX] = startPoint;
        while (queue.size() != 0) {
            Point currPos = (Point)queue.removeFirst();
            Intrinsics.checkNotNullExpressionValue(EnumFacing.field_176754_o, "HORIZONTALS");
            for (EnumFacing dir : EnumFacing.field_176754_o) {
                Intrinsics.checkNotNull(dir);
                Point nextPos = this.move(iceCave, iceCaveColors, currPos, dir);
                if (nextPos == null) continue;
                queue.addLast(nextPos);
                iceCaveColors[nextPos.y][nextPos.x] = new Point(currPos.x, currPos.y);
                if (!(nextPos.getY() == (double)endY) || !(nextPos.getX() == (double)endX)) continue;
                ArrayList<Point> steps = new ArrayList<Point>();
                Point tmp = currPos;
                int count2 = 0;
                steps.add(nextPos);
                steps.add(currPos);
                while (tmp != startPoint) {
                    ++count2;
                    Intrinsics.checkNotNull(iceCaveColors[tmp.y][tmp.x]);
                    steps.add(tmp);
                }
                return steps;
            }
        }
        return new ArrayList<Point>();
    }

    private final Point move(int[][] iceCave, Point[][] iceCaveColors, Point currPos, EnumFacing dir) {
        int x = currPos.x;
        int y = currPos.y;
        int diffX = dir.func_176730_m().func_177958_n();
        int diffY = dir.func_176730_m().func_177952_p();
        int i = 1;
        while (x + i * diffX >= 0) {
            Intrinsics.checkNotNull(iceCave);
            if (x + i * diffX >= iceCave[0].length || y + i * diffY < 0 || y + i * diffY >= ((Object[])iceCave).length || iceCave[y + i * diffY][x + i * diffX] == 1) break;
            ++i;
        }
        return iceCaveColors[y + --i * diffY][x + i * diffX] != null ? null : new Point(x + i * diffX, y + i * diffY);
    }

    public static final /* synthetic */ void access$setSilverfishChestPos$p(BlockPos blockPos2) {
        silverfishChestPos = blockPos2;
    }

    public static final /* synthetic */ void access$setRoomFacing$p(EnumFacing enumFacing) {
        roomFacing = enumFacing;
    }

    static {
        TickKt.tickTimer$default(20, true, false, 1.INSTANCE, 4, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EnumFacing.Axis.values().length];
            try {
                nArray[EnumFacing.Axis.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnumFacing.Axis.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnumFacing.Axis.Z.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

