/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.mixinextras.utils;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;

public class ProxyUtils {
    public static <T> T getProxy(Object impl, Class<T> interfaceClass) {
        if (interfaceClass.isInstance(impl)) {
            return interfaceClass.cast(impl);
        }
        String simpleName2 = interfaceClass.getSimpleName();
        if (Arrays.stream(impl.getClass().getInterfaces()).anyMatch(it -> it.getName().endsWith('.' + simpleName2))) {
            return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, (proxy, method2, args2) -> {
                Method original = impl.getClass().getMethod(method2.getName(), method2.getParameterTypes());
                original.setAccessible(true);
                return original.invoke(impl, args2);
            });
        }
        throw new UnsupportedOperationException(String.format("Cannot get a %s instance from %s", simpleName2, impl));
    }
}

