/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.mixinextras.sugar.impl.handlers;

import gg.skytils.mixinextras.sugar.impl.SugarParameter;
import gg.skytils.mixinextras.utils.ASMUtils;
import gg.skytils.mixinextras.utils.UniquenessHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.util.Bytecode;

public class HandlerInfo {
    private final Map<Integer, ParameterWrapper> wrappers = new LinkedHashMap<Integer, ParameterWrapper>();

    public void wrapParameter(SugarParameter param, Type type2, Type generic, BiConsumer<InsnList, Runnable> unwrap2) {
        this.wrappers.put(param.paramIndex, new ParameterWrapper(type2, generic, unwrap2));
    }

    public void transformHandler(ClassNode targetClass, MethodNode handler2) {
        Type[] paramTypes = Type.getArgumentTypes((String)handler2.desc);
        InsnList insns = new InsnList();
        if (!Bytecode.isStatic((MethodNode)handler2)) {
            insns.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        int index = Bytecode.isStatic((MethodNode)handler2) ? 0 : 1;
        for (int i = 0; i < paramTypes.length; ++i) {
            VarInsnNode loadInsn = new VarInsnNode(paramTypes[i].getOpcode(21), index);
            ParameterWrapper wrapper = this.wrappers.get(i);
            if (wrapper != null) {
                paramTypes[i] = wrapper.type;
                loadInsn.setOpcode(wrapper.type.getOpcode(21));
                wrapper.unwrap.accept(insns, () -> insns.add((AbstractInsnNode)loadInsn));
            } else {
                insns.add((AbstractInsnNode)loadInsn);
            }
            index += paramTypes[i].getSize();
        }
        insns.add((AbstractInsnNode)ASMUtils.getInvokeInstruction(targetClass, handler2));
        insns.add((AbstractInsnNode)new InsnNode(Type.getReturnType((String)handler2.desc).getOpcode(172)));
        handler2.instructions = insns;
        handler2.localVariables = null;
        handler2.name = UniquenessHelper.getUniqueMethodName(targetClass, handler2.name + "$mixinextras$bridge");
        handler2.desc = Type.getMethodDescriptor((Type)Type.getReturnType((String)handler2.desc), (Type[])paramTypes);
    }

    public void transformGenerics(ArrayList<Type> generics) {
        for (Map.Entry<Integer, ParameterWrapper> entry : this.wrappers.entrySet()) {
            Type type2 = entry.getValue().generic;
            generics.set(entry.getKey(), type2);
        }
    }

    private static class ParameterWrapper {
        private final Type type;
        private final Type generic;
        private final BiConsumer<InsnList, Runnable> unwrap;

        private ParameterWrapper(Type type2, Type generic, BiConsumer<InsnList, Runnable> unwrap2) {
            this.type = type2;
            this.generic = generic;
            this.unwrap = unwrap2;
        }
    }
}

