/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktx-serialization.json.internal;

import gg.skytils.ktx-serialization.descriptors.PolymorphicKind;
import gg.skytils.ktx-serialization.descriptors.SerialDescriptor;
import gg.skytils.ktx-serialization.descriptors.SerialKind;
import gg.skytils.ktx-serialization.encoding.CompositeDecoder;
import gg.skytils.ktx-serialization.internal.JsonInternalDependenciesKt;
import gg.skytils.ktx-serialization.json.Json;
import gg.skytils.ktx-serialization.json.JsonElement;
import gg.skytils.ktx-serialization.json.JsonElementKt;
import gg.skytils.ktx-serialization.json.JsonNamingStrategy;
import gg.skytils.ktx-serialization.json.JsonNull;
import gg.skytils.ktx-serialization.json.JsonObject;
import gg.skytils.ktx-serialization.json.JsonPrimitive;
import gg.skytils.ktx-serialization.json.JsonSchemaCacheKt;
import gg.skytils.ktx-serialization.json.internal.AbstractJsonTreeDecoder;
import gg.skytils.ktx-serialization.json.internal.JsonExceptionsKt;
import gg.skytils.ktx-serialization.json.internal.JsonNamesMapKt;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0012\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010*\u001a\u00020)\u0012\u0006\u0010%\u001a\u00020$\u0012\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b+\u0010,J\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\fH\u0014\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u0004\u0018\u00010\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010\"\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#R\u001a\u0010%\u001a\u00020$8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\u00a8\u0006-"}, d2={"Lgg/skytils/ktx-serialization/json/internal/JsonTreeDecoder;", "Lgg/skytils/ktx-serialization/json/internal/AbstractJsonTreeDecoder;", "Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;", "descriptor", "", "index", "", "absenceIsNull", "(Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;I)Z", "Lgg/skytils/ktx-serialization/encoding/CompositeDecoder;", "beginStructure", "(Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;)Lgg/skytils/ktx-serialization/encoding/CompositeDecoder;", "", "tag", "coerceInputValue", "(Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;ILjava/lang/String;)Z", "Lgg/skytils/ktx-serialization/json/JsonElement;", "currentElement", "(Ljava/lang/String;)Lgg/skytils/ktx-serialization/json/JsonElement;", "decodeElementIndex", "(Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;)I", "decodeNotNullMark", "()Z", "elementName", "(Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;I)Ljava/lang/String;", "", "endStructure", "(Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;)V", "forceNull", "Z", "polyDescriptor", "Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;", "polyDiscriminator", "Ljava/lang/String;", "position", "I", "Lgg/skytils/ktx-serialization/json/JsonObject;", "value", "Lgg/skytils/ktx-serialization/json/JsonObject;", "getValue", "()Lkotlinx/serialization/json/JsonObject;", "Lgg/skytils/ktx-serialization/json/Json;", "json", "<init>", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/JsonObject;Ljava/lang/String;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nTreeJsonDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TreeJsonDecoder.kt\nkotlinx/serialization/json/internal/JsonTreeDecoder\n+ 2 JsonNamesMap.kt\nkotlinx/serialization/json/internal/JsonNamesMapKt\n+ 3 JsonNamesMap.kt\nkotlinx/serialization/json/internal/JsonNamesMapKt$tryCoerceValue$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 TreeJsonEncoder.kt\nkotlinx/serialization/json/internal/TreeJsonEncoderKt\n*L\n1#1,326:1\n112#2,17:327\n129#2,4:345\n116#3:344\n1#4:349\n252#5,7:350\n*S KotlinDebug\n*F\n+ 1 TreeJsonDecoder.kt\nkotlinx/serialization/json/internal/JsonTreeDecoder\n*L\n192#1:327,17\n192#1:345,4\n192#1:344\n254#1:350,7\n*E\n"})
class JsonTreeDecoder
extends AbstractJsonTreeDecoder {
    @NotNull
    private final JsonObject value;
    @Nullable
    private final String polyDiscriminator;
    @Nullable
    private final SerialDescriptor polyDescriptor;
    private int position;
    private boolean forceNull;

    public JsonTreeDecoder(@NotNull Json json2, @NotNull JsonObject value, @Nullable String polyDiscriminator, @Nullable SerialDescriptor polyDescriptor) {
        Intrinsics.checkNotNullParameter(json2, "json");
        Intrinsics.checkNotNullParameter(value, "value");
        super(json2, value, null);
        this.value = value;
        this.polyDiscriminator = polyDiscriminator;
        this.polyDescriptor = polyDescriptor;
    }

    public /* synthetic */ JsonTreeDecoder(Json json2, JsonObject jsonObject, String string, SerialDescriptor serialDescriptor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            serialDescriptor = null;
        }
        this(json2, jsonObject, string, serialDescriptor);
    }

    @Override
    @NotNull
    public JsonObject getValue() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean coerceInputValue(SerialDescriptor descriptor2, int index, String tag) {
        void $this$tryCoerceValue_u24default$iv;
        boolean bl;
        boolean it;
        void elementDescriptor$iv;
        Json json2 = this.getJson();
        SerialDescriptor serialDescriptor = descriptor2.getElementDescriptor(index);
        boolean $i$f$tryCoerceValue = false;
        if (!elementDescriptor$iv.isNullable()) {
            it = true;
            bl = false;
            if (this.currentElement(tag) instanceof JsonNull) {
                return true;
            }
        }
        if (!Intrinsics.areEqual(elementDescriptor$iv.getKind(), SerialKind.ENUM.INSTANCE)) return false;
        if (elementDescriptor$iv.isNullable()) {
            it = false;
            bl = false;
            if (this.currentElement(tag) instanceof JsonNull) {
                return false;
            }
        }
        boolean bl2 = false;
        JsonElement jsonElement = this.currentElement(tag);
        if (!(jsonElement instanceof JsonPrimitive)) return false;
        JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
        if (jsonPrimitive == null) return false;
        String string = JsonElementKt.getContentOrNull(jsonPrimitive);
        if (string == null) {
            return false;
        }
        String enumValue$iv = string;
        int enumIndex$iv = JsonNamesMapKt.getJsonNameIndex((SerialDescriptor)elementDescriptor$iv, (Json)$this$tryCoerceValue_u24default$iv, enumValue$iv);
        if (enumIndex$iv != -3) return false;
        return true;
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        while (this.position < descriptor2.getElementsCount()) {
            int n = this.position;
            this.position = n + 1;
            String name = this.getTag(descriptor2, n);
            int index = this.position - 1;
            this.forceNull = false;
            if (!((Map)this.getValue()).containsKey(name) && !this.absenceIsNull(descriptor2, index) || this.configuration.getCoerceInputValues() && this.coerceInputValue(descriptor2, index, name)) continue;
            return index;
        }
        return -1;
    }

    private final boolean absenceIsNull(SerialDescriptor descriptor2, int index) {
        this.forceNull = !this.getJson().getConfiguration().getExplicitNulls() && !descriptor2.isElementOptional(index) && descriptor2.getElementDescriptor(index).isNullable();
        return this.forceNull;
    }

    @Override
    public boolean decodeNotNullMark() {
        return !this.forceNull && super.decodeNotNullMark();
    }

    @Override
    @NotNull
    protected String elementName(@NotNull SerialDescriptor descriptor2, int index) {
        Object v1;
        String baseName;
        JsonNamingStrategy strategy;
        block6: {
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            strategy = JsonNamesMapKt.namingStrategy(descriptor2, this.getJson());
            baseName = descriptor2.getElementName(index);
            if (strategy == null) {
                if (!this.configuration.getUseAlternativeNames()) {
                    return baseName;
                }
                if (this.getValue().keySet().contains(baseName)) {
                    return baseName;
                }
            }
            Map<String, Integer> deserializationNamesMap2 = JsonNamesMapKt.deserializationNamesMap(this.getJson(), descriptor2);
            Iterable iterable = this.getValue().keySet();
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                Integer n = deserializationNamesMap2.get(it);
                int n2 = index;
                if (!(n != null && n == n2)) continue;
                v1 = t;
                break block6;
            }
            v1 = null;
        }
        String string = v1;
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        JsonNamingStrategy jsonNamingStrategy = strategy;
        String fallbackName = jsonNamingStrategy != null ? jsonNamingStrategy.serialNameForJson(descriptor2, index, baseName) : null;
        String string2 = fallbackName;
        if (string2 == null) {
            string2 = baseName;
        }
        return string2;
    }

    @Override
    @NotNull
    protected JsonElement currentElement(@NotNull String tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        return (JsonElement)MapsKt.getValue(this.getValue(), tag);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (descriptor2 == this.polyDescriptor) {
            void value$iv;
            JsonElement jsonElement = this.currentObject();
            SerialDescriptor descriptor$iv = this.polyDescriptor;
            boolean $i$f$cast = false;
            if (!(value$iv instanceof JsonObject)) {
                throw JsonExceptionsKt.JsonDecodingException(-1, "Expected " + Reflection.getOrCreateKotlinClass(JsonObject.class) + " as the serialized body of " + descriptor$iv.getSerialName() + ", but had " + Reflection.getOrCreateKotlinClass(value$iv.getClass()));
            }
            return new JsonTreeDecoder(this.getJson(), (JsonObject)jsonElement, this.polyDiscriminator, this.polyDescriptor);
        }
        return super.beginStructure(descriptor2);
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Set<String> set2;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        if (this.configuration.getIgnoreUnknownKeys() || descriptor2.getKind() instanceof PolymorphicKind) {
            return;
        }
        JsonNamingStrategy strategy = JsonNamesMapKt.namingStrategy(descriptor2, this.getJson());
        if (strategy == null && !this.configuration.getUseAlternativeNames()) {
            set2 = JsonInternalDependenciesKt.jsonCachedSerialNames(descriptor2);
        } else if (strategy != null) {
            set2 = JsonNamesMapKt.deserializationNamesMap(this.getJson(), descriptor2).keySet();
        } else {
            Set<String> set3 = JsonInternalDependenciesKt.jsonCachedSerialNames(descriptor2);
            Map<String, Integer> map2 = JsonSchemaCacheKt.getSchemaCache(this.getJson()).get(descriptor2, JsonNamesMapKt.getJsonDeserializationNamesKey());
            Set<String> set4 = map2 != null ? map2.keySet() : null;
            if (set4 == null) {
                set4 = SetsKt.emptySet();
            }
            set2 = SetsKt.plus(set3, (Iterable)set4);
        }
        Set<String> names2 = set2;
        for (String key2 : this.getValue().keySet()) {
            if (names2.contains(key2) || Intrinsics.areEqual(key2, this.polyDiscriminator)) continue;
            throw JsonExceptionsKt.UnknownKeyException(key2, this.getValue().toString());
        }
    }
}

