/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.utils.io.streams;

import gg.skytils.ktor.utils.io.bits.MemoryJvmKt;
import gg.skytils.ktor.utils.io.core.Output;
import gg.skytils.ktor.utils.io.core.internal.ChunkBuffer;
import gg.skytils.ktor.utils.io.pool.ObjectPool;
import gg.skytils.ktor.utils.io.streams.ByteArraysKt;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0003\u001a\u00020\u0002H\u0014\u00a2\u0006\u0004\b\u0003\u0010\u0004J-\u0010\f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0014\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u000f\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b\u0019\u00a8\u0006\u0015"}, d2={"Lgg/skytils/ktor/utils/io/streams/OutputStreamAdapter;", "Lgg/skytils/ktor/utils/io/core/Output;", "", "closeDestination", "()V", "Lgg/skytils/ktor/utils/io/bits/Memory;", "source", "", "offset", "length", "flush-62zg_DM", "(Ljava/nio/ByteBuffer;II)V", "flush", "Ljava/io/OutputStream;", "stream", "Ljava/io/OutputStream;", "Lgg/skytils/ktor/utils/io/pool/ObjectPool;", "Lgg/skytils/ktor/utils/io/core/internal/ChunkBuffer;", "pool", "<init>", "(Lio/ktor/utils/io/pool/ObjectPool;Ljava/io/OutputStream;)V", "ktor-io"})
final class OutputStreamAdapter
extends Output {
    @NotNull
    private final OutputStream stream;

    public OutputStreamAdapter(@NotNull ObjectPool<ChunkBuffer> pool, @NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter(pool, "pool");
        Intrinsics.checkNotNullParameter(stream, "stream");
        super(pool);
        this.stream = stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flush-62zg_DM(@NotNull ByteBuffer source, int offset, int length) {
        Intrinsics.checkNotNullParameter(source, "source");
        ByteBuffer nioBuffer = source;
        if (nioBuffer.hasArray() && !nioBuffer.isReadOnly()) {
            this.stream.write(nioBuffer.array(), nioBuffer.arrayOffset() + offset, length);
            return;
        }
        byte[] array = ByteArraysKt.getByteArrayPool().borrow();
        ByteBuffer slice = MemoryJvmKt.sliceSafe(nioBuffer, offset, length);
        try {
            int partSize;
            while ((partSize = Math.min(slice.remaining(), array.length)) != 0) {
                slice.get(array, 0, partSize);
                this.stream.write(array, 0, partSize);
            }
        }
        finally {
            ByteArraysKt.getByteArrayPool().recycle(array);
        }
    }

    @Override
    protected void closeDestination() {
        this.stream.close();
    }
}

