/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.sessions.serialization;

import gg.skytils.ktx-serialization.descriptors.SerialDescriptor;
import gg.skytils.ktx-serialization.encoding.AbstractDecoder;
import gg.skytils.ktx-serialization.modules.SerializersModule;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010'\u001a\u00020&\u0012\u0006\u0010+\u001a\u00020\u001e\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u000fJ\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0004J\u0011\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u000f\u0010\u001f\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u00020\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001e0#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u001a\u0010'\u001a\u00020&8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*\u00a8\u0006."}, d2={"Lgg/skytils/ktor/server/sessions/serialization/ListLikeDecoder;", "Lgg/skytils/ktx-serialization/encoding/AbstractDecoder;", "", "decodeBoolean", "()Z", "", "decodeChar", "()C", "", "decodeDouble", "()D", "Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;", "descriptor", "", "decodeElementIndex", "(Lgg/skytils/ktx-serialization/descriptors/SerialDescriptor;)I", "enumDescriptor", "decodeEnum", "", "decodeFloat", "()F", "decodeInt", "()I", "", "decodeLong", "()J", "decodeNotNullMark", "", "decodeNull", "()Ljava/lang/Void;", "", "decodeString", "()Ljava/lang/String;", "currentIndex", "I", "", "items", "Ljava/util/List;", "Lgg/skytils/ktx-serialization/modules/SerializersModule;", "serializersModule", "Lgg/skytils/ktx-serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "string", "<init>", "(Lkotlinx/serialization/modules/SerializersModule;Ljava/lang/String;)V", "ktor-server-sessions"})
public final class ListLikeDecoder
extends AbstractDecoder {
    @NotNull
    private final SerializersModule serializersModule;
    private int currentIndex;
    @NotNull
    private final List<String> items;

    public ListLikeDecoder(@NotNull SerializersModule serializersModule, @NotNull String string) {
        Intrinsics.checkNotNullParameter(serializersModule, "serializersModule");
        Intrinsics.checkNotNullParameter(string, "string");
        this.serializersModule = serializersModule;
        this.currentIndex = -1;
        String[] stringArray = new String[]{"&"};
        this.items = StringsKt.split$default((CharSequence)string, stringArray, false, 0, 6, null);
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        ++this.currentIndex;
        if (this.currentIndex == this.items.size()) {
            return -1;
        }
        return this.currentIndex;
    }

    @Override
    public boolean decodeBoolean() {
        return Intrinsics.areEqual(this.items.get(this.currentIndex), "#bot");
    }

    @Override
    public char decodeChar() {
        return this.items.get(this.currentIndex).charAt(3);
    }

    @Override
    public double decodeDouble() {
        return Double.parseDouble(StringsKt.drop(this.items.get(this.currentIndex), 2));
    }

    @Override
    public float decodeFloat() {
        return Float.parseFloat(StringsKt.drop(this.items.get(this.currentIndex), 2));
    }

    @Override
    public int decodeInt() {
        return Integer.parseInt(StringsKt.drop(this.items.get(this.currentIndex), 2));
    }

    @Override
    public long decodeLong() {
        return Long.parseLong(StringsKt.drop(this.items.get(this.currentIndex), 2));
    }

    @Override
    @NotNull
    public String decodeString() {
        return StringsKt.drop(this.items.get(this.currentIndex), 2);
    }

    @Override
    public boolean decodeNotNullMark() {
        return !Intrinsics.areEqual(this.items.get(this.currentIndex), "#n");
    }

    @Override
    @Nullable
    public Void decodeNull() {
        return null;
    }

    @Override
    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
        String enumName = this.decodeString();
        int index = enumDescriptor.getElementIndex(enumName);
        if (index == -3) {
            throw new IllegalStateException(enumDescriptor.getSerialName() + " does not contain element with name '" + enumName + '\'');
        }
        return index;
    }
}

