/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.request;

import gg.skytils.ktor.http.CookieEncoding;
import gg.skytils.ktor.http.CookieKt;
import gg.skytils.ktor.server.request.ApplicationRequest;
import gg.skytils.ktor.util.collections.ConcurrentMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001b\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0002H\u0014\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\t\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u0007H\u0086\u0002\u00a2\u0006\u0004\b\t\u0010\nR,\u0010\r\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00030\f\u0012\u0004\u0012\u00020\u00030\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR'\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00028FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0005R\u001a\u0010\u0014\u001a\u00020\u00138\u0004X\u0084\u0004\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lgg/skytils/ktor/server/request/RequestCookies;", "", "", "", "fetchCookies", "()Ljava/util/Map;", "name", "Lgg/skytils/ktor/http/CookieEncoding;", "encoding", "get", "(Ljava/lang/String;Lgg/skytils/ktor/http/CookieEncoding;)Ljava/lang/String;", "Lgg/skytils/ktor/util/collections/ConcurrentMap;", "Lkotlin/Pair;", "map", "Lgg/skytils/ktor/util/collections/ConcurrentMap;", "rawCookies$delegate", "Lkotlin/Lazy;", "getRawCookies", "rawCookies", "Lgg/skytils/ktor/server/request/ApplicationRequest;", "request", "Lgg/skytils/ktor/server/request/ApplicationRequest;", "getRequest", "()Lio/ktor/server/request/ApplicationRequest;", "<init>", "(Lio/ktor/server/request/ApplicationRequest;)V", "ktor-server-core"})
public class RequestCookies {
    @NotNull
    private final ApplicationRequest request;
    @NotNull
    private final ConcurrentMap<Pair<CookieEncoding, String>, String> map;
    @NotNull
    private final Lazy rawCookies$delegate;

    public RequestCookies(@NotNull ApplicationRequest request2) {
        Intrinsics.checkNotNullParameter(request2, "request");
        this.request = request2;
        this.map = new ConcurrentMap(0, 1, null);
        this.rawCookies$delegate = LazyKt.lazy((Function0)new Function0<Map<String, ? extends String>>(this){
            final /* synthetic */ RequestCookies this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<String, String> invoke() {
                return this.this$0.fetchCookies();
            }
        });
    }

    @NotNull
    protected final ApplicationRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final Map<String, String> getRawCookies() {
        Lazy lazy = this.rawCookies$delegate;
        return (Map)lazy.getValue();
    }

    @Nullable
    public final String get(@NotNull String name, @NotNull CookieEncoding encoding) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter((Object)encoding, "encoding");
        String string = this.getRawCookies().get(name);
        if (string == null) {
            return null;
        }
        String rawValue = string;
        return this.map.computeIfAbsent(TuplesKt.to(encoding, name), new Function0<String>(rawValue, encoding){
            final /* synthetic */ String $rawValue;
            final /* synthetic */ CookieEncoding $encoding;
            {
                this.$rawValue = $rawValue;
                this.$encoding = $encoding;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return CookieKt.decodeCookieValue(this.$rawValue, this.$encoding);
            }
        });
    }

    public static /* synthetic */ String get$default(RequestCookies requestCookies, String string, CookieEncoding cookieEncoding, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: get");
        }
        if ((n & 2) != 0) {
            cookieEncoding = CookieEncoding.URI_ENCODING;
        }
        return requestCookies.get(string, cookieEncoding);
    }

    @NotNull
    protected Map<String, String> fetchCookies() {
        List<String> list = this.request.getHeaders().getAll("Cookie");
        if (list == null) {
            return MapsKt.emptyMap();
        }
        List<String> cookieHeaders = list;
        HashMap map2 = new HashMap(cookieHeaders.size());
        for (String cookieHeader : cookieHeaders) {
            Map cookies2 = CookieKt.parseClientCookiesHeader$default(cookieHeader, false, 2, null);
            map2.putAll(cookies2);
        }
        return map2;
    }
}

