/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.ktor.server.plugins.compression;

import gg.skytils.ktor.http.ContentType;
import gg.skytils.ktor.http.Headers;
import gg.skytils.ktor.http.HeadersBuilder;
import gg.skytils.ktor.http.HttpHeaders;
import gg.skytils.ktor.http.HttpStatusCode;
import gg.skytils.ktor.http.content.OutgoingContent;
import gg.skytils.ktor.server.plugins.compression.CompressedResponse;
import gg.skytils.ktor.server.plugins.compression.CompressionEncoder;
import gg.skytils.ktor.util.AttributeKey;
import gg.skytils.ktor.util.StringValuesKt;
import gg.skytils.ktor.utils.io.ByteReadChannel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010-\u001a\u00020,\u0012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0017\u0012\u0006\u0010\"\u001a\u00020!\u0012\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b5\u00106J)\u0010\u0006\u001a\u0004\u0018\u00018\u0000\"\b\b\u0000\u0010\u0003*\u00020\u00022\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\t\u0010\nJ1\u0010\r\u001a\u00020\f\"\b\b\u0000\u0010\u0003*\u00020\u00022\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\b\u0010\u000b\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001d\u001a\u00020\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u0017\u0010\"\u001a\u00020!8\u0006\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u001b\u0010+\u001a\u00020&8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R\u0017\u0010-\u001a\u00020,8\u0006\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R\u0016\u00104\u001a\u0004\u0018\u0001018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u00067"}, d2={"Lgg/skytils/ktor/server/plugins/compression/CompressedResponse;", "Lgg/skytils/ktor/http/content/OutgoingContent$ReadChannelContent;", "", "T", "Lgg/skytils/ktor/util/AttributeKey;", "key", "getProperty", "(Lio/ktor/util/AttributeKey;)Ljava/lang/Object;", "Lgg/skytils/ktor/utils/io/ByteReadChannel;", "readFrom", "()Lgg/skytils/ktor/utils/io/ByteReadChannel;", "value", "", "setProperty", "(Lio/ktor/util/AttributeKey;Ljava/lang/Object;)V", "", "getContentLength", "()Ljava/lang/Long;", "contentLength", "Lgg/skytils/ktor/http/ContentType;", "getContentType", "()Lio/ktor/http/ContentType;", "contentType", "Lkotlin/Function0;", "delegateChannel", "Lkotlin/jvm/functions/Function0;", "getDelegateChannel", "()Lkotlin/jvm/functions/Function0;", "Lgg/skytils/ktor/server/plugins/compression/CompressionEncoder;", "encoder", "Lgg/skytils/ktor/server/plugins/compression/CompressionEncoder;", "getEncoder", "()Lio/ktor/server/plugins/compression/CompressionEncoder;", "", "encoding", "Ljava/lang/String;", "getEncoding", "()Ljava/lang/String;", "Lgg/skytils/ktor/http/Headers;", "headers$delegate", "Lkotlin/Lazy;", "getHeaders", "()Lio/ktor/http/Headers;", "headers", "Lgg/skytils/ktor/http/content/OutgoingContent;", "original", "Lgg/skytils/ktor/http/content/OutgoingContent;", "getOriginal", "()Lio/ktor/http/content/OutgoingContent;", "Lgg/skytils/ktor/http/HttpStatusCode;", "getStatus", "()Lio/ktor/http/HttpStatusCode;", "status", "<init>", "(Lio/ktor/http/content/OutgoingContent;Lkotlin/jvm/functions/Function0;Ljava/lang/String;Lio/ktor/server/plugins/compression/CompressionEncoder;)V", "ktor-server-compression"})
@SourceDebugExtension(value={"SMAP\nCompression.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Compression.kt\nio/ktor/server/plugins/compression/CompressedResponse\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1#2:212\n*E\n"})
final class CompressedResponse
extends OutgoingContent.ReadChannelContent {
    @NotNull
    private final OutgoingContent original;
    @NotNull
    private final Function0<ByteReadChannel> delegateChannel;
    @NotNull
    private final String encoding;
    @NotNull
    private final CompressionEncoder encoder;
    @NotNull
    private final Lazy headers$delegate;

    public CompressedResponse(@NotNull OutgoingContent original, @NotNull Function0<? extends ByteReadChannel> delegateChannel, @NotNull String encoding, @NotNull CompressionEncoder encoder2) {
        Intrinsics.checkNotNullParameter(original, "original");
        Intrinsics.checkNotNullParameter(delegateChannel, "delegateChannel");
        Intrinsics.checkNotNullParameter(encoding, "encoding");
        Intrinsics.checkNotNullParameter(encoder2, "encoder");
        this.original = original;
        this.delegateChannel = delegateChannel;
        this.encoding = encoding;
        this.encoder = encoder2;
        this.headers$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, (Function0)new Function0<Headers>(this){
            final /* synthetic */ CompressedResponse this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Headers invoke() {
                HeadersBuilder headersBuilder;
                Headers.Companion companion = Headers.Companion;
                CompressedResponse compressedResponse = this.this$0;
                boolean $i$f$build = false;
                HeadersBuilder $this$invoke_u24lambda_u240 = headersBuilder = new HeadersBuilder(0, 1, null);
                boolean bl = false;
                StringValuesKt.appendFiltered$default($this$invoke_u24lambda_u240, compressedResponse.getOriginal().getHeaders(), false, headers.1.1.INSTANCE, 2, null);
                $this$invoke_u24lambda_u240.append(HttpHeaders.INSTANCE.getContentEncoding(), compressedResponse.getEncoding());
                return headersBuilder.build();
            }
        });
    }

    @NotNull
    public final OutgoingContent getOriginal() {
        return this.original;
    }

    @NotNull
    public final Function0<ByteReadChannel> getDelegateChannel() {
        return this.delegateChannel;
    }

    @NotNull
    public final String getEncoding() {
        return this.encoding;
    }

    @NotNull
    public final CompressionEncoder getEncoder() {
        return this.encoder;
    }

    @Override
    @NotNull
    public ByteReadChannel readFrom() {
        return CompressionEncoder.DefaultImpls.compress$default(this.encoder, this.delegateChannel.invoke(), null, 2, null);
    }

    @Override
    @NotNull
    public Headers getHeaders() {
        Lazy lazy = this.headers$delegate;
        return (Headers)lazy.getValue();
    }

    @Override
    @Nullable
    public ContentType getContentType() {
        return this.original.getContentType();
    }

    @Override
    @Nullable
    public HttpStatusCode getStatus() {
        return this.original.getStatus();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Long getContentLength() {
        Long l = this.original.getContentLength();
        Long l2 = l;
        if (l == null) return null;
        long it = ((Number)l2).longValue();
        boolean bl = false;
        Long l3 = this.encoder.predictCompressedLength(it);
        l2 = l3;
        if (l3 == null) return null;
        Long l4 = l2;
        it = ((Number)l4).longValue();
        boolean bl2 = false;
        if (it < 0L) return null;
        boolean bl3 = true;
        if (!bl3) return null;
        Long l5 = l4;
        return l5;
    }

    @Override
    @Nullable
    public <T> T getProperty(@NotNull AttributeKey<T> key2) {
        Intrinsics.checkNotNullParameter(key2, "key");
        return this.original.getProperty(key2);
    }

    @Override
    public <T> void setProperty(@NotNull AttributeKey<T> key2, @Nullable T value) {
        Intrinsics.checkNotNullParameter(key2, "key");
        this.original.setProperty(key2, value);
    }
}

