/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.gson.internal.sql;

import gg.skytils.gson.Gson;
import gg.skytils.gson.TypeAdapter;
import gg.skytils.gson.TypeAdapterFactory;
import gg.skytils.gson.reflect.TypeToken;
import gg.skytils.gson.stream.JsonReader;
import gg.skytils.gson.stream.JsonWriter;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;

class SqlTimestampTypeAdapter
extends TypeAdapter<Timestamp> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson2, TypeToken<T> typeToken) {
            if (typeToken.getRawType() == Timestamp.class) {
                TypeAdapter<Date> dateTypeAdapter = gson2.getAdapter(Date.class);
                return new SqlTimestampTypeAdapter(dateTypeAdapter);
            }
            return null;
        }
    };
    private final TypeAdapter<Date> dateTypeAdapter;

    private SqlTimestampTypeAdapter(TypeAdapter<Date> dateTypeAdapter) {
        this.dateTypeAdapter = dateTypeAdapter;
    }

    @Override
    public Timestamp read(JsonReader in) throws IOException {
        Date date = this.dateTypeAdapter.read(in);
        return date != null ? new Timestamp(date.getTime()) : null;
    }

    @Override
    public void write(JsonWriter out2, Timestamp value) throws IOException {
        this.dateTypeAdapter.write(out2, value);
    }
}

