/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.gson.internal.bind;

import gg.skytils.gson.Gson;
import gg.skytils.gson.JsonSyntaxException;
import gg.skytils.gson.ToNumberPolicy;
import gg.skytils.gson.ToNumberStrategy;
import gg.skytils.gson.TypeAdapter;
import gg.skytils.gson.TypeAdapterFactory;
import gg.skytils.gson.reflect.TypeToken;
import gg.skytils.gson.stream.JsonReader;
import gg.skytils.gson.stream.JsonToken;
import gg.skytils.gson.stream.JsonWriter;
import java.io.IOException;

public final class NumberTypeAdapter
extends TypeAdapter<Number> {
    private static final TypeAdapterFactory LAZILY_PARSED_NUMBER_FACTORY = NumberTypeAdapter.newFactory(ToNumberPolicy.LAZILY_PARSED_NUMBER);
    private final ToNumberStrategy toNumberStrategy;

    private NumberTypeAdapter(ToNumberStrategy toNumberStrategy) {
        this.toNumberStrategy = toNumberStrategy;
    }

    private static TypeAdapterFactory newFactory(ToNumberStrategy toNumberStrategy) {
        NumberTypeAdapter adapter = new NumberTypeAdapter(toNumberStrategy);
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson2, TypeToken<T> type2) {
                return type2.getRawType() == Number.class ? NumberTypeAdapter.this : null;
            }
        };
    }

    public static TypeAdapterFactory getFactory(ToNumberStrategy toNumberStrategy) {
        if (toNumberStrategy == ToNumberPolicy.LAZILY_PARSED_NUMBER) {
            return LAZILY_PARSED_NUMBER_FACTORY;
        }
        return NumberTypeAdapter.newFactory(toNumberStrategy);
    }

    @Override
    public Number read(JsonReader in) throws IOException {
        JsonToken jsonToken = in.peek();
        switch (jsonToken) {
            case NULL: {
                in.nextNull();
                return null;
            }
            case NUMBER: 
            case STRING: {
                return this.toNumberStrategy.readNumber(in);
            }
        }
        throw new JsonSyntaxException("Expecting number, got: " + (Object)((Object)jsonToken) + "; at path " + in.getPath());
    }

    @Override
    public void write(JsonWriter out2, Number value) throws IOException {
        out2.value(value);
    }
}

