/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.gson.internal.bind;

import gg.skytils.gson.Gson;
import gg.skytils.gson.TypeAdapter;
import gg.skytils.gson.TypeAdapterFactory;
import gg.skytils.gson.internal.$Gson$Types;
import gg.skytils.gson.internal.ConstructorConstructor;
import gg.skytils.gson.internal.ObjectConstructor;
import gg.skytils.gson.internal.bind.TypeAdapterRuntimeTypeWrapper;
import gg.skytils.gson.reflect.TypeToken;
import gg.skytils.gson.stream.JsonReader;
import gg.skytils.gson.stream.JsonToken;
import gg.skytils.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;

public final class CollectionTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;

    public CollectionTypeAdapterFactory(ConstructorConstructor constructorConstructor) {
        this.constructorConstructor = constructorConstructor;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson2, TypeToken<T> typeToken) {
        Type type2 = typeToken.getType();
        Class<T> rawType = typeToken.getRawType();
        if (!Collection.class.isAssignableFrom(rawType)) {
            return null;
        }
        Type elementType = $Gson$Types.getCollectionElementType(type2, rawType);
        TypeAdapter<?> elementTypeAdapter = gson2.getAdapter(TypeToken.get(elementType));
        ObjectConstructor<T> constructor = this.constructorConstructor.get(typeToken);
        Adapter result2 = new Adapter(gson2, elementType, elementTypeAdapter, constructor);
        return result2;
    }

    private static final class Adapter<E>
    extends TypeAdapter<Collection<E>> {
        private final TypeAdapter<E> elementTypeAdapter;
        private final ObjectConstructor<? extends Collection<E>> constructor;

        public Adapter(Gson context, Type elementType, TypeAdapter<E> elementTypeAdapter, ObjectConstructor<? extends Collection<E>> constructor) {
            this.elementTypeAdapter = new TypeAdapterRuntimeTypeWrapper<E>(context, elementTypeAdapter, elementType);
            this.constructor = constructor;
        }

        @Override
        public Collection<E> read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            Collection<E> collection = this.constructor.construct();
            in.beginArray();
            while (in.hasNext()) {
                E instance = this.elementTypeAdapter.read(in);
                collection.add(instance);
            }
            in.endArray();
            return collection;
        }

        @Override
        public void write(JsonWriter out2, Collection<E> collection) throws IOException {
            if (collection == null) {
                out2.nullValue();
                return;
            }
            out2.beginArray();
            for (E element : collection) {
                this.elementTypeAdapter.write(out2, element);
            }
            out2.endArray();
        }
    }
}

