/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.gson.internal;

import gg.skytils.gson.ExclusionStrategy;
import gg.skytils.gson.FieldAttributes;
import gg.skytils.gson.Gson;
import gg.skytils.gson.TypeAdapter;
import gg.skytils.gson.TypeAdapterFactory;
import gg.skytils.gson.annotations.Expose;
import gg.skytils.gson.annotations.Since;
import gg.skytils.gson.annotations.Until;
import gg.skytils.gson.reflect.TypeToken;
import gg.skytils.gson.stream.JsonReader;
import gg.skytils.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Excluder
implements TypeAdapterFactory,
Cloneable {
    private static final double IGNORE_VERSIONS = -1.0;
    public static final Excluder DEFAULT = new Excluder();
    private double version = -1.0;
    private int modifiers = 136;
    private boolean serializeInnerClasses = true;
    private boolean requireExpose;
    private List<ExclusionStrategy> serializationStrategies = Collections.emptyList();
    private List<ExclusionStrategy> deserializationStrategies = Collections.emptyList();

    protected Excluder clone() {
        try {
            return (Excluder)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Excluder withVersion(double ignoreVersionsAfter) {
        Excluder result2 = this.clone();
        result2.version = ignoreVersionsAfter;
        return result2;
    }

    public Excluder withModifiers(int ... modifiers) {
        Excluder result2 = this.clone();
        result2.modifiers = 0;
        for (int modifier2 : modifiers) {
            result2.modifiers |= modifier2;
        }
        return result2;
    }

    public Excluder disableInnerClassSerialization() {
        Excluder result2 = this.clone();
        result2.serializeInnerClasses = false;
        return result2;
    }

    public Excluder excludeFieldsWithoutExposeAnnotation() {
        Excluder result2 = this.clone();
        result2.requireExpose = true;
        return result2;
    }

    public Excluder withExclusionStrategy(ExclusionStrategy exclusionStrategy, boolean serialization, boolean deserialization) {
        Excluder result2 = this.clone();
        if (serialization) {
            result2.serializationStrategies = new ArrayList<ExclusionStrategy>(this.serializationStrategies);
            result2.serializationStrategies.add(exclusionStrategy);
        }
        if (deserialization) {
            result2.deserializationStrategies = new ArrayList<ExclusionStrategy>(this.deserializationStrategies);
            result2.deserializationStrategies.add(exclusionStrategy);
        }
        return result2;
    }

    @Override
    public <T> TypeAdapter<T> create(final Gson gson2, final TypeToken<T> type2) {
        boolean skipDeserialize;
        Class<T> rawType = type2.getRawType();
        boolean excludeClass = this.excludeClassChecks(rawType);
        final boolean skipSerialize = excludeClass || this.excludeClassInStrategy(rawType, true);
        boolean bl = skipDeserialize = excludeClass || this.excludeClassInStrategy(rawType, false);
        if (!skipSerialize && !skipDeserialize) {
            return null;
        }
        return new TypeAdapter<T>(){
            private TypeAdapter<T> delegate;

            @Override
            public T read(JsonReader in) throws IOException {
                if (skipDeserialize) {
                    in.skipValue();
                    return null;
                }
                return this.delegate().read(in);
            }

            @Override
            public void write(JsonWriter out2, T value) throws IOException {
                if (skipSerialize) {
                    out2.nullValue();
                    return;
                }
                this.delegate().write(out2, value);
            }

            private TypeAdapter<T> delegate() {
                TypeAdapter d = this.delegate;
                return d != null ? d : (this.delegate = gson2.getDelegateAdapter(Excluder.this, type2));
            }
        };
    }

    public boolean excludeField(Field field2, boolean serialize2) {
        List<ExclusionStrategy> list;
        Expose annotation;
        if ((this.modifiers & field2.getModifiers()) != 0) {
            return true;
        }
        if (this.version != -1.0 && !this.isValidVersion(field2.getAnnotation(Since.class), field2.getAnnotation(Until.class))) {
            return true;
        }
        if (field2.isSynthetic()) {
            return true;
        }
        if (this.requireExpose && ((annotation = field2.getAnnotation(Expose.class)) == null || (serialize2 ? !annotation.serialize() : !annotation.deserialize()))) {
            return true;
        }
        if (!this.serializeInnerClasses && this.isInnerClass(field2.getType())) {
            return true;
        }
        if (this.isAnonymousOrNonStaticLocal(field2.getType())) {
            return true;
        }
        List<ExclusionStrategy> list2 = list = serialize2 ? this.serializationStrategies : this.deserializationStrategies;
        if (!list.isEmpty()) {
            FieldAttributes fieldAttributes = new FieldAttributes(field2);
            for (ExclusionStrategy exclusionStrategy : list) {
                if (!exclusionStrategy.shouldSkipField(fieldAttributes)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean excludeClassChecks(Class<?> clazz) {
        if (this.version != -1.0 && !this.isValidVersion(clazz.getAnnotation(Since.class), clazz.getAnnotation(Until.class))) {
            return true;
        }
        if (!this.serializeInnerClasses && this.isInnerClass(clazz)) {
            return true;
        }
        return this.isAnonymousOrNonStaticLocal(clazz);
    }

    public boolean excludeClass(Class<?> clazz, boolean serialize2) {
        return this.excludeClassChecks(clazz) || this.excludeClassInStrategy(clazz, serialize2);
    }

    private boolean excludeClassInStrategy(Class<?> clazz, boolean serialize2) {
        List<ExclusionStrategy> list = serialize2 ? this.serializationStrategies : this.deserializationStrategies;
        for (ExclusionStrategy exclusionStrategy : list) {
            if (!exclusionStrategy.shouldSkipClass(clazz)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnonymousOrNonStaticLocal(Class<?> clazz) {
        return !Enum.class.isAssignableFrom(clazz) && !this.isStatic(clazz) && (clazz.isAnonymousClass() || clazz.isLocalClass());
    }

    private boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !this.isStatic(clazz);
    }

    private boolean isStatic(Class<?> clazz) {
        return (clazz.getModifiers() & 8) != 0;
    }

    private boolean isValidVersion(Since since, Until until) {
        return this.isValidSince(since) && this.isValidUntil(until);
    }

    private boolean isValidSince(Since annotation) {
        if (annotation != null) {
            double annotationVersion = annotation.value();
            return this.version >= annotationVersion;
        }
        return true;
    }

    private boolean isValidUntil(Until annotation) {
        if (annotation != null) {
            double annotationVersion = annotation.value();
            return this.version < annotationVersion;
        }
        return true;
    }
}

