/*
 * Decompiled with CFR 0.152.
 */
package gg.skytils.gson;

import gg.skytils.gson.JsonElement;
import gg.skytils.gson.JsonIOException;
import gg.skytils.gson.JsonParseException;
import gg.skytils.gson.JsonSyntaxException;
import gg.skytils.gson.internal.Streams;
import gg.skytils.gson.stream.JsonReader;
import gg.skytils.gson.stream.JsonToken;
import gg.skytils.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public final class JsonParser {
    @Deprecated
    public JsonParser() {
    }

    public static JsonElement parseString(String json2) throws JsonSyntaxException {
        return JsonParser.parseReader(new StringReader(json2));
    }

    public static JsonElement parseReader(Reader reader) throws JsonIOException, JsonSyntaxException {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            JsonElement element = JsonParser.parseReader(jsonReader);
            if (!element.isJsonNull() && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("Did not consume the entire document.");
            }
            return element;
        }
        catch (MalformedJsonException e) {
            throw new JsonSyntaxException(e);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
        catch (NumberFormatException e) {
            throw new JsonSyntaxException(e);
        }
    }

    public static JsonElement parseReader(JsonReader reader) throws JsonIOException, JsonSyntaxException {
        boolean lenient = reader.isLenient();
        reader.setLenient(true);
        try {
            JsonElement jsonElement = Streams.parse(reader);
            return jsonElement;
        }
        catch (StackOverflowError e) {
            throw new JsonParseException("Failed parsing JSON source: " + reader + " to Json", e);
        }
        catch (OutOfMemoryError e) {
            throw new JsonParseException("Failed parsing JSON source: " + reader + " to Json", e);
        }
        finally {
            reader.setLenient(lenient);
        }
    }

    @Deprecated
    public JsonElement parse(String json2) throws JsonSyntaxException {
        return JsonParser.parseString(json2);
    }

    @Deprecated
    public JsonElement parse(Reader json2) throws JsonIOException, JsonSyntaxException {
        return JsonParser.parseReader(json2);
    }

    @Deprecated
    public JsonElement parse(JsonReader json2) throws JsonIOException, JsonSyntaxException {
        return JsonParser.parseReader(json2);
    }
}

