/*
 * Decompiled with CFR 0.152.
 */
package me.odinmain.utils.ui.rendering;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.odinmain.utils.WebUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bB\u0019\b\u0016\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\rJ\u0006\u0010\b\u001a\u00020\tJ\u0013\u0010\u0017\u001a\u00020\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lme/odinmain/utils/ui/rendering/Image;", "", "identifier", "", "isSVG", "", "stream", "Ljava/io/InputStream;", "buffer", "Ljava/nio/ByteBuffer;", "<init>", "(Ljava/lang/String;ZLjava/io/InputStream;Ljava/nio/ByteBuffer;)V", "inputStream", "(Ljava/io/InputStream;Ljava/lang/String;)V", "getIdentifier", "()Ljava/lang/String;", "()Z", "setSVG", "(Z)V", "getStream", "()Ljava/io/InputStream;", "setStream", "(Ljava/io/InputStream;)V", "equals", "other", "hashCode", "", "Companion", "OdinMod"})
@SourceDebugExtension(value={"SMAP\nImage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Image.kt\nme/odinmain/utils/ui/rendering/Image\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class Image {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String identifier;
    private boolean isSVG;
    @NotNull
    private InputStream stream;
    @Nullable
    private ByteBuffer buffer;

    public Image(@NotNull String identifier, boolean isSVG, @NotNull InputStream stream, @Nullable ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        Intrinsics.checkNotNullParameter(stream, "stream");
        this.identifier = identifier;
        this.isSVG = isSVG;
        this.stream = stream;
        this.buffer = buffer;
        this.isSVG = StringsKt.endsWith(this.identifier, ".svg", true);
    }

    public /* synthetic */ Image(String string, boolean bl, InputStream inputStream, ByteBuffer byteBuffer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            inputStream = Image.Companion.getStream(string);
        }
        if ((n & 8) != 0) {
            byteBuffer = null;
        }
        this(string, bl, inputStream, byteBuffer);
    }

    @NotNull
    public final String getIdentifier() {
        return this.identifier;
    }

    public final boolean isSVG() {
        return this.isSVG;
    }

    public final void setSVG(boolean bl) {
        this.isSVG = bl;
    }

    @NotNull
    public final InputStream getStream() {
        return this.stream;
    }

    public final void setStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter(inputStream, "<set-?>");
        this.stream = inputStream;
    }

    public Image(@NotNull InputStream inputStream, @NotNull String identifier) {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        this(identifier, false, inputStream, null, 8, null);
        this.stream = inputStream;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ByteBuffer buffer() {
        if (this.buffer == null) {
            void it;
            ByteBuffer byteBuffer;
            byte[] bytes = ByteStreamsKt.readBytes(this.stream);
            ByteBuffer byteBuffer2 = byteBuffer = ByteBuffer.allocateDirect(bytes.length).order(ByteOrder.nativeOrder()).put(bytes);
            Image image = this;
            boolean bl = false;
            it.flip();
            image.buffer = byteBuffer;
            this.stream.close();
        }
        ByteBuffer byteBuffer = this.buffer;
        if (byteBuffer == null) {
            throw new IllegalStateException("Image has no data");
        }
        return byteBuffer;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Image)) {
            return false;
        }
        return Intrinsics.areEqual(this.identifier, ((Image)other).identifier);
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lme/odinmain/utils/ui/rendering/Image$Companion;", "", "<init>", "()V", "getStream", "Ljava/io/InputStream;", "path", "", "OdinMod"})
    public static final class Companion {
        private Companion() {
        }

        private final InputStream getStream(String path) {
            InputStream inputStream;
            String trimmedPath = ((Object)StringsKt.trim((CharSequence)path)).toString();
            if (StringsKt.startsWith$default(trimmedPath, "http", false, 2, null)) {
                inputStream = WebUtilsKt.setupConnection$default(trimmedPath, 0, false, 6, null);
            } else {
                File file = new File(trimmedPath);
                if (file.exists() && file.isFile()) {
                    InputStream inputStream2 = Files.newInputStream(file.toPath(), new OpenOption[0]);
                    inputStream = inputStream2;
                    Intrinsics.checkNotNullExpressionValue(inputStream2, "newInputStream(...)");
                } else {
                    inputStream = this.getClass().getResourceAsStream(trimmedPath);
                    if (inputStream == null) {
                        throw new FileNotFoundException(trimmedPath);
                    }
                }
            }
            return inputStream;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

