/*
 * Decompiled with CFR 0.152.
 */
package me.odinmain.utils.ui;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import me.odinmain.utils.Utils;
import me.odinmain.utils.render.Colors;
import me.odinmain.utils.ui.MouseUtilsKt;
import me.odinmain.utils.ui.rendering.NVGRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\f\n\u0002\b\u0017\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u000e2\u0006\u00104\u001a\u00020\u000eJ\u001e\u00105\u001a\u00020)2\u0006\u00103\u001a\u00020\u000e2\u0006\u00104\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u001dJ\u0006\u00107\u001a\u00020\u0007J\u0010\u00108\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u000eH\u0002J\u000e\u00109\u001a\u00020)2\u0006\u0010:\u001a\u00020\u001dJ\u000e\u0010;\u001a\u00020)2\u0006\u0010<\u001a\u00020=J\u0010\u0010>\u001a\u00020\u00072\u0006\u0010?\u001a\u00020\u0004H\u0002J\b\u0010@\u001a\u00020\u0007H\u0002J\u0010\u0010A\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u000eH\u0002J\b\u0010B\u001a\u00020\u0007H\u0002J\b\u0010C\u001a\u00020\u0007H\u0002J\b\u0010D\u001a\u00020\u0007H\u0002J\b\u0010E\u001a\u00020\u001dH\u0002J\b\u0010F\u001a\u00020\u001dH\u0002J\u0010\u0010G\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0004H\u0002J\b\u0010H\u001a\u00020\u0007H\u0002J\b\u0010I\u001a\u00020\u0007H\u0002J\b\u0010J\u001a\u00020\u0007H\u0002J\b\u0010K\u001a\u00020\u0007H\u0002J\b\u0010L\u001a\u00020\u0007H\u0002J\u001c\u0010M\u001a\u00020\u0004*\u00020\u00042\u0006\u0010N\u001a\u00020\u001d2\u0006\u0010O\u001a\u00020\u001dH\u0002J\u001c\u0010P\u001a\u00020\u0004*\u00020\u00042\u0006\u0010N\u001a\u00020\u001d2\u0006\u0010O\u001a\u00020\u001dH\u0002J\u001c\u0010Q\u001a\u00020\u0004*\u00020\u00042\u0006\u0010R\u001a\u00020\u001d2\u0006\u0010S\u001a\u00020\u001dH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\n\u001a\u00020\u00048\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u001a\u0010\u0016\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u001a\u0010\u0019\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0010\"\u0004\b\u001b\u0010\u0012R\u001e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020&X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e01X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006T"}, d2={"Lme/odinmain/utils/ui/TextInputHandler;", "", "textProvider", "Lkotlin/Function0;", "", "textSetter", "Lkotlin/Function1;", "", "<init>", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "text", "getText", "()Ljava/lang/String;", "x", "", "getX", "()F", "setX", "(F)V", "y", "getY", "setY", "width", "getWidth", "setWidth", "height", "getHeight", "setHeight", "value", "", "caret", "setCaret", "(I)V", "selection", "selectionWidth", "textOffset", "caretX", "caretBlinkTime", "", "lastClickTime", "listening", "", "dragging", "clickCount", "history", "", "historyIndex", "lastSavedText", "previousMousePos", "Lkotlin/Pair;", "draw", "mouseX", "mouseY", "mouseClicked", "mouseButton", "mouseReleased", "mouseDragged", "keyPressed", "keyCode", "keyTyped", "typedChar", "", "insert", "string", "deleteSelection", "caretFromMouse", "updateCaretPosition", "clearSelection", "selectWord", "getPreviousSpace", "getNextSpace", "textWidth", "resetState", "selectAll", "saveState", "undo", "redo", "substringSafe", "from", "to", "removeRangeSafe", "dropAt", "at", "amount", "OdinMod"})
@SourceDebugExtension(value={"SMAP\nTextInputHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextInputHandler.kt\nme/odinmain/utils/ui/TextInputHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,381:1\n16#1:382\n16#1:383\n16#1:384\n16#1:385\n16#1:386\n16#1:387\n16#1:388\n16#1:389\n16#1:390\n16#1:391\n16#1:392\n16#1:393\n16#1:394\n16#1:396\n16#1:397\n16#1:398\n16#1:399\n16#1:400\n16#1:401\n16#1:402\n16#1:403\n16#1:404\n16#1:405\n16#1:406\n16#1:407\n16#1:408\n16#1:409\n16#1:410\n16#1:411\n16#1:412\n16#1:413\n16#1:414\n16#1:415\n16#1:416\n16#1:417\n16#1:418\n16#1:419\n16#1:420\n16#1:421\n16#1:422\n16#1:423\n1#2:395\n*S KotlinDebug\n*F\n+ 1 TextInputHandler.kt\nme/odinmain/utils/ui/TextInputHandler\n*L\n23#1:382\n30#1:383\n26#1:384\n68#1:385\n115#1:386\n118#1:387\n129#1:388\n131#1:389\n132#1:390\n133#1:391\n136#1:392\n140#1:393\n162#1:394\n181#1:396\n188#1:397\n196#1:398\n233#1:399\n236#1:400\n237#1:401\n238#1:402\n246#1:403\n257#1:404\n258#1:405\n269#1:406\n275#1:407\n280#1:408\n283#1:409\n284#1:410\n299#1:411\n300#1:412\n310#1:413\n318#1:414\n319#1:415\n335#1:416\n340#1:417\n344#1:418\n346#1:419\n354#1:420\n356#1:421\n364#1:422\n366#1:423\n*E\n"})
public final class TextInputHandler {
    @NotNull
    private final Function0<String> textProvider;
    @NotNull
    private final Function1<String, Unit> textSetter;
    private float x;
    private float y;
    private float width;
    private float height;
    private int caret;
    private int selection;
    private float selectionWidth;
    private float textOffset;
    private float caretX;
    private long caretBlinkTime;
    private long lastClickTime;
    private boolean listening;
    private boolean dragging;
    private int clickCount;
    @NotNull
    private final List<String> history;
    private int historyIndex;
    @NotNull
    private String lastSavedText;
    @NotNull
    private Pair<Float, Float> previousMousePos;

    public TextInputHandler(@NotNull Function0<String> textProvider, @NotNull Function1<? super String, Unit> textSetter) {
        Intrinsics.checkNotNullParameter(textProvider, "textProvider");
        Intrinsics.checkNotNullParameter(textSetter, "textSetter");
        this.textProvider = textProvider;
        this.textSetter = textSetter;
        this.height = 18.0f;
        TextInputHandler this_$iv = this;
        boolean $i$f$getText = false;
        this.caret = this_$iv.textProvider.invoke().length();
        this_$iv = this;
        $i$f$getText = false;
        this.selection = this_$iv.textProvider.invoke().length();
        this.caretBlinkTime = System.currentTimeMillis();
        this.clickCount = 1;
        this.history = new ArrayList();
        this.historyIndex = -1;
        this.lastSavedText = "";
        this.saveState();
        this.previousMousePos = TuplesKt.to(Float.valueOf(0.0f), Float.valueOf(0.0f));
    }

    private final String getText() {
        boolean $i$f$getText = false;
        return this.textProvider.invoke();
    }

    public final float getX() {
        return this.x;
    }

    public final void setX(float f) {
        this.x = f;
    }

    public final float getY() {
        return this.y;
    }

    public final void setY(float f) {
        this.y = f;
    }

    public final float getWidth() {
        return this.width;
    }

    public final void setWidth(float f) {
        this.width = f;
    }

    public final float getHeight() {
        return this.height;
    }

    public final void setHeight(float f) {
        this.height = f;
    }

    private final void setCaret(int value) {
        if (this.caret == value) {
            return;
        }
        TextInputHandler this_$iv = this;
        boolean $i$f$getText = false;
        this.caret = RangesKt.coerceIn(value, 0, this_$iv.textProvider.invoke().length());
        this.caretBlinkTime = System.currentTimeMillis();
    }

    public final void draw(float mouseX, float mouseY) {
        if (!Intrinsics.areEqual(this.previousMousePos, TuplesKt.to(Float.valueOf(mouseX), Float.valueOf(mouseY)))) {
            this.mouseDragged(mouseX);
        }
        this.previousMousePos = TuplesKt.to(Float.valueOf(mouseX), Float.valueOf(mouseY));
        NVGRenderer.INSTANCE.pushScissor(this.x, this.y, this.width, this.height);
        if (!(this.selectionWidth == 0.0f)) {
            NVGRenderer.rect$default(NVGRenderer.INSTANCE, this.x + this.caretX + 4.0f, this.y, this.selectionWidth, this.height, Colors.MINECRAFT_BLUE.getRgba(), 4.0f, 0.0f, 0.0f, 0.0f, 448, null);
        }
        NVGRenderer.INSTANCE.popScissor();
        if (this.listening) {
            long time2 = System.currentTimeMillis();
            if (time2 - this.caretBlinkTime < 500L) {
                NVGRenderer.INSTANCE.line(this.x + this.caretX + 4.0f - this.textOffset, this.y, this.x + this.caretX + 4.0f - this.textOffset, this.y + this.height, 2.0f, Colors.WHITE.getRgba());
            } else if (time2 - this.caretBlinkTime > 1000L) {
                this.caretBlinkTime = System.currentTimeMillis();
            }
        }
        NVGRenderer.INSTANCE.pushScissor(this.x, this.y, this.width, this.height);
        TextInputHandler this_$iv = this;
        boolean $i$f$getText = false;
        NVGRenderer.INSTANCE.text(this_$iv.textProvider.invoke(), this.x + 4.0f - this.textOffset, this.y + 2.0f, this.height - (float)2, Colors.WHITE.getRgba(), NVGRenderer.INSTANCE.getDefaultFont());
        NVGRenderer.INSTANCE.popScissor();
    }

    public final boolean mouseClicked(float mouseX, float mouseY, int mouseButton) {
        if (!MouseUtilsKt.isAreaHovered(this.x, this.y, this.width, this.height)) {
            this.resetState();
            return false;
        }
        if (mouseButton != 0) {
            return false;
        }
        this.listening = true;
        this.dragging = true;
        long current = System.currentTimeMillis();
        if (current - this.lastClickTime < 200L) {
            int n = this.clickCount;
            this.clickCount = n + 1;
        } else {
            this.clickCount = 1;
        }
        this.lastClickTime = current;
        switch (this.clickCount) {
            case 1: {
                this.caretFromMouse(mouseX);
                this.clearSelection();
                break;
            }
            case 2: {
                this.selectWord();
                break;
            }
            case 3: {
                this.selectAll();
                break;
            }
            case 4: {
                this.clickCount = 0;
            }
        }
        return true;
    }

    public final void mouseReleased() {
        this.dragging = false;
    }

    private final void mouseDragged(float mouseX) {
        if (this.dragging) {
            this.caretFromMouse(mouseX);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final boolean keyPressed(int keyCode) {
        if (!this.listening) {
            return false;
        }
        block0 : switch (keyCode) {
            case 14: {
                if (this.selection != this.caret) {
                    this.deleteSelection();
                } else if (GuiScreen.func_146271_m()) {
                    previousSpace = this.getPreviousSpace();
                    this_$iv = this;
                    $i$f$getText = false;
                    this.textSetter.invoke(this.removeRangeSafe(this_$iv.textProvider.invoke(), previousSpace, this.caret));
                    this.setCaret(this.caret - (this.caret > previousSpace ? this.caret - previousSpace : 0));
                } else if (this.caret != 0) {
                    this_$iv = this;
                    $i$f$getText = false;
                    this.textSetter.invoke(this.dropAt(this_$iv.textProvider.invoke(), this.caret, -1));
                    this_$iv = this.caret;
                    this.setCaret(this_$iv + -1);
                }
                this.clearSelection();
                if (this.selection != this.caret || GuiScreen.func_146271_m() || this.caret != 0) {
                    v0 = true;
                    break;
                }
                v0 = false;
                break;
            }
            case 211: {
                if (this.selection != this.caret) {
                    this.deleteSelection();
                } else if (GuiScreen.func_146271_m()) {
                    nextSpace = this.getNextSpace();
                    this_$iv = this;
                    $i$f$getText = false;
                    this.textSetter.invoke(this.removeRangeSafe(this_$iv.textProvider.invoke(), this.caret, nextSpace));
                    this.setCaret(this.caret < nextSpace ? this.caret : nextSpace);
                } else {
                    this_$iv = this;
                    $i$f$getText = false;
                    if (this.caret != this_$iv.textProvider.invoke().length()) {
                        this_$iv = this;
                        $i$f$getText = false;
                        this.textSetter.invoke(this.dropAt(this_$iv.textProvider.invoke(), this.caret, 1));
                        this_$iv = this;
                        $i$f$getText = false;
                        if (this.caret < this_$iv.textProvider.invoke().length()) {
                            v1 = this.caret;
                        } else {
                            this_$iv = this;
                            $i$f$getText = false;
                            v1 = this_$iv.textProvider.invoke().length();
                        }
                        this.setCaret(v1);
                    }
                }
                this.clearSelection();
                if (this.selection != this.caret || GuiScreen.func_146271_m()) ** GOTO lbl62
                this_$iv = this;
                $i$f$getText = false;
                if (this.caret == this_$iv.textProvider.invoke().length()) ** GOTO lbl64
lbl62:
                // 2 sources

                v0 = true;
                break;
lbl64:
                // 1 sources

                v0 = false;
                break;
            }
            case 205: {
                this_$iv = this;
                $i$f$getText = false;
                if (this.caret != this_$iv.textProvider.invoke().length()) {
                    this.setCaret(GuiScreen.func_146271_m() != false ? this.getNextSpace() : this.caret + 1);
                    if (!GuiScreen.func_146272_n()) {
                        this.selection = this.caret;
                    }
                    v0 = true;
                    break;
                }
                v0 = false;
                break;
            }
            case 203: {
                if (this.caret != 0) {
                    this.setCaret(GuiScreen.func_146271_m() != false ? this.getPreviousSpace() : this.caret - 1);
                    if (!GuiScreen.func_146272_n()) {
                        this.selection = this.caret;
                    }
                    v0 = true;
                    break;
                }
                v0 = false;
                break;
            }
            case 199: {
                this.setCaret(0);
                if (!GuiScreen.func_146272_n()) {
                    this.selection = this.caret;
                }
                v0 = true;
                break;
            }
            case 207: {
                this_$iv = this;
                $i$f$getText = false;
                this.setCaret(this_$iv.textProvider.invoke().length());
                if (!GuiScreen.func_146272_n()) {
                    this.selection = this.caret;
                }
                v0 = true;
                break;
            }
            case 1: 
            case 28: {
                this.listening = false;
                v0 = true;
                break;
            }
            default: {
                if (GuiScreen.func_146271_m() && !GuiScreen.func_146272_n()) {
                    switch (keyCode) {
                        case 47: {
                            v2 = GuiScreen.func_146277_j();
                            if (v2 != null) {
                                it = v2;
                                $i$a$-let-TextInputHandler$keyPressed$returnValue$1 = false;
                                this.insert(it);
                            }
                            v0 = true;
                            break block0;
                        }
                        case 46: {
                            if (this.caret != this.selection) {
                                this_$iv = this;
                                $i$f$getText = false;
                                Utils.writeToClipboard$default(this.substringSafe(this_$iv.textProvider.invoke(), this.caret, this.selection), null, 2, null);
                                v0 = true;
                                break block0;
                            }
                            v0 = false;
                            break block0;
                        }
                        case 45: {
                            if (this.caret != this.selection) {
                                this_$iv = this;
                                $i$f$getText = false;
                                Utils.writeToClipboard$default(this.substringSafe(this_$iv.textProvider.invoke(), this.caret, this.selection), null, 2, null);
                                this.deleteSelection();
                                v0 = true;
                                break block0;
                            }
                            v0 = false;
                            break block0;
                        }
                        case 30: {
                            this.selection = 0;
                            this_$iv = this;
                            $i$f$getText = false;
                            this.setCaret(this_$iv.textProvider.invoke().length());
                            v0 = true;
                            break block0;
                        }
                        case 17: {
                            this.selectWord();
                            v0 = true;
                            break block0;
                        }
                        case 44: {
                            this.undo();
                            v0 = true;
                            break block0;
                        }
                        case 21: {
                            this.redo();
                            v0 = true;
                            break block0;
                        }
                    }
                    v0 = false;
                    break;
                }
                v0 = false;
            }
        }
        returnValue = v0;
        this.updateCaretPosition();
        return returnValue;
    }

    public final boolean keyTyped(char typedChar) {
        if (!this.listening) {
            return false;
        }
        if (!ChatAllowedCharacters.func_71566_a((char)typedChar)) {
            return false;
        }
        String string = ChatAllowedCharacters.func_71565_a((String)String.valueOf(typedChar));
        Intrinsics.checkNotNullExpressionValue(string, "filterAllowedCharacters(...)");
        this.insert(string);
        return true;
    }

    private final void insert(String string) {
        if (this.caret != this.selection) {
            TextInputHandler this_$iv = this;
            boolean $i$f$getText = false;
            this.textSetter.invoke(this.removeRangeSafe(this_$iv.textProvider.invoke(), this.caret, this.selection));
            this.setCaret(this.selection > this.caret ? this.caret : this.selection);
        }
        Object this_$iv = this;
        int $i$f$getText = 0;
        int tl = ((TextInputHandler)this_$iv).textProvider.invoke().length();
        this_$iv = this;
        $i$f$getText = 0;
        StringBuilder stringBuilder = new StringBuilder().append(this.substringSafe(((TextInputHandler)this_$iv).textProvider.invoke(), 0, this.caret)).append(string);
        this_$iv = this;
        $i$f$getText = 0;
        this_$iv = ((TextInputHandler)this_$iv).textProvider.invoke();
        $i$f$getText = this.caret;
        String string2 = ((String)this_$iv).substring($i$f$getText);
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        this.textSetter.invoke(stringBuilder.append(string2).toString());
        this_$iv = this;
        $i$f$getText = 0;
        if (((TextInputHandler)this_$iv).textProvider.invoke().length() != tl) {
            this.setCaret(this.caret + string.length());
        }
        this.clearSelection();
        this.updateCaretPosition();
        this.saveState();
    }

    private final void deleteSelection() {
        if (this.caret == this.selection) {
            return;
        }
        TextInputHandler this_$iv = this;
        boolean $i$f$getText = false;
        this.textSetter.invoke(this.removeRangeSafe(this_$iv.textProvider.invoke(), this.caret, this.selection));
        this.setCaret(this.selection > this.caret ? this.caret : this.selection);
        this.saveState();
    }

    private final void caretFromMouse(float mouseX) {
        float mx = mouseX - (this.x + this.textOffset);
        float currWidth = 0.0f;
        int newCaret = 0;
        TextInputHandler this_$iv = this;
        boolean $i$f$getText = false;
        int n = this_$iv.textProvider.invoke().length();
        for (int index = 0; index < n; ++index) {
            TextInputHandler this_$iv2 = this;
            boolean $i$f$getText2 = false;
            float charWidth = this.textWidth(String.valueOf(this_$iv2.textProvider.invoke().charAt(index)));
            if (currWidth + charWidth / (float)2 > mx) break;
            currWidth += charWidth;
            newCaret = index + 1;
        }
        this.setCaret(newCaret);
        this.updateCaretPosition();
    }

    private final void updateCaretPosition() {
        if (this.selection != this.caret) {
            TextInputHandler this_$iv = this;
            boolean $i$f$getText = false;
            this.selectionWidth = this.textWidth(this.substringSafe(this_$iv.textProvider.invoke(), this.selection, this.caret));
            if (this.selection <= this.caret) {
                this.selectionWidth *= (float)-1;
            }
        } else {
            this.selectionWidth = 0.0f;
        }
        if (this.caret != 0) {
            float previousX = this.caretX;
            TextInputHandler this_$iv = this;
            boolean $i$f$getText = false;
            this.caretX = this.textWidth(this.substringSafe(this_$iv.textProvider.invoke(), 0, this.caret));
            if (previousX < this.caretX) {
                if (this.caretX - this.textOffset >= this.width) {
                    this.textOffset = this.caretX - this.width;
                }
            } else if (this.caretX - this.textOffset <= 0.0f) {
                this_$iv = this;
                $i$f$getText = false;
                this.textOffset = this.textWidth(this.substringSafe(this_$iv.textProvider.invoke(), 0, this.caret - 1));
            }
            if (this.textOffset > 0.0f) {
                this_$iv = this;
                $i$f$getText = false;
                if (this.textWidth(this_$iv.textProvider.invoke()) - this.textOffset < this.width) {
                    this_$iv = this;
                    $i$f$getText = false;
                    this.textOffset = RangesKt.coerceAtLeast(this.textWidth(this_$iv.textProvider.invoke()) - this.width, 0.0f);
                }
            }
        } else {
            this.caretX = 0.0f;
            this.textOffset = 0.0f;
        }
    }

    private final void clearSelection() {
        this.selection = this.caret;
        this.selectionWidth = 0.0f;
    }

    private final void selectWord() {
        boolean $i$f$getText;
        TextInputHandler this_$iv;
        int start2;
        int end = this.caret;
        for (start2 = this.caret; start2 > 0; --start2) {
            this_$iv = this;
            $i$f$getText = false;
            if (CharsKt.isWhitespace(this_$iv.textProvider.invoke().charAt(start2 - 1))) break;
        }
        while (true) {
            this_$iv = this;
            $i$f$getText = false;
            if (end >= this_$iv.textProvider.invoke().length()) break;
            this_$iv = this;
            $i$f$getText = false;
            if (CharsKt.isWhitespace(this_$iv.textProvider.invoke().charAt(end))) break;
            ++end;
        }
        this.selection = start2;
        this.setCaret(end);
        this.updateCaretPosition();
    }

    private final int getPreviousSpace() {
        int start2;
        for (start2 = this.caret; start2 > 0; --start2) {
            if (start2 == this.caret) continue;
            TextInputHandler this_$iv = this;
            boolean $i$f$getText = false;
            if (CharsKt.isWhitespace(this_$iv.textProvider.invoke().charAt(start2 - 1))) break;
        }
        return start2;
    }

    private final int getNextSpace() {
        int end = this.caret;
        while (true) {
            TextInputHandler this_$iv = this;
            boolean $i$f$getText = false;
            if (end >= this_$iv.textProvider.invoke().length()) break;
            if (end != this.caret) {
                this_$iv = this;
                $i$f$getText = false;
                if (CharsKt.isWhitespace(this_$iv.textProvider.invoke().charAt(end))) break;
            }
            ++end;
        }
        return end;
    }

    private final float textWidth(String text) {
        return NVGRenderer.INSTANCE.textWidth(text, this.height - (float)2, NVGRenderer.INSTANCE.getDefaultFont());
    }

    private final void resetState() {
        this.listening = false;
        this.textOffset = 0.0f;
        this.clearSelection();
    }

    private final void selectAll() {
        this.selection = 0;
        TextInputHandler this_$iv = this;
        boolean $i$f$getText = false;
        this.setCaret(this_$iv.textProvider.invoke().length());
        this.updateCaretPosition();
    }

    private final void saveState() {
        TextInputHandler this_$iv = this;
        boolean $i$f$getText = false;
        if (Intrinsics.areEqual(this_$iv.textProvider.invoke(), this.lastSavedText)) {
            return;
        }
        if (this.historyIndex < this.history.size() - 1) {
            this.history.subList(this.historyIndex + 1, this.history.size()).clear();
        }
        this_$iv = this;
        $i$f$getText = false;
        this.history.add(this_$iv.textProvider.invoke());
        this.historyIndex = this.history.size() - 1;
        this_$iv = this;
        $i$f$getText = false;
        this.lastSavedText = this_$iv.textProvider.invoke();
    }

    private final void undo() {
        if (this.historyIndex <= 0) {
            return;
        }
        int n = this.historyIndex;
        this.historyIndex = n + -1;
        this.textSetter.invoke(this.history.get(this.historyIndex));
        TextInputHandler this_$iv = this;
        boolean $i$f$getText = false;
        this.setCaret(this_$iv.textProvider.invoke().length());
        this.selection = this.caret;
        this_$iv = this;
        $i$f$getText = false;
        this.lastSavedText = this_$iv.textProvider.invoke();
    }

    private final void redo() {
        if (this.historyIndex >= this.history.size() - 1) {
            return;
        }
        int n = this.historyIndex;
        this.historyIndex = n + 1;
        this.textSetter.invoke(this.history.get(this.historyIndex));
        TextInputHandler this_$iv = this;
        boolean $i$f$getText = false;
        this.setCaret(this_$iv.textProvider.invoke().length());
        this.selection = this.caret;
        this_$iv = this;
        $i$f$getText = false;
        this.lastSavedText = this_$iv.textProvider.invoke();
    }

    private final String substringSafe(String $this$substringSafe, int from, int to) {
        int f = RangesKt.coerceAtLeast(Math.min(from, to), 0);
        int t = Math.max(to, from);
        if (t > $this$substringSafe.length()) {
            String string = $this$substringSafe.substring(f);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            return string;
        }
        String string = $this$substringSafe.substring(f, t);
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        return string;
    }

    private final String removeRangeSafe(String $this$removeRangeSafe, int from, int to) {
        String string = $this$removeRangeSafe;
        int n = Math.min(from, to);
        int n2 = Math.max(to, from);
        return ((Object)StringsKt.removeRange((CharSequence)string, n, n2)).toString();
    }

    private final String dropAt(String $this$dropAt, int at, int amount) {
        return this.removeRangeSafe($this$dropAt, at, at + amount);
    }
}

