/*
 * Decompiled with CFR 0.152.
 */
package me.odinmain.utils.skyblock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import me.odinmain.features.impl.skyblock.DianaHelper;
import me.odinmain.utils.Utils;
import me.odinmain.utils.VecUtilsKt;
import me.odinmain.utils.render.Color;
import me.odinmain.utils.render.Colors;
import me.odinmain.utils.skyblock.DianaBurrowEstimate;
import me.odinmain.utils.skyblock.ItemUtilsKt;
import net.minecraft.network.play.server.S29PacketSoundEffect;
import net.minecraft.network.play.server.S2APacketParticles;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003678B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u0015J\u0006\u0010(\u001a\u00020#J\u001a\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00152\b\b\u0002\u0010,\u001a\u00020*H\u0002J\u000e\u0010-\u001a\u00020#2\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020#2\u0006\u00101\u001a\u00020%J\u0010\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020\fH\u0002J\b\u00104\u001a\u00020#H\u0002J\u0006\u00105\u001a\u00020#R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u001b0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\t0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010!\u00a8\u00069"}, d2={"Lme/odinmain/utils/skyblock/DianaBurrowEstimate;", "", "<init>", "()V", "numberOfDings", "", "lastDingTime", "", "lastDingPitch", "", "firstPitch", "lastParticlePosition", "Lnet/minecraft/util/Vec3;", "secondLastParticlePosition", "firstParticlePoint", "currentParticlePosition", "estimatedBurrowPosition", "lastSoundPoint", "particlePositions", "", "lastDugBurrow", "Lnet/minecraft/util/BlockPos;", "recentBurrows", "", "pendingBurrow", "activeBurrows", "Ljava/util/concurrent/ConcurrentHashMap;", "Lme/odinmain/utils/skyblock/DianaBurrowEstimate$Burrow;", "getActiveBurrows", "()Ljava/util/concurrent/ConcurrentHashMap;", "dingPitchSlopes", "estimatedBurrowDistance", "", "Ljava/lang/Double;", "handleBurrow", "", "it", "Lnet/minecraft/network/play/server/S2APacketParticles;", "blockEvent", "pos", "onBurrowDug", "removeBurrow", "", "location", "force", "handleSoundPacket", "packetSound", "Lnet/minecraft/network/play/server/S29PacketSoundEffect;", "handleParticlePacket", "packet", "guessPosition", "currLoc", "reset", "onWorldLoad", "ParticleType", "Burrow", "BurrowType", "OdinMod"})
@SourceDebugExtension(value={"SMAP\nDianaBurrowEstimate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DianaBurrowEstimate.kt\nme/odinmain/utils/skyblock/DianaBurrowEstimate\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 4 VecUtils.kt\nme/odinmain/utils/VecUtilsKt\n*L\n1#1,257:1\n1#2:258\n1#2:261\n72#3,2:259\n333#4:262\n333#4:263\n336#4:264\n*S KotlinDebug\n*F\n+ 1 DianaBurrowEstimate.kt\nme/odinmain/utils/skyblock/DianaBurrowEstimate\n*L\n41#1:261\n41#1:259,2\n99#1:262\n104#1:263\n120#1:264\n*E\n"})
public final class DianaBurrowEstimate {
    @NotNull
    public static final DianaBurrowEstimate INSTANCE = new DianaBurrowEstimate();
    private static int numberOfDings;
    private static long lastDingTime;
    private static float lastDingPitch;
    private static float firstPitch;
    @Nullable
    private static Vec3 lastParticlePosition;
    @Nullable
    private static Vec3 secondLastParticlePosition;
    @Nullable
    private static Vec3 firstParticlePoint;
    @Nullable
    private static Vec3 currentParticlePosition;
    @Nullable
    private static Vec3 estimatedBurrowPosition;
    @Nullable
    private static Vec3 lastSoundPoint;
    @NotNull
    private static final List<Vec3> particlePositions;
    @Nullable
    private static BlockPos lastDugBurrow;
    @NotNull
    private static final Set<BlockPos> recentBurrows;
    @Nullable
    private static BlockPos pendingBurrow;
    @NotNull
    private static final ConcurrentHashMap<BlockPos, Burrow> activeBurrows;
    @NotNull
    private static final List<Float> dingPitchSlopes;
    @Nullable
    private static Double estimatedBurrowDistance;

    private DianaBurrowEstimate() {
    }

    @NotNull
    public final ConcurrentHashMap<BlockPos, Burrow> getActiveBurrows() {
        return activeBurrows;
    }

    public final void handleBurrow(@NotNull S2APacketParticles it) {
        Intrinsics.checkNotNullParameter(it, "it");
        ParticleType particleType = ParticleType.Companion.getParticleType(it);
        if (particleType == null) {
            return;
        }
        ParticleType particleType2 = particleType;
        Object object = new BlockPos(it.func_149220_d(), it.func_149226_e() - 1.0, it.func_149225_f());
        BlockPos it2 = object;
        boolean bl = false;
        Object object2 = !recentBurrows.contains(it2) ? object : null;
        if (object2 == null) {
            return;
        }
        BlockPos location2 = object2;
        ConcurrentMap $this$getOrPut$iv = activeBurrows;
        boolean $i$f$getOrPut = false;
        Object object3 = $this$getOrPut$iv.get(location2);
        if (object3 == null) {
            boolean bl2 = false;
            Burrow default$iv = new Burrow(location2, false, false, null, false, 30, null);
            boolean bl3 = false;
            object3 = $this$getOrPut$iv.putIfAbsent(location2, default$iv);
            if (object3 == null) {
                object3 = default$iv;
            }
        }
        Burrow burrow = (Burrow)object3;
        Object $this$handleBurrow_u24lambda_u242 = object = burrow;
        boolean bl4 = false;
        switch (WhenMappings.$EnumSwitchMapping$0[particleType2.ordinal()]) {
            case 1: {
                ((Burrow)$this$handleBurrow_u24lambda_u242).setHasFootstep(true);
                break;
            }
            case 2: {
                ((Burrow)$this$handleBurrow_u24lambda_u242).setHasEnchant(true);
                break;
            }
            case 3: {
                ((Burrow)$this$handleBurrow_u24lambda_u242).setType(BurrowType.START);
                break;
            }
            case 4: {
                ((Burrow)$this$handleBurrow_u24lambda_u242).setType(BurrowType.MOB);
                break;
            }
            case 5: {
                ((Burrow)$this$handleBurrow_u24lambda_u242).setType(BurrowType.TREASURE);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (burrow.getHasEnchant() && burrow.getHasFootstep() && burrow.getType() != BurrowType.UNKNOWN && !burrow.getFound()) {
            burrow.setFound(true);
        }
    }

    public final void blockEvent(@NotNull BlockPos pos) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter(pos, "pos");
                if (!((ConcurrentHashMap.KeySetView)activeBurrows.keySet()).contains(pos)) break block4;
                String[] stringArray = new String[]{"ANCESTRAL_SPADE"};
                if (ItemUtilsKt.isHolding(stringArray)) break block5;
            }
            return;
        }
        lastDugBurrow = pos;
        if (!Intrinsics.areEqual(pos, pendingBurrow)) {
            return;
        }
        pendingBurrow = null;
        this.removeBurrow(pos, true);
    }

    public final void onBurrowDug() {
        block1: {
            BlockPos blockPos = lastDugBurrow;
            if (blockPos == null) break block1;
            BlockPos it = blockPos;
            boolean bl = false;
            if (!DianaBurrowEstimate.removeBurrow$default(INSTANCE, it, false, 2, null)) {
                pendingBurrow = it;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean removeBurrow(BlockPos location2, boolean force) {
        Burrow burrow;
        Burrow burrow2 = activeBurrows.get(location2);
        Burrow burrow3 = burrow2;
        if (burrow2 == null) return false;
        Burrow it = burrow = burrow3;
        boolean bl = false;
        if (!it.getFound()) {
            if (!force) return false;
        }
        boolean bl2 = true;
        if (!bl2) return false;
        Burrow burrow4 = burrow;
        burrow3 = burrow4;
        if (burrow4 == null) return false;
        it = burrow3;
        boolean bl3 = false;
        activeBurrows.remove(location2);
        recentBurrows.add(location2);
        lastDugBurrow = null;
        Utils.runIn$default(1200, false, new Function0<Unit>(location2){
            final /* synthetic */ BlockPos $location;
            {
                this.$location = $location;
                super(0);
            }

            public final void invoke() {
                if (DianaBurrowEstimate.access$getRecentBurrows$p().contains(this.$location)) {
                    DianaBurrowEstimate.access$getRecentBurrows$p().remove(this.$location);
                }
            }
        }, 2, null);
        if (!true) return false;
        return true;
    }

    static /* synthetic */ boolean removeBurrow$default(DianaBurrowEstimate dianaBurrowEstimate, BlockPos blockPos, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return dianaBurrowEstimate.removeBurrow(blockPos, bl);
    }

    public final void handleSoundPacket(@NotNull S29PacketSoundEffect packetSound) {
        block11: {
            Vec3 vec3;
            boolean bl;
            Intrinsics.checkNotNullParameter(packetSound, "packetSound");
            if (!Intrinsics.areEqual(packetSound.func_149212_c(), "note.harp") || !(packetSound.func_149208_g() == 1.0f)) {
                return;
            }
            lastDingTime = System.currentTimeMillis();
            if (lastDingTime == 0L) {
                firstPitch = packetSound.func_149209_h();
            }
            if (packetSound.func_149209_h() < lastDingPitch) {
                this.reset();
            }
            if (lastDingPitch == 0.0f) {
                lastDingPitch = packetSound.func_149209_h();
                lastParticlePosition = null;
                secondLastParticlePosition = null;
                lastSoundPoint = null;
                firstParticlePoint = null;
                particlePositions.clear();
                return;
            }
            int n = numberOfDings;
            if ((numberOfDings = n + 1) > 1) {
                dingPitchSlopes.add(Float.valueOf(packetSound.func_149209_h() - lastDingPitch));
            }
            if (dingPitchSlopes.size() > 20) {
                CollectionsKt.removeFirst(dingPitchSlopes);
            }
            S29PacketSoundEffect $this$positionVector$iv = packetSound;
            boolean $i$f$getPositionVector = false;
            lastSoundPoint = new Vec3($this$positionVector$iv.func_149207_d(), $this$positionVector$iv.func_149211_e(), $this$positionVector$iv.func_149210_f());
            lastDingPitch = packetSound.func_149209_h();
            Vec3 vec32 = firstParticlePoint;
            if (vec32 == null) {
                return;
            }
            Vec3 firstPosition = vec32;
            S29PacketSoundEffect $this$positionVector$iv2 = packetSound;
            boolean $i$f$getPositionVector2 = false;
            Double d = estimatedBurrowDistance = Double.valueOf(Math.E / (!((Collection)dingPitchSlopes).isEmpty() ? CollectionsKt.averageOfFloat((Iterable<Float>)dingPitchSlopes) : 0.0) - firstPosition.func_72438_d(new Vec3($this$positionVector$iv2.func_149207_d(), $this$positionVector$iv2.func_149211_e(), $this$positionVector$iv2.func_149210_f())));
            if (d != null) {
                double it = ((Number)d).doubleValue();
                boolean bl2 = false;
                bl = it > 1000.0;
            } else {
                bl = false;
            }
            if (bl) {
                estimatedBurrowDistance = null;
                return;
            }
            Vec3 vec33 = secondLastParticlePosition;
            if (vec33 == null) {
                return;
            }
            Vec3 secondLastParticle = vec33;
            Double d2 = estimatedBurrowDistance;
            if (d2 == null) break block11;
            double distance2 = ((Number)d2).doubleValue();
            boolean bl3 = false;
            Vec3 vec34 = lastSoundPoint;
            estimatedBurrowPosition = vec34 != null ? vec34.func_178787_e((vec3 = currentParticlePosition) != null && (vec3 = vec3.func_178788_d(secondLastParticle)) != null && (vec3 = vec3.func_72432_b()) != null ? VecUtilsKt.multiply$default(vec3, distance2, 0.0, 0.0, 6, null) : null) : null;
        }
    }

    public final void handleParticlePacket(@NotNull S2APacketParticles packet) {
        block8: {
            boolean bl;
            Intrinsics.checkNotNullParameter(packet, "packet");
            if (packet.func_179749_a() != EnumParticleTypes.DRIP_LAVA) {
                return;
            }
            S2APacketParticles $this$positionVector$iv = packet;
            boolean $i$f$getPositionVector = false;
            Vec3 currLoc = new Vec3($this$positionVector$iv.func_149220_d(), $this$positionVector$iv.func_149226_e(), $this$positionVector$iv.func_149225_f());
            Vec3 vec3 = lastSoundPoint;
            if (vec3 != null) {
                Vec3 it = vec3;
                boolean bl2 = false;
                bl = Math.abs(currLoc.field_72450_a - it.field_72450_a) < 2.0 && Math.abs(currLoc.field_72448_b - it.field_72448_b) < 0.5 && Math.abs(currLoc.field_72449_c - it.field_72449_c) < 2.0;
            } else {
                bl = false;
            }
            if (!bl) {
                return;
            }
            this.guessPosition(currLoc);
            if (lastParticlePosition == null) {
                firstParticlePoint = VecUtilsKt.clone(currLoc);
            }
            secondLastParticlePosition = lastParticlePosition;
            lastParticlePosition = currentParticlePosition;
            currentParticlePosition = VecUtilsKt.clone(currLoc);
            Double d = estimatedBurrowDistance;
            if (d == null) {
                return;
            }
            double estimatedDistance = d;
            Vec3 vec32 = secondLastParticlePosition;
            if (vec32 == null) {
                return;
            }
            Vec3 secondParticlePosition = vec32;
            Vec3 vec33 = currentParticlePosition;
            if (vec33 == null || (vec33 = vec33.func_178788_d(secondParticlePosition)) == null || (vec33 = vec33.func_72432_b()) == null) {
                return;
            }
            Vec3 changes = vec33;
            Vec3 vec34 = lastParticlePosition;
            if (vec34 == null) break block8;
            Vec3 it = vec34;
            boolean bl3 = false;
            estimatedBurrowPosition = it.func_178787_e(VecUtilsKt.multiply(changes, estimatedDistance, 1.0, estimatedDistance));
        }
    }

    private final void guessPosition(Vec3 currLoc) {
        block9: {
            double d;
            if (particlePositions.size() >= 100 || !((Collection)particlePositions).isEmpty() && CollectionsKt.last(particlePositions).func_72438_d(currLoc) == 0.0) {
                return;
            }
            Object object = particlePositions;
            List<Vec3> it = object;
            boolean bl = false;
            Object object2 = it.size() > 2 ? object : null;
            if (object2 != null) {
                List<Vec3> it2 = object2;
                boolean bl2 = false;
                d = currLoc.func_72438_d(CollectionsKt.last(it2)) / (0.06507 * (double)it2.size() + 0.259);
            } else {
                d = 1.0;
            }
            double distMultiplier = d;
            particlePositions.add(currLoc);
            if (particlePositions.size() <= 5 || estimatedBurrowPosition == null) {
                return;
            }
            List slopeValues2 = SequencesKt.toList(SequencesKt.zipWithNext(CollectionsKt.asSequence((Iterable)particlePositions), guessPosition.slopeValues.1.INSTANCE));
            object = VecUtilsKt.calculateCoefficientsFromVectors(new Vec3((double)slopeValues2.size() - 5.0, (double)slopeValues2.size() - 3.0, (double)slopeValues2.size() - 1.0), new Vec3(((Number)slopeValues2.get(slopeValues2.size() - 5)).doubleValue(), ((Number)slopeValues2.get(slopeValues2.size() - 3)).doubleValue(), ((Number)slopeValues2.get(slopeValues2.size() - 1)).doubleValue()));
            double a = ((Number)((Triple)object).component1()).doubleValue();
            double b = ((Number)((Triple)object).component2()).doubleValue();
            double c = ((Number)((Triple)object).component3()).doubleValue();
            List pr1 = new ArrayList();
            List pr2 = new ArrayList();
            int start2 = slopeValues2.size() - 1;
            double[] lastPos = VecUtilsKt.toDoubleArray(particlePositions.get(start2));
            double[] lastPos2 = VecUtilsKt.toDoubleArray(particlePositions.get(start2));
            double distCovered = 0.0;
            double ySpeed = (CollectionsKt.last(DianaBurrowEstimate.particlePositions).field_72450_a - DianaBurrowEstimate.particlePositions.get((int)(DianaBurrowEstimate.particlePositions.size() - 2)).field_72450_a) / Math.hypot(CollectionsKt.last(DianaBurrowEstimate.particlePositions).field_72450_a - DianaBurrowEstimate.particlePositions.get((int)(DianaBurrowEstimate.particlePositions.size() - 2)).field_72450_a, CollectionsKt.last(DianaBurrowEstimate.particlePositions).field_72449_c - DianaBurrowEstimate.particlePositions.get((int)(DianaBurrowEstimate.particlePositions.size() - 2)).field_72449_c);
            Double d2 = estimatedBurrowDistance;
            if (d2 == null) {
                return;
            }
            double estimatedDistance = d2;
            for (int i = start2 + 1; distCovered < estimatedDistance && i < 10000; ++i) {
                double y = b / ((double)i + a) + c;
                double dist = distMultiplier * (0.06507 * (double)i + 0.259);
                double xOff = dist * Math.sin(y);
                double zOff = dist * Math.cos(y);
                int n = 5;
                for (int j = 0; j < n; ++j) {
                    int it3 = j;
                    boolean bl3 = false;
                    lastPos[0] = lastPos[0] + xOff / (double)5;
                    lastPos[2] = lastPos[2] + zOff / (double)5;
                    lastPos[1] = lastPos[1] + ySpeed * dist / (double)5;
                    lastPos2[0] = lastPos2[0] - xOff / (double)5;
                    lastPos2[2] = lastPos2[2] - zOff / (double)5;
                    lastPos2[1] = lastPos2[1] + ySpeed * dist / (double)5;
                    pr1.add(VecUtilsKt.toVec3(lastPos));
                    pr2.add(VecUtilsKt.toVec3(lastPos2));
                    if (lastSoundPoint != null) {
                        Vec3 it4;
                        boolean bl4 = false;
                        distCovered = Math.hypot(lastPos[0] - it4.field_72450_a, lastPos[2] - it4.field_72449_c);
                    }
                    if (distCovered > estimatedDistance) continue;
                }
            }
            if (pr1.isEmpty()) {
                return;
            }
            Vec3 p1 = (Vec3)CollectionsKt.last(pr1);
            Vec3 p2 = (Vec3)CollectionsKt.last(pr2);
            Vec3 vec3 = estimatedBurrowPosition;
            if (vec3 == null) break block9;
            Vec3 it5 = vec3;
            boolean bl5 = false;
            DianaHelper.INSTANCE.setRenderPos(VecUtilsKt.findNearestGrassBlock(Math.pow((p1.field_72450_a - it5.field_72450_a) * ((double)2 + p1.field_72449_c - it5.field_72449_c), 2) < Math.pow((p2.field_72450_a - it5.field_72450_a) * ((double)2 + p2.field_72449_c - it5.field_72449_c), 2) ? new Vec3(Math.floor(p1.field_72450_a), 120.0, Math.floor(p1.field_72449_c)) : new Vec3(Math.floor(p2.field_72450_a), 120.0, Math.floor(p2.field_72449_c))));
        }
    }

    private final void reset() {
        secondLastParticlePosition = null;
        currentParticlePosition = null;
        estimatedBurrowPosition = null;
        lastParticlePosition = null;
        firstParticlePoint = null;
        lastSoundPoint = null;
        lastDingPitch = 0.0f;
        numberOfDings = 0;
        lastDingTime = 0L;
        firstPitch = 0.0f;
        dingPitchSlopes.clear();
    }

    public final void onWorldLoad() {
        activeBurrows.clear();
        pendingBurrow = null;
        recentBurrows.clear();
        this.reset();
    }

    public static final /* synthetic */ Set access$getRecentBurrows$p() {
        return recentBurrows;
    }

    static {
        particlePositions = new ArrayList();
        recentBurrows = new LinkedHashSet();
        activeBurrows = new ConcurrentHashMap();
        dingPitchSlopes = new ArrayList();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J;\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\"\u001a\u00020\u00052\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013\u00a8\u0006("}, d2={"Lme/odinmain/utils/skyblock/DianaBurrowEstimate$Burrow;", "", "location", "Lnet/minecraft/util/BlockPos;", "hasFootstep", "", "hasEnchant", "type", "Lme/odinmain/utils/skyblock/DianaBurrowEstimate$BurrowType;", "found", "<init>", "(Lnet/minecraft/util/BlockPos;ZZLme/odinmain/utils/skyblock/DianaBurrowEstimate$BurrowType;Z)V", "getLocation", "()Lnet/minecraft/util/BlockPos;", "setLocation", "(Lnet/minecraft/util/BlockPos;)V", "getHasFootstep", "()Z", "setHasFootstep", "(Z)V", "getHasEnchant", "setHasEnchant", "getType", "()Lme/odinmain/utils/skyblock/DianaBurrowEstimate$BurrowType;", "setType", "(Lme/odinmain/utils/skyblock/DianaBurrowEstimate$BurrowType;)V", "getFound", "setFound", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "", "OdinMod"})
    public static final class Burrow {
        @NotNull
        private BlockPos location;
        private boolean hasFootstep;
        private boolean hasEnchant;
        @NotNull
        private BurrowType type;
        private boolean found;

        public Burrow(@NotNull BlockPos location2, boolean hasFootstep, boolean hasEnchant, @NotNull BurrowType type2, boolean found) {
            Intrinsics.checkNotNullParameter(location2, "location");
            Intrinsics.checkNotNullParameter((Object)type2, "type");
            this.location = location2;
            this.hasFootstep = hasFootstep;
            this.hasEnchant = hasEnchant;
            this.type = type2;
            this.found = found;
        }

        public /* synthetic */ Burrow(BlockPos blockPos, boolean bl, boolean bl2, BurrowType burrowType, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            if ((n & 8) != 0) {
                burrowType = BurrowType.UNKNOWN;
            }
            if ((n & 0x10) != 0) {
                bl3 = false;
            }
            this(blockPos, bl, bl2, burrowType, bl3);
        }

        @NotNull
        public final BlockPos getLocation() {
            return this.location;
        }

        public final void setLocation(@NotNull BlockPos blockPos) {
            Intrinsics.checkNotNullParameter(blockPos, "<set-?>");
            this.location = blockPos;
        }

        public final boolean getHasFootstep() {
            return this.hasFootstep;
        }

        public final void setHasFootstep(boolean bl) {
            this.hasFootstep = bl;
        }

        public final boolean getHasEnchant() {
            return this.hasEnchant;
        }

        public final void setHasEnchant(boolean bl) {
            this.hasEnchant = bl;
        }

        @NotNull
        public final BurrowType getType() {
            return this.type;
        }

        public final void setType(@NotNull BurrowType burrowType) {
            Intrinsics.checkNotNullParameter((Object)burrowType, "<set-?>");
            this.type = burrowType;
        }

        public final boolean getFound() {
            return this.found;
        }

        public final void setFound(boolean bl) {
            this.found = bl;
        }

        @NotNull
        public final BlockPos component1() {
            return this.location;
        }

        public final boolean component2() {
            return this.hasFootstep;
        }

        public final boolean component3() {
            return this.hasEnchant;
        }

        @NotNull
        public final BurrowType component4() {
            return this.type;
        }

        public final boolean component5() {
            return this.found;
        }

        @NotNull
        public final Burrow copy(@NotNull BlockPos location2, boolean hasFootstep, boolean hasEnchant, @NotNull BurrowType type2, boolean found) {
            Intrinsics.checkNotNullParameter(location2, "location");
            Intrinsics.checkNotNullParameter((Object)type2, "type");
            return new Burrow(location2, hasFootstep, hasEnchant, type2, found);
        }

        public static /* synthetic */ Burrow copy$default(Burrow burrow, BlockPos blockPos, boolean bl, boolean bl2, BurrowType burrowType, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                blockPos = burrow.location;
            }
            if ((n & 2) != 0) {
                bl = burrow.hasFootstep;
            }
            if ((n & 4) != 0) {
                bl2 = burrow.hasEnchant;
            }
            if ((n & 8) != 0) {
                burrowType = burrow.type;
            }
            if ((n & 0x10) != 0) {
                bl3 = burrow.found;
            }
            return burrow.copy(blockPos, bl, bl2, burrowType, bl3);
        }

        @NotNull
        public String toString() {
            return "Burrow(location=" + this.location + ", hasFootstep=" + this.hasFootstep + ", hasEnchant=" + this.hasEnchant + ", type=" + (Object)((Object)this.type) + ", found=" + this.found + ')';
        }

        public int hashCode() {
            int result = this.location.hashCode();
            result = result * 31 + Boolean.hashCode(this.hasFootstep);
            result = result * 31 + Boolean.hashCode(this.hasEnchant);
            result = result * 31 + this.type.hashCode();
            result = result * 31 + Boolean.hashCode(this.found);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Burrow)) {
                return false;
            }
            Burrow burrow = (Burrow)other;
            if (!Intrinsics.areEqual(this.location, burrow.location)) {
                return false;
            }
            if (this.hasFootstep != burrow.hasFootstep) {
                return false;
            }
            if (this.hasEnchant != burrow.hasEnchant) {
                return false;
            }
            if (this.type != burrow.type) {
                return false;
            }
            return this.found == burrow.found;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lme/odinmain/utils/skyblock/DianaBurrowEstimate$BurrowType;", "", "text", "", "color", "Lme/odinmain/utils/render/Color;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lme/odinmain/utils/render/Color;)V", "getText", "()Ljava/lang/String;", "getColor", "()Lme/odinmain/utils/render/Color;", "START", "MOB", "TREASURE", "UNKNOWN", "OdinMod"})
    public static final class BurrowType
    extends Enum<BurrowType> {
        @NotNull
        private final String text;
        @NotNull
        private final Color color;
        public static final /* enum */ BurrowType START = new BurrowType("\u00a7aStart", Colors.MINECRAFT_GREEN);
        public static final /* enum */ BurrowType MOB = new BurrowType("\u00a7cMob", Colors.MINECRAFT_RED);
        public static final /* enum */ BurrowType TREASURE = new BurrowType("\u00a76Treasure", Colors.MINECRAFT_GOLD);
        public static final /* enum */ BurrowType UNKNOWN = new BurrowType("\u00a7fUnknown?!", Colors.WHITE);
        private static final /* synthetic */ BurrowType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private BurrowType(String text, Color color2) {
            this.text = text;
            this.color = color2;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final Color getColor() {
            return this.color;
        }

        public static BurrowType[] values() {
            return (BurrowType[])$VALUES.clone();
        }

        public static BurrowType valueOf(String value) {
            return Enum.valueOf(BurrowType.class, value);
        }

        @NotNull
        public static EnumEntries<BurrowType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = burrowTypeArray = new BurrowType[]{BurrowType.START, BurrowType.MOB, BurrowType.TREASURE, BurrowType.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0082\u0081\u0002\u0018\u0000 \u00102\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0010B\"\b\u0002\u0012\u0017\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\"\u0010\u0002\u001a\u0013\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0011"}, d2={"Lme/odinmain/utils/skyblock/DianaBurrowEstimate$ParticleType;", "", "check", "Lkotlin/Function1;", "Lnet/minecraft/network/play/server/S2APacketParticles;", "", "Lkotlin/ExtensionFunctionType;", "<init>", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;)V", "getCheck", "()Lkotlin/jvm/functions/Function1;", "EMPTY", "MOB", "TREASURE", "FOOTSTEP", "ENCHANT", "Companion", "OdinMod"})
    private static final class ParticleType
    extends Enum<ParticleType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final Function1<S2APacketParticles, Boolean> check;
        public static final /* enum */ ParticleType EMPTY;
        public static final /* enum */ ParticleType MOB;
        public static final /* enum */ ParticleType TREASURE;
        public static final /* enum */ ParticleType FOOTSTEP;
        public static final /* enum */ ParticleType ENCHANT;
        private static final /* synthetic */ ParticleType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ParticleType(Function1<? super S2APacketParticles, Boolean> check) {
            this.check = check;
        }

        @NotNull
        public final Function1<S2APacketParticles, Boolean> getCheck() {
            return this.check;
        }

        public static ParticleType[] values() {
            return (ParticleType[])$VALUES.clone();
        }

        public static ParticleType valueOf(String value) {
            return Enum.valueOf(ParticleType.class, value);
        }

        @NotNull
        public static EnumEntries<ParticleType> getEntries() {
            return $ENTRIES;
        }

        static {
            EMPTY = new ParticleType(1.INSTANCE);
            MOB = new ParticleType(2.INSTANCE);
            TREASURE = new ParticleType(3.INSTANCE);
            FOOTSTEP = new ParticleType(4.INSTANCE);
            ENCHANT = new ParticleType(5.INSTANCE);
            $VALUES = particleTypeArray = new ParticleType[]{ParticleType.EMPTY, ParticleType.MOB, ParticleType.TREASURE, ParticleType.FOOTSTEP, ParticleType.ENCHANT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lme/odinmain/utils/skyblock/DianaBurrowEstimate$ParticleType$Companion;", "", "<init>", "()V", "getParticleType", "Lme/odinmain/utils/skyblock/DianaBurrowEstimate$ParticleType;", "packet", "Lnet/minecraft/network/play/server/S2APacketParticles;", "OdinMod"})
        @SourceDebugExtension(value={"SMAP\nDianaBurrowEstimate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DianaBurrowEstimate.kt\nme/odinmain/utils/skyblock/DianaBurrowEstimate$ParticleType$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1#2:258\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final ParticleType getParticleType(@NotNull S2APacketParticles packet) {
                ParticleType particleType;
                Intrinsics.checkNotNullParameter(packet, "packet");
                if (!packet.func_179750_b()) {
                    particleType = null;
                } else {
                    Object v1;
                    block3: {
                        Iterable iterable = ParticleType.getEntries();
                        for (Object t : iterable) {
                            ParticleType it = (ParticleType)((Object)t);
                            boolean bl = false;
                            if (!it.getCheck().invoke(packet).booleanValue()) continue;
                            v1 = t;
                            break block3;
                        }
                        v1 = null;
                    }
                    particleType = v1;
                }
                return particleType;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ParticleType.values().length];
            try {
                nArray[ParticleType.FOOTSTEP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParticleType.ENCHANT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParticleType.EMPTY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParticleType.MOB.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ParticleType.TREASURE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

